!------------------------------------------------------------------------
! Copyright (c) 2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  eea_module_fftj ƥȥץ (䥳ӥ׻)
!
!  2011/12/10  ݹ
!
program eea_module_fftj_jacobian_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use eea_module_fftj
  implicit none

 !---- ֲ ----
  integer, parameter :: im=16, jm=16            ! ʻ(X,Y)
  integer, parameter :: km=5, lm=5              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yxa_A(0:jm-1,0:im-1,4)     ! ʻҥǡ
  real(8)            :: yxa_B(0:jm-1,0:im-1,4)     ! ʻҥǡ
  real(8)            :: yxa_Jacob(0:jm-1,0:im-1,4)  ! ʻҥǡ

  integer            :: k=4,l=2

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','eea_module_fftj_jacobian_test', &
       'eea_module_fftj jacobian function tests')

 !---------------- ɸͤ ---------------------
  call eea_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------

!!$  write(6,*) '  Input wavenumbers of the grid data, k and l :'
!!$  read(5,*) k,l
!!$  write(6,*) '  k,l = ', k,l

  yxa_A(:,:,1) = sin(k*pi*yx_X)
  yxa_B(:,:,1) = sin(l*pi*yx_Y)
  yxa_Jacob(:,:,1) = k*pi*cos(k*pi*yx_X) * l*pi*cos(l*pi*yx_Y)

  yxa_A(:,:,2) = cos(k*pi*yx_X)
  yxa_B(:,:,2) = cos(l*pi*yx_Y)
  yxa_Jacob(:,:,2) = k*pi*sin(k*pi*yx_X) * l*pi*sin(l*pi*yx_Y)

  yxa_A(:,:,3) = sin(k*pi*yx_X)
  yxa_B(:,:,3) = cos(l*pi*yx_Y)
  yxa_Jacob(:,:,3) = - k*pi*cos(k*pi*yx_X) * l*pi*sin(l*pi*yx_Y)

  yxa_A(:,:,4) = cos(k*pi*yx_X)
  yxa_B(:,:,4) = sin(l*pi*yx_Y)
  yxa_Jacob(:,:,4) = - k*pi*sin(k*pi*yx_X) * l*pi*cos(l*pi*yx_Y)

  call check3d(yxa_eea(eea_Jacobian_eea_eea(eea_yxa(yxa_A),eea_yxa(yxa_B))), &
    yxa_Jacob, &
    'Jacob(sin(k*pi*X),sin(l*pi*Y)),Jacob(cos(k*pi*X),cos(l*pi*Y)),Jacob(sin(k*pi*X),cos(l*pi*Y)),Jacob(cos(k*pi*X),sin(l*pi*Y))')

  call MessageNotify('M','eea_module_fftj_jacobian_test', &
       'eea_module_fftj jacobian function tests succeeded!')

contains

  subroutine check3d(var,sol,funcname) ! ͤ eps ʾ var Ǥ
    real(8) :: var(:,:,:)                ! Ƚꤹ
    real(8) :: sol(:,:,:)
    character(len=*) :: funcname

    call AssertEqual(     &
      message = funcname, &
      answer = sol,       &
      check = var,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check3d

end program eea_module_fftj_jacobian_test
