!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  et_module_fftj ƥȥץ (ַ׻)
!
!  2011/12/03  ݹ
!
program et_module_fftj_interpolate_test

  use et_module_fftj
  use dc_test
  implicit none

  integer, parameter :: im = 32,  km=10
  integer, parameter :: jm = 16,  lm=10
  real(8), parameter :: xmin=0.0, xmax=2.0
  real(8), parameter :: ymin=0.0, ymax=1.0
  
  real(8)            :: yx_Data(0:jm,0:im-1)
  real(8)            :: et_Data(-km:km,0:lm)

  real(8)            :: xobs = 0.3d0,  yobs=0.2d0
  real(8)            :: PI

  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -10

  PI = 4.0D0 * atan(1.0D0)

  call et_Initial(im,jm,km,lm,xmin,xmax,ymin,ymax)

  yx_Data = sin(PI*yx_X)**2 * sin(PI*yx_Y)  
  et_Data = et_yx(yx_Data)

  call AssertEqual(&
    message = '2-dim Interpolation ',                           &
    answer = sin(PI*xobs)**2*sin(PI*yobs),                      &
    check =  Interpolate_et(et_Data,xobs,yobs),                 &
    significant_digits = check_digits, ignore_digits = ignore   &
  )

end program et_module_fftj_interpolate_test
