/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jena.permissions.contract.graph;

import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.test.TestGraphListener;
import org.apache.jena.permissions.MockSecurityEvaluator;
import org.apache.jena.permissions.SecurityEvaluator;

public class SecuredGraphListenerTest extends TestGraphListener {
    private final SecurityEvaluator eval;

    public SecuredGraphListenerTest(final Class<? extends Graph> graphClass, final String name) {
        super(graphClass, name);
        eval = new MockSecurityEvaluator(true, true, true, true, true, true, true);
    }

    public SecuredGraphListenerTest(final String name) {
        super(name);
        eval = new MockSecurityEvaluator(true, true, true, true, true, true, true);
    }

    @Override
    public Graph getGraph() {
        final Graph graph = org.apache.jena.permissions.Factory.getInstance(eval, getName(),
                Factory.createDefaultGraph());
        graph.getEventManager().register(new CheckChanges("simple tracking", graph));
        return graph;
    }
}
