/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:10:08 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.StringReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class Strand_ESTest extends Strand_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Marker marker0 = strand0.makeMarker(2);
      MarkerRange markerRange0 = Strand.getORFAroundMarker(marker0, false);
      Strand.getOpenReadingFrameRanges(markerRange0, (-5), (-681), (-681));
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      char[] charArray0 = new char[22];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer((short)1);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = strand0.makeMarker('~');
      MarkerRange markerRange0 = new MarkerRange(marker0);
      // Undeclared exception!
      try { 
        Strand.getOpenReadingFrameRanges(markerRange0, 3014, 5471, 5);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 5 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Marker marker0 = strand0.makeMarker(2);
      MarkerRange markerRange0 = Strand.getORFAroundMarker(marker0, false);
      Strand.markerRangeBases(markerRange0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer('~');
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.makeMarkerFromRawPosition(0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.makeMarkerFromRawPosition('~');
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(rawStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      Range range0 = feature0.getMaxRawRange();
      strand0.getTranslation(range0, false);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Range range0 = new Range(0);
      strand0.getTranslation(range0, false);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("G\"zais_,9J");
      Bases bases0 = new Bases(genbankStreamSequence0);
      genbankStreamSequence0.setFromChar(bases0.letter_index);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getTCount();
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer('~');
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getStrandBases();
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      char[] charArray0 = new char[0];
      Short short0 = new Short((short)0);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, (Integer) null);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Range range0 = new Range((-897));
      StringVector stringVector0 = StringVector.getStrings(",Jg}@/r");
      strand0.getStopOrStartCodons(range0, stringVector0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      char[] charArray0 = new char[6];
      Short short0 = new Short((short)0);
      Integer integer0 = new Integer(0);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Range range0 = new Range(0);
      strand0.getSpacedTranslation(range0, false);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(",_<yS}sKhA");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, (-346));
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Range range0 = feature0.getMaxRawRange();
      strand0.getSpacedTranslation(range0, true);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      StringReader stringReader0 = new StringReader("^(.*)(.)(.*)$");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getSequenceLength();
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("^(.*)(.)(.*)$");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getSequenceLength();
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      strand0.getRawPosition(2);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, 2);
      strand0.getBases();
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      char[] charArray0 = new char[6];
      Short short0 = new Short((short)30000);
      Integer integer0 = new Integer(67);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 1257, 67, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, 1);
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions((-1463), (-1463));
      // Undeclared exception!
      try { 
        Strand.markerRangeBases(markerRange0);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      // Undeclared exception!
      try { 
        strand0.makeMarkerRangeFromRawPositions(5, 2);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "zWjH^7dU%vaIHEIOk'C");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      try { 
        strand0.makeMarkerRangeFromPositions(3, (-71));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: -71
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("bS%,csARh");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      try { 
        strand0.makeMarker(97);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: 97
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 120);
      // Undeclared exception!
      try { 
        strand0.makeMarker((-5));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 3349);
      // Undeclared exception!
      try { 
        strand0.isForwardStrand();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(",_<yS}sKhA");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, (-346));
      Range range0 = new Range((-346));
      // Undeclared exception!
      try { 
        strand0.getTranslation(range0, true);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 0);
      // Undeclared exception!
      try { 
        strand0.getSubSequence((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = new Marker(strand0, (-843));
      MarkerRange markerRange0 = new MarkerRange(marker0);
      Range range0 = markerRange0.getRange();
      // Undeclared exception!
      try { 
        strand0.getSubSequence(range0);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, (-1340));
      // Undeclared exception!
      try { 
        strand0.getStrandBases();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = new Marker(strand0, (-843));
      MarkerRange markerRange0 = new MarkerRange(marker0);
      Range range0 = markerRange0.getRange();
      // Undeclared exception!
      try { 
        strand0.getSpacedTranslation(range0, true);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      // Undeclared exception!
      try { 
        strand0.getRawSubSequenceC((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = strand0.makeMarkerFromRawPosition((-5));
      MarkerRange markerRange0 = new MarkerRange(marker0);
      Range range0 = markerRange0.getRange();
      // Undeclared exception!
      try { 
        strand0.getRawSubSequenceC(range0);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("1pG[bFy_");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      // Undeclared exception!
      try { 
        strand0.getRawSubSequence((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, 1);
      // Undeclared exception!
      try { 
        strand0.getRawPosition(2);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.getOpenReadingFrameRanges((MarkerRange) null, (-889), (-835), (-889));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.getORFAroundMarker((Marker) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, (-669));
      Range range0 = new Range(1);
      StringVector stringVector0 = new StringVector("Yx26kd~=i#0'{n*d<");
      // Undeclared exception!
      try { 
        strand0.getMatchingCodons(range0, stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 2);
      // Undeclared exception!
      try { 
        strand0.getGCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 120);
      // Undeclared exception!
      try { 
        strand0.getDirection();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.getCodonAtMarker((Marker) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      // Undeclared exception!
      try { 
        strand0.getCCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.deleteRange((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.addBases((Marker) null, "{f6ilf<6qO~Oy}#ML");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = new Marker(strand0, 0);
      // Undeclared exception!
      try { 
        Strand.addBases(marker0, "R5wM^hX/Db{EG ");
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      StringReader stringReader0 = new StringReader("^(.*)(.)(.*)$");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      try { 
        strand0.makeMarkerFromRawPosition(120);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: 120
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.isForwardStrand();
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, '~');
      strand0.isForwardStrand();
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("xL|$y^;");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getDirection();
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      strand0.getDirection();
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Marker marker0 = strand0.makeMarker(2);
      MarkerRange markerRange0 = Strand.getORFAroundMarker(marker0, false);
      Range range0 = markerRange0.getRawRange();
      strand0.getSubSequence(range0);
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 0);
      // Undeclared exception!
      try { 
        strand0.getSequenceLength();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 120);
      strand0.getBases();
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getCCount();
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      strand0.getCCount();
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getGCount();
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("bS%,csARh");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      strand0.getGCount();
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getTCount();
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      // Undeclared exception!
      try { 
        strand0.getTCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(rawStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      strand0.getACount();
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      // Undeclared exception!
      try { 
        strand0.getACount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = strand0.makeMarker(2);
      Strand.addBases(marker0, "+T>0");
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Marker marker0 = strand0.makeMarker(2);
      Strand.addBases(marker0, "+T>0");
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(rawStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      try { 
        strand0.makeMarkerRangeFromRawPositions(2, (-3280));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: -3280
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      try { 
        strand0.makeMarkerRangeFromRawPositions(44, 0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: -43
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      // Undeclared exception!
      try { 
        strand0.makeMarkerFromRawPosition(5);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Marker marker0 = strand0.makeMarker(2);
      MarkerRange markerRange0 = Strand.getORFAroundMarker(marker0, false);
      // Undeclared exception!
      try { 
        Strand.getOpenReadingFrameRanges(markerRange0, (-681), 5, 0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected OutOfRangeException
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test63()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = strand0.makeMarker(2);
      MarkerRange markerRange0 = Strand.getORFAroundMarker(marker0, false);
      Strand.getOpenReadingFrameRanges(markerRange0, 1, 0, (-3));
  }

  @Test(timeout = 4000)
  public void test64()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L;Bwo5ox<N0.AYWJEy/", "L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      Strand.getORFAroundMarker(marker0, true);
  }

  @Test(timeout = 4000)
  public void test65()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L;Bwo5ox<N0.AYWJEy/", "L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      Strand.getORFAroundMarker(marker0, false);
  }

  @Test(timeout = 4000)
  public void test66()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer(687);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = strand0.makeMarker(1);
      // Undeclared exception!
      try { 
        Strand.getORFAroundMarker(marker0, true);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test67()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L;Bwo5ox<N0.AYWJEy/", "L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      String string0 = strand0.getStrandBases();
      assertEquals("nnnwnnnnnnnnnnnnnyn", string0);
  }

  @Test(timeout = 4000)
  public void test68()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L;Bwo5ox<N0.AYWJEy/", "L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      String string0 = strand0.getStrandBases();
      assertEquals(2, strand0.getDirection());
      assertEquals("nrnnnnnnnnnnnnnwnnn", string0);
  }

  @Test(timeout = 4000)
  public void test69()  throws Throwable  {
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)1);
      Integer integer0 = new Integer('~');
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Range range0 = new Range(1);
      char[] charArray1 = strand0.getRawSubSequenceC(range0);
      assertArrayEquals(new char[] {'@'}, charArray1);
  }

  @Test(timeout = 4000)
  public void test70()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      // Undeclared exception!
      try { 
        strand0.getStopOrStartCodons((Range) null, (StringVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test71()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("at=Z,@'=");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(2, 5);
      Strand.deleteRange(markerRange0);
      assertEquals(2, genbankStreamSequence0.getOtherCount());
      assertEquals(4, genbankStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test72()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L;Bwo5ox<N0.AYWJEy/", "L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      int int0 = strand0.getRawPosition((-5));
      assertEquals((-5), int0);
  }

  @Test(timeout = 4000)
  public void test73()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 2);
      // Undeclared exception!
      try { 
        strand0.makeMarkerRangeFromPositions(753, 160);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test74()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(rawStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      Range range0 = new Range(2, 2);
      FeatureVector featureVector0 = entry0.checkForMissingQualifiers();
      StringVector stringVector0 = Feature.getAllQualifierNames(featureVector0);
      strand0.getMatchingCodons(range0, stringVector0);
      assertTrue(strand0.isForwardStrand());
  }

  @Test(timeout = 4000)
  public void test75()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L;Bwo5ox<N0.AYWJEy/", "L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstBaseMarker();
      String string0 = Strand.getCodonAtMarker(marker0);
      assertEquals("nnn", string0);
  }

  @Test(timeout = 4000)
  public void test76()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.markerRangeBases((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test77()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+T>0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Marker marker0 = strand0.makeMarker(2);
      MarkerRange markerRange0 = Strand.getORFAroundMarker(marker0, false);
      assertNotNull(markerRange0);
      
      Range range0 = markerRange0.getRange();
      String string0 = strand0.getRawSubSequence(range0);
      assertEquals(2, marker0.getPosition());
      assertEquals(2, strand0.getDirection());
      assertEquals("nnn", string0);
  }

  @Test(timeout = 4000)
  public void test78()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("L;Bwo5ox<N0.AYWJEy/", "L;Bwo5ox<N0.AYWJEy/");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      // Undeclared exception!
      try { 
        strand0.getSpacedTranslation((Range) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test79()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, (-681));
      Range range0 = new Range((-1357), 153);
      // Undeclared exception!
      try { 
        strand0.getTranslation(range0, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }
}
