# SPDX-License-Identifier: GPL-2.0-only
#
# Copyright (C) 2019 EfficiOS Inc.
#

import unittest

import bt2


class PackageTestCase(unittest.TestCase):
    def _assert_in_bt2(self, name):
        self.assertIn(name, dir(bt2))


_public_names = [
    "__version__",
    "_ArrayField",
    "_ArrayFieldClass",
    "_ArrayFieldClassConst",
    "_ArrayFieldConst",
    "_ArrayValueConst",
    "_BitArrayField",
    "_BitArrayFieldClass",
    "_BitArrayFieldClassConst",
    "_BitArrayFieldClassFlagConst",
    "_BitArrayFieldConst",
    "_BlobField",
    "_BlobFieldClass",
    "_BlobFieldClassConst",
    "_BlobFieldConst",
    "_BoolField",
    "_BoolFieldClass",
    "_BoolFieldClassConst",
    "_BoolFieldConst",
    "_BoolValueConst",
    "_ClockClass",
    "_ClockClassConst",
    "_ClockSnapshotConst",
    "_ComponentClassErrorCause",
    "_ComponentErrorCause",
    "_CurrentArrayElementFieldPathItem",
    "_CurrentOptionContentFieldPathItem",
    "_DiscardedEventsMessage",
    "_DiscardedEventsMessageConst",
    "_DiscardedPacketsMessage",
    "_DiscardedPacketsMessageConst",
    "_DoublePrecisionRealField",
    "_DoublePrecisionRealFieldClass",
    "_DoublePrecisionRealFieldClassConst",
    "_DoublePrecisionRealFieldConst",
    "_DynamicArrayField",
    "_DynamicArrayFieldClass",
    "_DynamicArrayFieldClassConst",
    "_DynamicArrayFieldClassWithLengthField",
    "_DynamicArrayFieldClassWithLengthFieldConst",
    "_DynamicArrayFieldConst",
    "_DynamicArrayFieldWithLengthField",
    "_DynamicArrayFieldWithLengthFieldConst",
    "_DynamicArrayWithLengthFieldFieldClass",
    "_DynamicArrayWithLengthFieldFieldClassConst",
    "_DynamicBlobField",
    "_DynamicBlobFieldClass",
    "_DynamicBlobFieldClassConst",
    "_DynamicBlobFieldClassWithLengthField",
    "_DynamicBlobFieldClassWithLengthFieldConst",
    "_DynamicBlobFieldConst",
    "_DynamicBlobFieldWithLengthField",
    "_DynamicBlobFieldWithLengthFieldConst",
    "_EnumerationField",
    "_EnumerationFieldClass",
    "_EnumerationFieldClassConst",
    "_EnumerationFieldConst",
    "_Error",
    "_ErrorCause",
    "_EventClass",
    "_EventClassConst",
    "_EventMessage",
    "_EventMessageConst",
    "_Field",
    "_FieldClass",
    "_FieldClassConst",
    "_FieldConst",
    "_FieldLocationConst",
    "_FieldPathConst",
    "_FieldPathItem",
    "_FilterComponentClassConst",
    "_FilterComponentConst",
    "_IncompleteUserClass",
    "_IndexFieldPathItem",
    "_InputPortConst",
    "_IntegerField",
    "_IntegerFieldClass",
    "_IntegerFieldClassConst",
    "_IntegerFieldConst",
    "_IntegerValue",
    "_IntegerValueConst",
    "_ListenerHandle",
    "_MapValueConst",
    "_MemoryError",
    "_MessageConst",
    "_MessageIteratorConfiguration",
    "_MessageIteratorErrorCause",
    "_MessageIteratorInactivityMessage",
    "_MessageIteratorInactivityMessageConst",
    "_OptionField",
    "_OptionFieldClass",
    "_OptionFieldClassConst",
    "_OptionFieldClassWithBoolSelectorField",
    "_OptionFieldClassWithBoolSelectorFieldConst",
    "_OptionFieldClassWithIntegerSelectorField",
    "_OptionFieldClassWithIntegerSelectorFieldConst",
    "_OptionFieldClassWithSelectorField",
    "_OptionFieldClassWithSelectorFieldConst",
    "_OptionFieldClassWithSignedIntegerSelectorField",
    "_OptionFieldClassWithSignedIntegerSelectorFieldConst",
    "_OptionFieldClassWithUnsignedIntegerSelectorField",
    "_OptionFieldClassWithUnsignedIntegerSelectorFieldConst",
    "_OptionFieldConst",
    "_OptionFieldWithBoolSelectorField",
    "_OptionFieldWithBoolSelectorFieldConst",
    "_OptionFieldWithSignedIntegerSelectorField",
    "_OptionFieldWithSignedIntegerSelectorFieldConst",
    "_OptionFieldWithUnsignedIntegerSelectorField",
    "_OptionFieldWithUnsignedIntegerSelectorFieldConst",
    "_OptionWithBoolSelectorFieldClass",
    "_OptionWithBoolSelectorFieldClassConst",
    "_OptionWithIntegerSelectorFieldClass",
    "_OptionWithIntegerSelectorFieldClassConst",
    "_OptionWithSelectorFieldClass",
    "_OptionWithSelectorFieldClassConst",
    "_OptionWithSignedIntegerSelectorFieldClass",
    "_OptionWithSignedIntegerSelectorFieldClassConst",
    "_OptionWithUnsignedIntegerSelectorFieldClass",
    "_OptionWithUnsignedIntegerSelectorFieldClassConst",
    "_OutputPortConst",
    "_OverflowError",
    "_PacketBeginningMessage",
    "_PacketBeginningMessageConst",
    "_PacketEndMessage",
    "_PacketEndMessageConst",
    "_PluginSet",
    "_PrivateQueryExecutor",
    "_RealField",
    "_RealFieldClass",
    "_RealFieldClassConst",
    "_RealFieldConst",
    "_RealValueConst",
    "_SignedEnumerationField",
    "_SignedEnumerationFieldClass",
    "_SignedEnumerationFieldClassConst",
    "_SignedEnumerationFieldClassMappingConst",
    "_SignedEnumerationFieldConst",
    "_SignedIntegerField",
    "_SignedIntegerFieldClass",
    "_SignedIntegerFieldClassConst",
    "_SignedIntegerFieldConst",
    "_SignedIntegerRangeConst",
    "_SignedIntegerRangeSetConst",
    "_SignedIntegerValueConst",
    "_SinglePrecisionRealField",
    "_SinglePrecisionRealFieldClass",
    "_SinglePrecisionRealFieldClassConst",
    "_SinglePrecisionRealFieldConst",
    "_SinkComponentClassConst",
    "_SinkComponentConst",
    "_SourceComponentClassConst",
    "_SourceComponentConst",
    "_StaticArrayField",
    "_StaticArrayFieldClass",
    "_StaticArrayFieldClassConst",
    "_StaticArrayFieldConst",
    "_StaticBlobField",
    "_StaticBlobFieldClass",
    "_StaticBlobFieldClassConst",
    "_StaticBlobFieldConst",
    "_Stream",
    "_StreamBeginningMessage",
    "_StreamBeginningMessageConst",
    "_StreamClass",
    "_StreamClassConst",
    "_StreamConst",
    "_StreamEndMessage",
    "_StreamEndMessageConst",
    "_StringField",
    "_StringFieldClass",
    "_StringFieldClassConst",
    "_StringFieldConst",
    "_StringValueConst",
    "_StructureField",
    "_StructureFieldClass",
    "_StructureFieldClassConst",
    "_StructureFieldClassMember",
    "_StructureFieldClassMemberConst",
    "_StructureFieldConst",
    "_Trace",
    "_TraceClass",
    "_TraceClassConst",
    "_TraceConst",
    "_UnixEpochClockOrigin",
    "_UnknownClockOrigin",
    "_UnknownClockSnapshot",
    "_UnsignedEnumerationField",
    "_UnsignedEnumerationFieldClass",
    "_UnsignedEnumerationFieldClassConst",
    "_UnsignedEnumerationFieldClassMappingConst",
    "_UnsignedEnumerationFieldConst",
    "_UnsignedIntegerField",
    "_UnsignedIntegerFieldClass",
    "_UnsignedIntegerFieldClassConst",
    "_UnsignedIntegerFieldConst",
    "_UnsignedIntegerRangeConst",
    "_UnsignedIntegerRangeSetConst",
    "_UnsignedIntegerValueConst",
    "_UserComponentInputPort",
    "_UserComponentInputPortMessageIterator",
    "_UserComponentOutputPort",
    "_UserFilterComponent",
    "_UserFilterComponentConfiguration",
    "_UserMessageIterator",
    "_UserSinkComponent",
    "_UserSinkComponentConfiguration",
    "_UserSourceComponent",
    "_UserSourceComponentConfiguration",
    "_Value",
    "_ValueConst",
    "_VariantField",
    "_VariantField",
    "_VariantFieldClass",
    "_VariantFieldClassConst",
    "_VariantFieldClassOption",
    "_VariantFieldClassOptionConst",
    "_VariantFieldClassWithIntegerSelector",
    "_VariantFieldClassWithIntegerSelectorConst",
    "_VariantFieldClassWithIntegerSelectorField",
    "_VariantFieldClassWithIntegerSelectorFieldConst",
    "_VariantFieldClassWithIntegerSelectorFieldOption",
    "_VariantFieldClassWithIntegerSelectorFieldOptionConst",
    "_VariantFieldClassWithoutSelector",
    "_VariantFieldClassWithoutSelectorConst",
    "_VariantFieldClassWithoutSelectorField",
    "_VariantFieldClassWithoutSelectorFieldConst",
    "_VariantFieldClassWithSignedIntegerSelector",
    "_VariantFieldClassWithSignedIntegerSelectorConst",
    "_VariantFieldClassWithSignedIntegerSelectorField",
    "_VariantFieldClassWithSignedIntegerSelectorFieldConst",
    "_VariantFieldClassWithSignedIntegerSelectorFieldOption",
    "_VariantFieldClassWithSignedIntegerSelectorFieldOptionConst",
    "_VariantFieldClassWithUnsignedIntegerSelector",
    "_VariantFieldClassWithUnsignedIntegerSelectorConst",
    "_VariantFieldClassWithUnsignedIntegerSelectorField",
    "_VariantFieldClassWithUnsignedIntegerSelectorFieldConst",
    "_VariantFieldClassWithUnsignedIntegerSelectorFieldOption",
    "_VariantFieldClassWithUnsignedIntegerSelectorFieldOptionConst",
    "_VariantFieldConst",
    "_VariantFieldConst",
    "_VariantFieldWithSignedIntegerSelectorField",
    "_VariantFieldWithSignedIntegerSelectorFieldConst",
    "_VariantFieldWithUnsignedIntegerSelectorField",
    "_VariantFieldWithUnsignedIntegerSelectorFieldConst",
    "ArrayValue",
    "AutoSourceComponentSpec",
    "BoolValue",
    "ClockClassOffset",
    "ClockOffset",
    "ClockOrigin",
    "ComponentClassType",
    "ComponentDescriptor",
    "ComponentSpec",
    "create_value",
    "EventClassLogLevel",
    "FieldLocationScope",
    "FieldPathScope",
    "find_plugin",
    "find_plugins",
    "find_plugins_in_path",
    "get_global_logging_level",
    "get_greatest_operative_mip_version",
    "get_maximal_mip_version",
    "get_minimal_logging_level",
    "Graph",
    "IntegerDisplayBase",
    "Interrupter",
    "LoggingLevel",
    "MapValue",
    "plugin_component_class",
    "QueryExecutor",
    "RealValue",
    "register_plugin",
    "set_global_logging_level",
    "SignedIntegerRange",
    "SignedIntegerRangeSet",
    "SignedIntegerValue",
    "Stop",
    "StringValue",
    "TraceCollectionMessageIterator",
    "TryAgain",
    "unix_epoch_clock_origin",
    "unknown_clock_origin",
    "UnknownObject",
    "UnsignedIntegerRange",
    "UnsignedIntegerRangeSet",
    "UnsignedIntegerValue",
]

for name in _public_names:

    def test_func(self):
        self._assert_in_bt2(name)

    setattr(PackageTestCase, "test_has_" + name, test_func)


if __name__ == "__main__":
    unittest.main()
