# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
DEBIAN_RELEASES += sid
DEBIAN_sid_CODENAME = sid

.PHONY: all
all:: debian-cloud-sid.$(GARDEN_ARCH).qcow2 debian-cloud-sid.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/debian/debian-sid-genericcloud-$(call map_to_debian_arch,$(GARDEN_ARCH))-daily.qcow2

$(GARDEN_DL_DIR)/debian/debian-sid-genericcloud-amd64-daily.qcow2 $(GARDEN_DL_DIR)/debian/debian-sid-genericcloud-arm64-daily.qcow2: $(GARDEN_DL_DIR)/debian/debian-sid-genericcloud-%-daily.qcow2: | $(GARDEN_DL_DIR)/debian
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://cloud.debian.org/images/cloud/$(DEBIAN_sid_CODENAME)/daily/latest/debian-sid-genericcloud-$*-daily.qcow2)

$(GARDEN_DL_DIR)/debian/debian-cloud-sid.x86_64.qcow2: | $(GARDEN_DL_DIR)/debian $(GARDEN_DL_DIR)/debian/debian-sid-genericcloud-amd64-daily.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/debian/debian-cloud-sid.aarch64.qcow2: | $(GARDEN_DL_DIR)/debian $(GARDEN_DL_DIR)/debian/debian-sid-genericcloud-arm64-daily.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/debian/debian-cloud-sid.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/debian/debian-sid-genericcloud-*.qcow2
