libXpertMassCore
================

*libXpertMassCore* is a C++ shared library that is referenced from other projects.

The *libXpertMass* shared library is designed to enshrine the non-GUI functionalities
needed by the following two projects:

* MsXpertSuite/MassXpert (currently MassXpert3)
* MsXpertSuite/MineXpert (currently MineXpert3)

In particular, it contains abstractions for all the chemical entities required to fully characterize
a polymer chemistry definition, as shown below:

* Isotope
* IsotopicData
* Formula
* Monomer
* Oligomer
* Polymer
* Modif
* CrossLinker
* CrossLink
* Aqueous chemical reactions (cleavages, enzymatic and non-enzymatic)
* Gas-phase chemical reactions (fragmentations, with a sophisticated grammar to describe complex
fragmentation patterns)
* Isotopic cluster modelling/calculations for any chemical entity representable by an elemental
composition formula and a charge.
* ...

*libXpertMassCore* has a companion GUI library, *libXpertMassGui* , that is designed to
enshrine the GUI functionalities needed by the same two projects above.


libXpertMassGui
===============

*libXpertMassGui* is a C++ shared library that is referenced from other projects.

The *libXpertMassGui* shared library is designed to enshrine the GUI functionalities
needed by the following two projects:

* MsXpertSuite/massXpert2;
* MsXpertSuite/mineXpert2.

*libXpertMassGui* has a companion GUI library, *libXpertMassCore* , that is designed to
enshrine the non-GUI functionalities needed by the same two projects above.

