//***************************************************************************
//
//  Copyright (c) 1999 - 2006 Intel Corporation
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//***************************************************************************

/**
	@file	IFXRenderingCIDs.h

			This header defines all of the CIDs that identify the various
			components contained in the PluginName DL.
*/


#ifndef IFXRenderingCIDs_H
#define IFXRenderingCIDs_H


//***************************************************************************
//	Includes
//***************************************************************************


#include "IFXGUID.h"


//***************************************************************************
//	Component identifiers
//***************************************************************************


// {9517413B-09D2-4700-8E5A-2F52EE2B8126}
IFXDEFINE_GUID(CID_IFXDirectX8,
0x9517413b, 0x9d2, 0x4700, 0x8e, 0x5a, 0x2f, 0x52, 0xee, 0x2b, 0x81, 0x26);

// {2E0432CA-423D-429c-86CA-BC449542A900}
IFXDEFINE_GUID(CID_IFXDirectX7,
0x2e0432ca, 0x423d, 0x429c, 0x86, 0xca, 0xbc, 0x44, 0x95, 0x42, 0xa9, 0x0);

// {8CB0DD4D-5E73-4258-944B-487A2DBF4376}
IFXDEFINE_GUID(CID_IFXOpenGL,
0x8cb0dd4d, 0x5e73, 0x4258, 0x94, 0x4b, 0x48, 0x7a, 0x2d, 0xbf, 0x43, 0x76);

// {78005E95-DDEA-46a3-A382-B47195FA65EF}
IFXDEFINE_GUID(CID_IFXDeviceLight,
0x78005e95, 0xddea, 0x46a3, 0xa3, 0x82, 0xb4, 0x71, 0x95, 0xfa, 0x65, 0xef);

// {560830A6-5472-47e8-8D3D-2D533BD1F50B}
IFXDEFINE_GUID(CID_IFXDeviceTexture,
0x560830a6, 0x5472, 0x47e8, 0x8d, 0x3d, 0x2d, 0x53, 0x3b, 0xd1, 0xf5, 0xb);

// {C8C4296E-768F-43ce-9FB7-B2BBA50EBF30}
IFXDEFINE_GUID(CID_IFXDeviceTexUnit,
0xc8c4296e, 0x768f, 0x43ce, 0x9f, 0xb7, 0xb2, 0xbb, 0xa5, 0xe, 0xbf, 0x30);

#ifdef WIN32

// {7E92E91E-61EC-4834-A066-1F8F63D1F8F2}
IFXDEFINE_GUID(CID_IFXDeviceLightDX8,
0x7e92e91e, 0x61ec, 0x4834, 0xa0, 0x66, 0x1f, 0x8f, 0x63, 0xd1, 0xf8, 0xf2);

// {C2C6246F-612E-4423-89A7-E7D039AEC435}
IFXDEFINE_GUID(CID_IFXDeviceTextureDX8,
0xc2c6246f, 0x612e, 0x4423, 0x89, 0xa7, 0xe7, 0xd0, 0x39, 0xae, 0xc4, 0x35);

// {EB16F1C1-503A-4450-AEBB-29F97AB224C0}
IFXDEFINE_GUID(CID_IFXDeviceTexUnitDX8,
0xeb16f1c1, 0x503a, 0x4450, 0xae, 0xbb, 0x29, 0xf9, 0x7a, 0xb2, 0x24, 0xc0);

// {595F91F2-B792-4f0d-BDDB-EE5CAFD352CA}
IFXDEFINE_GUID(CID_IFXDeviceLightDX7,
0x595f91f2, 0xb792, 0x4f0d, 0xbd, 0xdb, 0xee, 0x5c, 0xaf, 0xd3, 0x52, 0xca);

// {E253F2FF-0E51-450d-8BA2-ADC64E06565E}
IFXDEFINE_GUID(CID_IFXDeviceTextureDX7,
0xe253f2ff, 0xe51, 0x450d, 0x8b, 0xa2, 0xad, 0xc6, 0x4e, 0x6, 0x56, 0x5e);

// {B19F1CFB-0C57-47c6-8FF5-8C1DA09BE404}
IFXDEFINE_GUID(CID_IFXDeviceTexUnitDX7,
0xb19f1cfb, 0xc57, 0x47c6, 0x8f, 0xf5, 0x8c, 0x1d, 0xa0, 0x9b, 0xe4, 0x4);

#endif // WIN32

// {7E92E91E-61EC-4834-A066-1F8F63D1F8F3}
IFXDEFINE_GUID(CID_IFXDeviceLightNULL,
0x7e92e91e, 0x61ec, 0x4834, 0xa0, 0x66, 0x1f, 0x8f, 0x63, 0xd1, 0xf8, 0xf3);

// {C2C6246F-612E-4423-89A7-E7D039AEC436}
IFXDEFINE_GUID(CID_IFXDeviceTextureNULL,
0xc2c6246f, 0x612e, 0x4423, 0x89, 0xa7, 0xe7, 0xd0, 0x39, 0xae, 0xc4, 0x36);

// {EB16F1C1-503A-4450-AEBB-29F97AB224C1}
IFXDEFINE_GUID(CID_IFXDeviceTexUnitNULL,
0xeb16f1c1, 0x503a, 0x4450, 0xae, 0xbb, 0x29, 0xf9, 0x7a, 0xb2, 0x24, 0xc1);

// {71B65845-A23A-49e2-BB4D-FE49EF8E2DAC}
IFXDEFINE_GUID(CID_IFXDeviceLightOGL,
0x71b65845, 0xa23a, 0x49e2, 0xbb, 0x4d, 0xfe, 0x49, 0xef, 0x8e, 0x2d, 0xac);

// {7E7F63A3-7EBD-4993-B321-A071910A80B7}
IFXDEFINE_GUID(CID_IFXDeviceTextureOGL,
0x7e7f63a3, 0x7ebd, 0x4993, 0xb3, 0x21, 0xa0, 0x71, 0x91, 0xa, 0x80, 0xb7);

// {6D9DC0A7-1B08-45d5-B4F8-4E060FB07AA2}
IFXDEFINE_GUID(CID_IFXDeviceTexUnitOGL,
0x6d9dc0a7, 0x1b08, 0x45d5, 0xb4, 0xf8, 0x4e, 0x6, 0xf, 0xb0, 0x7a, 0xa2);

// {030CDFDA-9A12-49de-B967-77E0ED1E55F8}
IFXDEFINE_GUID(CID_IFXRenderServices,
0x30cdfda, 0x9a12, 0x49de, 0xb9, 0x67, 0x77, 0xe0, 0xed, 0x1e, 0x55, 0xf8);

// {5F20D06B-D121-449a-BE82-CD134701D6AD}
IFXDEFINE_GUID(CID_IFXRenderContext,
0x5f20d06b, 0xd121, 0x449a, 0xbe, 0x82, 0xcd, 0x13, 0x47, 0x1, 0xd6, 0xad);

// {7C88A73A-808E-4729-B811-BD18759C320B}
IFXDEFINE_GUID(CID_IFXRenderDevice,
0x7c88a73a, 0x808e, 0x4729, 0xb8, 0x11, 0xbd, 0x18, 0x75, 0x9c, 0x32, 0xb);

#ifdef WIN32

// {6E104682-8670-4189-A277-72B75B2F76BE}
IFXDEFINE_GUID(CID_IFXRenderDX8,
0x6e104682, 0x8670, 0x4189, 0xa2, 0x77, 0x72, 0xb7, 0x5b, 0x2f, 0x76, 0xbe);

// {DFD9DA7A-1F26-4a4b-A48C-D47CEC8F9A5F}
IFXDEFINE_GUID(CID_IFXRenderDeviceDX8,
0xdfd9da7a, 0x1f26, 0x4a4b, 0xa4, 0x8c, 0xd4, 0x7c, 0xec, 0x8f, 0x9a, 0x5f);

// {242B8A87-DF7E-4745-A1F5-ADB57DF94CFF}
IFXDEFINE_GUID(CID_IFXRenderDX7,
0x242b8a87, 0xdf7e, 0x4745, 0xa1, 0xf5, 0xad, 0xb5, 0x7d, 0xf9, 0x4c, 0xff);

// {EC1ED06B-0624-46d4-98A5-10C5483261FD}
IFXDEFINE_GUID(CID_IFXRenderDeviceDX7,
0xec1ed06b, 0x624, 0x46d4, 0x98, 0xa5, 0x10, 0xc5, 0x48, 0x32, 0x61, 0xfd);

#endif // WIN32

// {6E104682-8670-4189-A277-72B75B2F76BF}
IFXDEFINE_GUID(CID_IFXRenderNULL,
0x6e104682, 0x8670, 0x4189, 0xa2, 0x77, 0x72, 0xb7, 0x5b, 0x2f, 0x76, 0xbf);

// {DFD9DA7A-1F26-4a4b-A48C-D47CEC8F9A60}
IFXDEFINE_GUID(CID_IFXRenderDeviceNULL,
0xdfd9da7a, 0x1f26, 0x4a4b, 0xa4, 0x8c, 0xd4, 0x7c, 0xec, 0x8f, 0x9a, 0x60);

// {43E21510-7881-4fbb-A642-54D366136C64}
IFXDEFINE_GUID(CID_IFXRenderOGL,
0x43e21510, 0x7881, 0x4fbb, 0xa6, 0x42, 0x54, 0xd3, 0x66, 0x13, 0x6c, 0x64);

// {602B6E5D-59A0-4a16-9795-72CA6802EC88}
IFXDEFINE_GUID(CID_IFXRenderDeviceOGL,
0x602b6e5d, 0x59a0, 0x4a16, 0x97, 0x95, 0x72, 0xca, 0x68, 0x2, 0xec, 0x88);



// {3CA3C019-D721-445e-8691-1104F35F0448}
IFXDEFINE_GUID(CID_IFXOctreeCollection,
0x3ca3c019, 0xd721, 0x445e, 0x86, 0x91, 0x11, 0x4, 0xf3, 0x5f, 0x4, 0x48);

// {B822FCF3-773B-4520-9DDF-35A3A1274A5A}
IFXDEFINE_GUID(CID_IFXOctreeCuller,
0xb822fcf3, 0x773b, 0x4520, 0x9d, 0xdf, 0x35, 0xa3, 0xa1, 0x27, 0x4a, 0x5a);

//---------------------------------------------------------------------------
//  CID_IFXSceneGraphCuller
//
//  This component supports the following interfaces:  IFXUnknown and
//  IFXSceneGraphCuller.  It is not a singleton.
//---------------------------------------------------------------------------
// {E439EBB2-B58C-4dfb-A4FB-093796B5986A}
IFXDEFINE_GUID(CID_IFXSceneGraphCuller,
0xe439ebb2, 0xb58c, 0x4dfb, 0xa4, 0xfb, 0x9, 0x37, 0x96, 0xb5, 0x98, 0x6a);


#endif
