/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <Metview.h>
#include "mars.h"
#include <iostream>

#include "MvQApplication.h"

#include "ProcMonitor.h"

svc* s = NULL;
int ac;
char** av;

ProcMonitor* mon;

void browse_cb(svcid* id, request* r, void*)
{
    mon->input(id, r);
}

void dummy_cb(svcid* id, request* /*r*/, void*)
{
    send_reply(id, NULL);
}

void monitor()
{
    request* t = empty_request("MONITOR");
    call_switchboard(s, t);
    free_all_requests(t);
}

int main(int argc, char** argv)
{
    MvQApplication app(argc, argv);

    //Initialise resorces from a static library (libMvQtGui)
    Q_INIT_RESOURCE(window);

    QApplication::setWindowIcon(
        QIcon(QPixmap(QString::fromUtf8(":/window/metview_logo"))));

    s = app.getService();
    add_service_callback(s, NULL, dummy_cb, NULL);
    add_progress_callback(s, NULL, browse_cb, NULL);

    mon = new ProcMonitor(s);

    //start
    monitor();

    mon->show();

    return app.exec();
}
