/*
 * Copyright (C) 1996-2000 Michael R. Elkins <me@mutt.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef MAPPING_H
#define MAPPING_H

struct mapping_t
{
  const char *name;
  int value;
};

const char *mutt_getnamebyvalue (int, const struct mapping_t *);
char *mutt_compile_help (char *, size_t, int, const struct mapping_t *);

const struct mapping_t *mutt_get_mapentry_by_name (const char *,
                                                   const struct mapping_t *);
int mutt_getvaluebyname (const char *, const struct mapping_t *);

#endif
