# How to contribute

Please keep all code, comments, issues and pull requests in English, otherwise they will be **removed**.

## Found a bug?

- First, check there are no already open issues for the bug. See [here](https://github.com/ntop/nDPI/issues).
- If there is not open issue addressing the bug, [open a new one](https://github.com/ntop/nDPI/issues/new).
- Make sure to include a **descriptive and clear title and description**, including the **version of nDPI** being used.
- Try to include steps to reproduce the bug.
- If applicable, try to provide a stacktrace.
- Providing a simple test case which shows the bug would help resolve the issue faster.

## Written a new protocol dissector?

- Ensure you have followed the guide in the [README](https://github.com/ntop/nDPI#how-to-add-a-new-protocol-dissector).
- Open a new pull request with a **clear, descriptive** title.
- Ensure the pull request passes CI testing. Any pull request which fails CI will be **ignored**.
- If possible, add a new test for the new protocol. See [existing tests](https://github.com/ntop/nDPI/tree/dev/tests) for examples.

## Written a fix for a bug?

- Open a new pull request with a **clear, descriptive** title.
- If there is an open issue for the bug, ensure the description of the pull request contains `Fixes #issue_number`.
- Ensure the pull request passes CI testing. Any pull request which fails CI will be **ignored**.

Finally, thank you for your contributions.
