#include <inttypes.h>
#include <smspdu.h>

struct smi_header {
  uint8_t  magic[2];
  uint8_t  format;
  uint16_t headerlen;
  /* model specific fields */
} __attribute__ ((packed));
#define SMI_FORMAT_SL42 0x00
#define SMI_FORMAT_S55  0x02

struct smi_head_s55 {
  struct {
    uint8_t total; /* count of concatenated short message parts (total) */
    uint8_t file; /* counts of parts in this file */
  } parts __attribute__ ((packed));
  uint16_t  unknown1;
  uint8_t   scts[7];
  uint8_t   unknown2;
} __attribute__ ((packed));

#define SMI_DATA_SIZE 175
struct smi_entry {
  uint8_t status;
  uint8_t data[SMI_DATA_SIZE]; /* SMS TPDU data */
} __attribute__ ((packed));
#define SMI_READ   0x01
#define SMI_UNREAD 0x03
#define SMI_SENT   0x05
#define SMI_UNSENT 0x07

struct sms_slot_data** smifile_read (char* file);

