/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import writer2latex.base.ConverterBase;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.StarMathConverter;
import writer2latex.office.EmbeddedObject;
import writer2latex.office.EmbeddedXMLObject;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableReader;
import writer2latex.util.Misc;

public final class MathConverter
extends ConverterHelper {
    private StarMathConverter smc;
    private boolean bContainsFormulas = false;
    private boolean bAddParAfterDisplay = false;
    private boolean bNeedTexMathsPreamble = false;
    private boolean bNeedOOoLaTeXPreamble = false;
    private Element theEquation = null;
    private Element theSequence = null;

    public MathConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.smc = new StarMathConverter(palette.getI18n(), config);
        this.bAddParAfterDisplay = config.formatting() >= 3;
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        Map<String, String> props;
        if (this.bContainsFormulas) {
            this.smc.appendDeclarations(pack, decl);
        }
        if (this.bNeedTexMathsPreamble && (props = this.palette.getMetaData().getUserDefinedMetaData()).containsKey("TexMathsPreamble")) {
            decl.append("% TexMaths preamble\n").append(props.get("TexMathsPreamble").replace('\u00a7', '\n'));
        }
        if (this.bNeedOOoLaTeXPreamble) {
            String sDescription = this.palette.getMetaData().getDescription();
            int nStart = sDescription.indexOf("%%% OOoLatex Preamble %%%%%%%%%%%%%%");
            int nEnd = sDescription.indexOf("%%% End OOoLatex Preamble %%%%%%%%%%%%");
            if (nStart > -1 && nEnd > nStart) {
                decl.append("% OOoLaTeX preamble").nl().append(sDescription.substring(nStart + 37, nEnd));
            }
        }
    }

    public String convert(Element formula) {
        Element semantics = Misc.getChildByTagName(formula, "semantics");
        if (semantics == null) {
            semantics = Misc.getChildByTagName(formula, "math:semantics");
        }
        if (semantics != null) {
            Element annotation = Misc.getChildByTagName(semantics, "annotation");
            if (annotation == null) {
                annotation = Misc.getChildByTagName(semantics, "math:annotation");
            }
            if (annotation != null) {
                String sStarMath = "";
                if (annotation.hasChildNodes()) {
                    NodeList anl = annotation.getChildNodes();
                    int nLen = anl.getLength();
                    for (int i = 0; i < nLen; ++i) {
                        if (anl.item(i).getNodeType() != 3) continue;
                        sStarMath = sStarMath + anl.item(i).getNodeValue();
                    }
                    this.bContainsFormulas = true;
                    return this.smc.convert(sStarMath);
                }
            }
        }
        if (formula.hasChildNodes()) {
            return "\\text{Warning: No StarMath annotation}";
        }
        return " ";
    }

    public boolean handleTexMathsEquation(Element node, LaTeXDocumentPortion ldp) {
        String sLaTeX = null;
        Element equation = this.palette.getTexMathsEquation(node);
        if (equation != null) {
            sLaTeX = Misc.getPCDATA(equation);
            if (sLaTeX != null) {
                this.bNeedTexMathsPreamble = true;
            }
        } else {
            StyleWithProperties style = this.ofr.getFrameStyle(Misc.getAttribute(node, "draw:style-name"));
            if (style != null && (sLaTeX = style.getProperty("OOoLatexArgs")) != null) {
                this.bNeedOOoLaTeXPreamble = true;
            }
        }
        if (sLaTeX != null) {
            switch (this.palette.getTexMathsStyle(sLaTeX)) {
                case inline: {
                    ldp.append("$").append(this.palette.getTexMathsEquation(sLaTeX)).append("$");
                    break;
                }
                case display: {
                    ldp.append("$\\displaystyle ").append(this.palette.getTexMathsEquation(sLaTeX)).append("$");
                    break;
                }
                case latex: {
                    ldp.append(this.palette.getTexMathsEquation(sLaTeX));
                }
            }
            return true;
        }
        return false;
    }

    public boolean handleDisplayEquation(TableReader table, LaTeXDocumentPortion ldp) {
        if (table.getRowCount() == 1 && table.getColCount() == 2 && OfficeReader.isSingleParagraph(table.getCell(0, 0)) && OfficeReader.isSingleParagraph(table.getCell(0, 1)) && this.parseDisplayEquation(Misc.getFirstChildElement(table.getCell(0, 0))) && this.theEquation != null && this.theSequence == null) {
            Element myEquation = this.theEquation;
            if (this.parseDisplayEquation(Misc.getFirstChildElement(table.getCell(0, 1))) && this.theEquation == null && this.theSequence != null) {
                this.handleDisplayEquation(myEquation, this.theSequence, ldp);
                return true;
            }
        }
        return false;
    }

    public boolean handleDisplayEquation(Element node, LaTeXDocumentPortion ldp) {
        if (this.parseDisplayEquation(node) && this.theEquation != null) {
            this.handleDisplayEquation(this.theEquation, this.theSequence, ldp);
            return true;
        }
        return false;
    }

    private void handleDisplayEquation(Element equation, Element sequence, LaTeXDocumentPortion ldp) {
        String sLaTeX;
        boolean bTexMaths = equation.getTagName().equals("svg:desc");
        ConverterBase.TexMathsStyle style = ConverterBase.TexMathsStyle.inline;
        if (bTexMaths) {
            sLaTeX = this.palette.getTexMathsEquation(Misc.getPCDATA(equation));
            style = this.palette.getTexMathsStyle(Misc.getPCDATA(equation));
            if (sLaTeX != null) {
                this.bNeedTexMathsPreamble = true;
            }
        } else {
            sLaTeX = this.convert(equation);
        }
        if (sLaTeX != null && !" ".equals(sLaTeX)) {
            if (!bTexMaths || style != ConverterBase.TexMathsStyle.latex) {
                if (sequence != null) {
                    ldp.append("\\begin{equation}");
                    this.palette.getFieldCv().handleSequenceLabel(sequence, ldp);
                    if (bTexMaths && style == ConverterBase.TexMathsStyle.inline) {
                        ldp.append("\\textstyle ");
                    }
                    ldp.nl().append(sLaTeX).nl().append("\\end{equation}").nl();
                } else {
                    ldp.append("\\begin{equation*}");
                    if (bTexMaths && style == ConverterBase.TexMathsStyle.inline) {
                        ldp.append("\\textstyle ");
                    }
                    ldp.nl().append(sLaTeX).nl().append("\\end{equation*}").nl();
                }
            } else {
                ldp.append(sLaTeX).nl();
            }
            if (this.bAddParAfterDisplay) {
                ldp.nl();
            }
        }
    }

    private boolean parseDisplayEquation(Node node) {
        this.theEquation = null;
        this.theSequence = null;
        return this.doParseDisplayEquation(node);
    }

    private boolean doParseDisplayEquation(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Misc.isElement(child)) {
                Element elm = (Element)child;
                String sName = elm.getTagName();
                Element equation = this.getMathmlEquation(elm);
                if (equation == null) {
                    equation = this.palette.getTexMathsEquation(elm);
                }
                if (equation != null) {
                    if (this.theEquation == null) {
                        this.theEquation = equation;
                        continue;
                    }
                    return false;
                }
                if ("text:sequence".equals(sName)) {
                    if (this.theSequence == null) {
                        this.theSequence = elm;
                        continue;
                    }
                    return false;
                }
                if ("text:span".equals(sName)) {
                    if (this.doParseDisplayEquation(child)) continue;
                    return false;
                }
                if ("text:s".equals(sName) || "text:tab".equals(sName) || "text:tab-stop".equals(sName) || "text:soft-page-break".equals(sName)) continue;
                return false;
            }
            if (!Misc.isText(child)) continue;
            String s = child.getNodeValue();
            int nLen = s.length();
            for (int i = 0; i < nLen; ++i) {
                char c = s.charAt(i);
                if (c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}' || c == ' ' || c == '\u00a0') continue;
                return false;
            }
        }
        return true;
    }

    private Element getMathmlEquation(Element node) {
        String sHref;
        if (node.getTagName().equals("draw:frame")) {
            node = Misc.getFirstChildElement(node);
        }
        if ((sHref = Misc.getAttribute(node, "xlink:href")) != null) {
            if (this.ofr.isInPackage(sHref)) {
                EmbeddedObject object;
                if (sHref.startsWith("#")) {
                    sHref = sHref.substring(1);
                }
                if (sHref.startsWith("./")) {
                    sHref = sHref.substring(2);
                }
                if ((object = this.palette.getEmbeddedObject(sHref)) != null && ("application/vnd.sun.xml.math".equals(object.getType()) || "application/vnd.oasis.opendocument.formula".equals(object.getType()))) {
                    try {
                        Document formuladoc = ((EmbeddedXMLObject)object).getContentDOM();
                        Element formula = Misc.getChildByTagName(formuladoc, "math");
                        if (formula == null) {
                            formula = Misc.getChildByTagName(formuladoc, "math:math");
                        }
                        return formula;
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            Element formula = Misc.getChildByTagName(node, "math");
            if (formula == null) {
                formula = Misc.getChildByTagName(node, "math:math");
            }
            return formula;
        }
        return null;
    }
}

