/*
 * $Id$
 */

#include <stdio.h>
#include "ruby.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

#ifndef NARRAY_BIGMEM
typedef int    na_shape_t;
#endif

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, na_shape_t, int, na_shape_t *);
extern VALUE dcl_crealary2obj(real *, na_shape_t, int, na_shape_t *);
/* extern VALUE dcl_ccomplexary2obj(complex *, int, char *); */
extern VALUE dcl_clogicalary2obj(logical *, na_shape_t, int, na_shape_t *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_igus(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = igus__(&i_rx);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_imod(obj, ix, id)
    VALUE obj, ix, id;
{
    integer i_ix;
    integer i_id;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) != T_BIGNUM) || (TYPE(ix) != T_FIXNUM)) {
      ix = rb_funcall(ix, rb_intern("to_i"), 0);
    }
    if ((TYPE(id) != T_BIGNUM) || (TYPE(id) != T_FIXNUM)) {
      id = rb_funcall(id, rb_intern("to_i"), 0);
    }

    i_ix = NUM2INT(ix);
    i_id = NUM2INT(id);


    o_rtn_val = imod__(&i_ix, &i_id);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_rmod(obj, rx, rd)
    VALUE obj, rx, rd;
{
    real i_rx;
    real i_rd;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }
    if (TYPE(rd) != T_FLOAT) {
      rd = rb_funcall(rd, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);
    i_rd = (real)NUM2DBL(rd);


    o_rtn_val = rmod__(&i_rx, &i_rd);

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_rexp(obj, rx, ib, ie)
    VALUE obj, rx, ib, ie;
{
    real i_rx;
    integer i_ib;
    integer i_ie;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }
    if ((TYPE(ib) != T_BIGNUM) || (TYPE(ib) != T_FIXNUM)) {
      ib = rb_funcall(ib, rb_intern("to_i"), 0);
    }
    if ((TYPE(ie) != T_BIGNUM) || (TYPE(ie) != T_FIXNUM)) {
      ie = rb_funcall(ie, rb_intern("to_i"), 0);
    }

    i_rx = (real)NUM2DBL(rx);
    i_ib = NUM2INT(ib);
    i_ie = NUM2INT(ie);


    o_rtn_val = rexp__(&i_rx, &i_ib, &i_ie);

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_rd2r(obj, x)
    VALUE obj, x;
{
    real i_x;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);


    o_rtn_val = rd2r__(&i_x);

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_rr2d(obj, x)
    VALUE obj, x;
{
    real i_x;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);


    o_rtn_val = rr2d__(&i_x);

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_rfpi(obj)
    VALUE obj;
{
    real o_rtn_val;
    VALUE rtn_val;

    o_rtn_val = rfpi__();

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}
void
init_math1_fnclib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "igus", dcl_igus, 1);
    rb_define_module_function(mDCL, "imod", dcl_imod, 2);
    rb_define_module_function(mDCL, "rmod", dcl_rmod, 2);
    rb_define_module_function(mDCL, "rexp", dcl_rexp, 3);
    rb_define_module_function(mDCL, "rd2r", dcl_rd2r, 1);
    rb_define_module_function(mDCL, "rr2d", dcl_rr2d, 1);
    rb_define_module_function(mDCL, "rfpi", dcl_rfpi, 0);
}
