!=========================================================================
!			켡ȥ졼ήǥ
!
! 	1997/10/16		2
!
!=========================================================================
module cal_module
public :: get_dtrc,get_mval

  contains
!=========================================================================
subroutine get_dtrc( u, dt, dx, TRC, DTRC )

  real,dimension(:),intent(in)  :: u
  real,intent(in)  :: dt, dx
  real,dimension(:),intent(in)  :: TRC 
  real,dimension(:),intent(out) :: DTRC
  real,dimension(:),allocatable :: TRCM ! ȥ졼ѿ(Ⱦ)
  real,dimension(:),allocatable :: FLUX ! եå
  real,dimension(:),allocatable  :: ADVE ! ή
  integer              :: i
  integer              :: dimm

  dimm = size(TRC)

  allocate( TRCM(dimm+1) )
  allocate( FLUX(dimm+1) )
  allocate( ADVE(dimm) )

  call get_mval( TRC, TRCM )

  FLUX = u * TRCM 

  do i = 1, dimm    
     ADVE(i) = - ( FLUX(i+1) - FLUX(i) )/dx
  end do

  DTRC = dt * ADVE

  deallocate( TRCM, FLUX, ADVE )

end subroutine get_dtrc
!=========================================================================
subroutine get_mval( val, mval )

  real,dimension(:),intent(in)  :: val
  real,dimension(:),intent(out) :: mval
  integer                       :: i
  integer                       :: dimm, xdim

  dimm = size(val)
  xdim = size(mval)

  mval(1)    = ( val(1) + val(dimm) )/2

  do i = 2, dimm
     mval(i) = ( val(i) + val(i-1) )/2
  end do

  mval(xdim) = mval(1)

end subroutine get_mval
!=========================================================================
!subroutine dennou_set
!
!call SGLSET( 'LCORNER', .FALSE. )
!call SWISET( 'IPOSX', 50 )
!call SWISET( 'IPOSY', 50 )
!call SWLSET( 'LALT', .TRUE. )
!call SWLSET( 'LWAIT', .FALSE. )
!call GROPN( 1 )
!
!end subroutine dennou_set
!=========================================================================
!subroutine dennou_draw( xplot, yplot, header )
!
!real,dimension(:),intent(in):: xplot
!real,dimension(:),intent(in):: yplot
!CHARACTER(LEN=9),intent(in):: header
!
!call GRFRM
!call USSTTL( 'X', '', '', '' ) 
!call USGRPH( xdim, xplot, yplot )
!
!end subroutine dennou_draw
!=========================================================================
end module cal_module

program main
use cal_module
implicit none

  integer,parameter :: dimm  = 128       !ʻ
  integer,parameter :: xdim = dimm+1     ! ѿ
  real,parameter    :: xmin = 0.0        ! ΰ貼
  real,parameter    :: xmax = 1.0       ! ΰ

  real :: dx ! ʻҴֳ
  real :: dt ! ֳִ

  real,dimension(xdim) :: xplot ! ʻɸ
  real,dimension(xdim) :: u     ! ή®(ʻ)
  real,dimension(dimm) :: TRC   ! ѿ(ʻ)
  real,dimension(xdim) :: TRCP  ! ѿ(Ⱦ)

  real                 :: a      ! ѥѥ᡼
  integer              :: tstep
!  character(len=9)     :: header ! إå
!  character(len=3)     :: time   ! 
  real,dimension(dimm) :: DTRC1  ! ʬ1
  real,dimension(dimm) :: DTRC2  ! ʬ2
  integer              :: i

!- ѥ᡼

  dx  = ( xmax - xmin )/dimm 
  u   = 1.0
  dt  = 0.8 * dx/maxval(u)
  a   = 0.1

  do i = 1, xdim
     xplot(i) = dx * ( i - 1 )
  end do

!- ͤ(ʬ)

  do i = 1, dimm
     TRC(i) = 1.0*exp( - ( (i - dimm/2)*dx/a)**2 )
  end do


!- ֥ƥå׿ɤ߹

  write(unit=6,fmt=*) "INPUT TIME STEP NUMBER ? (I)"
  read(unit=5,fmt=*) tstep

!  write(unit=time,fmt=*) tstep
!  header = "tstep=" // time 


!- ͤ

!call dennou_set
!call get_mval( TRC, TRCP )
!call dennou_draw( xplot,  TRCP , header)

!- ʬ

  do i = 1, tstep

!     write(unit=time,fmt=*) i
!     header = "tstep=" // time 
     write(unit=6,fmt=*) i

     call get_dtrc( u, dt, dx, TRC, DTRC1 )
     call get_dtrc( u, dt, dx, TRC+DTRC1, DTRC2 )

     TRC = TRC + ( DTRC1 + DTRC2 )/2

     call get_mval( TRC, TRCP )
!   call dennou_draw( xplot,  TRCP , header)

  end do


!- 

!call GRCLS

end program main

