!= Matthews Υǡ˴Ť٤
!
!= set roughness length on land surface based on data by Matthews
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: roughlen_Matthews.f90,v 1.2 2010-02-24 08:07:54 yot Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module roughlen_Matthews

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING     ! ʸ.       Strings.

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetRoughLenLandMatthews

  ! ѿ)
  ! Public variables
  !
  logical, save, public:: roughlen_matthews_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  integer, parameter :: NLandUseType = 32
  integer, parameter :: NM84Element  =  9
  integer, parameter :: NM84Type     = 22

  integer, save      :: DataSurfCond2M84Type( 0:NLandUseType )
  real(DP)  , save      :: DataM84Weight( NM84Element, 0:NM84Type )
  real(DP)  , save      :: DataM84RL( NM84Element )

  real(DP)  , parameter :: z0_ice = 0.01d0


  !
  ! Matthews (1984) grouped UNESCO land use type into 22 groups, whose properties
  ! can be constructed by conbining properties of those of 9 land use 'elemental
  ! groups'. Note that a word 'elemental group' is not used by Matthews (1984).
  !
  !
  ! Table 2B of Matthews (1984), NASA Technical memorandum #86096
  !
  ! 9 'elemental group' is as follows.
  !   #1 desert
  !   #2 tundra
  !   #3 grassland
  !   #4 grassland with shrub cover
  !   #5 grassland with tree cover
  !   #6 deciduous forest
  !   #7 evergreen forest
  !   #8 rainforest
  !   #9 ice
  !
  !     %1   %2   %3   %4   %5   %6   %7   %8   %9
  data DataM84Weight / &
         0,   0,   0,   0,   0,   0,   0,   0,   0, & !  0, This is not included in Matthews papers.
         0,   0,   0,   0,   0,   0,   0, 100,   0, & !  1
         0,   0,  25,   0,   0,   0,  75,   0,   0, & !  2
        40,   0,   0,   0,   0,   0,  60,   0,   0, & !  3
         0,   0,   0,   0,   0,   0, 100,   0,   0, & !  4
         0,   0,  25,   0,   0,  75,   0,   0,   0, & !  5
         0,   0,   0,   0,   0, 100,   0,   0,   0, & !  6
        15,   0,   0,   0,   0,  85,   0,   0,   0, & !  7
        85,   0,   0,   0,   0,  15,   0,   0,   0, & !  8
        35,   0,   0,   0,   0,   0,  65,   0,   0, & !  9
        25,   0,  25,   0,   0,   0,  50,   0,   0, & ! 10
        35,   0,   0,   0,   0,  65,   0,   0,   0, & ! 11
        30,   0,   0,   0,   0,  70,   0,   0,   0, & ! 12
         0,   0,  50,   0,   0,  50,   0,   0,   0, & ! 13
        10,   0,  80,   0,   0,   0,  10,   0,   0, & ! 14
        10,   0,  80,   0,   0,  10,   0,   0,   0, & ! 15
         0, 100,   0,   0,   0,   0,   0,   0,   0, & ! 16
         0,   0,   0,   0, 100,   0,   0,   0,   0, & ! 17
         0,   0,   0, 100,   0,   0,   0,   0,   0, & ! 18
         0,   0, 100,   0,   0,   0,   0,   0,   0, & ! 19
       100,   0,   0,   0,   0,   0,   0,   0,   0, & ! 20
         0,   0,   0,   0,   0,   0,   0,   0, 100, & ! 21 ice
        30,   0,   0,   0,   0,   0,  70,   0,   0  & ! 22
        /

  !
  ! roughness length
  ! Table 3 of Matthews (1984). unit is cm.
  ! A value of roughness length for ice is not included in Matthews (1984).
  !
  !     %1     %2     %3     %4     %5     %6     %7     %8     %9
  data DataM84RL / &
       0.5,   0.5,   1.0,   1.0,   1.8,  32.0, 100.0, 200.0,   0 &
       /

contains

  subroutine SetRoughLenLandMatthews( xy_SurfCond, xy_SurfRoughLen )

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ʸ ; Declaration statements
    !
    integer , intent(in   ) :: xy_SurfCond    ( 0:imax-1, 1:jmax )
    real(DP), intent(inout) :: xy_SurfRoughLen( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: l


    if ( .not. roughlen_matthews_inited ) call SetRoughLenInit


    !
    !
    !
    do j = 1, jmax
      do i = 0, imax-1
        if( xy_SurfCond( i, j ) >= 1 ) then
          xy_SurfRoughLen( i, j ) = 0.0d0
        end if
      end do
    end do
    do l = 1, NM84Element
      do j = 1, jmax
        do i = 0, imax-1
          if( xy_SurfCond( i, j ) >= 1 ) then
            xy_SurfRoughLen( i, j ) = xy_SurfRoughLen( i, j ) &
              + DataM84RL( l ) &
              * DataM84Weight( l, DataSurfCond2M84Type( xy_SurfCond( i, j ) ) )
          end if
        end do
      end do
    end do


    !
    ! ice
    !
    do j = 1, jmax
      do i = 0, imax-1

        if( xy_SurfCond( i, j ) == 31 ) then
          xy_SurfRoughLen( i, j ) = z0_ice
        end if

      end do
    end do


  end subroutine SetRoughLenLandMatthews

  !************************************************************************************

  subroutine SetRoughLenInit

    ! ѿ
    ! Work variables
    !
    integer:: l
    integer:: m

    !
    ! This table/list is created by using Table 4 of Matthews (1983) and Table 1 of 
    ! Matthews (1984).
    !
    DataSurfCond2M84Type(  0 ) =  0 ! ocean, This is not included in Matthews papers.
    DataSurfCond2M84Type(  1 ) =  1
    DataSurfCond2M84Type(  2 ) =  1
    DataSurfCond2M84Type(  3 ) =  1
    DataSurfCond2M84Type(  4 ) =  1
    DataSurfCond2M84Type(  5 ) =  2
    DataSurfCond2M84Type(  6 ) =  3
    DataSurfCond2M84Type(  7 ) =  4
    DataSurfCond2M84Type(  8 ) =  4
    DataSurfCond2M84Type(  9 ) =  5
    DataSurfCond2M84Type( 10 ) =  6 ! A
    DataSurfCond2M84Type( 11 ) =  6 ! B, This may be 7. I cannot identify.
    DataSurfCond2M84Type( 12 ) =  8 ! C
    DataSurfCond2M84Type( 13 ) =  9 ! D
    DataSurfCond2M84Type( 14 ) = 10 ! E
    DataSurfCond2M84Type( 15 ) = 11 ! F
    DataSurfCond2M84Type( 16 ) = 12 ! G
    DataSurfCond2M84Type( 17 ) = 14 ! H
    DataSurfCond2M84Type( 18 ) = 14 ! I
    DataSurfCond2M84Type( 19 ) = 15 ! J
    DataSurfCond2M84Type( 20 ) = 15 ! K
    DataSurfCond2M84Type( 21 ) =  8 ! L
    DataSurfCond2M84Type( 22 ) = 16 ! M
    DataSurfCond2M84Type( 23 ) = 17 ! N
    DataSurfCond2M84Type( 24 ) = 17 ! O
    DataSurfCond2M84Type( 25 ) = 17 ! P
    DataSurfCond2M84Type( 26 ) = 19 ! Q
    DataSurfCond2M84Type( 27 ) = 19 ! R
    DataSurfCond2M84Type( 28 ) = 19 ! S
    DataSurfCond2M84Type( 29 ) = 19 ! T
    DataSurfCond2M84Type( 30 ) = 20 ! U
    DataSurfCond2M84Type( 31 ) = 21 ! V ice
    DataSurfCond2M84Type( 32 ) = 19 ! W

    do m = 0, NM84Type
      do l = 1, NM84Element
        DataM84Weight( l, m ) = DataM84Weight( l, m ) * 1.0d-2
      end do
    end do
    do l = 1, NM84Element
      DataM84RL( l ) = DataM84RL( l ) * 1.0d-2
    end do

    roughlen_matthews_inited = .true.

  end subroutine SetRoughLenInit

  !**************************************************************************************

!!$
!!$  subroutine setroughnesslength_ocean( im, jm, km, gzs, gsfcindex, &
!!$    gu, gv, gt, galt, gpt, gpth, gz0_out )
!!$
!!$    use vtype_module
!!$    use const_module, only : grav
!!$    use vdiff_module
!!$
!!$    implicit none
!!$
!!$    integer(i4b), intent(in   ) :: im, jm, km
!!$    real(dp)    , intent(in   ) :: gzs( im, jm )
!!$    integer(i4b), intent(in   ) :: gsfcindex( im, jm )
!!$    real(dp)    , intent(in   ) :: gu( im, jm, km ), gv( im, jm, km ), gt( im, jm, km ), galt( im, jm, km ), gpt( im, jm, km ), gpth( im, jm, km+1 )
!!$    real(dp)    , intent(inout) :: gz0_out( im, jm )
!!$
!!$    !
!!$    ! local variables
!!$    !
!!$    real(dp)    , parameter :: gz0_init = 0.01d0
!!$
!!$    real(dp)                :: c_charnock
!!$
!!$    integer(i4b)            :: iitr, nitr
!!$    real(dp)                :: cd( im, jm ), ch( im, jm ), fvsq( im, jm )
!!$
!!$    real(dp)                :: gz0( im, jm )
!!$
!!$    integer(i4b)            :: i, j
!!$
!!$
!!$    !
!!$    ! initial value for interation
!!$    !
!!$    do j = 1, jm
!!$      do i = 1, im
!!$        gz0( i, j ) = gz0_init
!!$      end do
!!$    end do
!!$
!!$    nitr = 10
!!$    do iitr = 1, nitr
!!$
!!$      call vdiff_dragcoef_core( im, jm, km, gzs, &
!!$        gz0, &
!!$        gu, gv, gt, galt, gpt, gpth, cd, ch )
!!$
!!$      write( 6, * ) gsfcindex( 1, jm/2 ), iitr, gz0( 1, jm/2 ), cd( 1, jm/2 )
!!$
!!$
!!$      do j = 1, jm
!!$        do i = 1, im
!!$          fvsq( i, j ) = ( cd( i, j ) + 1.0d-6 )&
!!$            * ( gu( i, j, km )**2 + gv( i, j, km )**2 + 1.0d-3 )
!!$        end do
!!$      end do
!!$
!!$      !
!!$      ! Krishnamurti?
!!$!         c_charnock = 0.04d0
!!$      !
!!$      ! Wu (1967), technical report
!!$      ! http://oai.dtic.mil/oai/oai?&verb=getRecord&metadataPrefix=html&identifier=AD0672750
!!$!         c_charnock = 0.0156d0
!!$      ! Wu (1980), JPO
!!$      c_charnock = 0.0185d0
!!$      do j = 1, jm
!!$        do i = 1, im
!!$          if( gsfcindex( i, j ) .le. 0 ) then
!!$            ! Ocean
!!$            ! Charnock, 1955
!!$            gz0( i, j ) = c_charnock * fvsq( i, j ) / grav
!!$          end if
!!$        end do
!!$      end do
!!$
!!$    end do
!!$
!!$
!!$    do j = 1, jm
!!$      do i = 1, im
!!$
!!$        if( gsfcindex( i, j ) .le. 0 ) then
!!$          gz0_out( i, j ) = gz0( i, j )
!!$        end if
!!$
!!$      end do
!!$    end do
!!$
!!$
!!$  end subroutine setroughnesslength_ocean

end module roughlen_Matthews
