!= Module ChemData
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: chemdata.f90,v 1.1 2009-03-05 05:39:39 yamasita Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!βؼʪǡݴɤ⥸塼(ή׻). 
!
!   * ̿̾§
!     "ؼ̾-"
!
!ƤʪˤͿɬפʪ
!   *  ('Gas' => , 'Liq' => , 'Sol' => )
!   * ʬ
!   * ʬҤ븵ǤȤθĿ
!
!ФɬͿɬפΤʪ
!   * ֤Υȥԡ
!   * ֤Υ󥿥ԡ
!   * Ǯβٰ¸
!
!ꡦФɬͿɬפΤʪ
!   * ˰¾βٰ¸
!   * Antoine μη
!
!CO2  Antoine μηɲ. (by YAMASHITA)
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!   * ֹ 20 ޤǤƤʤ. 
!   * ʬҤϤ褯ФƤΤƤʤ. 
!   * ʬҤϼ׸ 7 ĤΤȤ. (H, He, C, N, O, S)
!
!== References
!
!   * Ǥμ̤ϲ 4 ()
!
!== Future Plans
!


module ChemData
  !
  !βؼʪǡݴɤ⥸塼
  !
  !   * ̿̾§
  !     "ؼ̾-"
  !
  !ƤʪˤͿɬפʪ
  !   *  ('Gas' => , 'Liq' => , 'Sol' => )
  !   * ʬ
  !   * ʬҤ븵ǤȤθĿ
  !
  !ФɬͿɬפΤʪ
  !   * ֤Υȥԡ
  !   * ֤Υ󥿥ԡ
  !   * Ǯβٰ¸
  !
  !ꡦФɬͿɬפΤʪ
  !   * ˰¾βٰ¸
  !   * Antoine μη
  !

  save
  
  !ѿ
  real(8), parameter :: TempRef  = 298.15d0                   !ɸಹ [K]
  real(8), parameter :: Temp0C   = 273.15d0                   !0 ٤Ǥβ [K]
  real(8), parameter :: PressRef = 1.0d5                      !ɸవ [Pa]
  real(8), parameter :: GasRUniv = 8.314d0                    !׵
  integer, parameter :: ChemData_AtmNum  = 6                  !Ǥο
  integer, parameter :: ChemData_SpcNum  = 12                 !ؼο
  integer, parameter :: ChemData_DataNum = 16                 !ǡ
  character(2)       :: ChemData_AtmSymbol(ChemData_AtmNum)   !ҵ
  real(8)            :: ChemData_AtmWt(ChemData_AtmNum)       ! [kg/mol]
  character(20)      :: ChemData_SpcSymbol(ChemData_SpcNum)   !ʬҵ
  character(3)       :: ChemData_Phase(ChemData_SpcNum)       !
  real(8)            :: ChemData_MolWt(ChemData_SpcNum)       !ʬ [kg/mol]
  real(8)            :: ChemData_GasR(ChemData_SpcNum)        ![J/K kg]
  integer            :: ChemData_SpcFormula(ChemData_SpcNum,ChemData_AtmNum) 
                                            !ʬҤ븵ǤθĿ
  real(8)            :: ChemData_Entropy(ChemData_SpcNum)  
                                            !२ȥԡ[J/K mol]
  real(8)            :: ChemData_Enthalpy(ChemData_SpcNum)
                                            !२󥿥ԡ[J/K mol]
  real(8)            :: ChemData_CpPerMol(ChemData_SpcNum, ChemData_DataNum)   
                                            !Ǯ() [J/K mol]
  real(8)            :: ChemData_Cp(ChemData_SpcNum, ChemData_DataNum)
                                            !Ǯ(ñ̼) [J/K kg]
  real(8)            :: ChemData_Cp_Temp(ChemData_SpcNum, ChemData_DataNum)
                                            !Ǯǡб벹[K]
  real(8)            :: ChemData_CpPerMolRef(ChemData_SpcNum)
                                            !ɸ֤Ǯ() [J/K mol]
  real(8)            :: ChemData_CpRef(ChemData_SpcNum)
                                            !ɸ֤Ǯ(ñ̼) [J/K kg]
  real(8)            :: ChemData_CvPerMolRef(ChemData_SpcNum)
                                            !ɸ֤Ǯ() [J/K mol]
  real(8)            :: ChemData_CvRef(ChemData_SpcNum)
                                            !ɸ֤Ǯ(ñ̼) [J/K kg]
  real(8)            :: ChemData_SVapPress(ChemData_SpcNum, ChemData_DataNum)  
                                            ! ˰¾ [Pa]
  real(8)            :: ChemData_SVapPress_Temp(ChemData_SpcNum, ChemData_DataNum)
                                            !˰¾ǡб벹 [K]
  real(8)            :: ChemData_SVapPress_AntoineA(ChemData_SpcNum) 
                                            !Antoine  A 
  real(8)            :: ChemData_SVapPress_AntoineB(ChemData_SpcNum) 
                                            !Antoine  B 
  real(8)            :: ChemData_SVapPress_AntoineC(ChemData_SpcNum) 
                                            !Antoine  C 
  real(8)            :: ChemData_SVapPress_AntoineUnit(ChemData_SpcNum) 
                                            !Antoine ñѴѤη
  real(8)            :: ChemData_SVapPress_AMPA(ChemData_SpcNum) 
                                            !Antoine  A 
  real(8)            :: ChemData_SVapPress_AMPB(ChemData_SpcNum) 
                                            !Antoine  B 
  real(8)            :: ChemData_SVapPress_AMPC(ChemData_SpcNum) 
                                            !Antoine  C 
  real(8)            :: ChemData_SVapPress_AMPD(ChemData_SpcNum) 
                                            !Antoine  C 
  real(8)            :: ChemData_SVapPress_AMPE(ChemData_SpcNum) 
                                            !Antoine ñѴѤη

contains

  subroutine ChemData_Init
    !
    ! ʪ̾ФֹդԤ, ֹФ
    ! ʪͤƤ
    !

    !ۤηػ
    implicit none
    
    !ѿ
    integer        :: SNum, ANum1, ANum2, ANum3, RNum
    character(2)   :: AtmSymbol
    character(20)  :: SpcSymbol

    !-------------------------------------------------------------
    ! , ʬ̾˳Ǽ. 
    !-------------------------------------------------------------
    !ҵ 
    ChemData_AtmSymbol = (/ &
      & "H ",               & ! #1
      & "He",               & ! #2
      & "C ",               & ! #3
      & "N ",               & ! #4
      & "O ",               & ! #5
      & "S "                & ! #6
      & /)

    ! (kg/mol). 
    ChemData_AtmWt = (/                       &
      & 1.00794d-3,      & ! #1
      & 4.002602d-3,     & ! #2
      & 12.0107d-3,      & ! #3
      & 14.00674d-3,     & ! #4
      & 15.9994d-3,      & ! #5
      & 32.066d-3        & ! #6
      /) 

    !ʬ
    ChemData_SpcSymbol = (/ &
      & "N2-g   ",  &              !#01
      & "H2-g   ",  &              !#02
      & "He-g   ",  &              !#03
      & "He-g   ",  &              !#04
      & "H2O-g  ",  &              !#05
      & "H2O-l  ",  &              !#06
      & "H2O-s  ",  &              !#07
      & "NH3-g  ",  &              !#08
      & "NH3-s  ",  &              !#09
      & "H2S-g  ",  &              !#10
      & "NH4SH-s",  &              !#11
      & "CO2-g  "   &              !#12
      & /)

    !-------------------------------------------------------------
    ! 줾θ, ʬҤбʪͤǼ
    !-------------------------------------------------------------
    !
    ChemData_MolWt       = 0.0d0
    ChemData_GasR        = 0.0d0 
    ChemData_Entropy     = 0.0d0
    ChemData_Enthalpy    = 0.0d0
    ChemData_SpcFormula  = 0.0d0
    ChemData_CpPerMol    = 0.0d0
    ChemData_Cp          = 0.0d0
    ChemData_Cp_Temp     = 0.0d0
    ChemData_CpPerMolRef = 0.0d0
    ChemData_CpRef       = 0.0d0
    ChemData_CvPerMolRef = 0.0d0
    ChemData_CvRef       = 0.0d0
    ChemData_SVapPress   = 0.0d0
    ChemData_SVapPress_Temp     = 0.0d0
    ChemData_SVapPress_AntoineA = 0.0d0
    ChemData_SVapPress_AntoineB = 0.0d0
    ChemData_SVapPress_AntoineC = 0.0d0
    ChemData_SVapPress_AntoineUnit = 0.0d0
    ChemData_SVapPress_AMPA = 0.0d0
    ChemData_SVapPress_AMPB = 0.0d0
    ChemData_SVapPress_AMPC = 0.0d0
    ChemData_SVapPress_AMPD = 0.0d0
    ChemData_SVapPress_AMPE = 0.0d0
    SNum = 0
    RNum = 0
    ANum1 = 0
    ANum2 = 0
    ANum3 = 0

    !!=============================================================
    !! N2-g ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'N2-g'
    SNum  = ChemData_SearchSpc( SpcSymbol )
    AtmSymbol = 'N'
    ANum1 = ChemData_SearchAtm( AtmSymbol )

    !
    ChemData_Phase(SNum) = 'Gas'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 191.609d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = 0.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 2.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
     
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)

    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:9) = (/ &
      & 29.104d0, 29.107d0, 29.111d0, 29.124d0, 29.125d0, &
      & 29.165d0, 29.249d0, 29.387d0, 29.58d0 /)

    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)

    !갵Ǯβٰ¸
    ChemData_Cp_temp(SNum,1:9) = (/ &
      & 100.0d0,  200.0d0,  250.0d0,  298.15d0, 300.0d0,  &
      & 350.0d0,  400.0d0,  450.0d0,  500.0d0 /)

    !֤Ǥֹ
    RNum = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !֤Ǥñ̥갵Ǯ [J/K mol]. 
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
       
    !֤Ǥñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !֤Ǥñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !֤Ǥñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)


    !!=============================================================
    !! H2-g ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'H2-g'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'H'
    ANum1 = ChemData_SearchAtm( AtmSymbol)

    !
    ChemData_Phase(SNum) = 'Gas'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 130.68d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = 0.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 2.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
     
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)
    
    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:12) = (/ &
      & 20.65d0, 21.15d0, 22.46d0, 23.85d0, 25.18d0, &
      & 26.32d0, 27.17d0, 27.61d0, 28.03d0, 28.34d0, &
      & 28.57d0, 28.59d0 /)

    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)

    !갵Ǯβٰ¸
    ChemData_Cp_temp(SNum,1:12) = (/ &
      & 50.0d0,    75.0d0, 100.0d0, 125.0d0, 150.0d0, &
      & 175.0d0,  200.0d0, 225.0d0, 250.0d0, 275.0d0, &
      & 298.15d0, 300.0d0 /)

    !֤Ǥֹ
    RNum = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !֤Ǥñ̥갵Ǯ [J/K mol]. 
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !֤Ǥñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !֤Ǥñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !֤Ǥñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)


    !!=============================================================
    !! CO2-g ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'CO2-g'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'C'
    ANum1 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'O'
    ANum2 = ChemData_SearchAtm( AtmSymbol)

    !
    ChemData_Phase(SNum) = 'Gas'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) =  0.0d0   !ץå

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = 0.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 1.0d0
    ChemData_SpcFormula(SNum,ANum2) = 2.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
     
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)
    
    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:5) = (/ &
      & 34.46d0, 32.3d0, 37.53d0, 41.44d0, 44.68d0 /)
    
    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)

    !갵Ǯβٰ¸
    ChemData_Cp_temp(SNum,1:5) = (/ &
      & 200.0d0, 298.15d0, 300.0d0, 400.0d0, 500.0d0 /)

    !֤Ǥֹ
    RNum = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !֤Ǥñ̥갵Ǯ [J/K mol]. 
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !֤Ǥñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !֤Ǥñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !֤Ǥñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)


    !Antoine μη (عز, 1999)
    !2008/06/09  ã ɲ 
    ChemData_SvapPress_AntoineA(SNum) =  27.4d0
    ChemData_SvapPress_AntoineB(SNum) =  3103d0 
    ChemData_SvapPress_AntoineC(SNum) =  -0.16d0

    !!=============================================================
    !! He-g ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'He-g'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'He'
    ANum1 = ChemData_SearchAtm( AtmSymbol)

    !
    ChemData_Phase(SNum) = 'Gas'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 0.0d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = 0.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 1.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
     
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)
    
    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,:) = 20.786d0

    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)

    !갵Ǯβٰ¸
    ChemData_Cp_temp(SNum,1:12) = (/ &
      & 50.0d0,    75.0d0, 100.0d0, 125.0d0, 150.0d0, &
      & 175.0d0,  200.0d0, 225.0d0, 250.0d0, 275.0d0, &
      & 298.15d0, 300.0d0 /)

    !֤Ǥֹ
    RNum = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !֤Ǥñ̥갵Ǯ [J/K mol]. 
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !֤Ǥñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !֤Ǥñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !֤Ǥñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)


    !!=============================================================
    !! H2O-g ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'H2O-g'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'H'
    ANum1 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'O'
    ANum2 = ChemData_SearchAtm( AtmSymbol)

    !
    ChemData_Phase(SNum) = 'Gas'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 188.834d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = -2241826.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 2.0d0
    ChemData_SpcFormula(SNum,ANum2) = 1.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
    
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)

    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:11) = (/ &
      & 33.299d0, 33.349d0, 33.590d0, 33.596d0, 34.262d0, &
      & 35.266d0, 36.325d0, 37.495d0, 38.721d0, 39.987d0, 41.268d0 /) 
    
    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)
    
    !갵Ǯǡб벹
    ChemData_Cp_temp(SNum,1:11) = (/ &
      & 100.0d0,  200.0d0,  298.15d0, 300.0d0,  400.0d0, &
      & 500.0d0,  600.0d0,  700.0d0,  800.0d0,  900.0d0,  1000.0d0 /)
    
    !֤Ǥ갵Ǯ
    RNum  = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !ñ̥갵Ǯ [J/K mol].
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !ñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !ñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !ñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)

    !!=============================================================
    !! H2O-l ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'H2O-l'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'H'
    ANum1 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'O'
    ANum2 = ChemData_SearchAtm( AtmSymbol)

    !
    ChemData_Phase(SNum) = 'Liq'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 188.834d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = -2241826.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 2.0d0
    ChemData_SpcFormula(SNum,ANum2) = 1.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
    
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)

    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:11) = (/ &
      & 33.299d0, 33.349d0, 33.590d0, 33.596d0, 34.262d0, &
      & 35.266d0, 36.325d0, 37.495d0, 38.721d0, 39.987d0, 41.268d0 /) 
    
    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)
    
    !갵Ǯǡб벹
    ChemData_Cp_temp(SNum,1:11) = (/ &
      & 100.0d0,  200.0d0,  298.15d0, 300.0d0,  400.0d0, &
      & 500.0d0,  600.0d0,  700.0d0,  800.0d0,  900.0d0,  1000.0d0 /)
    
    !֤Ǥ갵Ǯ
    RNum  = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !ñ̥갵Ǯ [J/K mol].
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !ñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !ñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !ñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)

    !˰¾ [Pa]
    ChemData_SvapPress(SNum,1:16) = (/ &
      & 610.749769736842d0, 1227.63236842105d0, 2337.94105263158d0, &
      & 4243.25101973684d0, 7376.72664473684d0, 12338.9851973684d0, &
      & 19923.6947368421d0, 31166.7700657895d0, 47364.1046052632d0, &
      & 70110.2338815789d0, 101325d0,           143268.217105263d0, &
      & 198530.338815789d0, 270111.118421053d0, 361356.947368421d0, &
      & 475974.1875d0 /)

    !˰¾Υǡб벹
    ChemData_SvapPress_Temp(SNum,1:16) = (/ &
      & 273.15d0, 283.15d0, 293.15d0, 303.15d0, 313.15d0, &
      & 323.15d0, 333.15d0, 343.15d0, 353.15d0, 363.15d0, &
      & 373.15d0, 383.15d0, 393.15d0, 403.15d0, 413.15d0, &
      & 423.15d0 /)

    !Antoine μη
    ChemData_SvapPress_AntoineA(SNum) =  7.9186968d0
    ChemData_SvapPress_AntoineB(SNum) =  1636.909d0
    ChemData_SvapPress_AntoineC(SNum) =  224.92d0
    ChemData_SvapPress_AntoineUnit(SNum) = dlog(133.322d0)

    !AMP η
    ChemData_SvapPress_AMPA(SNum) = -2313.0338d0
    ChemData_SvapPress_AMPB(SNum) = -164.03307d0
    ChemData_SvapPress_AMPC(SNum) =  38.053682d0
    ChemData_SvapPress_AMPD(SNum) = -0.13844344d0    
    ChemData_SvapPress_AMPE(SNum) =  7.4465367d-5


    !!=============================================================
    !! H2O-s ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'H2O-s'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'H'
    ANum1 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'O'
    ANum2 = ChemData_SearchAtm( AtmSymbol)

    !
    ChemData_Phase(SNum) = 'Sol'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 188.834d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = -2241826.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 2.0d0
    ChemData_SpcFormula(SNum,ANum2) = 1.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
    
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)

    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:11) = (/ &
      & 33.299d0, 33.349d0, 33.590d0, 33.596d0, 34.262d0, &
      & 35.266d0, 36.325d0, 37.495d0, 38.721d0, 39.987d0, 41.268d0 /) 
    
    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)
    
    !갵Ǯǡб벹
    ChemData_Cp_temp(SNum,1:11) = (/ &
      & 100.0d0,  200.0d0,  298.15d0, 300.0d0,  400.0d0, &
      & 500.0d0,  600.0d0,  700.0d0,  800.0d0,  900.0d0,  1000.0d0 /)
    
    !֤Ǥ갵Ǯ
    RNum  = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !ñ̥갵Ǯ [J/K mol].
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !ñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !ñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !ñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)

    !˰¾ [Pa]
    ChemData_SvapPress(SNum,1:15) = (/ &
      & 181.451743421053d0, 198.650328947368d0, 217.582105263158d0, &
      & 237.980427631579d0, 259.978618421053d0, 284.109967105263d0, &
      & 310.107828947368d0, 338.23884868421d0,  368.636348684211d0,  &
      & 401.700296052632d0, 437.297368421053d0, 475.694210526316d0, &
      & 517.290789473684d0, 562.220427631579d0, 610.483125d0 /)

    !˰¾Υǡб벹
    ChemData_SvapPress_Temp(SNum,1:15) = (/ &
      & 259.15d0, 260.15d0, 261.15d0, 262.15d0, 263.15d0, &
      & 264.15d0, 265.15d0, 266.15d0, 267.15d0, 268.15d0, &
      & 269.15d0, 270.15d0, 271.15d0, 272.15d0, 273.15d0  /)

    !Antoine μη
    ChemData_SvapPress_AntoineA(SNum) =  8.184254d0
    ChemData_SvapPress_AntoineB(SNum) =  1791.3d0
    ChemData_SvapPress_AntoineC(SNum) =  238.1d0
    ChemData_SvapPress_AntoineUnit(SNum) = dlog(133.322d0)

    !AMP η
    ChemData_SvapPress_AMPA(SNum) = -5631.1206d0
    ChemData_SvapPress_AMPB(SNum) = -8.363602d0
    ChemData_SvapPress_AMPC(SNum) =  8.2312d0
    ChemData_SvapPress_AMPD(SNum) = -0.03861449d0
    ChemData_SvapPress_AMPE(SNum) =  2.77494d-5


    !!=============================================================
    !! NH3-g ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'NH3-g'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'H'
    ANum1 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'N'
    ANum2 = ChemData_SearchAtm( AtmSymbol)
    
    !
    ChemData_Phase(SNum) = 'Gas'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 192.774d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = -45898.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 3.0d0
    ChemData_SpcFormula(SNum,ANum2) = 1.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
    
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)

    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:11) = (/ &
      & 33.284d0, 33.757d0, 35.652d0, 35.701d0, 38.716d0, &
      & 42.048d0, 45.293d0, 48.354d0, 51.235d0, 53.948d0, 56.491d0 /) 
    
    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)
    
    !갵Ǯǡб벹
    ChemData_Cp_temp(SNum,1:11) = (/ &
      & 100.0d0,  200.0d0,  298.15d0, 300.0d0,  400.0d0, &
      & 500.0d0,  600.0d0,  700.0d0,  800.0d0,  900.0d0,  1000.0d0 /)
    
    !֤Ǥ갵Ǯ
    RNum  = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !ñ̥갵Ǯ [J/K mol].
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !ñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !ñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !ñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)


    !!=============================================================
    !! NH3-s ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'NH3-s'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'H'
    ANum1 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'N'
    ANum2 = ChemData_SearchAtm( AtmSymbol)
    
    !
    ChemData_Phase(SNum) = 'Sol'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 192.774d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = -45898.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 3.0d0
    ChemData_SpcFormula(SNum,ANum2) = 1.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
    
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)

    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:11) = (/ &
      & 33.284d0, 33.757d0, 35.652d0, 35.701d0, 38.716d0, &
      & 42.048d0, 45.293d0, 48.354d0, 51.235d0, 53.948d0, 56.491d0 /) 
    
    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)
    
    !갵Ǯǡб벹
    ChemData_Cp_temp(SNum,1:11) = (/ &
      & 100.0d0,  200.0d0,  298.15d0, 300.0d0,  400.0d0, &
      & 500.0d0,  600.0d0,  700.0d0,  800.0d0,  900.0d0,  1000.0d0 /)
    
    !֤Ǥ갵Ǯ
    RNum  = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !ñ̥갵Ǯ [J/K mol].
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !ñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !ñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !ñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)

    !˰¾ [Pa]
    ChemData_SvapPress(SNum,1:4) = (/ &
      & 1333.22368421053d0, 2666.44736842105d0, 7999.34210526316d0, &
      & 13332.2368421053d0 /)

    !˰¾Υǡб벹
    ChemData_SvapPress_Temp(SNum,1:4) = (/ &
      & 181.09d0, 187.37d0, 198.25d0, 203.76d0 /)

    !Antoine μη
    ChemData_SvapPress_AntoineA(SNum) =  9.96382d0
    ChemData_SvapPress_AntoineB(SNum) =  1617.907d0 
    ChemData_SvapPress_AntoineC(SNum) =  272.55d0
    ChemData_SvapPress_AntoineUnit(SNum) = dlog(133.322d0)
    
    !AMP η
    ChemData_SvapPress_AMPA(SNum) = -4122.0d0
    ChemData_SvapPress_AMPB(SNum) = 41.67871d0
    ChemData_SvapPress_AMPC(SNum) = -1.8163d0
    ChemData_SvapPress_AMPD(SNum) = 0.0d0
    ChemData_SvapPress_AMPE(SNum) = 0.0d0
 

    !!=============================================================
    !! H2S-g ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'H2S-g'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'H'
    ANum1 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'S'
    ANum2 = ChemData_SearchAtm( AtmSymbol)

    !
    ChemData_Phase(SNum) = 'Gas'

    !֤ǤΥȥԡ 
    ChemData_Entropy(SNum) = 205.757d0

    !֤ǤΥ󥿥ԡ
    ChemData_Enthalpy(SNum) = -20502.0d0

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 2.0d0
    ChemData_SpcFormula(SNum,ANum2) = 1.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
    
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)

    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1:11) = (/ &
      & 33.259d0, 33.38d0, 34.192d0, 34.208d0, 35.581d0, &
      & 37.192d0, 38.936d0, 40.74d0, 42.518d0, 44.212d0, 45.786d0 /)
    
    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)
    
    !갵Ǯǡб벹
    ChemData_Cp_temp(SNum,1:11) = (/ &
      & 100.0d0,  200.0d0,  298.15d0, 300.0d0,  400.0d0, &
      & 500.0d0,  600.0d0,  700.0d0,  800.0d0,  900.0d0,  1000.0d0 /)
    
    !֤Ǥ갵Ǯ
    RNum  = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !ñ̥갵Ǯ [J/K mol].
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !ñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !ñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !ñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)
    
    !!=============================================================
    !! NH4SH-s ˴ؤʪ
    !!=============================================================
    SpcSymbol = 'NH4SH-s'
    SNum  = ChemData_SearchSpc( SpcSymbol)
    AtmSymbol = 'H'
    ANum1 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'N'
    ANum2 = ChemData_SearchAtm( AtmSymbol)
    AtmSymbol = 'S'
    ANum3 = ChemData_SearchAtm( AtmSymbol)

    !
    ChemData_Phase(SNum) = 'Sol'

!    !֤ǤΥȥԡ 
!    ChemData_Entropy(SNum) =
!
!    !֤ǤΥ󥿥ԡ
!    ChemData_Enthalpy(SNum) =

    !ʬҤ븵
    ChemData_SpcFormula(SNum,ANum1) = 5.0d0
    ChemData_SpcFormula(SNum,ANum2) = 1.0d0
    ChemData_SpcFormula(SNum,ANum3) = 1.0d0

    !ʬ [kg/mol]
    ChemData_MolWt(SNum) = &
      & dot_product(ChemData_AtmWt, ChemData_SpcFormula(SNum,:))
    
    !
    ChemData_GasR(SNum) = GasRUniv / ChemData_MolWt(SNum)

    !ñ̥갵Ǯ [J/K mol]. ٰ¸θ
    ChemData_CpPerMol(SNum,1) = 34.922d0
    
    !ñ̼갵Ǯ [J/K kg]. ٰ¸θ
    ChemData_Cp(SNum,:) = &
      & ChemData_CpPerMol(SNum,:) / ChemData_MolWt(SNum)
    
    !갵Ǯǡб벹
    ChemData_Cp_temp(SNum,1) = 298.15d0
    
    !֤Ǥ갵Ǯ
    RNum  = ChemData_SearchRef(ChemData_Cp_temp(SNum,:))

    !ñ̥갵Ǯ [J/K mol].
    ChemData_CpPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum)
        
    !ñ̼갵Ǯ [J/K kg]. 
    ChemData_CpRef(SNum) = ChemData_Cp(SNum, RNum)

    !ñ̥Ǯ [J/K mol]. 
    ChemData_CvPerMolRef(SNum) = ChemData_CpPerMol(SNum, RNum) - GasRUniv
    
    !ñ̼Ǯ [J/K kg]. 
    ChemData_CvRef(SNum) = &
      & ChemData_CvPerMolRef(SNum) / ChemData_MolWt(SNum)
    
    !˰¾ [Pa]
    ChemData_SvapPress(SNum,1:9) = (/ &
      & 133.322368421053d0, 666.611842105263d0, 1333.22368421053d0, &
      & 2666.44736842105d0, 7999.34210526316d0, 13332.2368421053d0, &
      & 26664.4736842105d0, 53328.9473684211d0, 101325d0           /)   
    
    !˰¾Υǡб벹
    ChemData_SvapPress_Temp(SNum,1:9) = (/ &
      & 222.05d0, 237.15d0, 244.45d0, 252.35d0, &
      & 266.15d0, 273.15d0, 283.65d0, 294.95d0, 306.45d0 /)
    
    !Antoine μη (JANAF Chemical WebBook )
    !â, ׻ɤȤ C  273.15 [K] äƤ.
    ChemData_SvapPress_AntoineA(SNum) =  6.09146d0
    ChemData_SvapPress_AntoineB(SNum) =  1598.378 
    ChemData_SvapPress_AntoineC(SNum) =  -43.805d0 + Temp0C
    ChemData_SvapPress_AntoineUnit(SNum) = dlog(1.0d5)
    
  end subroutine ChemData_Init



!!!
!!! 󥸥δؿ
!!!

!!!-----------------------------------------------------------------!!!
  function ChemData_SearchSpc(var)
    !
    ! ̾θ󥸥
    !

    !ۤηػ
    implicit none

    !ѿ
    integer                   :: ChemData_SearchSpc
    character(20), intent(in) :: var
    
    !ѿ
    integer                  :: i

    !õ
    Search: do i = 1, ChemData_SpcNum
      
      if (trim(ChemData_SpcSymbol(i)) == trim(var)) then 
        ChemData_SearchSpc = i
        exit Search
      end if
    end do Search
    
  end function ChemData_SearchSpc


!!!-----------------------------------------------------------------!!!
  function ChemData_SearchAtm(var)
    !
    ! ̾θ󥸥
    !

    !ۤηػ
    implicit none

    !ѿ
    integer                  :: ChemData_SearchAtm
    character(2), intent(in) :: var

    !ѿ
    integer                  :: i

    !õ
    Search: do i = 1, ChemData_AtmNum
      if (trim(ChemData_AtmSymbol(i)) == trim(var)) then 

        ChemData_SearchAtm = i
        exit Search
      end if
    end do Search
    
  end function ChemData_SearchAtm
  

!!!-----------------------------------------------------------------!!!
  function ChemData_SearchRef( array )
    !
    ! ̾θ󥸥
    !

    !ۤηػ
    implicit none

    !ѿ
    integer                  :: ChemData_SearchRef
    real(8), intent(in)      :: array(:)
    
    !ѿ
    integer                  :: i
    
    !õ
    Search: do i = 1, size(array,1)
      if (array(i) == TempRef) then 
        ChemData_SearchRef = i
        exit Search
      end if
    end do Search
    
  end function ChemData_SearchRef
  

!!!-----------------------------------------------------------------!!!
  function ChemData_SpcID( SpcNum, SpcSymbol )
    !
    ! ʸȤͿ줿ؼ̾, βؼź
    ! 礭ȤͿɬפ뤳Ȥ.
    !

    !ۤηػ
    implicit none

    !ѿ
    integer, intent(in)       :: SpcNum
    character(20), intent(in) :: SpcSymbol(SpcNum)
    integer                   :: ChemData_SpcID(SpcNum)
    
    !ѿ
    integer                  :: i, j

    !
    ChemData_SpcID = 0.0d0

!    write(*,*) SpcNum, SpcSymbol(SpcNum)

    !õ
    do i = 1, size(SpcSymbol,1)
      Search: do j = 1, size(ChemData_SpcSymbol,1)
        if (ChemData_SpcSymbol(j) == SpcSymbol(i)) then 
          ChemData_SpcID(i) = j
          exit Search
        end if
      end do Search
    end do

  end function ChemData_SpcID
  
!!!-----------------------------------------------------------------!!!
  function ChemData_OneSpcID( SpcSymbol )
    !
    ! ʸȤͿ줿ؼ̾, βؼź
    ! 礭ȤͿɬפ뤳Ȥ.
    !

    !ۤηػ
    implicit none

    !ѿ
    integer                   :: ChemData_OneSpcID
    character(20), intent(in) :: SpcSymbol
    
    !ѿ
    integer                  :: j

    !
    ChemData_OneSpcID = 0.0d0

    !õ
    Search: do j = 1, size(ChemData_SpcSymbol,1)
      if (ChemData_SpcSymbol(j) == SpcSymbol) then 
        ChemData_OneSpcID = j
        exit Search
      end if
    end do Search

  end function ChemData_OneSpcID
  
end module ChemData
