!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module CloudSet
!
!   * Developer: SUGIYAMA Ko-ichiro
!   * Version: $Id: cloudset.f90,v 1.1 2009-03-05 05:39:42 yamasita Exp $ 
!   * Tag Name: $Name: arare4-20100306 $
!   * Change History: 
!
!== Overview 
!
!ʪ˴طѥ⥸塼(ή׻)
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
                                                                 !=end
module cloudset

  implicit none
  save
                                                                 !=begin
  !== Public Interface
  real(8)  :: DensIce     ! ̩ [kg/m^3]
  real(8)  :: NumAerosol  ! ο̩ [1/kg]
  real(8)  :: RadiAerosol ! ο̩ [1/kg]
  real(8)  :: Kd          ! 絤ǮƳ [W/K m]
!  real(8)  :: SatPressA   ! ˰¾μη [Pa]
!  real(8)  :: SatPressB   ! ˰¾μη [K]
  real(8)  :: SatRatioCr  ! ׳˰ []
  real(8)  :: SatRtWetAdia  ! Ǯ˰ []
                                                                 !=end
contains
                                                                 !=begin
  !== Procedure Interface 
  !
  !=== Initialize module and acquire NAMELIST
  !
  !NAMELIST ʪɤ߹
  !
  subroutine cloudset_init(cfgfile)
    !=== Dependency
    use dc_trace,      only: BeginSub, EndSub 
                                                                 !=end
    character(*), intent(in) :: cfgfile
                                                                 !=begin
    !=== NAMELIST
    NAMELIST /cloudset/ DensIce, NumAerosol, RadiAerosol, Kd, & 
      & SatRatioCr, SatRtWetAdia
!      & SatPressA, SatPressB, SatRatioCr, SatRtWetAdia
                                                                 !=end
    call BeginSub("cloudset_init", &
&                 fmt="%c",       &
&                 c1="Initialize parameters of cloud physics. ")

    open (10, FILE=cfgfile)
    read(10, NML=cloudset)
    close(10)

    !==== ǧ
    write(*,*) "DensIce", DensIce
    write(*,*) "NumAerosol", NumAerosol
    write(*,*) "RadiAerosol", RadiAerosol
    write(*,*) "Kd", Kd
!    write(*,*) "SatPressA", SatPressA
!    write(*,*) "SatPressB", SatPressB
    write(*,*) "SatRatioCr", SatRatioCr
    write(*,*) "SatRtWetAdia", SatRtWetAdia


    call EndSub("cloudset_init")

  end subroutine cloudset_init

end module cloudset
