!= Module MoistAdjust
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: moistadjust.f90,v 1.1 2009-03-05 05:39:42 yamasita Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!˰Ĵˡ
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

Module MoistAdjust
  !
  !˰ĴˡԤΥѥå⥸塼
  !  * ˰¾Ȥؼ, 층Ū˼¹Ԥ
  !  * ȿˤĤƤ, 줾βȿ˼¹Ԥ. 

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset, only:  SpcNum,           &!ؼο
    &                 DimXMin,          &! x β
    &                 DimXMax,          &! x ξ
    &                 DimZMin,          &! z β
    &                 DimZMax            ! z ξ
  use basicset, only: MolWtWet,         &
    &                 SpcWetID,         &
    &                 xz_ExnerBasicZ,   &
    &                 xz_PotTempBasicZ, &
    &                 xz_EffMolWtBasicZ,&
    &                 xza_MixRtBasicZ,  &  
    &                 PressBasis,       &!̤δవ         [Pa]
    &                 CpDry,            &!ʬʿ갵Ǯ [J/K kg]
    &                 MolWtDry,         &!ʬʿʬ   [kg/mol]
    &                 GasRDry            !ʬε     [J/K kg]
  use moistset, only: CondNum,          &!ŷο
    &                 IdxCG,            &!ŷ()ź
    &                 IdxCC,            &!ŷ()ź
    &                 IdxNH3,           &!NH3()ź
    &                 IdxH2S,           &!H2S()ź
    &                 IdxNH4SHc          !NH4SH()ź
  use ChemCalc, only: xz_SvapPress, xz_LatentHeat, ReactHeatNH4SH
  use MoistFunc,only: xz_DMixRtSatDPotTemp, xz_DelMixRtNH4SH

  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ° public ѹ
  public MoistAdjustSvapPress    !˰¾Ѥ˰¼Ĵ(ʰ)
  public MoistAdjustNH4SH        !ȿΰʿѤ˰¼Ĵ

contains

!!!------------------------------------------------------------------!!!
  subroutine MoistAdjustSvapPress(xz_Exner, xz_PotTemp, xza_MixRt)
    !
    ! ˰¾Ѥ˰Ĵˡμ¹
    ! ץǤ, ͽ᤿ȿɤԤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8),intent(in)   :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax) 
                                                          !ʡؿ
    real(8),intent(inout):: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax) 
                                                          !
    real(8),intent(inout):: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                          !
    integer, parameter   :: ItrNum = 4                    !ȿɤβ

    real(8) :: xz_MixRtV_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtV_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtC_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtC_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_PotTemp_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_PotTemp_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtSat(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_Cond(DimXMin:DimXMax, DimZMin:DimZMax)  
    real(8) :: xz_Evap(DimXMin:DimXMax, DimZMin:DimZMax)  
    real(8) :: xz_Gamma(DimXMin:DimXMax, DimZMin:DimZMax) 
    integer :: i, s                                       ! ź  

    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    xz_MixRtV_pre  = 0.0d0
    xz_MixRtV_nxt  = 0.0d0
    xz_MixRtC_pre  = 0.0d0
    xz_MixRtC_nxt  = 0.0d0
    xz_PotTemp_pre = 0.0d0
    xz_PotTemp_nxt = 0.0d0
    
    xz_ExnerAll    = 0.0d0
    xz_TempAll     = 0.0d0
    xz_DelMixRt    = 0.0d0
    xz_MixRtSat    = 0.0d0 
    xz_Gamma       = 0.0d0
    
    !---------------------------------------------------------------------
    ! ˰Ĵˡμ¹
    !   롼פ󤹤Τ, ˤĤƤ.  
    !---------------------------------------------------------------------
    LoopSvapPress: do s = 1, CondNum
      
      !˰ˡǤϰϤѲʤ. 
      xz_ExnerAll = xz_Exner + xz_ExnerBasicZ
          
      !ޤǤ줿ʬ̤ͤȤߤʤ. źɲ
      xz_MixRtV_pre  = xza_MixRt(:,:,IdxCG(s))   + xza_MixRtBasicZ(:,:,IdxCG(s))
      xz_MixRtC_pre  = xza_MixRt(:,:,IdxCC(s)) + xza_MixRtBasicZ(:,:,IdxCC(s))
      xz_PotTemp_pre = xz_PotTemp
          
      Adjusting: do i = 1, ItrNum
        !---------------------------------------------------------------
        ! ˰¾˰º
        !---------------------------------------------------------------
        !
        xz_TempAll = ( xz_PotTemp_pre + xz_PotTempBasicZ ) * xz_ExnerAll

        !˰¾˰º׻(ܾ줫κ). 
        xz_MixRtSat =                                                    &
          & xz_SvapPress(SpcWetID(IdxCC(s)), xz_TempAll)              &
          &  * MolWtWet(IdxCC(s))                                     &
          &  / (MolWtDry * PressBasis * (xz_ExnerAll ** (CpDry / GasRDry)) )

        !ʲ줿Ǯ
        xz_Gamma = xz_LatentHeat(SpcWetID(IdxCC(s)), xz_TempAll) &
          &        * xz_EffMolWtBasicZ                              &
          &        / (xz_ExnerAll * CpDry)
        
        !ŷ̤. 
        !  ŷ뤬ˤ, xz_MixRtV_pre - xz_MixRtSat ɬͤȤʤ.
        !  ȯˤ, ȯ̤ - MixRtC Ķ뤳ȤϤʤ. 
        xz_DelMixRt = &
          & ( xz_MixRtV_pre - xz_MixRtSat ) &
          &   / (1.0d0 + xz_Gamma * xz_DMixRtSatDPotTemp( &
          &           SpcWetID(IdxCC(s)), MolWtWet(IdxCC(s)), xz_TempAll, xz_ExnerAll & 
          &        ) )

        xz_Cond = max( 0.0d0, min( xz_MixRtV_pre,   xz_DelMixRt ) )
        xz_Evap = max( 0.0d0, min( xz_MixRtC_pre, - xz_DelMixRt ) )

        !꿿˶ᤤͤ׻
        xz_PotTemp_nxt = xz_PotTemp_pre + xz_Gamma * ( xz_Cond - xz_Evap )
        xz_MixRtV_nxt  = xz_MixRtV_pre  - xz_Cond + xz_Evap
        xz_MixRtC_nxt  = xz_MixRtC_pre  + xz_Cond - xz_Evap
        
        !֤Τѿ
        xz_PotTemp_pre = xz_PotTemp_nxt
        xz_MixRtV_pre  = xz_MixRtV_nxt
        xz_MixRtC_pre  = xz_MixRtC_nxt

      end do Adjusting
      
      xz_PotTemp                 = xz_PotTemp_nxt                 
      xza_MixRt(:,:,IdxCG(s))   = xz_MixRtV_nxt - xza_MixRtBasicZ(:,:,IdxCG(s))
      xza_MixRt(:,:,IdxCC(s)) = xz_MixRtC_nxt - xza_MixRtBasicZ(:,:,IdxCC(s))
      
    end do LoopSvapPress
    
  end subroutine MoistAdjustSvapPress


!!!--------------------------------------------------------------------------!!!
  subroutine MoistAdjustNH4SH(xz_Exner, xz_PotTemp, xza_MixRt ) 
    !
    ! NH3 + H2S --> NH4SH ȿΰʿ Kp Ѥ˰¼Ĵˡ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8),intent(in)   :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax) 
                                                          !ʡؿ
    real(8),intent(inout):: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax) 
                                                          !
    real(8),intent(inout):: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                          !Žʬκ
    real(8) :: xz_PotTemp_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_PotTemp_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtNH3_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtNH3_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtH2S_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtH2S_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtNH4SH_pre(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_MixRtNH4SH_nxt(DimXMin:DimXMax, DimZMin:DimZMax) 
    
    real(8) :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_Gamma(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax) 
    real(8) :: xz_Cond(DimXMin:DimXMax, DimZMin:DimZMax)  
    real(8) :: xz_Evap(DimXMin:DimXMax, DimZMin:DimZMax)  
    
    integer            :: i
    integer, parameter :: ItrNum = 2
            
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    xz_PotTemp_nxt = 0.0d0
    xz_MixRtNH3_nxt   = 0.0d0
    xz_MixRtH2S_nxt   = 0.0d0
    xz_MixRtNH4SH_nxt = 0.0d0
    
    xz_Gamma     = 0.0d0
    xz_DelMixRt  = 0.0d0

    !˰ˡǤϰϤѲʤ. 
    xz_ExnerAll = xz_Exner + xz_ExnerBasicZ
    xz_PressAll = PressBasis * (xz_ExnerAll ** (CpDry / GasRDry))
        
    !ޤǤ줿ʬ̤ͤȤߤʤ. źɲ
    xz_MixRtNH3_pre(:,:)    = xza_MixRt(:,:,IdxNH3)    + xza_MixRtBasicZ(:,:,IdxNH3)
    xz_MixRtH2S_pre(:,:)    = xza_MixRt(:,:,IdxH2S)    + xza_MixRtBasicZ(:,:,IdxH2S)
    xz_MixRtNH4SH_pre(:,:)  = xza_MixRt(:,:,IdxNH4SHc) + xza_MixRtBasicZ(:,:,IdxNH4SHc)
    xz_PotTemp_pre          = xz_PotTemp
    
    AdjustNH4SH: do i = 1, ItrNum
      !---------------------------------------------------------------
      ! ѿν
      !---------------------------------------------------------------
      !
      xz_TempAll = ( xz_PotTemp_pre + xz_PotTempBasicZ ) * xz_ExnerAll
      
      !ʲ줿ȿǮ (NH4SH kg ФǮ)
      xz_Gamma = ReactHeatNH4SH * xz_EffMolWtBasicZ / ( xz_ExnerAll * CpDry )

      !NH4SH 
      xz_DelMixRt =                                                           &
        &    xz_DelMixRtNH4SH(                                                &
        &          xz_TempAll, xz_PressAll, xz_MixRtNH3_pre, xz_MixRtH2S_pre, &
        &          MolWtWet(IdxNH3), MolWtWet(IdxH2S)                         &
        &      )

      xz_Cond = max( 0.0d0, xz_DelMixRt )
      xz_Evap = max( 0.0d0, min( - xz_DelMixRt, xz_MixRtNH4SH_pre ) )

      !---------------------------------------------------------------
      ! 꿿˶ᤤͤ˰¾˰º
      !---------------------------------------------------------------
      ! NH4SH κ
      xz_MixRtNH4SH_nxt  = xz_MixRtNH4SH_pre + xz_Cond - xz_Evap
      
      ! DelPress 򸵤, NH3  H2S κ
      xz_MixRtNH3_nxt = xz_MixRtNH3_pre - ( xz_Cond - xz_Evap )      &
        &                 * MolWtWet(IdxNH3) / MolWtWet(IdxNH4SHc)
      xz_MixRtH2S_nxt = xz_MixRtH2S_pre - ( xz_Cond - xz_Evap )      &
        &                 * MolWtWet(IdxH2S) / MolWtWet(IdxNH4SHc)
          
      !̤
      xz_PotTemp_nxt = xz_PotTemp_pre + xz_Gamma * ( xz_Cond - xz_Evap )
      
      !롼פ󤹤ѿѲ
      xz_PotTemp_pre     = xz_PotTemp_nxt
      xz_MixRtNH3_pre   = xz_MixRtNH3_nxt 
      xz_MixRtH2S_pre   = xz_MixRtH2S_nxt 
      xz_MixRtNH4SH_pre = xz_MixRtNH4SH_nxt 

    end do AdjustNH4SH

    xz_PotTemp              = xz_PotTemp_nxt                 
    xza_MixRt(:,:,IdxNH3)   = xz_MixRtNH3_nxt   - xza_MixRtBasicZ(:,:,IdxNH3)
    xza_MixRt(:,:,IdxH2S)   = xz_MixRtH2S_nxt   - xza_MixRtBasicZ(:,:,IdxH2S)
    xza_MixRt(:,:,IdxNH4SHc) = xz_MixRtNH4SH_nxt - xza_MixRtBasicZ(:,:,IdxNH4SHc)
    
  end subroutine MoistAdjustNH4SH

  
end Module MoistAdjust
