!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Subroutine DensityCloud
!
!   * Developer: Kitamori Taichi
!   * Version: $Id: densitycloud_turb2.f90,v 1.1 2009-03-05 05:39:42 yamasita Exp $ 
!   * Tag Name: $Name: arare4-20100306 $
!   * Change History: 
!
!== Overview 
!
!̩٤λȯŸ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!   * եå򤤤Ƥ
!   * ήȻθ
!   * ͳȻγνϹθʤ
!  
!== Future Plans
!
                                                                 !=end
subroutine DensityCloud(      & 
  & xz_DensCloud_in,                 & !(in) ̩
  & DelTime,                         & !(in) leapfrog λֳִ
  & pz_VelXNl,                      & !(in) ʿή®
  & xr_VelZNl,                      & !(in) ľή®
  & xz_DensCloudNl,                 & !(in) ̩(ή)
  & xz_DensCloudBl,                 & !(in) ̩(Ȼ)
  & xz_KhBl,                        & !(in) ήȻ
  & xz_MasscondNl,                  & !(inout) ŷ
  & xz_DensCloud_out)                  !(out) ̩

                                                                 !=begin  
  !== Dependancy
  use dc_trace, only: BeginSub, EndSub, DbgMessage
  use gridset,  only: DimXMin, DimXMax, DimZMin, DimZMax
!  use bcset,    only: xz_BC
  use average,  only: pz_avr_xz, xr_avr_xz
  use differentiate_center4, only: xz_dx_pz, xz_dz_xr
  use Turbulence, only: xz_TurbScalar
  use NumDiffusion, only: xz_NumDiffScalar
                                                                 !=end
  !== ۤηػ
  implicit none
                                                                 !=begin
  !== Input
  real(8), intent(in)  :: DelTime       ! leapfrog λֳִ [s]
  real(8), intent(in)  :: xz_DensCloud_in(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ̩ [kg/m^3]
  real(8), intent(in)  :: pz_VelXNl(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ʿ® [m/s]
  real(8), intent(in)  :: xr_VelZNl(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ľ® [m/s]
  real(8), intent(in)  :: xz_DensCloudNl(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ̩ [kg/m^3]
  real(8), intent(in)  :: xz_DensCloudBl(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ̩ [kg/m^3]
  real(8), intent(in)  :: xz_KhBl(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ήȻ [kg/m^3]

  !== Output
  real(8), intent(out)  :: xz_DensCloud_out(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ̩ [kg/m^3]

  !== In/Out
  real(8), intent(inout):: xz_MasscondNl(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ŷ [kg/m^3 s]
                                                                 !=end  
  !== Work
  real(8)  :: xz_FluxDensCloud(DimXMin:DimXMax, DimZMin:DimZMax) 
                                        ! եåˤ̩٤λѲΨ [kg/m^3 s]
  real(8)  :: xz_SrcDensCloud(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! Ǥˤ̩٤λѲΨ [kg/m^3 s]
  real(8)  :: xz_TurbDensCloud(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ήȻˤ̩٤λѲΨ [kg/m^3 s]
!  real(8)  :: xz_NumDensCloud(DimXMin:DimXMax, DimZMin:DimZMax)
!                                        ! Ǵˤ̩٤λѲΨ [kg/m^3 s]

  call BeginSub("DensityCloud", &
       &        fmt="%c",              &
       &        c1="Time integration of density of cloud.")
  
!  write(*,*) xz_DensCloudNl(1,:)

  !=== եåη׻. 4 濴ʬѤƷ׻
  xz_FluxDensCloud  = &
    & - xz_dx_pz(pz_VelXNl * pz_avr_xz(xz_DensCloudNl)) &
    & - xz_dz_xr(xr_VelZNl * xr_avr_xz(xz_DensCloudNl))
!  xz_FluxDensCloud = 0.0d0

  call DbgMessage( fmt="*** Debug Message [DensityCloud] *** xz_SrcDensCloud ")

  !=== η׻
  xz_SrcDensCloud = xz_MasscondNl

  call DbgMessage( fmt="*** Debug Message [DensityCloud] *** xz_DensCloud_out ")

  !=== ήȻη׻
  xz_TurbDensCloud = xz_TurbScalar(xz_DensCloudBl, xz_KhBl)

  !=== Ǵη׻
!  xz_NumDensCloud = xz_NumDiffScalar(xz_DensCloudBl)

!  xz_DensCloud_out = xz_DensCloud_in  & 
!    & + DelTime * ( xz_FluxDensCloud + xz_SrcDensCloud  &
!    &  + xz_TurbDensCloud + xz_NumDensCloud ) 

  xz_DensCloud_out = xz_DensCloud_in  & 
    & + DelTime * ( xz_FluxDensCloud + xz_SrcDensCloud  &
    &  + xz_TurbDensCloud ) 

  call DbgMessage( fmt="*** Debug Message [DensityCloud] *** xz_DensCloud_out(adjustment) ")

  ! ̤ˤʤ 0 ˤ. 
  ! ʬȯ̤򸺤餹
  xz_DensCloud_out = max(xz_DensCloud_out, 0.0d0)
  xz_MasscondNl & 
   & = max(xz_MasscondNl,   &
   &    - (xz_DensCloudNl / DelTime  + xz_FluxDensCloud &
   &   + xz_TurbDensCloud ) )

!  xz_MasscondNl & 
!   & = max(xz_MasscondNl,   &
!   &    - (xz_DensCloudNl / DelTime  + xz_FluxDensCloud &
!   &   + xz_TurbDensCloud + xz_NumDensCloud) )


!  !=== 
!  call boundary(xz_BC, xz_DensCloud_out)
!
  call EndSub("DensityCloud")
  
end subroutine DensityCloud
