!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Subroutine MassCondense
!
!   * Developer: KITAMORI Taichi, YAMASHITA Tatsuya
!   * Version: $ 
!   * Tag Name: $Name: arare4-20100306 $
!   * Change History: 
!
!== Overview 
!
!ή׻. 
!ŷ/ȯ̤׻.
!γνθʤ.
!˰·׻κ, ʪŪʶŷΰγɤ˱̩٤ͤƳ.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!ȻˤäƱγĹˤĹ. 
!ȯ̤¸ߤ̤¿, ȯ̤¸ߤ̤ˤ. 
!
!== Future Plans
!
                                                                 !=end
subroutine MassCondense(  &
  & xz_LatHeatPerMassNl,  &  !(in) ñ̼̤Ǯ
  & xz_SatRatioNl, &         !(in) ˰
  & xz_PotTempNl,     &      !(in) 
  & xz_ExnerNl,       &      !(in) ʡؿ
  & xz_DensCloudNl,     &    !(in) ̩
  & xz_MassCondNl)           !(out) ŷ
                                                                 !=begin
  !==Dependency
  use dc_trace, only: BeginSub, EndSub, DbgMessage
  use gridset,  only: DimXMin, DimXMax, DimZMin, DimZMax
!  use physset,  only: GasR,   &         !   
!    &                 Pi,     &         ! ߼Ψ
!    &                 PressSfc          ! ɽ̰
!  use physset,  only: Pi,     &         ! ߼Ψ
!    &                 PressSfc          ! ɽ̰
  use cloudset, only: DensIce, &        ! ʪ̩ 
    &                 NumAerosol, &     ! ̤ζŷ˿̩
    &                 RadiAerosol, &    ! ŷȾ
    &                 Kd,     &         ! 絤γȻ
!    &                 SatPressA, &      ! Antoine μη A 
!    &                 SatPressB,  &     ! Antoine μη B
    &                 SatRatioCr        ! ׳˰
!  use basicset, only: ss_CpBasicZ, &       ! 갵Ǯ
!    &                 ss_PotTempBasicZ,  & ! ̴ܾ
!    &                 ss_ExnerBasicZ,  &   ! ̵
!    &                 ss_DensBasicZ    &   ! ̩
!    &                 GasRDry              ! 
!  use BasicSet, only: xz_PotTempBasicZ,  & ! ̴ܾ
  use basicset, only: xz_PotTempBasicZ,  & ! ̴ܾ
    &                 xz_ExnerBasicZ,  &   ! ̵
    &                 xz_DensBasicZ,   &   ! ̩
    &                 GasRDry,         &    ! 
    &                 PressSfc,        &    ! ɽ̰
    &                 CpDry                 ! 갵Ǯ
  use ChemData, only: ChemData_Cp,     &   ! 갵Ǯ
    &                 ChemData_SVapPress_AntoineA, & ! Antoine μη B
    &                 ChemData_SVapPress_AntoineB    ! Antoine μη B
!  use basicset, only: PressSfc             ! ɽ̰

                                                                 !=end
  !==ۤηػ
  implicit none
  
  !==Input
  real(8), intent(in)   :: xz_LatHeatPerMassNl(DimXMin:DimXMax, DimZMin:DimZMax) 
                                        ! ñ̼̤ζŷǮ [J/kg]
  real(8), intent(in)   :: xz_SatRatioNl(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ˰ [1]
  real(8), intent(in)   :: xz_PotTempNl(DimXMin:DimXMax, DimZMin:DimZMax) 
                                        !  [K]
  real(8), intent(in)   :: xz_ExnerNl(DimXMin:DimXMax, DimZMin:DimZMax) 
                                        ! ̵ [1]
  real(8), intent(in)   :: xz_DensCloudNl(DimXMin:DimXMax, DimZMin:DimZMax)   
                                        ! ̩   [kg/m^3]


  !==Output
  real(8), intent(out)  :: xz_MassCondNl(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ŷ [kg/m^3 s]
   
  !==Work
  real(8)               :: xz_Rh(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! ǮȻˤ񹳷
  real(8)               :: xz_RadiCloud(DimXMin:DimXMax, DimZMin:DimZMax)
                                        ! γȾ [m]
  real, parameter       :: Pi = 3.1415926535897932385d0
                                        ! ߼Ψ
!  real(8)               :: DensCloudThreshold = 1.0d-5
!  real(8)               :: DensCloudThreshold = 5.0d-6
  real(8)               :: DensCloudThreshold = 1.0d-6
  integer               :: i,k          ! 롼ѿ

  call BeginSub("MassCondense", &
    &           fmt="%c",        &
    &           c1="Calculate latent heat per unit mass.")

  
  call DbgMessage( fmt="*** Debug Message [MassCondense] *** xz_Rh ")

!write(*,*) xz_PotTempNl(1,:)

  xz_Rh =  & 
    & xz_LatHeatPerMassNl**2.0d0 &
    & / (  &
    &      Kd * GasRDry * (xz_ExnerBasicZ + xz_ExnerNl)** 2.0d0 &
    &      * (xz_PotTempBasicZ + xz_PotTempNl)**2.0d0  &
    &   )
      ! , 20080410, 
      ! L**2 / (k * R * Exner**2 * theta**2) Ȥͤ׻Ƥ. 
      ! ʸ : ̼齤Ͽ A ƳвҤƤ. 
      ! â, ̼齤ʸ Rh μ (3.4) ˤϸΤդ줿. 
      ! ʽȤ 1 ȸϤɤʤΤĴ٤ɬפꤽ. 

  call DbgMessage( fmt="*** Debug Message [MassCondense] *** xz_RadiCloud ")


  xz_RadiCloud =   &
    & (  &
    &      3.0d0 * xz_DensCloudNl &
    &      / (4.0d0 * Pi * DensIce * NumAerosol * xz_DensBasicZ) & 
    &      + RadiAerosol**3.0d0  &
    &   )**(1.0d0 / 3.0d0)

  do k= DimZMin, DimZMax
   do i = DimXMin, DimXMax
!      if (xz_DensCloudNl(i,k) == 0 .and. &        
!        & xz_SatRatioNl(i,k) <= SatRatioCr) then
!        ! ̩ 0 ΤȤϲ˰٤ۤʤȶŷ뤷ʤ
!        xz_MassCondNl(i,k) = 0.0d0
!      else 
!        ! ŷ/ȯ̤׻
!        xz_MassCondNl(i,k) = &
!          &   4.0d0 * Pi * xz_RadiCloud(i,k) &
!          & * NumAerosol * xz_DensBasicZ(i,k)  &
!          & / xz_Rh(i,k)  &
!          & * (xz_SatRatioNl(i,k) - 1.0d0)


      if (xz_SatRatioNl(i,k) - SatRatioCr > epsilon(0.0e0)) then
!      if (xz_SatRatioNl(i,k) / SatRatioCr > 1.0d0) then
! ˰椬᤿׳˰礭
! CO2 ˰μϵ絤Ѥ˰μʤΤʤΤǧɬפ. 
        xz_MassCondNl(i,k) = &
         &   4.0d0 * Pi * xz_RadiCloud(i,k) &
         & * NumAerosol * xz_DensBasicZ(i,k)  &
         & / xz_Rh(i,k)  &
         & * (xz_SatRatioNl(i,k) - 1.0d0) 
      else if (xz_DensCloudNl(i,k) > DensCloudThreshold ) then
! ׳˰ĶƤʤ, ̩٤ͰʾǤ
! ˰椬 1 ʾΤȤ˶ŷ, 1 ʲΤȤ˾ȯ. 
        xz_MassCondNl(i,k) = &
          &   4.0d0 * Pi * xz_RadiCloud(i,k) &
          & * NumAerosol * xz_DensBasicZ(i,k)  &
          & / xz_Rh(i,k)  &
          & * (xz_SatRatioNl(i,k) - 1.0d0)
      else
! ׳˰ĶƤ餺, ̩٤̤ξ         
! ̩٤ǤϤʤ, ˰ 1.0 ̤ΤȤ˸¤äƾȯ. 
! ʳξˤϲⵯʤ. 
!        xz_MassCondNl(i,k) = 0.0d0
        xz_MassCondNl(i,k) = &
          & ( -0.5d0 * ( -1.0d0 + sign(1.0d0, - xz_DensCloudNl(i,k)) ) ) &
          & * &
          & ( -0.5d0 * ( -1.0d0 + sign(1.0d0, xz_SatRatioNl(i,k) - 1.0d0) ) ) &
          & * 4.0d0 * Pi * xz_RadiCloud(i,k) &
          & * NumAerosol * xz_DensBasicZ(i,k)  &
          & / xz_Rh(i,k)  &
          & * (xz_SatRatioNl(i,k) - 1.0d0)

!      if (xz_DensCloudNl(i,k) == 0 .and. &        
!        & xz_SatRatioNl(i,k) <= SatRatioCr) then
!        ! ̩ 0 ΤȤϲ˰٤ۤʤȶŷ뤷ʤ
!        xz_MassCondNl(i,k) = 0.0d0
!      else 
!        ! ŷ/ȯ̤׻
!        xz_MassCondNl(i,k) = &
!          &   4.0d0 * Pi * xz_RadiCloud(i,k) &
!          & * NumAerosol * xz_DensBasicZ(i,k)  &
!          & / xz_Rh(i,k)  &
!          & * (xz_SatRatioNl(i,k) - 1.0d0)

      end if
    end do
  end do

  call EndSub("MassCondense")

end subroutine MassCondense
