!= Module StoreBuoy
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: storebuoy.f90,v 1.1 2009-03-05 05:39:43 yamasita Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϥ˴ؤѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module StoreBuoy
  !
  !Ϥѻͤݴɤ뤿ѿ⥸塼.
  !

  !⥸塼ɤ߹
  use gridset, only:   DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax        ! x ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public StoreBuoy_Init, StoreBuoyMeanX, StoreBuoyClean
  public z_BuoyTemp, z_BuoyMolWt, z_BuoyDrag
  public StoreBuoyTemp, StoreBuoyMolWt, StoreBuoyDrag

  !ѿ
  real(8), allocatable :: z_BuoyTemp(:)
  real(8), allocatable :: z_BuoyMolWt(:)
  real(8), allocatable :: z_BuoyDrag(:)
  real(8), allocatable :: xz_BuoyTemp(:,:)
  real(8), allocatable :: xz_BuoyMolWt(:,:)
  real(8), allocatable :: xz_BuoyDrag(:,:)

  save z_BuoyTemp,  z_BuoyMolWt, z_BuoyDrag
  save xz_BuoyTemp,  xz_BuoyMolWt, xz_BuoyDrag

contains

  subroutine StoreBuoy_Init( )
    !롼

    allocate(     &
      & z_BuoyTemp(DimZMin:DimZMax),   & 
      & z_BuoyMolWt(DimZMin:DimZMax),  &
      & z_BuoyDrag(DimZMin:DimZMax),   &
      & xz_BuoyTemp(DimXMin:DimXMax, DimZMin:DimZMax),   & 
      & xz_BuoyMolWt(DimXMin:DimXMax, DimZMin:DimZMax),  &
      & xz_BuoyDrag(DimXMin:DimXMax, DimZMin:DimZMax)  &
      &  )
    
    call StoreBuoyClean()

  end subroutine StoreBuoy_Init


  subroutine StoreBuoyClean( )
    !ݴɤͤΥꥢ
    
    z_BuoyTemp   = 0.0d0
    z_BuoyMolWt  = 0.0d0
    z_BuoyDrag   = 0.0d0
    xz_BuoyTemp  = 0.0d0
    xz_BuoyMolWt = 0.0d0
    xz_BuoyDrag  = 0.0d0
    
  end subroutine StoreBuoyClean


  subroutine StoreBuoyMeanX( )
    !ݴɤͤοʿʿ
 
    real(8) :: CalNum

    CalNum = TimeDisp / DelTimeLong
   
    z_BuoyTemp  = a_MeanX_aa( xz_BuoyTemp  ) / CalNum
    z_BuoyMolWt = a_MeanX_aa( xz_BuoyMolWt ) / CalNum
    z_BuoyDrag  = a_MeanX_aa( xz_BuoyDrag  ) / CalNum

  end subroutine StoreBuoyMeanX
  

  subroutine StoreBuoyTemp( xz_Work )
    !٤δͿݴ

    implicit none

    real(8), intent(in)  :: xz_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: xz_Work2(DimXMin:DimXMax, DimZMin:DimZMax)
    
    xz_Work2    = xz_BuoyTemp + xz_Work 
    xz_BuoyTemp = xz_Work2

  end subroutine StoreBuoyTemp


  subroutine StoreBuoyMolWt( xz_Work )
    !ʬ̤δͿݴ

    implicit none

    real(8), intent(in)  :: xz_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: xz_Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    xz_Work2     = xz_BuoyMolWt + xz_Work 
    xz_BuoyMolWt = xz_Work2

  end subroutine StoreBuoyMolWt


  subroutine StoreBuoyDrag( xz_Work )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: xz_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: xz_Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    xz_Work2    = xz_BuoyDrag + xz_Work 
    xz_BuoyDrag = xz_Work2

  end subroutine StoreBuoyDrag


  function a_MeanX_aa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: a_MeanX_aa(DimZMin:DimZMax)
                                     !ʿʿ
    
    a_MeanX_aa = sum( var(RegXMin+1:RegXMax,:), 1 ) &
      &           / real(RegXMax - RegXMin, 8) 
    
  end function a_MeanX_aa
  
  
end module StoreBuoy
