!= Module StoreBuoy_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: storebuoy_3d.f90,v 1.1 2009-03-05 05:39:43 yamasita Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϥ˴ؤѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module StoreBuoy_3d
  !
  !Ϥѻͤݴɤ뤿ѿ⥸塼.
  !

  !⥸塼ɤ߹
  use dc_types, only : DP

  use gridset_3d, only : DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimYMin,     & ! y β
    &                  DimYMax,     & ! y ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax,     & ! x ʪΰξ
    &                  RegYMin,     & ! y ʪΰβ
    &                  RegYMax        ! y ʪΰξ
  use TimeSet,  only : TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public StoreBuoy_Init, StoreBuoyMeanXY, StoreBuoyClean
  public z_BuoyTemp, z_BuoyMolWt, z_BuoyDrag
  public StoreBuoyTemp, StoreBuoyMolWt, StoreBuoyDrag

  !ѿ
  real(DP), allocatable :: z_BuoyTemp (:)
  real(DP), allocatable :: z_BuoyMolWt(:)
  real(DP), allocatable :: z_BuoyDrag (:)
  real(DP), allocatable :: xyz_BuoyTemp (:,:,:)
  real(DP), allocatable :: xyz_BuoyMolWt(:,:,:)
  real(DP), allocatable :: xyz_BuoyDrag (:,:,:)

  save z_BuoyTemp  , z_BuoyMolWt  , z_BuoyDrag
  save xyz_BuoyTemp, xyz_BuoyMolWt, xyz_BuoyDrag

contains

  subroutine StoreBuoy_Init( )
    !롼

    allocate(     &
      & z_BuoyTemp (DimZMin:DimZMax),                                   & 
      & z_BuoyMolWt(DimZMin:DimZMax),                                   &
      & z_BuoyDrag (DimZMin:DimZMax),                                   &
      & xyz_BuoyTemp (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), & 
      & xyz_BuoyMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_BuoyDrag (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  &
      &  )
    
    call StoreBuoyClean()

  end subroutine StoreBuoy_Init


  subroutine StoreBuoyClean( )
    !ݴɤͤΥꥢ
    
    z_BuoyTemp   = 0.0d0
    z_BuoyMolWt  = 0.0d0
    z_BuoyDrag   = 0.0d0
    xyz_BuoyTemp  = 0.0d0
    xyz_BuoyMolWt = 0.0d0
    xyz_BuoyDrag  = 0.0d0
    
  end subroutine StoreBuoyClean


  subroutine StoreBuoyMeanXY( )
    !ݴɤͤοʿʿ
 
    real(DP) :: CalNum

    CalNum = TimeDisp / DelTimeLong
   
    z_BuoyTemp  = a_MeanXY_aaa( xyz_BuoyTemp  ) / CalNum
    z_BuoyMolWt = a_MeanXY_aaa( xyz_BuoyMolWt ) / CalNum
    z_BuoyDrag  = a_MeanXY_aaa( xyz_BuoyDrag  ) / CalNum

  end subroutine StoreBuoyMeanXY
  

  subroutine StoreBuoyTemp( xyz_Work )
    !٤δͿݴ

    implicit none

    real(DP), intent(in)  :: xyz_Work (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)              :: xyz_Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    
    xyz_Work2    = xyz_BuoyTemp + xyz_Work 
    xyz_BuoyTemp = xyz_Work2

  end subroutine StoreBuoyTemp


  subroutine StoreBuoyMolWt( xyz_Work )
    !ʬ̤δͿݴ

    implicit none

    real(DP), intent(in)  :: xyz_Work (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)              :: xyz_Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    xyz_Work2     = xyz_BuoyMolWt + xyz_Work 
    xyz_BuoyMolWt = xyz_Work2

  end subroutine StoreBuoyMolWt


  subroutine StoreBuoyDrag( xyz_Work )
    !ͳȻݴ

    implicit none
    
    real(DP), intent(in)  :: xyz_Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)              :: xyz_Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    xyz_Work2    = xyz_BuoyDrag + xyz_Work 
    xyz_BuoyDrag = xyz_Work2

  end subroutine StoreBuoyDrag


  function a_MeanXY_aaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(DP)              :: a_MeanXY_aaa(DimZMin:DimZMax)
                                     !ʿʿ
    real(DP)              :: aa_work(DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿʿ
    
    aa_work = aa_MeanX_aaa(var)

    a_MeanXY_aaa = sum( aa_work(RegYMin+1:RegYMax,:), 1 ) &
      &           / real(RegYMax - RegYMin, 8) 
    
  end function a_MeanXY_aaa

  function aa_MeanX_aaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(DP)             :: aa_MeanX_aaa(DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿʿ

    aa_MeanX_aaa = sum( var(RegXMin:RegXMax, :, :), 1 ) &
      &           / real(RegXMax - RegXMin + 1 , 8) 

  end function aa_MeanX_aaa
 
  
end module StoreBuoy_3d
