!= Program ArareEnergy
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: arare-energy.f90,v 1.1 2009-08-24 04:07:06 sugiyama Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ϳإǥ deepconv/arare 2 ǡץ
!
!
program ArareEnergy

  !----- ⥸塼ɤ߹ ------

  !-----   , ʸ   ----
  use dc_types,       only : STRING
  use dc_string,      only : StoA

  !-----   å   -----
  use dc_message,     only: MessageNotify

  !  ޥɥ饤
  use argset,        only : argset_init  

  !-----    ⥸塼   -----
  !  ̷׻⥸塼
  use chemcalc, only: chemcalc_init, xz_SvapPress, xz_LatentHeat, ReactHeatNH4SH
  use chemdata, only: chemdata_init

  !  ϥե̾⥸塼
  use fileset,       only : fileset_init

  !  ǥХåϴ⥸塼
  use debugset,      only : debugset_init

  !  ִ⥸塼
  use timeset,       only : timeset_init, TimeDisp, TImeInt

  !  ʻ⥸塼 
  use gridset,       only : gridset_init, DelX, DelZ, XMin, XMax, &
    &                       DimXMin, DimXMax, DimZMin, DimZMax, SpcNum, &
    &                       RegXMax, RegZMax, RegXMin, RegZMin, s_Z

  !  ܾ⥸塼
  use basicset,      only : basicset_init,  &
    &                       MolWtDry, MolWtWet, CpDry, PressBasis, GasRDry,    &
    &                       SpcWetID, SpcWetMolfr, PressSfc, &
    &                       xza_MixRtBasicZ, xz_PotTempBasicZ, xz_ExnerBasicZ, &
    &                       xz_TempBasicZ, xz_PressBasicZ, Grav, xz_EffMolWtBasicZ, xz_DensBasicZ, xz_VelSoundBasicZ

  !  롼⥸塼
  use moistset,      only: moistset_init,   &
    &                      GasNum, CloudNum, RainNum, CondNum, RactNum, &
    &                      IdxG,   IdxC,   IdxR,                        &
    &                      IdxCG,  IdxCC,  IdxCR,                       &
    &                      IdxNH3, IdxH2S, IdxNH4SHc, IdxNH4SHr         

  use ChemCalc, only: xz_LatentHeat,    &!Ǯ
    &                 ReactHeatNH4SH     !NH4SH ȿǮ

  !  ѻʹ⥸塼
  use StorePotTemp,      only : StorePotTemp_init
  use StoreMixRt,        only : StoreMixRt_init
  use StoreBuoy,         only : StoreBuoy_init
  use StoreStab,         only : StoreStab_init

  !-----    ⥸塼   -----
  !ʬʿѱ黻
  use average

  !  Ǯ徺βٸΨ׻ѥ⥸塼
  use ECCM,         only : eccm_molfr
  
  ! 
  use boundary,      only : BoundaryXCyc_xz, BoundaryZSym_xz

  !  ᵤϷ׻ѥ⥸塼
  use MoistBuoyancy,only : MoistBuoy_Init, xr_BuoyMolWt, xr_BuoyDrag
  use DynFunc,       only : xr_Buoy

  !ۤηػ
  implicit none
  
  !ѿ
  real(8), allocatable :: xz_PotTemp(:,:)
  real(8), allocatable :: xz_PotTempAll(:,:)
  real(8), allocatable :: xz_Exner(:,:)
  real(8), allocatable :: pz_VelX(:,:)
  real(8), allocatable :: xr_VelZ(:,:)
  real(8), allocatable :: xza_MixRt(:,:,:)
  real(8), allocatable :: xza_MixRtAll(:,:,:)
  real(8), allocatable :: xza_MixRtAll2(:,:,:)
  real(8), allocatable :: xza_MixRtSat(:,:,:)
  real(8), allocatable :: xza_MixRtSatBasicZ(:,:,:)
  real(8)              :: AnalTime
  real(8)              :: Hum

  real(8), allocatable :: xz_MassDens(:,:)
  real(8), allocatable :: xz_KineticEnergy(:,:)
  real(8), allocatable :: xz_PotentialEnergy(:,:)
  real(8), allocatable :: xz_ElasticEnergyFO(:,:)
  real(8), allocatable :: xz_ElasticEnergySO(:,:)
  real(8)              :: MassTotal
  real(8)              :: KineticEnergyTotal
  real(8)              :: PotentialEnergyTotal
  real(8)              :: ElasticEnergyFOTotal
  real(8)              :: ElasticEnergySOTotal
!  real(8)              :: CloudMassTotal

  real(8), allocatable :: xz_TempAll(:,:)
  real(8), allocatable :: xz_PressAll(:,:)
  real(8), allocatable :: xz_EffMolWt(:,:)
  real(8), allocatable :: xza_MixRtDivMolWt(:,:,:)
  real(8), allocatable :: xza_LatentHeat(:,:,:)

  real(8), allocatable :: xz_MoistCond(:,:)
  real(8), allocatable :: xz_MoistSat(:,:)
  real(8), allocatable :: xz_MoistCondBasicZ(:,:)
  real(8), allocatable :: xz_MoistNH4SH(:,:)
  real(8), allocatable :: xz_MoistNH4SH2(:,:)
  real(8), allocatable :: xz_MoistNH4SH3(:,:)
  real(8), allocatable :: xz_DryENG(:,:)
  real(8), allocatable :: xz_DryEngBasicZ(:,:)
  real(8), allocatable :: xz_MoistENG(:,:)
  real(8), allocatable :: xz_SatMoistENG(:,:)
  real(8), allocatable :: xz_MoistENGBasicZ(:,:)

  real(8), allocatable :: xz_Z(:,:) 

  integer             :: t, s, i, k, tt, step
  character(100)       :: cfgfile

  !ޥɥ饤β
  !  NAMELIST ե̾ɤ߹
  call argset_init(cfgfile)

  !ʪν
  call chemdata_init()

  !˴ؤν
  !  NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
  call timeset_init(cfgfile)

  !ʻν
  !  NAMELIST , ʻ׻
  call gridset_init(cfgfile)
  
  !ط׻롼ν
  call chemcalc_init()

  !ܾξν
  !  NAMELIST , ܾꤹ.
  call basicset_init(cfgfile)
  
  !I/O ե̾ν
  !  NAMELIST ե̾ꤷ, deepconv/arare 
  !  ϥե̾ NAMELIST 
  call fileset_init(cfgfile)
  
  !ܾμ
  call AnalFile_BasicZ_Get( )

  !롼ζͭѿν
  call moistset_init()

  !ѻͤݴɤ뤿Υ⥸塼ν
  !  NAMELIST , ܾꤹ.
  call StorePotTemp_init( )
  call StoreMixRt_init( )
  call StoreBuoy_init( )  
  call StoreStab_init( )  

  !ѿν. ȤꤢͤꤵƤ. 
  call ArareAlloc

  !ʬ̤ФϷ׻롼ν
  call MoistBuoy_Init()             
  
  !NetCDF եκȴܾμ  
!  call AnalFile_EqPotTemp_Open(  )
  call AnalFile_MoistENG_Open(  )
    
  !----------------------------------------------------------------------
  ! ͤη׻
  !   ʤʤ, եͤ
  !----------------------------------------------------------------------
!  do t = 1, int( TimeInt / TimeDisp ) + 1
  step = int( TimeInt / TimeDisp )
  STEPS: do while (step >= 600)
   write(*,*) step
   if (mod(step, 2) == 1) then 
       exit STEPS
    end if
    step = step / 2 
  end do STEPS
  write(*,*) "**** STEPS ***** ", int( TimeInt / TimeDisp ), " ==> ", step

  TIMESTEP: do tt = 0, int( TimeInt / TimeDisp) -1
     if ( mod(tt, int(TimeInt / TimeDisp / step)) /= 0 ) then 
        cycle TIMESTEP
     end if
     t = tt + 1
    
    !----------------------------------------------------------------
    ! ҥȥե򳫤ͤ. 
    !----------------------------------------------------------------
    call AnalFile_Get(                                           &
      &       t,  AnalTime,                                      &
      &       xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, xza_MixRt )
    write(*,*) t, AnalTime    
    
    !----------------------------------------------------------------
    ! 
    !----------------------------------------------------------------
    xza_MixRtAll = xza_MixRt + xza_MixRtBasicZ

    !----------------------------------------------------------------
    ! ١Ϥη׻
    !----------------------------------------------------------------
    xz_PressAll = &
      & PressBasis * ((xz_Exner + xz_ExnerBasicZ ) ** (CpDry / GasRDry))
    
    xz_PotTempAll  = xz_PotTemp + xz_PotTempBasicZ
    xz_TempAll = ( xz_Exner + xz_ExnerBasicZ ) * xz_PotTempAll

    !----------------------------------------------------------------
    ! ̩, ̤η׻
    !----------------------------------------------------------------
    xza_MixRtDivMolWt = 0.0d0
    do s = 1, GasNum
      xza_MixRtDivMolWt(:,:,IdxG(s)) = xza_MixRtAll(:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do

    xz_EffMolWt = &
      & (1.0d0 + sum(xza_MixRtAll,3)) &
      & / (MolWtDry * ((1.0d0 / MolWtDry) + sum(xza_MixRtDivMolWt,3))) 

    !----------------------------------------------------------------
    ! ˰¾ʿ
    !----------------------------------------------------------------
    do s = 1, CondNum
      !˰¾
      xza_MixRtSat(:,:,IdxCG(s)) =                        &
        & xz_SvapPress(SpcWetID(IdxCC(s)), xz_TempAll)    &
        &  * MolWtWet(IdxCC(s))                           &
        &  / (MolWtDry * xz_PressAll)                     

      xza_MixRtSatBasicZ(:,:,IdxCG(s)) =                  &
        & xz_SvapPress(SpcWetID(IdxCC(s)), xz_TempBasicZ) &
        &  * MolWtWet(IdxCC(s))                           &
        &  / (MolWtDry * xz_PressBasicZ)                  
    end do
    
    !---------------------------------------------------------------
    ! Ūͥ륮
    !---------------------------------------------------------------
    ! ľɸ 2 
    do k = DimZMin, DimZMax
      xz_Z(:,k) = s_Z(k)
    end do
    
    ! Ūͥ륮 CpT+gz
    xz_DryEng = 0.0d0    
    xz_DryEngBasicZ = 0.0d0    
!    xz_DryEng       = CpDry * xz_TempAll + Grav / xz_EffMolWt * xz_Z
    xz_DryEng       = CpDry * xz_TempAll + Grav * xz_Z
    xz_DryEngBasicZ = CpDry * xz_TempBasicZ + Grav * xz_Z

    !NH4SH ȿ. H2S  NH3 ȿ NH4SH ˤʤȹͤ. 
    ! H2S ȿʬ NH3 򸺾. 
    xz_MoistNH4SH = ReactHeatNH4SH * xza_MixRtAll(:,:,IdxH2S) * MolWtWet(IdxNH4SHc) / MolWtWet(IdxH2S)
    xza_MixRtAll(:,:,IdxNH3) = xza_MixRtAll(:,:,IdxNH3) -  xza_MixRtAll(:,:,IdxH2S) &  
         &          * MolWtWet(IdxNH3) / MolWtWet(IdxH2S)  

    xz_MoistNH4SH2 = ReactHeatNH4SH * xza_MixRtSat(:,:,IdxH2S) * MolWtWet(IdxNH4SHc) / MolWtWet(IdxH2S)
    xza_MixRtSat(:,:,IdxNH3) = xza_MixRtSat(:,:,IdxNH3) -  xza_MixRtSat(:,:,IdxH2S) &  
         &          * MolWtWet(IdxNH3) / MolWtWet(IdxH2S)  

    xz_MoistNH4SH3 = ReactHeatNH4SH * xza_MixRtSatBasicZ(:,:,IdxH2S) * MolWtWet(IdxNH4SHc) / MolWtWet(IdxH2S)
    xza_MixRtSatBasicZ(:,:,IdxNH3) = xza_MixRtSatBasicZ(:,:,IdxNH3) - xza_MixRtSatBasicZ(:,:,IdxH2S) &  
         &          * MolWtWet(IdxNH3) / MolWtWet(IdxH2S)  

    ! H2O  NH3 ζŷǮ. 
    xz_MoistCond = 0.0d0
    xz_MoistSat = 0.0d0    
    xz_MoistCondBasicZ = 0.0d0    
    
    ! ŷ
    do s = 1, CondNum
      xz_MoistCond = xz_MoistCond     &
        &             + xz_LatentHeat( SpcWetID(IdxCC(s)), xz_TempAll )   &
        &               * xza_MixRtAll(:,:,IdxCG(s))  
    end do
    s = 1
!    do s = 1, CondNum
       xz_MoistSat = xz_MoistSat                                          &
        &             + xz_LatentHeat( SpcWetID(IdxCC(s)), xz_TempAll )   &
        &               * xza_MixRtSat(:,:,IdxCG(s))  
!    end do
    do s = 1, CondNum
      xz_MoistCondBasicZ = xz_MoistCondBasicZ                              &
        &             + xz_LatentHeat( SpcWetID(IdxCC(s)), xz_TempBasicZ ) &
        &               * xza_MixRtSatBasicZ(:,:,IdxCG(s))  
    end do    
    
    xz_MoistEng      = xz_DryEng       + xz_MoistCond       + xz_MoistNH4SH
!    xz_SatMoistEng   = xz_DryEng       + xz_MoistSat        + xz_MoistNH4SH2
    xz_SatMoistEng   = xz_DryEng       + xz_MoistSat
    xz_MoistEngBasicZ= xz_DryEngBasicZ + xz_MoistCondBasicZ + xz_MoistNH4SH3
  
    !----------------------------------------------------
    ! ͥ륮˴ؤΤ
    !----------------------------------------------------
    ! Ƴʻμ̩(ʬδͿ)
    xz_MassDens =                                                   &
      & (xz_ExnerBasicZ + xz_Exner)**( (CpDry - GasRDry)/GasRDry )  &
      & / (xz_PotTempBasicZ + xz_PotTemp)                           &
      & - (xz_ExnerBasicZ )**( (CpDry - GasRDry)/GasRDry )          &
      & / xz_PotTempBasicZ
    
    ! ΰΤεμ
    MassTotal = (Xmax - Xmin) * PressSfc /Grav                 &
      & * ( xz_ExnerBasicZ(RegXMin,RegZMin)**(CpDry/GasRDry)          &
      &     - xz_ExnerBasicZ(RegXMin,RegZMax)**(CpDry/GasRDry) )      &
      & + PressSfc * DelX * DelZ / GasRDry                            &
      & * sum( xz_MassDens(RegXMin:RegXMax,RegZMin:RegZMax))
    
!    ! Ƴʻαưͥ륮(̩٤¤̩٤ɾ)
!     xz_KineticEnergy = 0.5d0 * PressSfc * DelX * DelZ / GasRDry      &
!      & * (xz_ExnerBasicZ + xz_Exner )**((CpDry - GasRDry)/GasRDry) &
!      & / (xz_PotTempBasicZ + xz_PotTemp)                           &
!      & * ( xz_avr_pz(pz_VelX)**2.0d0 + xz_avr_xr(xr_VelZ)**2.0d0 &
!      &     )

    ! Ƴʻαưͥ륮(̩٤ܾ̩٤ɾ)
    xz_KineticEnergy = 0.5d0 * PressSfc * DelX * DelZ / GasRDry      &
      & * (xz_ExnerBasicZ)**((CpDry - GasRDry)/GasRDry)               &
      & / (xz_PotTempBasicZ)                                          &
      & * ( xz_avr_pz(pz_VelX)**2.0d0 + xz_avr_xr(xr_VelZ)**2.0d0 &
      &     )
    
    ! ΰΤαưͥ륮
    KineticEnergyTotal =                                             &
      & sum( xz_KineticEnergy(RegXMin:RegXMax,RegZMin:RegZMax) )
    
!    ! ΰΤαμ
!    CloudMassTotal = DelX * DelZ                                     &
!      & * sum( xz_MixRt(RegXMin:RegXMax,RegZMin:RegZMax,1:SpcNum) )
    
    ! Ƴʻΰ֥ͥ륮
    xz_PotentialEnergy = - xz_DensBasicZ * xz_PotTemp * xz_Z       &
      & / xz_PotTempBasicZ
    
    ! ΰΤΰ֥ͥ륮
    PotentialEnergyTotal = DelX * DelZ                               &
      & * sum( xz_PotentialEnergy(RegXMin:RegXMax,RegZMin:RegZMax) )
    
    ! Ƴʻͥ륮(1 )
    xz_ElasticEnergyFO = xz_DensBasicZ *                             &
      & (CpDry * xz_PotTempBasicZ / xz_VelSoundBasicZ )**2.0d0        &
      & * xz_ExnerBasicZ * xz_Exner
    
    ! ΰΤͥ륮(1 )
    ElasticEnergyFOTotal = DelX * DelZ                               &
      & * sum( xz_ElasticEnergyFO(RegXMin:RegXMax,RegZMin:RegZMax) )
    
    ! Ƴʻͥ륮(2 )
    xz_ElasticEnergySO = 0.5d0 * xz_DensBasicZ *                     &
      & (CpDry * xz_PotTempBasicZ * xz_Exner / xz_VelSoundBasicZ )**2.0d0
    
    ! ΰΤͥ륮(2 )
    ElasticEnergySOTotal = DelX * DelZ                               &
      & * sum( xz_ElasticEnergySO(RegXMin:RegXMax,RegZMin:RegZMax) )
    
    !----------------------------------------------------------------    
    ! ե
    !----------------------------------------------------------------
    call AnalFile_MoistENG_OutPut( AnalTime )
    
 end do TIMESTEP
  
  !----------------------------------------------------------------    
  ! եĤ
  !----------------------------------------------------------------    
  call AnalFile_Close

    
contains
  
  subroutine AnalFile_Close( )
    !
    !ϥեΥ
    !
    use gt4_history, only: HistoryClose
    use fileset, only: gt_hist

    call HistoryClose
    
  end subroutine AnalFile_Close

  
  subroutine AnalFile_MoistENG_Open( )
    !
    !ϥե
    !
    
    use gt4_history, only: HistoryCreate, HistoryPut, HistoryAddVariable
    use fileset, only: gt_hist, exptitle, expsrc, expinst, HistoryFilePrefix    
    use gridset, only: FileNX, FileNZ, s_X, s_Z, &
      &                FileXMin, FileXMax, FileZMin, FileZMax
    
    !ۤηػ
    implicit none

    !ѿ
    character(150)  :: File

    !ե̾λ
    File = trim(HistoryFilePrefix)// '_Energy.nc'
    write(*,*) "******* OUTPUT FILE: ", File

    !-----------------------------------------------------------
    ! ҥȥ꡼
    !-----------------------------------------------------------
    call HistoryCreate(                              &
      & file = File,                                 &
      & title = exptitle,                            &
      & source = expsrc,                             &
      & institution = expinst,                       &
      & dims=(/'x','z','t'/),                        &
      & dimsizes=(/FileNX, FileNZ, 0/),              &
      & longnames=(/'X-coordinate',                  &
      &             'Z-coordinate',                  &
      &             'Time        '/),                &
      & units=(/'m','m','s'/), origin=0.0,           &
      & interval=0.0 )
    
    !-----------------------------------------------------------  
    ! ν
    !-----------------------------------------------------------
    call HistoryPut('x', s_X( FileXMin: FileXMax ))
    call HistoryPut('z', s_Z( FileZMin: FileZMax ))

    !-----------------------------------------------------------  
    ! Ѥѿν
    !-----------------------------------------------------------  
    call HistoryAddVariable(                                &
      & varname='Cp', dims=(/'x','z','t'/),           &
      & longname='Mean Specific Heat',                     &
      & units='J/K/kg', xtype='double' )

    call HistoryAddVariable(                                &
      & varname='CpBasicZ', dims=(/'x','z','t'/),           &
      & longname='Specific Heat (BasicZ)',                     &
      & units='J/K/kg', xtype='double' )

    call HistoryAddVariable(                                &
      & varname='MoistCond', dims=(/'x','z','t'/),           &
      & longname='Moist Static Energy (Lq)',                     &
      & units='J/kg', xtype='double' )
    
    call HistoryAddVariable(                                &
      & varname='MoistSat', dims=(/'x','z','t'/),           &
      & longname='Moist Static Energy (Lq_eq)',                     &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                                &
      & varname='MoistCondBasicZ', dims=(/'x','z','t'/),           &
      & longname='Moist Static Energy (Lq_sat, BasicZ)',                     &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                                &
      & varname='MoistNH4SH', dims=(/'x','z','t'/),           &
      & longname='Moist Static Energy (NH4SH)',                     &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                                &
      & varname='DrySEngBasicZ', dims=(/'x','z','t'/),           &
      & longname='Moist Static Energy (gz, BasicZ)',                     &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                                &
      & varname='MoistSEng', dims=(/'x','z','t'/),           &
      & longname='Moist Static Energy',                     &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                                &
      & varname='DrySEng', dims=(/'x','z','t'/),             &
      & longname='Dry Static Energy',                       &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                                &
      & varname='SatMoistSEng', dims=(/'x','z','t'/),        &
      & longname='Saturated Moist Static Energy',           &
      & units='J/kg', xtype='double' )


    call HistoryAddVariable(                                &
      & varname='MoistSEngBasicZ', dims=(/'x','z','t'/),  &
      & longname='Saturated Moist Static Energy (BasicZ)',  &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='MassDens', dims=(/'x','z','t'/),          &
      & longname='Mass Density',                           &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='MassTotal', dims=(/'t'/),                 &
      & longname='Mass Density',                           &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='KineticEnergy', dims=(/'x','z','t'/),     &
      & longname='Kinetic Energy',                         &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='KineticEnergyTotal', dims=(/'t'/),        &
      & longname='Total Kinetic Energy',                   &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='PotentialEnergy', dims=(/'x','z','t'/),   &
      & longname='Potential Energy',                       &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='PotentialEnergyTotal', dims=(/'t'/),      &
      & longname='Total Potential Energy',                 &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='ElasticEnergyFO', dims=(/'x','z','t'/),   &
      & longname='Elastic Energy',                         &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='ElasticEnergyFOTotal', dims=(/'t'/),      &
      & longname='Total Elastic Energy',                   &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='ElasticEnergySO', dims=(/'x','z','t'/),   &
      & longname='Elastic Energy',                         &
      & units='J/kg', xtype='double' )

    call HistoryAddVariable(                               &
      & varname='ElasticEnergySOTotal', dims=(/'t'/),      &
      & longname='Total Elastic Energy',                   &
      & units='J/kg', xtype='double' )

  end subroutine AnalFile_MoistENG_Open


  subroutine AnalFile_MoistENG_OutPut( Time )

    use gridset, only: FileXMin, FileXMax, FileZMin, FileZMax
    use gt4_history, only: HistoryPut


    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: Time    
 
    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------
    call HistoryPut( 't', Time ) 
    
    call HistoryPut( 'Cp',          &
      &            CpDry / xz_EffMolWt(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'CpBasicZ',          &
      &            CpDry / xz_EffMolWtBasicZ(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'MoistCond',          &
      &            xz_MoistCond(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'MoistSat',          &
      &            xz_MoistSat(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'MoistCondBasicZ',          &
      &            xz_MoistCondBasicZ(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'MoistNH4SH',          &
      &            xz_MoistNH4SH(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'DrySEngBasicZ',          &
      &            xz_DryEngBasicZ(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'DrySEng',          &
      &            xz_DryENG(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'MoistSEng',          &
      &            xz_MoistENG(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'SatMoistSEng',          &
      &            xz_SatMoistENG(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'MoistSEngBasicZ',          &
      &            xz_MoistENGBasicZ(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'MassDens',          &
      &            xz_MassDens(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'MassTotal', MassTotal)

    call HistoryPut( 'KineticEnergy',          &
      &            xz_KineticEnergy(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'KineticEnergyTotal', KineticEnergyTotal )

    call HistoryPut( 'PotentialEnergy',          &
      &            xz_PotentialEnergy(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'PotentialEnergyTotal', PotentialEnergyTotal )

    call HistoryPut( 'ElasticEnergyFO',          &
      &            xz_ElasticEnergyFO(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'ElasticEnergyFOTotal', ElasticEnergyFOTotal)

    call HistoryPut( 'ElasticEnergySO',          &
      &            xz_ElasticEnergySO(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'ElasticEnergySOTotal', ElasticEnergySOTotal )
    
  end subroutine AnalFile_MoistENG_OutPut


!!!------------------------------------------------------------------------------!!!
  subroutine AnalFile_Get(                                      &
    &       i, AnalTime,                                        &
    &       xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, xza_MixRt )
 
    use dc_string
    use gt4_history,   only : HistoryGet
    use fileset,       only : HistoryFile
    use gridset,       only : DimXMin, DimXMax, DimZMin, DimZMax, SpcNum, &
      &                       FileXMin, FileXMax, FileZMin, FileZMax
    use basicset,      only : SpcWetSymbol
    use boundary,      only : BoundaryXCyc_xz, BoundaryZSym_xz,   &
      &                       BoundaryXCyc_xza, BoundaryZSym_xza, &
      &                       BoundaryXCyc_pz, BoundaryZSym_pz,   &
      &                       BoundaryXCyc_xr, BoundaryZAntiSym_xr

    !ۤηػ
    implicit none

    !ѿ
    integer, intent(in)  :: i    
    real(8), intent(out) :: AnalTime
    real(8), intent(out) :: pz_VelX(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xr_VelZ(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xz_Exner(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xza_MixRt(DimXMin:DimXMax,DimZMin:DimZMax,1:SpcNum)
    character(30)        :: name               !ѿ̾
    character(10)        :: step
    
    step = 't=^' // adjustl(toChar(i))

    !-------------------------------------------------------------
    !Get a Value from netCDF File
    !-------------------------------------------------------------
    name = "t"
    call HistoryGet( HistoryFile(1), name, AnalTime, step )

    !-------------------------------------------------------------    
    ! Get a Value from netCDF File 
    !-------------------------------------------------------------
    name = "Exner"
    call HistoryGet( HistoryFile(1), name, xz_Exner(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    call BoundaryXCyc_xz( xz_Exner )
    call BoundaryZSym_xz( xz_Exner )
    
    name = "PotTemp"
    call HistoryGet( HistoryFile(2), name, xz_PotTemp(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    call BoundaryXCyc_xz( xz_PotTemp )
    call BoundaryZSym_xz( xz_PotTemp )

    name = "VelX"
    call HistoryGet( HistoryFile(3), name, pz_VelX(FileXMin:FileXMax, FileZMin:FileZMax), range=step )    
    call BoundaryXCyc_pz( pz_VelX )
    call BoundaryZSym_pz( pz_VelX )
    
    name = "VelZ"
    call HistoryGet( HistoryFile(4), name, xr_VelZ(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    call BoundaryXCyc_xr( xr_VelZ )
    call BoundaryZAntiSym_xr( xr_VelZ )

!    name = "Km"
!    call HistoryGet( HistoryFile(5), name, xz_Km(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
!    xz_Km = xz_BoundaryXCyc_xz( xz_Km )
!    xz_Km = xz_BoundaryZSym_xz( xz_Km )

    do s = 1, SpcNum
      name = trim(SpcWetSymbol(s))
      call HistoryGet( HistoryFile(8+s), name, xza_MixRt(FileXMin:FileXMax, FileZMin:FileZMax, s), range=step )
    end do

    call BoundaryXCyc_xza( xza_MixRt )
    call BoundaryZSym_xza( xza_MixRt )

  end subroutine AnalFile_Get



  subroutine AnalFile_BasicZ_Get( )

    use dc_string
    use gt4_history,   only: HistoryGet
    use fileset,       only: HistoryFile
    use basicset,      only: BasicSetArray_Init, SpcWetSymbol
    use gridset,       only: DimXMin, DimXMax, DimZMin, DimZMax, SpcNum, &
      &                      FileXMin, FileXMax, FileZMin, FileZMax
    use boundary,      only: BoundaryXCyc_xz, BoundaryZSym_xz,     &
      &                      BoundaryXCyc_xza,BoundaryZSym_xza, &
      &                      BoundaryXCyc_pz, BoundaryZSym_pz,     &
      &                      BoundaryXCyc_xr, BoundaryZAntiSym_xr

    !ۤηػ
    implicit none

    !ѿ
    real(8) :: xz_DensBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_PotTempBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_ExnerBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xza_MixRtBZ(DimXMin:DimXMax, DimZMin:DimZMax,1:SpcNum)
    real(8) :: xz_EffMolWtBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_PressBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_TempBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_VelSoundBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    character(30)        :: name               !ѿ̾
    

    !-------------------------------------------------------------
    ! ܾμ
    !-------------------------------------------------------------
    name = "TempBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_TempBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_TempBZ )
    call BoundaryZSym_xz( xz_TempBZ )

    name = "PressBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_PressBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_PressBZ )
    call BoundaryZSym_xz( xz_PressBZ )

    name = "ExnerBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_ExnerBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_ExnerBZ )
    call BoundaryZSym_xz( xz_ExnerBZ )

    name = "PotTempBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_PotTempBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_PotTempBZ )
    call BoundaryZSym_xz( xz_PotTempBZ )

    name = "DensBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_DensBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_DensBZ )
    call BoundaryZSym_xz( xz_DensBZ )

    name = "VelSoundBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_VelSoundBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_VelSoundBZ )
    call BoundaryZSym_xz( xz_VelSoundBZ )

    name = "EffMolWtBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_EffMolWtBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_EffMolWtBZ )
    call BoundaryZSym_xz( xz_EffMolWtBZ )

    do s = 1, SpcNum
      name = trim(SpcWetSymbol(s))//'BasicZ'
      call HistoryGet( HistoryFile(7), name, xza_MixRtBZ(FileXMin:FileXMax, FileZMin:FileZMax, s) )
    end do

    call BoundaryXCyc_xza( xza_MixRtBZ )
    call BoundaryZSym_xza( xza_MixRtBZ )

    !----------------------------------------------------------
    ! BasicSet ⥸塼ͤ
    !----------------------------------------------------------
    call BasicSetArray_Init(                       &
      & xz_PressBZ,   xz_ExnerBZ,   xz_TempBZ,     &
      & xz_PotTempBZ, xz_DensBZ,    xz_VelSoundBZ, &
      & xza_MixRtBZ,  xz_EffMolWtBZ )

  end subroutine AnalFile_BasicZ_Get


  subroutine ArareAlloc

    use gridset,       only: DimXMin, DimXMax, DimZMin, DimZMax, SpcNum

    !ܾ, μ.
    allocate( &
      &       xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax ),             &
      &       xz_PotTempAll(DimXMin:DimXMax, DimZMin:DimZMax ),          &
      &       xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax ),               &
      &       pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax ),                &
      &       xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax ),                &
      &       xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ),    &
      &       xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       xza_MixRtAll2(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       xza_MixRtSat(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       xza_MixRtSatBasicZ(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ),  &
      &       xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax ),            &
      &       xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      !
      &       xz_EffMolWt(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       xza_MixRtDivMolWt(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum),&
      &       xza_LatentHeat(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum),   &
      !
      &       xz_MoistCond(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_MoistSat(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_MoistCondBasicZ(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_MoistNH4SH(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_MoistNH4SH2(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_MoistNH4SH3(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_DryEngBasicZ(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_MoistENG(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_SatMoistENG(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_MoistENGBasicZ(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_DryENG(DimXMin:DimXMax,DimZMin:DimZMax),   &
      !
      &       xz_MassDens(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_KineticEnergy(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_PotentialEnergy(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_ElasticEnergyFO(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_ElasticEnergySO(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_Z(DimXMin:DimXMax,DimZMin:DimZMax)   &
      &   )

    xza_MixRtSat = 0.0d0
    xza_MixRtDivMolWt = 0.0d0

    xz_MoistCond = 0.0d0
    xz_MoistSat = 0.0d0
    xz_MoistCondBasicZ = 0.0d0
    xz_MoistNH4SH = 0.0d0
    xz_DryEngBasicZ = 0.0d0
    xz_MoistENG = 0.0d0
    xz_SatMoistENG = 0.0d0
    xz_MoistENGBasicZ = 0.0d0
    xz_DryENG = 0.0d0

  end subroutine ArareAlloc

end program ArareEnergy
