!= Module ECCM
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: eccm.f90,v 1.27 2010-03-05 03:52:38 sugiyama Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǮŪ˾徺뵤βٸΨ׻, ſ尵ʿդ鰵Ϥ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * Ǯ, ʿʬ̤
!  * 顼٤­ʤΤ, 󥲥å. 
!
!== Future Plans
!

module ECCM

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset,  only: DimZMin,       &!  Z β
    &                 DimZMax,       &!  Z ξ 
    &                 RegZMin,       &!
    &                 SpcNum,        &!
    &                 s_Z,           &!
    &                 DelZ            !
  use basicset,only:  MolWtDry,      &!
    &                 MolWtWet,      &!
    &                 CpDryMol,      &!
    &                 SpcWetID,      &!
    &                 TempSfc,       &!
    &                 PressSfc,      &!
    &                 Grav            !
  use chemcalc, only: SvapPress,        &!
    &                 LatentHeatPerMol, &!
    &                 ReactHeatNH4SHPerMol
  use moistset, only: CondNum,          &!ŷο
    &                 IdxCG,            &!ŷ()ź
    &                 IdxCC,            &!ŷ()ź
    &                 GasNum,           &!Το
    &                 IdxNH3,           &!NH3()ź
    &                 IdxH2S             !H2S()ź
  use ChemData, only: GasRUniv        
  use MoistFunc,only: DelMolFrNH4SH 
  use StoreStab,only: StoreStabTemp, StoreStabMolWt

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿθ
  public ECCM_MolFr
  public ECCM_Stab
  public ECCM_Dry
  public ECCM_Wet
  public ECCM_Wet2

contains

!!!------------------------------------------------------------------------------!!!
!  subroutine ECCM_Dry( a_MolFrIni, Humidity, z_Temp, z_Press, z_MolWtMean, za_MolFr )
  subroutine ECCM_Dry( a_MolFrIni, Humidity, z_Temp, z_Press, za_MolFr )
    !
    !== 
    !  * ǮٸΨ˱ä١ϤᡢФƻꤵ줿м٤Ȥʤ褦˶ŷʬΥ
    !  * Ǯϴ絤ΤΤɽ
    !    * ήΤˤǮϴʬΤΤɽƤ뤿
    !  * 絤ʿʬ̤ˤϼʬʬ̤
    !    * ήΤˤ, ʬʬ̤ϹθƤ뤿
    !
    
    !ۤηػ
    implicit none
    
    real(8), intent(in) :: a_MolFrIni(1:SpcNum)    !ǤΥ
    real(8), intent(in) :: Humidity                !м ( Humidity <= 1.0 )
    real(8), intent(out):: z_Temp(DimZMin:DimZMax) !
    real(8), intent(out):: z_Press(DimZMin:DimZMax)!
!    real(8), intent(out):: z_MolWtMean(DimZMin:DimZMax) 
    real(8)             :: z_MolWtMean(DimZMin:DimZMax) 
                                                   !ʿʬ
    real(8), intent(out):: za_MolFr(DimZMin:DimZMax, 1:SpcNum) 
                                                   !ʬΨ
    real(8)             :: MolWtMeanDry            !絤ʬ̤κѿ
    real(8)             :: MolWtMeanWet            !ᵤʬ̤κѿ
    real(8)             :: SatPress                !˰¾
    real(8)             :: VapPress                !
    real(8)             :: DelMolFr
    integer             :: k, s

    !-------------------------------------------------------------
    ! ν
    !-------------------------------------------------------------
    !ɽ̤ʬ̤
    za_MolFr(RegZMin+1, 1:SpcNum)   = a_MolFrIni(1:SpcNum) 

    !ɽ̤Ǥʿʬ̤
    MolWtMeanDry = MolWtDry * (1.0d0 - sum(a_MolFrIni))
    MolWtMeanWet = dot_product(MolWtWet, a_MolFrIni) 
    z_MolWtMean(RegZMin+1) = MolWtMeanDry + MolWtMeanWet
  
    !ɽ̤Ǥβ(RegZMin+1 ,  DelZ / 2 )
    z_Temp          = 1.0d-60
    z_Temp(RegZMin+1) = TempSfc - Grav * MolWtDry &
      &                 / CpDryMol * ( DelZ * 5.0d-1 )
    
    !ɽ̤Ǥΰ(RegZMin+1 ,  DelZ / 2 )
    z_Press           = 1.0d-60
    z_Press(RegZMin+1)  = &
      & PressSfc *((TempSfc / z_Temp(RegZMin+1)) ** (- CpDryMol /  GasRUniv))
    
    !-----------------------------------------------------------
    ! (1) Ǯ˱ä٤
    ! (2) ſ尵ʿդ鰵Ϥ
    ! (3) (1),(2) βٰϤФ, Ȥм٤Ȥʤ
    !-----------------------------------------------------------    
    DtDz: do k = RegZMin+1, DimZMax-1

      !(1)Ǯ˱ä k+1 Ǥβ٤׻
      z_Temp(k+1) = z_Temp(k) - Grav * MolWtDry / CpDryMol * DelZ
      
      !ǰ
      if (z_Temp(k+1) <= 0.0d0 ) z_Temp(k+1) = z_Temp(k) 
      
      !(2)Ϥſ尵ʿդ׻
      z_Press(k+1) =                                                  &
        &  z_Press(k) * ((z_Temp(k) / z_Temp(k+1)) ** (- CpDryMol / GasRUniv)) 

      !(3)η׻
      !  ޤϥѲʤΤȤƥͿ
      !  ˰¾ʿȤʿվŬѤƤ
      za_MolFr(k+1,:) = za_MolFr(k,:)
      
      do s = 1, CondNum      
        !˰¾
        SatPress = SvapPress( SpcWetID(IdxCC(s)), z_Temp(k+1) )        
        
        !ΥʬΨѤƸߤξ׻
        VapPress = za_MolFr(k,IdxCG(s)) * z_Press(k+1)
        
        !˰¾ȰϤ鸽ߤΥ׻
        if ( VapPress > SatPress ) then         
          za_MolFr(k+1,IdxCG(s)) = max(SatPress * Humidity / z_Press(k+1), 1.0d-16)

        end if
!        write(*,*) k, s, z_Temp(k), za_MolFr(k,IdxCG(s)), VapPress, SatPress
      end do
      
      !NH4SH ʿվ
      if ( IdxNH3 /= 0 ) then 
        DelMolFr =                                              &
          & max (                                               &
          &    DelMolFrNH4SH(                                   &
          &         z_Temp(k+1), z_Press(k+1),                  &
          &         za_MolFr(k+1,IdxNH3), za_MolFr(k+1,IdxH2S),       &
          &         Humidity                                    &
          &      ),                                             &
          &    0.0d0                                            &
          &  )
        za_MolFr(k+1,IdxNH3) = za_MolFr(k+1,IdxNH3) - DelMolFr
        za_MolFr(k+1,IdxH2S) = za_MolFr(k+1,IdxH2S) - DelMolFr
      end if
      
      !------------------------------------------------------------
      !ٸۤ׻
      !------------------------------------------------------------
      !ɽ̤Ǥʿʬ̤
      MolWtMeanDry = MolWtDry * (1.0d0 - sum(za_MolFr(k+1, 1:SpcNum)))
      MolWtMeanWet = dot_product(MolWtWet(1:SpcNum), za_MolFr(k+1, 1:SpcNum))
      z_MolWtMean(k+1) = MolWtMeanDry + MolWtMeanWet

    end do DtDz
    
  end subroutine ECCM_Dry


!!------------------------------------------------------------------------------!!!
!  subroutine ECCM_Wet( a_MolFrIni, Humidity, z_Temp, z_Press, z_MolWtMean, za_MolFr )
  subroutine ECCM_Wet( a_MolFrIni, Humidity, z_Temp, z_Press, za_MolFr )
    !
    !== 
    !  * ǮٸΨ˱ä١ϤᡢФƻꤵ줿м٤Ȥʤ褦˶ŷʬΥ
    !  * Ǯϴ絤ΤΤɽ
    !    * ήΤˤǮϴʬΤΤɽƤ뤿
    !  * 絤ʿʬ̤ˤϼʬʬ̤
    !    * ήΤˤ, ʬʬ̤ϹθƤ뤿
    !
    
    !ۤηػ
    implicit none
    
    real(8), intent(in) :: a_MolFrIni(1:SpcNum)    !ǤΥ
    real(8), intent(in) :: Humidity                !м ( Humidity <= 1.0 )
    real(8), intent(out):: z_Temp(DimZMin:DimZMax) !
    real(8), intent(out):: z_Press(DimZMin:DimZMax)!
!    real(8), intent(out):: z_MolWtMean(DimZMin:DimZMax) 
    real(8)             :: z_MolWtMean(DimZMin:DimZMax) 
                                                   !ʿʬ
    real(8), intent(out):: za_MolFr(DimZMin:DimZMax, 1:SpcNum) 
                                                   !ʬΨ
    real(8)             :: MolWtMeanDry            !絤ʬ̤κѿ
    real(8)             :: MolWtMeanWet            !ᵤʬ̤κѿ
    real(8)             :: SatPress                !˰¾
    real(8)             :: VapPress                !
    real(8)             :: DelMolFr
    integer             :: k, s, j
    
    real(8)             :: TempA, PressA, a_MolFrA(SpcNum)
    real(8)             :: TempN, PressN, a_MolFrN(SpcNum)
    real(8)             :: DZ
    real(8)             :: A, B
    real(8)             :: Heat(SpcNum)
    real(8)             :: ReactHeat
    logical             :: MoistFlag(SpcNum), ReactFlag
    
    !-------------------------------------------------------------
    ! ν
    !-------------------------------------------------------------
    !ɽ̤ʬ̤
    za_MolFr(RegZMin+1, 1:SpcNum)   = a_MolFrIni(1:SpcNum) 
    
    !ɽ̤Ǥʿʬ̤
    MolWtMeanDry = MolWtDry * (1.0d0 - sum(a_MolFrIni))
    MolWtMeanWet = dot_product(MolWtWet, a_MolFrIni) 
    z_MolWtMean(RegZMin+1) = MolWtMeanDry + MolWtMeanWet
  
    !ɽ̤Ǥβ(RegZMin+1 ,  DelZ / 2 )
    z_Temp          = 1.0d-60
    z_Temp(RegZMin+1) = TempSfc - Grav * MolWtDry / CpDryMol * ( DelZ * 5.0d-1 )
    
    !ɽ̤Ǥΰ(RegZMin+1 ,  DelZ / 2 )
    z_Press             = 1.0d-60
    z_Press(RegZMin+1)  = PressSfc *((TempSfc / z_Temp(RegZMin+1)) ** (- CpDryMol /  GasRUniv))

    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------    
    DtDz: do k = RegZMin+1, DimZMax-1
      TempN  = z_Temp(k)
      PressN = z_Press(k)
      a_MolFrN = za_MolFr(k,:)
      
      DZ = DelZ/100
      do j = 1, 100
        MoistFlag = .false.
        Heat = 0.0d0   
        a_MolFrA = a_MolFrN  !
        
        !Ǯ˱ä k+1 Ǥβ٤׻
        TempA = TempN - Grav * MolWtDry / CpDryMol * DZ
!        write(*,*) "TempA", TempA
        
        !ǰ
        if (TempA <= 0.0d0 ) TempA = TempN
        
        !Ϥſ尵ʿդ׻
        PressA = PressN * ((TempN / TempA) ** (- CpDryMol / GasRUniv))
        
        ! ŷ뤬뤫Ƚ
        do s = 1, CondNum      
          !˰¾
          SatPress = SvapPress( SpcWetID(IdxCC(s)), TempA )
          
          !ΥʬΨѤƸߤξ׻
          VapPress = a_MolFrN(IdxCG(s)) * PressA
          
          !˰¾ŷ̵ͭ
          if ( VapPress < SatPress ) then         
            !ŷ뤷ƤʤΤǮʤ.
            a_MolFrA(IdxCG(s)) = a_MolFrN(IdxCG(s))
            !ŷ뤷ʤΤǮʤ
            Heat(IdxCG(s)) = 0.0d0
          else
            !Ǯ. ߤι٤Ǥ
            Heat(IdxCG(s)) = LatentHeatPerMol( SpcWetID(IdxCC(s)), TempN )
            !ŷΥå
            MoistFlag(s) = .true.
          end if
        end do

        !NH4SH ʿվ
        if ( IdxNH3 /= 0 ) then      
          DelMolFr =                                            &
            & max (                                             &
            &    DelMolFrNH4SH(                                 &
            &         TempA, PressA, a_MolFrN(IdxNH3), a_MolFrN(IdxH2S),&
            &         Humidity                                  &
            &      ),                                           &
            &    0.0d0                                          &
            &  )
          ! ȿǮ
          ReactHeat = ReactHeatNH4SHPerMol * DelMolFr
          ! ȿΥå
          if (DelMolFr > 0) ReactFlag = .true. 
        end if

!        write(*,*) "MoistFlag", MoistFlag
!        write(*,*) "ReactFlag", ReactFlag
        
        if (count(MoistFlag) > 0 .or. ReactFlag) then 
          !.  k Ǥͤɾ
          A = dot_product( Heat(1:SpcNum), a_MolFrN(1:SpcNum)) / ( GasRUniv * TempN )
          B = dot_product(( Heat(1:SpcNum) ** 2.0d0), a_MolFrN(1:SpcNum)) &
            & / ( CpDryMol * GasRUniv * ( TempN ** 2.0d0 ) )
          
          !ǮٸΨ
          TempA = TempN - Grav * MolWtDry * (1.0d0 + A) / (CpDryMol * (1.0d0 + B)) * DZ &
            &       + ReactHeat / (CpDryMol * DelZ)
!          write(*,*) "Moist TempA",   TempA
!          write(*,*) "Moist Heat ",   Heat
!          write(*,*) "Moist MolFr ",  a_MolFrN
!          write(*,*) "Moist DTempDZ", - Grav * MolWtDry * (1.0d0 + A) / (CpDryMol * (1.0d0 + B))
          
          !ǰ
          if (TempA <= 0.0d0 ) TempA = TempN
          
          !Ϥſ尵ʿդ׻
          PressA = PressN * ((TempN / TempA) ** (- CpDryMol / GasRUniv)) 
          
          do s = 1, CondNum              
            if (MoistFlag(s)) then 
              !˰¾
              SatPress = SvapPress( SpcWetID(IdxCC(s)), TempA )
              ! ˰¥
              a_MolFrA(IdxCG(s)) = max(SatPress / PressA, 1.0d-16)
            else
              ! ΥƱ
              a_MolFrA(IdxCG(s)) = a_MolFrN(IdxCG(s)) 
            end if
          end do

          if ( ReactFlag ) then 
            DelMolFr =                                            &
              & max (                                             &
              &    DelMolFrNH4SH(                                 &
              &         TempA, PressA, a_MolFrA(IdxNH3), a_MolFrA(IdxH2S),&
              &         Humidity                                  &
              &      ),                                           &
              &    0.0d0                                          &
              &  )
            a_MolFrA(IdxNH3) = a_MolFrA(IdxNH3) - DelMolFr
            a_MolFrA(IdxH2S) = a_MolFrA(IdxH2S) - DelMolFr
          end if
        end if
        
        TempN  = TempA
        PressN = PressA
        a_MolFrN = a_MolFrA        
      end do
        
      z_Temp(k+1)     = TempA
      z_Press(k+1)    = PressA
      za_MolFr(k+1,:) = a_MolFrA(:)
      
      !ʿʬ̤
      MolWtMeanDry = MolWtDry * (1.0d0 - sum(za_MolFr(k+1, 1:SpcNum)))
      MolWtMeanWet = dot_product(MolWtWet(1:SpcNum), za_MolFr(k+1, 1:SpcNum))
      z_MolWtMean(k+1) = MolWtMeanDry + MolWtMeanWet
    end do DtDz
    
  end subroutine ECCM_Wet


!!------------------------------------------------------------------------------!!!
  subroutine ECCM_Wet2( Idx, Humidity, z_Temp, z_Press, za_MolFr)
    !
    !== 
    !  * ǮٸΨ˱ä١ϤᡢФƻꤵ줿м٤Ȥʤ褦˶ŷʬΥ
    !  * Ǯϴ絤ΤΤɽ
    !    * ήΤˤǮϴʬΤΤɽƤ뤿
    !  * 絤ʿʬ̤ˤϼʬʬ̤
    !    * ήΤˤ, ʬʬ̤ϹθƤ뤿
    !
    
    !ۤηػ
    implicit none
    
    integer             :: Idx
    real(8), intent(inout) :: z_Temp(DimZMin:DimZMax)    !ǤΥ
    real(8), intent(inout) :: z_Press(DimZMin:DimZMax) !ǤΥ
    real(8), intent(inout) :: za_MolFr(DimZMin:DimZMax, 1:SpcNum)    !ǤΥ
    real(8), intent(in) :: Humidity                !м ( Humidity <= 1.0 )
    real(8)             :: SatPress                !˰¾
    real(8)             :: VapPress                !
    real(8)             :: DelMolFr
    integer             :: k, s, j
    
    real(8)             :: TempA, PressA, a_MolFrA(SpcNum)
    real(8)             :: TempN, PressN, a_MolFrN(SpcNum)
    real(8)             :: DZ
    real(8)             :: A, B
    real(8)             :: Heat(SpcNum)
    real(8)             :: ReactHeat
    logical             :: MoistFlag(SpcNum), ReactFlag
    

    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------    
    DtDz: do k = Idx, DimZMax-1
      TempN  = z_Temp(k)
      PressN = z_Press(k)
      a_MolFrN = za_MolFr(k,:)
      
      DZ = DelZ/100
      do j = 1, 100
        MoistFlag = .false.
        Heat = 0.0d0   
        a_MolFrA = a_MolFrN  !
        
        !Ǯ˱ä k+1 Ǥβ٤׻
        TempA = TempN - Grav * MolWtDry / CpDryMol * DZ
!        write(*,*) "TempA", TempA
        
        !ǰ
        if (TempA <= 0.0d0 ) TempA = TempN
        
        !Ϥſ尵ʿդ׻
        PressA = PressN * ((TempN / TempA) ** (- CpDryMol / GasRUniv))
        
        ! ŷ뤬뤫Ƚ
        do s = 1, CondNum      
          !˰¾
          SatPress = SvapPress( SpcWetID(IdxCC(s)), TempA )
          
          !ΥʬΨѤƸߤξ׻
          VapPress = a_MolFrN(IdxCG(s)) * PressA
          
          !˰¾ŷ̵ͭ
          if ( VapPress < SatPress ) then         
            !ŷ뤷ƤʤΤǮʤ.
            a_MolFrA(IdxCG(s)) = a_MolFrN(IdxCG(s))
            !ŷ뤷ʤΤǮʤ
            Heat(IdxCG(s)) = 0.0d0
          else
            !Ǯ. ߤι٤Ǥ
            Heat(IdxCG(s)) = LatentHeatPerMol( SpcWetID(IdxCC(s)), TempN )
            !ŷΥå
            MoistFlag(s) = .true.
          end if
        end do

        !NH4SH ʿվ
        if ( IdxNH3 /= 0 ) then      
          DelMolFr =                                            &
            & max (                                             &
            &    DelMolFrNH4SH(                                 &
            &         TempA, PressA, a_MolFrN(IdxNH3), a_MolFrN(IdxH2S),&
            &         Humidity                                  &
            &      ),                                           &
            &    0.0d0                                          &
            &  )
          ! ȿǮ
          ReactHeat = ReactHeatNH4SHPerMol * DelMolFr
          ! ȿΥå
          if (DelMolFr > 0) ReactFlag = .true. 
        end if

!        write(*,*) "MoistFlag", MoistFlag
!        write(*,*) "ReactFlag", ReactFlag
        
        if (count(MoistFlag) > 0 .or. ReactFlag) then 
          !.  k Ǥͤɾ
          A = dot_product( Heat(1:SpcNum), a_MolFrN(1:SpcNum)) / ( GasRUniv * TempN )
          B = dot_product(( Heat(1:SpcNum) ** 2.0d0), a_MolFrN(1:SpcNum)) &
            & / ( CpDryMol * GasRUniv * ( TempN ** 2.0d0 ) )
          
          !ǮٸΨ
          TempA = TempN - Grav * MolWtDry * (1.0d0 + A) / (CpDryMol * (1.0d0 + B)) * DZ &
            &       + ReactHeat / (CpDryMol * DZ)
!          write(*,*) "Moist TempA",   TempA
!          write(*,*) "Moist Heat ",   Heat
!          write(*,*) "Moist MolFr ",  a_MolFrN
!          write(*,*) "Moist DTempDZ", - Grav * MolWtDry * (1.0d0 + A) / (CpDryMol * (1.0d0 + B))
          
          !ǰ
          if (TempA <= 0.0d0 ) TempA = TempN
          
          !Ϥſ尵ʿդ׻
          PressA = PressN * ((TempN / TempA) ** (- CpDryMol / GasRUniv)) 
          
          do s = 1, CondNum              
            if (MoistFlag(s)) then 
              !˰¾
              SatPress = SvapPress( SpcWetID(IdxCC(s)), TempA )
              ! ˰¥
              a_MolFrA(IdxCG(s)) = max(SatPress / PressA, 1.0d-16)
            else
              ! ΥƱ
              a_MolFrA(IdxCG(s)) = a_MolFrN(IdxCG(s)) 
            end if
          end do

          if ( ReactFlag ) then 
            DelMolFr =                                            &
              & max (                                             &
              &    DelMolFrNH4SH(                                 &
              &         TempA, PressA, a_MolFrA(IdxNH3), a_MolFrA(IdxH2S),&
              &         Humidity                                  &
              &      ),                                           &
              &    0.0d0                                          &
              &  )
            a_MolFrA(IdxNH3) = a_MolFrA(IdxNH3) - DelMolFr
            a_MolFrA(IdxH2S) = a_MolFrA(IdxH2S) - DelMolFr
          end if
       end if
        
        TempN  = TempA
        PressN = PressA
        a_MolFrN = a_MolFrA        
      end do
        
      z_Temp(k+1)     = TempA
      z_Press(k+1)    = PressA
      za_MolFr(k+1,:) = a_MolFrA(:)
      
   end do DtDz
    
  end subroutine ECCM_Wet2



!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_MolFr( a_MolFrIni, Humidity, z_Temp, z_Press, za_MolFr )
    !
    ! Ϳ줿٤Ф, ǮŪ˾徺˼¸
    ! Υץե
    !

    
    !ۤηػ
    implicit none
    
    real(8), intent(in) :: a_MolFrIni(1:SpcNum)
    real(8), intent(in) :: Humidity
    real(8), intent(in) :: z_Temp(DimZMin:DimZMax)
    real(8), intent(in) :: z_Press(DimZMin:DimZMax)
    real(8), intent(out):: za_MolFr(DimZMin:DimZMax, 1:SpcNum)
    
    real(8)             :: DelMolFr
    integer             :: k, s
    

    !-----------------------------------------------------------
    ! ν
    !-----------------------------------------------------------
    do s = 1, SpcNum
      za_MolFr(:,s) = a_MolFrIni(s) 
    end do

    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------
    do k = RegZMin, DimZMax

      za_MolFr(k,:) = za_MolFr(k-1,:)
      
      !------------------------------------------------------------
      !NH4SH ʳβؼʿվ
      !------------------------------------------------------------
      do s = 1, CondNum

        !
        !ΥƥåפǤΥĶ뤳ȤϤʤ
        za_MolFr(k,IdxCG(s)) =                                 &
          & min(                                                &
          &       za_MolFr(k-1,IdxCG(s)),                      &
          &       SvapPress( SpcWetID(IdxCC(s)), z_Temp(k) ) &
          &        * Humidity / z_Press(k)                      &
          &      )
        
      end do

      !------------------------------------------------------------
      !NH4SH ʿվ
      !------------------------------------------------------------
      if ( IdxNH3 /= 0 ) then 
        
        !Ѳ. 
        !Ȥꤢ NH4SH Ф˰ 1.0 Ȥ(ȴ...).
        DelMolFr =                                            &
          & max (                                             &
          &    DelMolFrNH4SH(                                 &
          &      z_Temp(k), z_Press(k),                       &
          &      za_MolFr(k,IdxNH3), za_MolFr(k,IdxH2S), Humidity   &
          &     ),                                            &
          &    0.0d0                                          &
          &  )
        
        za_MolFr(k,IdxNH3) = za_MolFr(k,IdxNH3) - DelMolFr 
        za_MolFr(k,IdxH2S) = za_MolFr(k,IdxH2S) - DelMolFr
      end if
      
    end do
  end subroutine ECCM_MolFr



  subroutine ECCM_DTempDZ( Temp, Press, MolFr, DTempDZ )
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: Temp
    real(8), intent(in) :: Press
!    real(8), intent(inout) :: MolFr(0:SpcNum)    !ʬΨ
    real(8), intent(inout) :: MolFr(1:SpcNum)    !ʬΨ
    real(8), intent(out):: DTempDZ
    real(8)             :: MolFrOrig(1:SpcNum) 
    real(8)             :: ReactHeat
    real(8)             :: Heat(SpcNum)
    real(8)             :: DelMolFr
    real(8)             :: SatPress
    real(8)             :: VapPress
    real(8)             :: Humidity
    real(8)             :: A, B
    integer             :: s

    !
    DTempDZ      = 0.0d0
    ReactHeat    = 0.0d0
    Heat         = 0.0d0
    DelMolFr     = 0.0d0
    SatPress     = 0.0d0
    VapPress     = 0.0d0
    MolFrOrig    = MolFr

    !------------------------------------------------------------
    !NH4SH ʳβؼʿվ
    !------------------------------------------------------------
    do s = 1, CondNum      
      
      !˰¾
      SatPress = SvapPress( SpcWetID(IdxCC(s)), Temp )
      
      !Ǯ. 
      Heat(IdxCG(s)) = LatentHeatPerMol( SpcWetID(IdxCC(s)), Temp )
      
      !ΥʬΨѤƸߤξ׻
      VapPress = MolFr(IdxCG(s)) * Press

      !˰¾ŷ̵ͭ
      if ( VapPress < SatPress ) then         
        !ŷ뤷ƤʤΤǮʤ.
        Heat(IdxCG(s)) = 0.0d0                  
      else      
       !˰¾ȰϤ鸽ߤΥ׻
        MolFr(IdxCG(s)) = max(SatPress / Press, 1.0d-16)        
      end if
    end do
    
    !------------------------------------------------------------
    !NH4SH ʿվ
    !------------------------------------------------------------
    if ( IdxNH3 /= 0 ) then 
      
      Humidity = 1.0d0
      DelMolFr =                                            &
        & max (                                             &
        &    DelMolFrNH4SH(                                 &
        &         Temp, Press, MolFr(IdxNH3), MolFr(IdxH2S),&
        &         Humidity                                  &
        &      ),                                           &
        &    0.0d0                                          &
        &  )
      MolFr(IdxNH3) = MolFr(IdxNH3) - DelMolFr
      MolFr(IdxH2S) = MolFr(IdxH2S) - DelMolFr

      ReactHeat = ReactHeatNH4SHPerMol * DelMolFr
    end if
    
    !------------------------------------------------------------
    !ٸۤ׻
    !------------------------------------------------------------
    !.  Temp(i) ɾ
    A = dot_product( Heat(1:SpcNum), MolFrOrig(1:SpcNum)) &
!    A = dot_product( Heat(1:SpcNum), MolFr(1:SpcNum)) &
      & / ( GasRUniv * Temp )
    B = dot_product(( Heat(1:SpcNum) ** 2.0d0), MolFrOrig(1:SpcNum)) &
!    B = dot_product(( Heat(1:SpcNum) ** 2.0d0), MolFr(1:SpcNum)) &
      & / ( CpDryMol * GasRUniv * ( Temp ** 2.0d0 ) )

    !ǮٸΨ
    DTempDZ = - Grav * MolWtDry * (1.0d0 + A) / (CpDryMol * (1.0d0 + B))  &
      &       + ReactHeat / (CpDryMol * DelZ)
   
  end subroutine ECCM_DTempDZ



  subroutine ECCM_Stab( xz_PotTemp, xz_Exner, xza_MixRt )
!    &                   xz_Stab, xz_StabTemp, xz_StabMolWt )

    use gridset,  only: DimXMin,       &!  X β
      &                 DimXMax,       &!  X ξ 
      &                 DimZMin,       &!  Z β
      &                 DimZMax,       &!  Z ξ 
      &                 SpcNum          !
    use basicset,only:  MolWtDry,      &!
      &                 MolWtWet,      &!
      &                 CpDry,         &!
      &                 Grav,          &!
      &                 xz_ExnerBasicZ,   &!
      &                 xz_PotTempBasicZ, &! 
      &                 xz_EffMolWtBasicZ, &!
      &                 xza_MixRtBasicZ
    use average, only:  xz_avr_xr
    use differentiate_center2, only: xr_dz_xz
    
    implicit none

    real(8), intent(in)  :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(in)  :: xz_Exner(DimXMin:DimXMax,  DimZMin:DimZMax)
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
!    real(8), intent(out) :: xz_Stab(DimXMin:DimXMax,   DimZMin:DimZMax)
!    real(8), intent(out) :: xz_StabTemp(DimXMin:DimXMax, DimZMin:DimZMax)
!    real(8), intent(out) :: xz_StabMolWt(DimXMin:DimXMax, DimZMin:DimZMax)

    real(8)    :: xz_Stab(DimXMin:DimXMax,   DimZMin:DimZMax)
    real(8)    :: xz_StabTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)    :: xz_StabMolWt(DimXMin:DimXMax, DimZMin:DimZMax)

    real(8)    :: xza_MolFrAll(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum)
    real(8)    :: xz_TempAll(DimXMin:DimXMax,  DimZMin:DimZMax)
    real(8)    :: xz_MolWtWet(DimXMin:DimXMax, DimZMin:DimZMax)
    integer    :: i, k, s

    xz_TempAll = (xz_PotTemp + xz_PotTempBasicZ) * (xz_Exner + xz_ExnerBasicZ)
    do s = 1, SpcNum
      xza_MolFrAll(:,:,s) =                             &
        &   (xza_MixRt(:,:,s) + xza_MixRtBasicZ(:,:,s)) &
        &   * MolWtDry / MolWtWet(s) 
    end do
    
    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_MolWtWet(i,k) = dot_product( MolWtWet(1:GasNum), xza_MolFrAll(i,k,1:GasNum) )
      end do
    end do
    
    xz_StabTemp =                                           &
      &         Grav / xz_TempAll                           &
      &           * (   xz_avr_xr( xr_dz_xz( xz_TempAll ) ) &
      &               + Grav * xz_EffMolWtBasicZ / CpDry ) 
    xz_StabMolWt =                                          &
      &       - Grav * xz_avr_xr( xr_dz_xz( xz_MolWtWet ) ) &
      &         / ( MolWtDry * xz_EffMolWtBasicZ )   
    xz_Stab = xz_StabTemp + xz_StabMolWt
!    xz_Stab =                                               &
!      &         Grav / xz_TempAll                           &
!      &           * ( xz_avr_xr( xr_dz_xz( xz_TempAll ) )   &
!      &               + Grav * xz_EffMolWtBasicZ / CpDry )  &
!      &       - Grav * xz_avr_xr( xr_dz_xz( xz_MolWtWet ) ) &
!      &         / ( MolWtDry * xz_EffMolWtBasicZ )   

    call StoreStabTemp( xz_StabTemp ) 
    call StoreStabMolWt( xz_StabMolWt ) 

    where (xz_Stab < 1.0d-7) 
      xz_Stab = 1.0d-7
    end where

  end subroutine ECCM_Stab
  
end module ECCM
