!= Module WarmRainPrm_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: warmrainprm_3d.f90,v 1.1 2008-06-19 16:53:25 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
!   *  (1994) Ѥ꼰򤽤Τޤ. 
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module WarmRainPrm_3d
  !
  !ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
  !   *  (1994) Ѥ꼰򤽤Τޤ. 
  ! 
  
  !⥸塼ɤ߹
  use dc_types,   only : DP
  use dc_iounit,  only : FileOpen
  use dc_message, only : MessageNotify

  use gridset_3d, only : DimXMin,           &!x β
    &                    DimXMax,           &!x ξ
    &                    DimYMin,           &!y ξ
    &                    DimYMax,           &!y ξ
    &                    DimZMin,           &!z β
    &                    DimZMax,           &!z ξ
    &                    SpcNum              !ؼο
  use basicset_3d,only : PressBasis,        &!̤δవ 
    &                    CpDry,             &!ʬǮ
    &                    MolWtWet,          &!
    &                    MolWtDry,          &!
    &                    SpcWetID,          &!
    &                    xyz_DensBasicZ,    &!ܾ̩
    &                    xyz_PotTempBasicZ, &!ܾβ
    &                    xyz_ExnerBasicZ,   &!̵ܾ
    &                    xyz_EffMolWtBasicZ,&!ܾʬ̤δͿ
    &                    xyza_MixRtBasicZ,  &!ܾκ
    &                    GasRDry             !ʬε 
  use moistset, only : CondNum,          &!ŷο
    &                  IdxCG,            &!ŷ()ź
    &                  IdxCC,            &!ŷ()ź
    &                  IdxCR,            &!ŷ()ź
    &                  CloudNum,         &!ο
    &                  RainNum,          &!ο
    &                  IdxC,             &!ź
    &                  IdxR,             &!ź
    &                  IdxNH3,           &!NH3()ź
    &                  IdxH2S,           &!H2S()ź
    &                  IdxNH4SHr          !NH4SH()ź

  use xyz_base_module, only : xyz_avr_xyr
  use xyz_deriv_module,only : xyr_dz_xyz

  use ChemCalc_3d, only : xyz_SvapPress, xyz_LatentHeat, ReactHeatNH4SH
  use MoistFunc_3d,only : xyz_DelMixRtNH4SH
  use StoreMixRt,  only : StoreMixRtRain
  
  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public ˤ
  public WarmRainPrm_Init
  public xyz_Rain2GasHeat
  public xyz_Rain2GasHeatNH4SH
  public xyza_Rain2Gas
  public xyza_Rain2GasNH4SH
  public xyza_Cloud2Rain
  public xyza_FallRain

  real(DP)      :: FactorJ      = 1.0d0 !ʪΥѥ᡼
                                       !Ǥ 3.0d0
                                       !ϵǤ 1.0d0 Ȥ
  real(DP)      :: AutoConvTime = 1.0d3 !ʻĹλ [sec]
  real(DP)      :: MixRt_AutoConvCr = 1.0d-3 
                                       !ʻĹ׳ [kg/kg]

  save FactorJ, AutoConvTime, MixRt_AutoConvCr

contains  

!!!=================================================================================!!!
  subroutine WarmRainPrm_Init( cfgfile )

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile

    !ѿ
    integer                  :: unit    !ֹ

    !-----------------------------------------------------------
    ! NAMELIST 
    !-----------------------------------------------------------
    ! NAMELIST 
    NAMELIST /warmrainprm/                              &
      & FactorJ, AutoConvTime, MixRt_AutoConvCr

    call FileOpen(unit, file=cfgfile, mode='r')
    read(unit, NML=warmrainprm)
    close(unit)

    call MessageNotify( "M", &
      &  "WarmRainPrm_Init", "FactorJ = %f",  d=(/FactorJ/) )
    call MessageNotify( "M", &
      &  "WarmRainPrm_Init", "AutoConvTime = %f",  d=(/AutoConvTime/) )
    call MessageNotify( "M", &
      &  "WarmRainPrm_Init", "MixRt_AutoConvCr = %f",  d=(/MixRt_AutoConvCr/) )
    
  end subroutine WarmRainPrm_Init


!!!=================================================================================!!!  
  function xyza_Rain2Gas(xyz_Exner, xyz_PotTemp, xyza_MixRt, DelTime)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
    ! ξ, FactorJ Ѵ̤®. 
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in) :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !̤ξʬ
    real(DP), intent(in) :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !٤ξʬ 
    real(DP), intent(in) :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(DP)             :: DelTime        !ֹ
    real(DP)             :: xyza_Rain2Gas(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !
    real(DP)             :: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !٤ξʬ + ʿʬ
    real(DP)             :: xyz_PressAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !
    real(DP)             :: xyza_MixRtAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(DP)             :: xyz_NonSaturate(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !̤˰(˰ºȾκκ)
    integer             :: s

    !, , ̤
    !ʬʿʬ­
    xyz_TempAll   = ( xyz_PotTemp + xyz_PotTempBasicZ ) * ( xyz_Exner + xyz_ExnerBasicZ )
    xyz_PressAll  = PressBasis * ((xyz_Exner + xyz_ExnerBasicZ) ** (CpDry / GasRDry))
    xyza_Rain2Gas = 0.0d0
 
    !ͤǤ뤳Ȥݾ
    !ήȻ׻ˤʤ뤳ȤΤ. 
    xyza_MixRtAll = max( 0.0d0, xyza_MixRt + xyza_MixRtBasicZ )
    
    do s = 1, CondNum
          
      !˰¾Ⱥκ(˰)׻. 
      !  ؤѴ̤˰٤㤹.
      xyz_NonSaturate =                                      &
        & max(                                               &
        &   0.0d0,                                           &
        &   xyz_SvapPress(SpcWetID(IdxCC(s)), xyz_TempAll)   &
        &     * MolWtWet(IdxCG(s))                           &
        &     / ( MolWtDry * xyz_PressAll)                   &
        &     - xyza_MixRtAll(:,:,:,IdxCG(s))                &
        &    )
      
      !Ѵ
      !  αγκʾ˾ȯʤ褦˾ͤ
      xyza_Rain2Gas(:,:,:,IdxCR(s)) =                                       &
        & - min(                                                            &
        &    DelTime * 4.85d-2 * FactorJ * xyz_NonSaturate                  &
        &     * ( xyza_MixRtAll(:,:,:,IdxCR(s)) * xyz_DensBasicZ )** 0.65d0,&
        &    xyza_MixRtAll(:,:,:,IdxCR(s))                                  &
        &   ) 
      
      !Ѵ
      !  γѴ̤Ȥ椬դȤʤ
      xyza_Rain2Gas(:,:,:,IdxCG(s)) = - xyza_Rain2Gas(:,:,:,IdxCR(s)) 
    end do
    
  end function xyza_Rain2Gas
  

!!!=================================================================================!!!  
  function xyza_Rain2GasNH4SH(xyz_Exner, xyz_PotTemp, xyza_MixRt, DelTime)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in) :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !̤ξʬ
    real(DP), intent(in) :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !٤ξʬ 
    real(DP), intent(in) :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(DP), intent(in) :: DelTime        !ֹ
    real(DP)             :: xyza_Rain2GasNH4SH(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !
    real(DP)             :: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !٤ξʬ + ʿʬ
    real(DP)             :: xyz_PressAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !Ϥξʬ + ʿʬ
    real(DP)             :: xyza_MixRtAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(DP)             :: xyz_NonSaturate(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !̤˰(˰ºȾκκ)

    !, , ̤
    !ʬʿʬ­
    xyz_TempAll = ( xyz_PotTemp + xyz_PotTempBasicZ ) *  ( xyz_Exner + xyz_ExnerBasicZ )
    xyz_PressAll= PressBasis * ((xyz_Exner + xyz_ExnerBasicZ) ** (CpDry / GasRDry))    
    xyza_Rain2GasNH4SH = 0.0d0

    !ͤǤ뤳Ȥݾ
    !ήȻ׻ˤʤ뤳ȤΤ. 
    xyza_MixRtAll = max( 0.0d0, xyza_MixRt + xyza_MixRtBasicZ )
        
    !˰¾Ⱥκ(˰)׻. 
    !  ؤѴ̤˰٤㤹.
    !  ̤˰٤᤿Τ, ޥʥ򤫤Ƥ
    !  (DelMixRtNH4SH , NH4SH ä, ʤ˰٤ȤƤ)
    xyz_NonSaturate =                      &
      & max(                               &
      &  0.0d0,                            &
      &   - xyz_DelMixRtNH4SH(             &  
      &       xyz_TempAll, xyz_PressAll,   &
      &       xyza_MixRtAll(:,:,:,IdxNH3), &
      &       xyza_MixRtAll(:,:,:,IdxH2S), &
      &       MolWtWet(IdxNH3),            &
      &       MolWtWet(IdxH2S)             &
      &     )                                                         &
      &  )
        
    !Ѵ
    !  αγκʾ˾ȯʤ褦˾ͤ
    xyza_Rain2GasNH4SH(:,:,:,IdxNH4SHr) =                        &
      & - min(                                                   &
      &     DelTime * 4.85d-2 * FactorJ * xyz_NonSaturate        &
      &      * (                                                 &
      &          xyza_MixRtAll(:,:,:,IdxNH4SHr) * xyz_DensBasicZ &
      &         ) ** 0.65d0,                                     &
      &     xyza_MixRtAll(:,:,:,IdxNH4SHr)                       &
      &    ) 
        
    !Ѵ
    !  γѴ̤Ȥ椬դȤʤ
    xyza_Rain2GasNH4SH(:,:,:,IdxNH3) =                           &
      & - xyza_Rain2GasNH4SH(:,:,:,IdxNH4SHr) * MolWtWet(IdxNH3) &
      &   / MolWtWet(IdxNH4SHr)

    xyza_Rain2GasNH4SH(:,:,:,IdxH2S) =                           &
      & - xyza_Rain2GasNH4SH(:,:,:,IdxNH4SHr) * MolWtWet(IdxH2S) &
      &   / MolWtWet(IdxNH4SHr)
    
  end function xyza_Rain2GasNH4SH
    

!!!=================================================================================!!!  
  function xyz_Rain2GasHeatNH4SH(xyz_Exner, xyza_DelMixRt)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in) :: xyza_DelMixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !Ѳ
    real(DP), intent(in) :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !٤ξʬ 
    real(DP)             :: xyz_Rain2GasHeatNH4SH(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !
    real(DP)             :: xyz_ExnerAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    !Ϥ̤
    !ʬʿʬ­
    xyz_ExnerAll    = xyz_Exner + xyz_ExnerBasicZ

    !ؤѲȼȯǮ
    xyz_Rain2GasHeatNH4SH =                                             &
      & ReactHeatNH4SH * xyza_DelMixRt(:,:,:,IdxNH4SHr) * xyz_EffMolWtBasicZ  &
      &  / (xyz_ExnerAll * CpDry)

  end function xyz_Rain2GasHeatNH4SH
  

!!!=================================================================================!!!  
  function xyz_Rain2GasHeat(xyz_PotTemp, xyz_Exner, xyza_DelMixRt)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in) :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !̤ξʬ
    real(DP), intent(in) :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !٤ξʬ 
    real(DP), intent(in) :: xyza_DelMixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !Ѳ
    real(DP)             :: xyz_Rain2GasHeat(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: xyza_LatentHeat(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)             :: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: xyz_ExnerAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    integer             :: s

    !, , ̤
    !ʬʿʬ­
    xyz_ExnerAll = xyz_Exner + xyz_ExnerBasicZ
    xyz_TempAll  = ( xyz_PotTemp + xyz_PotTempBasicZ ) * ( xyz_Exner + xyz_ExnerBasicZ )
    xyza_LatentHeat = 0.0d0
    
    !ؤѲȼȯǮ    
    do s = 1, CondNum
      xyza_LatentHeat(:,:,:,s) =                              &
        & xyz_LatentHeat( SpcWetID(IdxCR(s)), xyz_TempAll )  &
        &  * xyza_DelMixRt(:,:,:,IdxCR(s))                    &
        &  * xyz_EffMolWtBasicZ                             &
        &  / (xyz_ExnerAll * CpDry) 
    end do
    xyz_Rain2GasHeat = sum( xyza_LatentHeat, 3 )

  end function xyz_Rain2GasHeat
  

!!!=================================================================================!!!  
  function xyza_Cloud2Rain( xyza_MixRt, DelTime )
    !
    ! γ鱫γؤѴ̤׻뤿Υ롼
    ! ʻĹ Berry (1968) Υѥ᥿ꥼѤ, 
    ! ͹Ĺ Kessler (1969) Υѥ᥿ꥼѤ. 
    !
    ! Ѵ̤, γȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! γѴʤ褦, αγѴ̤ξ¤ȤƤ.
    ! ͤݾڤ뤿, ȤƻֹߤɬפȤʤ. 
    ! (AutoConv, Collect ϻֹǤʬͤ׻)
    !
    ! Υ롼Ǥ, ŽʪȿʪȤ̤ɬפʤΤ, 
    ! 롼פ󤹲 LoopNum2 ȤƤ. 
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in) :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(DP)             :: DelTime        !ֹ
    real(DP)             :: xyza_Cloud2Rain(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !鱫ؤѴ
    real(DP)             :: xyza_MixRtAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(DP)             :: xyz_AutoConv(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !˰º
    real(DP)             :: xyz_Collect(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                          !ʲ줿Ǯ
!    real(DP), parameter  :: N0 = 5.0d7 
!    real(DP), parameter  :: D0 = 3.66d-1
    integer             :: s


    xyza_Cloud2Rain  = 0.0d0

    !ͤݾ
    !ήȻˤʤ뤳Ȥ⤢Τ. 
    xyza_MixRtAll = max( 0.0d0, xyza_MixRt + xyza_MixRtBasicZ )


    do s = 1, CloudNum
      xyz_AutoConv = 0.0d0
      xyz_Collect  = 0.0d0
      
      !ʻĹ
      !  Kessler (1969) Υѥ᥿ꥼ        
      xyz_AutoConv =                                                 &
        & DelTime / AutoConvTime                                    &
        & * max( 0.0d0, ( xyza_MixRtAll(:,:,:,IdxC(s)) - MixRt_AutoConvCr) )

!      !  Berry (1968) Υѥ᥿ꥼ      
!      xyz_AutoConv =                                           &
!        & DelTime                                              &
!        & * xyz_DensBasicZ                                     &
!        & * ( xyza_MixRtAll(:,:,:,IdxC(s)) ** 3.0d0  ) * 1.0d6 &
!        & / ( 60.0d0                                           &
!        &     * (                                              &
!        &         2.0d0 * xyza_MixRtAll(:,,:,:,IdxC(s))        &
!        &       + 2.66d-8 * N0 / ( xyz_DensBasicZ * D0 )       &
!        &      )                                               &
!        &   )

      !͹Ĺ
      !  Kessler (1969) Υѥ᥿ꥼ    
      xyz_Collect =                                           &
        &  DelTime                                            &
        &  * 2.2d0 * FactorJ * xyza_MixRtAll(:,:,:,IdxC(s))   &
        &  * (                                                &
        &       xyza_MixRtAll(:,:,:,IdxR(s)) * xyz_DensBasicZ &
        &     ) ** 0.875d0  
      
      !Ѵ: ʻĹȹξͤ
      !  Ѳ̤ͤȤꤹ. ͤȤʤ.
      xyza_Cloud2Rain(:,:,:,IdxC(s)) =                       &
        & - min(                                             &
        &         xyza_MixRtAll(:,:,:,IdxC(s)),              &
        &         ( xyz_AutoConv + xyz_Collect )             &
        &       )
      
      !Ѵ. ϱѴ̤Ȥȿ. 
      xyza_Cloud2Rain(:,:,:,IdxR(s)) = - xyza_Cloud2Rain(:,:,:,IdxC(s)) 
          
    end do

!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,:,1)), maxval(xza_Cloud2Rain(:,:,:,1))
!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,:,2)), maxval(xza_Cloud2Rain(:,:,:,2))
!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,:,3)), maxval(xza_Cloud2Rain(:,:,:,3))
    
  end function xyza_Cloud2Rain
  

!!!=================================================================================!!!
  function xyza_FallRain( xyza_MixRt )
    !
    ! γˤή. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum) 
                                                 !()
    real(DP)  :: xyza_MixRtAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                                 !( + ʿѾ)
    real(DP)  :: xyza_FallRain(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                                 !γ
    real(DP)  :: xyz_VelZRain(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                 !γ®
    integer  :: s

    xyza_MixRtAll = max( 0.0d0, xyza_MixRt + xyza_MixRtBasicZ )
    xyza_FallRain = 0.0d0
    xyz_VelZRain = 0.0d0
    
    !ˤή
    !  Dens  avr äƤ, 䤬Τ
    do s = 1, RainNum
      !γü®
      xyz_VelZRain = 12.2d0 * FactorJ * ( xyza_MixRtAll(:,:,:,IdxR(s)) ** 0.125d0 )
      
      xyza_FallRain(:,:,:,IdxR(s)) =                   &
        &  xyz_avr_xyr(                                &
        &     xyr_dz_xyz(xyz_DensBasicZ                &
        &               * xyz_VelZRain                 &
        &               * xyza_MixRtAll(:,:,:,IdxR(s)) &
        &              )                               &
        &      ) / xyz_DensBasicZ                      
    end do
    
    call StoreMixRtRain( xyza_FallRain )
    
  end function xyza_FallRain
  
  
end module WarmRainPrm_3d
