!= Module Radiation_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: radiation_3d.f90,v 1.2 2007-10-01 08:57:59 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ǥͲ׻뤿Υѥå⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * 
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module Radiation_3d
  !
  !ǥͲ׻뤿Υѥå⥸塼
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * 
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify
  use dc_iounit,  only: FileOpen

  use GridSet_3d,  only: DimXMin,     & !x β
    &                 DimXMax,     & !x ξ
    &                 DimYMin,     & !y β
    &                 DimYMax,     & !y ξ
    &                 DimZMin,     & !z β
    &                 DimZMax,     & !z ξ
    &                 z_Z            !Z ɸ(顼ʻ)
  use TimeSet,  only: DayTime        ! 1 Ĺ [s]
  use basicset_3d, only: xyz_ExnerBasicZ !ʡؿδܾ
  use StorePotTemp_3d,  only: StorePotTempRad, StorePotTempDamp
  
  !ۤηػ
  implicit none

  !private °
  private

  !ؿ public ˤ. 
  public Radiation_init
  public xyz_RadHeatConst
  public xyz_NewtonCool

  !ѿ
  real(8)              :: RadHeatRate  = 0.0d0 !ͲǮΨ [K/day]
  real(8), allocatable :: xyz_RadHeight(:,:,:)    !ͲǮ¸ߤΰ
  
  !save °
  save RadHeatRate, xyz_RadHeight

contains

!!!------------------------------------------------------------------------!!!
  subroutine Radiation_init(cfgfile)
    !
    !NAMELIST Ͷ
    !

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile
    real(8)                  :: RadHeightUp   !ͶͿľΰξ
    real(8)                  :: RadHeightDown !ͶͿľΰβ
    integer                  :: k             !롼ѿ
    integer                  :: unit            !ֹ

    ! NAMELIST 
    NAMELIST /radiation/ RadHeatRate, RadHeightUp, RadHeightDown

    call FileOpen(unit, file=cfgfile, mode='r')
    read(unit, NML=radiation)
    close(unit)


    allocate( xyz_RadHeight(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) )

    ! Ͷ¸ߤΰ
    ! RadHeightDown < s_Z < RadHeightUp ϰϤǤͤ 1 Ȥʤ
    ! Ѱդ.
    !
    xyz_RadHeight = 1.0d0    

    do k = DimZMin, DimZMax
      if ( z_Z(k) <= RadHeightDown  ) then
        xyz_RadHeight(:,:,k) = 0.0d0 
      elseif( z_Z(k) >= RadHeightUp ) then
        xyz_RadHeight(:,:,k) = 0.0d0 
      end if
    end do

    call MessageNotify( "M", &
      & "Radiation", "RadHeatRate = %f", d=(/RadHeatRate/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeightUp = %f", d=(/RadHeightUP/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeightDown= %f", d=(/RadHeightDown/))
    
  end subroutine Radiation_init


!!!------------------------------------------------------------------------!!!
  function xyz_RadHeatConst(xyz_Exner)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǰѤͿ. 
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                       !ʡؿξ
    real(8)               :: xyz_RadHeatConst(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                       !Ͷ

    xyz_RadHeatConst = &
      & xyz_RadHeight * RadHeatRate  &
      & / ( ( xyz_ExnerBasicZ + xyz_Exner ) * DayTime )

    call StorePotTempRad( xyz_RadHeatConst )
    
  end function xyz_RadHeatConst
  
  
  
!!!------------------------------------------------------------------------!!!
  function xyz_NewtonCool(xyz_PotTemp)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǰѤͿ. 
    !
    ! = Х
    ! 
    ! 嵭λ̤߷פƤʤ. ׸Ƥ. 
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                       !̤ξ
    real(8)               :: xyz_NewtonCool(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                       !Ͷ
    real(8)               :: xyz_PotTempMean(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                       !̾ʿ
    real(8)               :: EFTime    !ʹ»
    integer               :: k

    !ʹ»֤ 5 
    EFTime = 5.0d0 * DayTime  
    
    do k = DimZMin, DimZMax
      xyz_PotTempMean(:,:,k) = &
        & sum( xyz_PotTemp(:,:,k) ) / &
        & (real(DimXMax - DimXMin + 1) * real(DimYMax - DimYMin + 1) )
    end do
    
    xyz_NewtonCool = - (xyz_PotTemp - xyz_PotTempMean) / EFTime 
    
    call StorePotTempDamp( xyz_NewtonCool )

  end function xyz_NewtonCool
  
end module Radiation_3d
