!= Module BasicSet
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: basicset_3d.f90,v 1.4 2008-06-19 16:52:09 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ǥեȤδܾꤹ뤿ѿȷ⥸塼
! * BasicEnvFile_init: ܾͤ netCDF ե뤫
! * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module BasicSet_3d
  !
  !ǥեȤδܾꤹ뤿ѿȷ⥸塼
  !, hogeBasicZ Ȥʤ, ͤϤ뤳Ȥ
  !Ԥ. 
  !

  !⥸塼ɤ߹
  use dc_types,   only: DP
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify   !å
  
  use ChemData,   only: GasRUniv,             &!׵
    &                   ChemData_OneSpcID,    &!ؼ ID
    &                   ChemData_CpPerMolRef, &!ɸ֤ǤǮ
    &                   ChemData_MolWt         !ʬ
  use gridset_3d, only: DimXMin,       &!  X β
    &                   DimXMax,       &!  X ξ
    &                   DimYMin,       &!  Z β
    &                   DimYMax,       &!  Z ξ
    &                   DimZMin,       &!  Z β
    &                   DimZMax,       &!  Z ξ
    &                   SpcNum          ! ؼο

  !ۤηػ
  implicit none

  !save °
  save

  !Public Interface
  real(DP)               :: Grav                  ! [m/s^2]
  real(DP)               :: TempSfc               !ɽ̲ [K]
  real(DP)               :: PressSfc              !ɽ̰ [Pa]
  real(DP)               :: PressBasis            !̤δవ [Pa]
  real(DP)               :: CpDry                 !ʬ갵Ǯ [J/K kg]
  real(DP)               :: CpDryMol              !ʬ갵Ǯ [J/K kg]
  real(DP)               :: CvDry                 !ʬǮ [J/K kg]
  real(DP)               :: MolWtDry              !ʬʬ   [kg/mol]
  real(DP)               :: GasRDry               !ʬε [J/K kg]
  integer, allocatable   :: SpcWetID(:)           !ʬβؼID
  real(DP), allocatable  :: MolWtWet(:)           !ʬʬ  
  real(DP), allocatable  :: xyz_DensBasicZ(:,:,:)  !̩
  real(DP), allocatable  :: xyz_PressBasicZ(:,:,:) !̵
  real(DP), allocatable  :: xyz_ExnerBasicZ(:,:,:) !̵
  real(DP), allocatable  :: xyz_TempBasicZ(:,:,:)  !
  real(DP), allocatable  :: xyz_PotTempBasicZ(:,:,:) !
  real(DP), allocatable  :: xyz_VelSoundBasicZ(:,:,:)!®
  real(DP), allocatable  :: xyza_MixRtBasicZ(:,:,:,:)!Žʬ
  real(DP), allocatable  :: xyz_EffMolWtBasicZ(:,:,:)!ʬ̸
  real(DP)               :: SpcWetMolFr(10)       !ʬβؼ¸
  character(20)          :: SpcWetSymbol(10)      !ʬβؼ̾
  real(DP)               :: Tropopause            !ή̹
  real(DP)               :: Humidity              !м 
  character(20)          :: EnvType               !ܾβ, 'Dry' or 'Moist'   
  real(DP)               :: TempStrat             !طβ [k]
  real(DP)               :: Dhight                !ŤߴؿΥѥ᡼ [m]


contains

!!!-----------------------------------------------------------------!!!
  subroutine BasicSetArray_Init(                         &
    & xyz_Press, xyz_Exner, xyz_Temp, xyz_PotTemp, xyz_Dens, xyz_VelSound, &
    & xyza_MixRt, xyz_EffMolWt &
    & )

    !
    !ܾͤ. 
    !
    
    !ѿ
    real(DP), intent(in) :: xyz_Press &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_Exner &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_Temp &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_PotTemp &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_Dens &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_VelSound &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyza_MixRt &
      &             (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
    real(DP), intent(in) :: xyz_EffMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
   
    !---------------------------------------------------------------
    ! *BasicZ ν
    !---------------------------------------------------------------
    !γ
    allocate( & 
      & xyz_DensBasicZ    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_PressBasicZ   (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_ExnerBasicZ   (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_TempBasicZ    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_PotTempBasicZ (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_VelSoundBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyza_MixRtBasicZ  (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum), &
      & xyz_EffMolWtBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  &
      & )
    
    !ͤ
    xyz_PressBasicZ    = xyz_Press
    xyz_ExnerBasicZ    = xyz_Exner
    xyz_TempBasicZ     = xyz_Temp
    xyz_PotTempBasicZ  = xyz_PotTemp
    xyz_DensBasicZ     = xyz_Dens
    xyz_VelSoundBasicZ = xyz_VelSound
    xyza_MixRtBasicZ   = xyza_MixRt
    xyz_EffMolWtBasicZ = xyz_EffMolWt

  end subroutine BasicSetArray_Init

!!!-----------------------------------------------------------------!!!
  subroutine BasicSet_Init(cfgfile)
    !
    !ܾξ Namelist ͤ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ
    character(*), intent(in) :: cfgfile         !NAMELIST ե
!    real(DP)                 :: Tropopause      !ή̹
!    real(DP)                 :: CpDryMol        !ʬ갵Ǯ [J/K mol]
    integer                  :: SpcDryNum       !ʬβؼο
    integer                  :: SpcWetNum       !ʬβؼο
    character(20)            :: SpcDrySymbol(5)!ʬβؼ̾
!    character(15)            :: SpcWetSymbol(10)!ʬβؼ̾
    real(DP)                 :: SpcDryMolFr(5) !ʬβؼ¸
!    real(DP)                 :: SpcWetMolFr(10) !ʬβؼ¸
    integer, allocatable     :: SpcDryID(:)     !ʬβؼID
!    real(DP)                 :: Humidity        !м
!    character(20)            :: EnvType         !ܾβ, 'Dry' or 'Moist'
    real(DP), allocatable    :: PropertyDry(:)  !
    character(20), allocatable:: Symbol(:)       !
    integer                  :: s, n1, n2, n3   !ѿ
    integer                  :: unit            !ֹ

    !NAMELIST 
    NAMELIST /basicset/ &
      & Grav, TempSfc, PressSfc,   PressBasis, Tropopause,  & 
      & SpcDrySymbol, SpcDryMolFr,                          &
      & SpcWetSymbol, SpcWetMolFr,                          &
      & EnvType, Humidity, TempStrat, Dhight

    SpcDrySymbol = '' 
    SpcDryMolFr  = 0.0d0
    SpcWetSymbol = '' 
    SpcWetMolFr  = 0.0d0
    
    !ե륪ץ. . 
    call FileOpen(unit, file=cfgfile, mode='r')
    read(unit, NML=basicset)
    close(unit)

    !----------------------------------------------------------
    ! ʬʪͤν
    !----------------------------------------------------------
    !ʬθĿ
    SpcDryNum = count(SpcDrySymbol /= "")
    
    !ؼ ID     
    allocate(SpcDryID(SpcDryNum))    
    do s = 1, SpcDryNum
      SpcDryID(s) = ChemData_OneSpcID( SpcDrySymbol(s) )
    end do

    !ν
    allocate(PropertyDry(SpcDryNum))

    !ʬ
    do s = 1, SpcDryNum
      PropertyDry(s) = ChemData_MolWt(SpcDryID(s))
    end do
    MolWtDry = dot_product(PropertyDry, SpcDryMolFr(1:SpcDryNum)) 
    
    !갵Ǯ()
    do s = 1, SpcDryNum    
      PropertyDry(s) = ChemData_CpPerMolRef(SpcDryID(s))
    end do
    CpDryMol = dot_product(PropertyDry, SpcDryMolFr(1:SpcDryNum)) 
    
    !갵Ǯ
    CpDry    = CpDryMol / MolWtDry
    
    !
    GasRDry = GasRUniv / MolWtDry
    
    !Ǯ
    CvDry    = CpDry - GasRDry
    
    
    !----------------------------------------------------------
    ! ʬ ID 
    !----------------------------------------------------------
    !ʬθĿ
    SpcWetNum = count(SpcWetSymbol /= "")
    if (SpcWetNum /= SpcNum) then 
      call MessageNotify( "E", &
        &  "basicset: ", "SpcWetNum is not equal to SpcNum." )
!      write(*,*) "SpcWetNum /= SpcNum"
!      stop
    end if
    
    !γ
    allocate(SpcWetID(SpcWetNum), Symbol(SpcWetNum), MolWtWet(SpcWetNum))

    !SpcWetSymbol ʸ󤫤, -Rain, -Cloud Τ Symbol Ȥݴ
    do s = 1, SpcWetNum
      n1 = index(SpcWetSymbol(s), '-Cloud' )
      n2 = index(SpcWetSymbol(s), '-Rain' )
      n3 = max(n1, n2)
      if (n3 == 0) then
        Symbol(s) = SpcWetSymbol(s)
      else
        Symbol(s) = SpcWetSymbol(s)(1:n3-1)
      end if
    end do
    
    !ؼ ID 
    do s =1, SpcWetNum
      SpcWetID(s) = ChemData_OneSpcID( Symbol(s) )
    end do
    
    !ʬ̤ݴ
    do s = 1, SpcWetNum
      MolWtWet(s) = ChemData_MolWt(SpcWetID(s))
    end do
    

    !----------------------------------------------------------
    ! ǧ
    !----------------------------------------------------------
    call MessageNotify( "M", &
      & "basicset_init", "Grav = %f",     d=(/Grav/) )
    call MessageNotify( "M", &
      & "basicset_init", "TempSfc = %f",  d=(/TempSfc/) )
    call MessageNotify( "M", &
      & "basicset_init", "PressSfc = %f", d=(/PressSfc/) )
    call MessageNotify( "M", &
      & "basicset_init", "PressBasis = %f", d=(/PressBasis/))

    do s = 1, SpcDryNum
      call MessageNotify( "M", &
        &  "basicset_init", "SpcDryID = %d",      i=(/SpcDryID(s)/))
      call MessageNotify( "M", &
        &  "basicset_init", "SpcDrySymbol = %c", c1=trim(SpcDrySymbol(s)))
      call MessageNotify( "M", &
        &  "basicset_init", "SpcDryMolFr = %f",   d=(/SpcDryMolFr(s)/))
    end do

    call MessageNotify( "M", "basicset_init", "CpDry = %f",    d=(/CpDry/) )
    call MessageNotify( "M", "basicset_init", "CpDryMol = %f", d=(/CpDryMol/) )
    call MessageNotify( "M", "basicset_init", "CvDry = %f",    d=(/CvDry/) )
    call MessageNotify( "M", "basicset_init", "GasRDry = %f",  d=(/GasRDry/) )
    call MessageNotify( "M", "basicset_init", "MolWtDry = %f", d=(/MolWtDry/) )

    do s = 1, SpcWetNum
      call MessageNotify( "M", &
        & "basicset_init", "SpcWetID = %d",     i=(/SpcWetID(s)/) )
      call MessageNotify( "M", &
        & "basicset_init", "SpcWetSymbol = %c", c1=trim(SpcWetSymbol(s)) )
      call MessageNotify( "M", &
        & "basicset_init", "SpcWetMolFr = %f",  d=(/SpcWetMolFr(s)/) )
      call MessageNotify( "M", &
        & "basicset_init", "MolWtWet = %f",     d=(/MolWtWet(s)/) )
    end do

    call MessageNotify( "M", &
      & "basicset_init", "Tropopause = %f ", d=(/Tropopause/) )
    call MessageNotify( "M", &
      & "basicset_init", "EnvType = %c", c1=trim(EnvType) )
    call MessageNotify( "M", & 
      & "basicset_init", "Humidity = %f", d=(/Humidity/)  )

  end subroutine BasicSet_Init

end module BasicSet_3d
