!= Module StoreMixRt_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: storemixrt_3d.f90,v 1.1 2008-06-19 16:47:53 odakker Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!˴ؤѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module StoreMixRt_3d
  !
  !ѻͤݴɤ뤿ѿ⥸塼.
  !
  use dc_types,  only : DP
  use dc_message,only : MessageNotify

  !⥸塼ɤ߹
  use gridset_3d, only:DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimYMin,     & ! y β
    &                  DimYMax,     & ! y ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  SpcNum,      & ! number of species
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax,     & ! x ʪΰξ
    &                  RegYMin,     & ! x ʪΰβ
    &                  RegYMax        ! x ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public StoreMixRt_Init, StoreMixRtMeanXY, StoreMixRtClean
  public za_Adv,  za_Turb,  za_Diff, za_Flux, za_Rain, &
    &    za_Cond, za_Fill1, za_Fill2
  public StoreMixRtAdv, StoreMixRtTurb, StoreMixRtDiff, StoreMixRtFlux, StoreMixRtRain, &
    &    StoreMixRtCond, StoreMixRtFill1, StoreMixRtFill2

  !ѿ
  real(DP), allocatable :: za_Adv(:,:)
  real(DP), allocatable :: za_Turb(:,:)
  real(DP), allocatable :: za_Diff(:,:)
  real(DP), allocatable :: za_Flux(:,:)
  real(DP), allocatable :: za_Rain(:,:)
  real(DP), allocatable :: za_Fill1(:,:)
  real(DP), allocatable :: za_Fill2(:,:)
  real(DP), allocatable :: za_Cond(:,:)
!  real(DP), allocatable :: za_Asln(:,:)
  real(DP), allocatable :: xyza_Adv (:,:,:,:)
  real(DP), allocatable :: xyza_Turb(:,:,:,:)
  real(DP), allocatable :: xyza_Diff(:,:,:,:)
  real(DP), allocatable :: xyza_Flux(:,:,:,:)
  real(DP), allocatable :: xyza_Rain(:,:,:,:)
  real(DP), allocatable :: xyza_Fill1(:,:,:,:)
  real(DP), allocatable :: xyza_Fill2(:,:,:,:)
  real(DP), allocatable :: xyza_Cond(:,:,:,:)
!  real(DP), allocatable :: xyza_Asln(:,:,:,:)
!  real(DP)              :: CalNum

  save xyza_Adv,  xyza_Turb,  xyza_Diff, xyza_Flux, xyza_Rain, &
    &  xyza_Cond, xyza_Fill1, xyza_Fill2
  save za_Adv,  za_Turb,  za_Diff, za_Flux, za_Rain, &
    &  za_Cond, za_Fill1, za_Fill2
  
contains

  subroutine StoreMixRt_Init( )
    !롼

    allocate(     &
      & za_Adv  (DimZMin:DimZMax, SpcNum),   & 
      & za_Turb (DimZMin:DimZMax, SpcNum),  &
      & za_Diff (DimZMin:DimZMax, SpcNum),  &
      & za_Flux (DimZMin:DimZMax, SpcNum),  &
      & za_Rain (DimZMin:DimZMax, SpcNum),  &
      & za_Fill1(DimZMin:DimZMax, SpcNum), &
      & za_Fill2(DimZMin:DimZMax, SpcNum), &
!      & za_Asln (DimZMin:DimZMax, SpcNum), &
      & za_Cond (DimZMin:DimZMax, SpcNum), &
      & xyza_Adv  (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), & 
      & xyza_Turb (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), &
      & xyza_Diff (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), &
      & xyza_Flux (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), &
      & xyza_Rain (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), &
      & xyza_Fill1(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), &
      & xyza_Fill2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), &
!      & xyza_Asln(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), &
      & xyza_Cond(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum) &
      &  )
    
    call StoreMixRtClean()

  end subroutine StoreMixRt_Init


  subroutine StoreMixRtClean( )
    !ݴɤͤΥꥢ
    
    za_Adv  = 0.0d0
    za_Turb = 0.0d0
    za_Diff = 0.0d0
    za_Flux = 0.0d0
    za_Rain = 0.0d0
    za_Fill1 = 0.0d0
    za_Fill2 = 0.0d0
    za_Cond = 0.0d0
!    za_Asln = 0.0d0

    xyza_Adv  = 0.0d0
    xyza_Turb = 0.0d0
    xyza_Diff = 0.0d0
    xyza_Flux = 0.0d0
    xyza_Rain = 0.0d0
    xyza_Fill1 = 0.0d0
    xyza_Fill2 = 0.0d0
    xyza_Cond = 0.0d0
!    xyza_Asln = 0.0d0

!    CalNum  = 1.0d-40   !ػ
  end subroutine StoreMixRtClean


  subroutine StoreMixRtMeanXY( )
    !ݴɤͤοʿʿ
 
    real(DP) :: CalNum

    CalNum = TimeDisp / DelTimeLong
   
    za_Adv   = aa_MeanXY_aaaa( xyza_Adv )   / CalNum
    za_Turb  = aa_MeanXY_aaaa( xyza_Turb )  / CalNum
    za_Diff  = aa_MeanXY_aaaa( xyza_Diff )  / CalNum
    za_Flux  = aa_MeanXY_aaaa( xyza_Flux )  / CalNum
    za_Rain  = aa_MeanXY_aaaa( xyza_Rain )  / CalNum
    za_Fill1 = aa_MeanXY_aaaa( xyza_Fill1 ) / CalNum
    za_Fill2 = aa_MeanXY_aaaa( xyza_Fill2 ) / CalNum
    za_Cond  = aa_MeanXY_aaaa( xyza_Cond )  / CalNum
!    za_Asln  = aa_MeanXY_aaaa( xyza_Asln )  / CalNum

  end subroutine StoreMixRtMeanXY


  subroutine StoreMixRtAdv( Work )
    !ήݴ

    implicit none

    real(DP), intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)              :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    Work2  = xyza_Adv + Work
    xyza_Adv = Work2

!    CalNum = CalNum + 1

  end subroutine StoreMixRtAdv


  subroutine StoreMixRtTurb( Work )
    !ήݴ

    implicit none

    real(DP), intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)              :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    Work2   = xyza_Turb + Work
    xyza_Turb = Work2

  end subroutine StoreMixRtTurb


  subroutine StoreMixRtDiff( Work )
    !ͳȻݴ

    implicit none
    
    real(DP), intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)              :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    Work2   = xyza_Diff + Work
    xyza_Diff = Work2

  end subroutine StoreMixRtDiff


  subroutine StoreMixRtRain( Work )
    !߱νȼѲ

    implicit none
    
    real(DP), intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)              :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    Work2   = xyza_Rain + Work
    xyza_Rain = Work2

  end subroutine StoreMixRtRain


  subroutine StoreMixRtFlux( Work )
    !ɽ̥եåˤѲ

    implicit none
    
    real(DP), intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)              :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    Work2  = xyza_Flux + Work
    xyza_Flux = Work2

  end subroutine StoreMixRtFlux


  subroutine StoreMixRtCond( Work )
    !ŷȼѲ

    implicit none
    
    real(DP), intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)              :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    Work2   = xyza_Cond + Work
    xyza_Cond = Work2

  end subroutine StoreMixRtCond


!  subroutine StoreMixRtAsln( Work )
!    !å֥ե륿ȼѲ̤ݴ
!
!    implicit none
!    
!    real(DP), intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
!    real(DP)              :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
!
!    Work2   = xyza_Asln + Work
!    xyza_Asln = Work2
!
!  end subroutine StoreMixRtAsln


  subroutine StoreMixRtFill1( Work1 )
    !ץˤѲ

    implicit none
    
    real(DP), intent(in)  :: Work1(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)              :: WorkA(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    WorkA     = Work1 + xyza_Fill1
    xyza_Fill1 = WorkA

  end subroutine StoreMixRtFill1


  subroutine StoreMixRtFill2( Work1 )
    !ץ(2)ˤѲ

    implicit none
    
    real(DP), intent(in)  :: Work1(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP)              :: WorkA(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    WorkA      = Work1 + xyza_Fill2
    xyza_Fill2  = WorkA

  end subroutine StoreMixRtFill2


  function aa_MeanXY_aaaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                     !ʿѱ黻оݤȤʤѿ
    real(DP)              :: aa_MeanXY_aaaa(DimZMin:DimZMax, SpcNum)
                                     !ʿʿ
    real(DP)              :: aaa_work(DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                     !X ʿ

    aaa_work = aaa_MeanX_aaaa(var) 

    aa_MeanXY_aaaa = sum( aaa_work(RegYMin+1:RegYMax,:,:), 1 ) &
      &           / real(RegYMax - RegYMin, 8) 
    
  end function aa_MeanXY_aaaa
  
  function aaa_MeanX_aaaa( var ) 
    !
    ! X ʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
                                     !ʿѱ黻оݤȤʤѿ
    real(DP)             :: aaa_MeanX_aaaa(DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
                                     !X ʿ

    aaa_MeanX_aaaa = sum( var(RegXMin:RegXMax, :, :, :), 1 ) &
      &           / real(RegXMax - RegXMin + 1 , 8) 

  end function aaa_MeanX_aaaa
  
end module StoreMixRt_3d
