!= Module StorePotTemp
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: storepottemp.f90,v 1.2 2007-10-01 08:59:22 odakker Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!̤˴ؤѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module StorePotTemp
  !
  !̤˴ؤѻͤݴɤ뤿ѿ⥸塼.
  !

  !⥸塼ɤ߹
  use gridset, only:   DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  SpcNum,      & ! number of species
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax        ! x ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public StorePotTemp_Init, StorePotTempMeanX, StorePotTempClean
  public z_Adv,  z_Turb, z_Disp, z_Diff, z_Rad, &
    &    z_Cond, z_Flux, z_Damp
  public StorePotTempAdv,  StorePotTempTurb, StorePotTempDisp, StorePotTempDiff, StorePotTempRad, &
    &    StorePotTempCond, StorePotTempFlux, StorePotTempDamp

  !ѿ
  real(8), allocatable :: z_Adv(:)
  real(8), allocatable :: z_Turb(:)
  real(8), allocatable :: z_Disp(:)
  real(8), allocatable :: z_Diff(:)
  real(8), allocatable :: z_Rad(:)
  real(8), allocatable :: z_Damp(:)
  real(8), allocatable :: z_Cond(:)
  real(8), allocatable :: z_Flux(:)
  real(8), allocatable :: xz_Adv(:,:)
  real(8), allocatable :: xz_Turb(:,:)
  real(8), allocatable :: xz_Disp(:,:)
  real(8), allocatable :: xz_Diff(:,:)
  real(8), allocatable :: xz_Rad(:,:)
  real(8), allocatable :: xz_Damp(:,:)
  real(8), allocatable :: xz_Cond(:,:)
  real(8), allocatable :: xz_Flux(:,:)

  !save °
  save xz_Adv,  xz_Turb, xz_Disp, xz_Diff, xz_Rad, &
    &  xz_Cond, xz_Flux, xz_Damp
  save z_Adv,  z_Turb, z_Disp, z_Diff, z_Rad, &
    &  z_Cond, z_Flux, z_Damp

contains

  subroutine StorePotTemp_Init( )
    !롼

    allocate(     &
      & z_Adv(DimZMin:DimZMax),  & 
      & z_Turb(DimZMin:DimZMax), &
      & z_Disp(DimZMin:DimZMax), &
      & z_Diff(DimZMin:DimZMax), &
      & z_Rad(DimZMin:DimZMax),  &
      & z_Damp(DimZMin:DimZMax), &
      & z_Cond(DimZMin:DimZMax), &
      & z_Flux(DimZMin:DimZMax), &
      & xz_Adv(DimXMin:DimXMax, DimZMin:DimZMax),  & 
      & xz_Turb(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Disp(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Diff(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Rad(DimXMin:DimXMax, DimZMin:DimZMax),  &
      & xz_Damp(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Cond(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Flux(DimXMin:DimXMax, DimZMin:DimZMax)  &
      &  )

    call StorePotTempClean

  end subroutine StorePotTemp_Init


  subroutine StorePotTempClean( )
    !ݴɤͤΥꥢ
    
    z_Adv  = 0.0d0
    z_Turb = 0.0d0
    z_Diff = 0.0d0
    z_Disp = 0.0d0
    z_Rad  = 0.0d0
    z_Damp = 0.0d0
    z_Cond = 0.0d0
    z_Flux = 0.0d0

    xz_Adv  = 0.0d0
    xz_Turb = 0.0d0
    xz_Diff = 0.0d0
    xz_Disp = 0.0d0
    xz_Rad  = 0.0d0
    xz_Damp = 0.0d0
    xz_Cond = 0.0d0
    xz_Flux = 0.0d0
   
!    CalNum  = 1.0d-40    !ػ. 
  end subroutine StorePotTempClean


  subroutine StorePotTempMeanX( )
    !ݴɤͤοʿʿ [K/s]
    real(8) :: CalNum

    CalNum = TimeDisp / DelTimeLong 
    
    z_Adv  = a_MeanX_aa( xz_Adv )   / CalNum
    z_Turb = a_MeanX_aa( xz_Turb )  / CalNum
    z_Diff = a_MeanX_aa( xz_Diff )  / CalNum
    z_Disp = a_MeanX_aa( xz_Disp )  / CalNum
    z_Rad  = a_MeanX_aa( xz_Rad  )  / CalNum
    z_Damp = a_MeanX_aa( xz_Damp )  / CalNum
    z_Cond = a_MeanX_aa( xz_Cond )  / CalNum
    z_Flux = a_MeanX_aa( xz_Flux )  / CalNum

  end subroutine StorePotTempMeanX


  subroutine StorePotTempAdv( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2  = xz_Adv + Work
    xz_Adv = Work2

  end subroutine StorePotTempAdv


  subroutine StorePotTempTurb( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Turb + Work
    xz_Turb = Work2

  end subroutine StorePotTempTurb


  subroutine StorePotTempDiff( Work )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Diff + Work
    xz_Diff = Work2

  end subroutine StorePotTempDiff


  subroutine StorePotTempDisp( Work )
    !Ǯݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Disp + Work
    xz_Disp = Work2

  end subroutine StorePotTempDisp


  subroutine StorePotTempRad( Work )
    !ѹݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2  = xz_Rad + Work
    xz_Rad = Work2

  end subroutine StorePotTempRad


  subroutine StorePotTempDamp( Work )
    !ԥ󥰹ݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Damp + Work
    xz_Damp = Work2

  end subroutine StorePotTempDamp


  subroutine StorePotTempCond( Work )
    !ǮȯǮݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Cond + Work
    xz_Cond = Work2

  end subroutine StorePotTempCond


  subroutine StorePotTempFlux( Work )
    !ɽ̥եåݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Flux + Work
    xz_Flux = Work2

  end subroutine StorePotTempFlux


  function a_MeanX_aa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: a_MeanX_aa(DimZMin:DimZMax)
                                     !ʿʿ

    a_MeanX_aa = sum( var(RegXMin+1:RegXMax, :), 1 ) &
      &           / real(RegXMax - RegXMin, 8) 

  end function a_MeanX_aa
  

end module StorePotTemp
