!= Module Damping_3D
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: damping_3d.f90,v 1.1 2007-08-03 06:56:39 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ΨȤη׻ԤΥѥå⥸塼
!  * ȸη
!  * ݥؤ(նȤȿͤޤۼ뤿)
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!  * δؿ, ܾ줬ѿ(®, ʡؿξ)
!    ŬѤ뤳ȤꤷƤ. 
!  * ƳʻФؿɬפ
!
!== Future Plans
!
!

module Damping_3d
  !
  !ΨȤη׻ԤΥѥå⥸塼
  !  * ȸη
  !  * ݥؤ(նȤȿͤޤۼ뤿)
  ! 

  !⥸塼ɤ߹
  use dc_types,   only : DP
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify

  use gridset_3d,only: DimXMin,       &! x β
    &                DimXMax,       &! x ξ
    &                DimYMin,       &! y β
    &                DimYMax,       &! y ξ
    &                DimZMin,       &! z β
    &                DimZMax,       &! z ξ
    &                RegXMin,       &! x ʪΰβ
    &                RegXMax,       &! x ʪΰξ
    &                RegYMin,       &! y ʪΰβ
    &                RegYMax,       &! y ʪΰξ
    &                RegZMin,       &! z ʪΰβ
    &                RegZMax,       &! z ʪΰξ
    &                x_X,           &!X ɸ(顼ʻ)
    &                y_Y,           &!Y ɸ(顼ʻ)
    &                z_Z,           &!Z ɸ(顼ʻ)
    &                p_X,           &!X ɸ(եåʻ)
    &                q_Y,           &!Y ɸ(եåʻ)
    &                r_Z,           &!Z ɸ(եåʻ)
    &                x_dx, y_dy, z_dz, &! ʻҴֳ
    &                XMax,          &!X ɸκ
    &                YMax,          &!Y ɸκ
    &                ZMax            !Z ɸκ
  use timeset, only: DelTimeShort  !û֥ƥå
  
  !ۤηػ
  implicit none

  !private °
  private 
  
  !ؿˤ public °
  public Damping_Init
  public DampSound_Init
  public DampSponge_Init
  public xyz_DampSponge_xyz
  public xyr_DampSponge_xyr
  public pyz_DampSponge_pyz
  public xqz_DampSponge_xqz
  public xyz_DampSponge
  public xyr_DampSponge
  public pyz_DampSponge
  public xqz_DampSponge
  public DampSound

  !ѿ
  real(DP)  :: DampSound  = 0.0d0   !ȸθ그

  real(DP)  :: EFTime     = 100.0d0 !ݥؤ e-folding time
  real(DP)  :: DampDepthH = 0.0d0   !ݥؤθ(ʿ)
  real(DP)  :: DampDepthV = 0.0d0   !ݥؤθ(ľ)
  real(DP), allocatable    :: xyz_DampRateH(:,:,:) !xyz ʻҸ그(ʿ)
  real(DP), allocatable    :: xyz_DampRateV(:,:,:) !xyz ʻҸ그(ľ)
  real(DP), allocatable    :: pyz_DampRateH(:,:,:) !pyz ʻҸ그(ʿ)
  real(DP), allocatable    :: pyz_DampRateV(:,:,:) !pyz ʻҸ그(ľ)
  real(DP), allocatable    :: xqz_DampRateH(:,:,:) !xqz ʻҸ그(ʿ)
  real(DP), allocatable    :: xqz_DampRateV(:,:,:) !xqz ʻҸ그(ľ)
  real(DP), allocatable    :: xyr_DampRateH(:,:,:) !xyr ʻҸ그(ʿ)
  real(DP), allocatable    :: xyr_DampRateV(:,:,:) !xyr ʻҸ그(ľ)
  integer                  :: unit ! ֹ

  !ͤ save 
  save DampSound, EFTime, DampDepthH, DampDepthV
  save xyz_DampRateH, xyz_DampRateV
  save pyz_DampRateH, pyz_DampRateV
  save xqz_DampRateH, xqz_DampRateV  
  save xyr_DampRateH, xyr_DampRateV

contains 
  
!!!------------------------------------------------------------------------!!!
  subroutine Damping_Init( cfgfile ) 
    !
    ! ȸȥݥؤθ그ν
    ! 

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile
    real(DP)                  :: Alpha    !ȸη
    real(DP)                  :: Time     !
    real(DP)                  :: DepthH   !ݥؤθ(ʿ)
    real(DP)                  :: DepthV   !ݥؤθ(ľ)

    !NAMELIST 
    NAMELIST /damping/ Alpha, Time, DepthH, DepthV

    call FileOpen(unit, file=cfgfile, mode='r')
    read(unit, NML=damping)
    close(unit)

    !
    call DampSound_Init( Alpha ) 
    call DampSponge_Init( Time, DepthH, DepthV )

  end subroutine Damping_Init
!!!------------------------------------------------------------------------!!!
  subroutine DampSound_Init( damp ) 
    !
    ! ȸθ그ν
    ! 

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)  :: damp
    real(DP)              :: DelXMin, DelZMin

    DelXMin = minval( x_dx ) 
    DelZMin = minval( z_dz ) 

    !-------------------------------------------------------------------
    ! ȸθΨ   Min(DelX, DelZ) ** 2.0 
    !-------------------------------------------------------------------
    DampSound = Damp * ( Min(DelXMin, DelZMin) ** 2.0d0 ) / DelTimeShort
    
    !-----------------------------------------------------------------    
    ! ͤγǧ
    !-----------------------------------------------------------------
    call MessageNotify( "M", &
      & "DampSound_init", "DampSound = %f", d=(/DampSound/) )

  end subroutine DampSound_Init


!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_Init( Time, DepthH, DepthV )
    !
    ! ݥؤθ그
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: Time     !ݥؤ e-folding time
    real(DP), intent(in)   :: DepthH   !ݥؤθ(ʿ)
    real(DP), intent(in)   :: DepthV   !ݥؤθ(ľ)
    real(DP), parameter    :: Pi =3.1415926535897932385d0   !߼Ψ
    integer                :: i, j, k

    !
    allocate( &
      & xyz_DampRateH(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_DampRateV(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & pyz_DampRateH(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & pyz_DampRateV(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xqz_DampRateH(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xqz_DampRateV(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyr_DampRateH(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyr_DampRateV(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)    )
    xyz_DampRateH = 0.0d0
    xyz_DampRateV = 0.0d0
    pyz_DampRateH = 0.0d0
    pyz_DampRateV = 0.0d0
    xqz_DampRateH = 0.0d0
    xqz_DampRateV = 0.0d0
    xyr_DampRateH = 0.0d0
    xyr_DampRateV = 0.0d0

    !ͤ
    EFTime     = Time
    DampDepthH = DepthH
    DampDepthV = DepthV
    
    !-----------------------------------------------------------------    
    ! ݥؤθΨ
    !-----------------------------------------------------------------
    !ʿ¦¦
    if ( DampDepthH < x_dx(RegXMin) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelX is %f", d=(/x_dx(RegXMin)/))

    else if ( DampDepthH < x_dx(RegXMax) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelX is %f", d=(/x_dx(RegXMax)/))

    else
      do i = DimXMin, DimXMax
        !顼ʻ¦
        if ( x_X(i) < DampDepthH) then 
          xyz_DampRateH(i,:,:) = ((1.0d0 - x_X(i) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !եåʻ¦
        if ( p_X(i) < DampDepthH) then 
          pyz_DampRateH(i,:,:) = ((1.0d0 - p_X(i) / DampDepthH) ** 3.0d0) / EFTime
         end if
        
        !顼ʻ¦    
        if ( x_X(i) > ( XMax - DampDepthH ) ) then 
          xyz_DampRateH(i,:,:) = &
            & ((1.0d0 - (XMax - x_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
        
        !եåʻ¦    
        if ( p_X(i) > ( XMax - DampDepthH ) ) then 
          pyz_DampRateH(i,:,:) = &
            & ((1.0d0 - (XMax - p_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
      end do
    end if
    !sf  ss  X ˴ؤƤƱ
    xyr_DampRateH  = xyz_DampRateH

    !ʿ¦¦
    if ( DampDepthH < y_dy(RegYMin) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelY is %f", d=(/x_dx(RegYMin)/))

    else if ( DampDepthH < y_dy(RegYMax) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelY is %f", d=(/y_dy(RegYMax)/))

    else
      do j = DimYMin, DimYMax
        !顼ʻ¦
        if ( y_Y(j) < DampDepthH) then 
          xyz_DampRateH(:,j,:) = ((1.0d0 - y_Y(j) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !եåʻ¦
        if ( q_Y(j) < DampDepthH) then 
          pyz_DampRateH(:,j,:) = ((1.0d0 - q_Y(j) / DampDepthH) ** 3.0d0) / EFTime
         end if
        
        !顼ʻ¦    
        if ( y_Y(j) > ( YMax - DampDepthH ) ) then 
          xyz_DampRateH(:,j,:) = &
            & ((1.0d0 - (YMax - y_Y(j)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
        
        !եåʻ¦    
        if ( q_Y(j) > ( YMax - DampDepthH ) ) then 
          pyz_DampRateH(:,j,:) = &
            & ((1.0d0 - (YMax - q_Y(j)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
      end do
    end if
    !sf  ss  X ˴ؤƤƱ
    xqz_DampRateH  = xyz_DampRateH

    
    !ľξ    
    if ( DampDepthV < z_dz(RegZMax) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthV is too thin. DelZ is %f", d=(/z_dz(RegZMax)/) )
      
    else
      do k = DimZMin, DimZMax
        !顼ʻ
        if ( z_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xyz_DampRateV(:,:,k) =  &
            & (1.0d0 - dcos(Pi * (z_Z(k) - ZMax + DampDepthV) / DampDepthV)) &
            &  / EFTime 
        end if
        
        !եåʻ
        if ( r_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xyr_DampRateV(:,:,k) =  &
            & (1.0d0 - dcos(Pi * (r_Z(k) - ZMax + DampDepthV)/ DampDepthV)) &
            &  / EFTime 
        end if
      end do
    end if
    !fs  ss  Z ˴ؤƤƱ
    pyz_DampRateV  = xyz_DampRateV
    
    !-----------------------------------------------------------------    
    ! ͤγǧ
    !-----------------------------------------------------------------

    call MessageNotify( "M", "DampSponge_Init", "EFTime = %f", d=(/EFTime/) )
    call MessageNotify( "M", "DampSponge_Init", "DampDepthH = %f", d=(/DampDepthH/) )
    call MessageNotify( "M", "DampSponge_Init", "DampDepthV = %f", d=(/DampDepthV/) )  

  end subroutine DampSponge_Init
!!!------------------------------------------------------------------------!!!
  function xyz_DampSponge_xyz(xyz_Var)
    !
    ! xyz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xyz_Var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)               :: xyz_DampSponge_xyz(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻
    xyz_DampSponge_xyz =  ( xyz_DampRateH + xyz_DampRateV ) * xyz_Var
    
  end function xyz_DampSponge_xyz
!!!------------------------------------------------------------------------!!!
  function xyz_DampSponge(xyz_VarA, xyz_VarB, DelTime)
    !
    ! xyz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xyz_VarA(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)   :: xyz_VarB(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)   :: DelTime
    real(DP)               :: xyz_DampSponge(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻
    xyz_DampSponge =  xyz_VarA - ( xyz_DampRateH + xyz_DampRateV ) * xyz_VarB * DelTime
    
  end function xyz_DampSponge


!!!------------------------------------------------------------------------!!!
  function xyr_DampSponge_xyr(xyr_Var)
    !
    ! xyr ʻФ륹ݥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xyr_Var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)               :: xyr_DampSponge_xyr(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    !ݥؤˤԥ󥰤׻  
    xyr_DampSponge_xyr =  ( xyr_DampRateH + xyr_DampRateV )* xyr_Var
    
  end function xyr_DampSponge_xyr


!!!------------------------------------------------------------------------!!!
  function xyr_DampSponge(xyr_VarA, xyr_VarB, DelTime)
    !
    ! xyr ʻФ륹ݥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xyr_VarA(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)   :: xyr_VarB(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)   :: DelTime
    real(DP)               :: xyr_DampSponge(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    !ݥؤˤԥ󥰤׻  
    xyr_DampSponge =  xyr_VarA - ( xyr_DampRateH + xyr_DampRateV )* xyr_VarB * DelTime
    
  end function xyr_DampSponge


!!!------------------------------------------------------------------------!!!
  function pyz_DampSponge_pyz(pyz_Var)
    !
    ! pyz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: pyz_Var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)               :: pyz_DampSponge_pyz(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻  
    pyz_DampSponge_pyz = ( pyz_DampRateH + pyz_DampRateV ) * pyz_Var
    
  end function pyz_DampSponge_pyz
  

!!!------------------------------------------------------------------------!!!
  function pyz_DampSponge(pyz_VarA, pyz_VarB, DelTime)
    !
    ! pyz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: pyz_VarA(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)   :: pyz_VarB(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)   :: DelTime
    real(DP)               :: pyz_DampSponge(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻  
    pyz_DampSponge = pyz_VarA - ( pyz_DampRateH + pyz_DampRateV ) * pyz_VarB * DelTime
    
  end function pyz_DampSponge
!!!------------------------------------------------------------------------!!!
  function xqz_DampSponge_xqz(xqz_Var)
    !
    ! xqz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xqz_Var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)               :: xqz_DampSponge_xqz(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻  
    xqz_DampSponge_xqz = ( xqz_DampRateH + xqz_DampRateV ) * xqz_Var
    
  end function xqz_DampSponge_xqz
!!!------------------------------------------------------------------------!!!
  function xqz_DampSponge(xqz_VarA, xqz_VarB, DelTime)
    !
    ! xqz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xqz_VarA(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)   :: xqz_VarB(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)   :: DelTime
    real(DP)               :: xqz_DampSponge(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻  
    xqz_DampSponge = xqz_VarA - ( xqz_DampRateH + xqz_DampRateV ) * xqz_VarB * DelTime
    
  end function xqz_DampSponge
  
end module Damping_3d
