!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 3  (xyz ) ֳָ߳ʻ ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/06/07 () : 

module xyz_bc_module
  != 3  (xyz ) ֳָ߳ʻ ͭºʬǥ ⥸塼
  !
  !== 
  !
  ! xyz_bc_module , 3  (xyz ) ֳָ߳ʻҤѤͭºʬˡ
  ! ŤͥǥΤ,  Fortran 90 ץ
  ! .
  !
  ! Υ⥸塼 xyz_module β̥⥸塼Ǥ. ⥸塼
  ! Ȥ data_type, xyz_base_module, x_bc_module, y_bc_module, 
  ! z_bc_module ⥸塼ѤƤ. 
  !
  !
  !== ³̿̾ˡ
  !
  ! ꤹץ
  !
  !   Boundary[򼨤ʸ][...]_(μ)
  !
  ! Τ褦̿̾Ƥ. 򼨤ʸμ x_bc_module,
  ! y_bc_module, z_bc_module ξƱǤ.
  ! 
  !
  use dc_types,        only : DBKIND => DP
  use xyz_base_module, only : imin, imax, jmin, jmax, kmin, kmax, &
    &                         xmargin, ymargin, zmargin, im, jm, km 
  use x_bc_module,   only : BoundarySym_x, BoundaryAsym_x, BoundaryCyc_x, &
    &                       BoundarySym_p, BoundaryAsym_p, BoundaryCyc_p
  use y_bc_module,   only : BoundarySym_y, BoundaryAsym_y, BoundaryCyc_y, &
    &                       BoundarySym_q, BoundaryAsym_q, BoundaryCyc_q
  use z_bc_module,   only : BoundarySym_z, BoundaryAsym_z, BoundaryCyc_z, &
    &                       BoundarySym_r, BoundaryAsym_r, BoundaryCyc_r

  implicit none

  private

  public :: BoundaryXSym_xyz, BoundaryXAsym_xyz, BoundaryXCyc_xyz 
  public :: BoundaryXSym_xqz, BoundaryXAsym_xqz, BoundaryXCyc_xqz 
  public :: BoundaryXSym_xyr, BoundaryXAsym_xyr, BoundaryXCyc_xyr 
  public :: BoundaryXSym_pyz, BoundaryXAsym_pyz, BoundaryXCyc_pyz 

  public :: BoundaryYSym_xyz, BoundaryYAsym_xyz, BoundaryYCyc_xyz 
  public :: BoundaryYSym_xqz, BoundaryYAsym_xqz, BoundaryYCyc_xqz 
  public :: BoundaryYSym_xyr, BoundaryYAsym_xyr, BoundaryYCyc_xyr 
  public :: BoundaryYSym_pyz, BoundaryYAsym_pyz, BoundaryYCyc_pyz 

  public :: BoundaryZSym_xyz, BoundaryZAsym_xyz, BoundaryZCyc_xyz 
  public :: BoundaryZSym_xqz, BoundaryZAsym_xqz, BoundaryZCyc_xqz 
  public :: BoundaryZSym_xyr, BoundaryZAsym_xyr, BoundaryZCyc_xyr 
  public :: BoundaryZSym_pyz, BoundaryZAsym_pyz, BoundaryZCyc_pyz 

  interface BoundaryXSym_xyz
    module procedure BoundaryXSym_xaa
  end interface

  interface BoundaryXSym_xqz
    module procedure BoundaryXSym_xaa
  end interface

  interface BoundaryXSym_xyr
    module procedure BoundaryXSym_xaa
  end interface

  interface BoundaryXAsym_xyz
    module procedure BoundaryXAsym_xaa
  end interface

  interface BoundaryXAsym_xqz
    module procedure BoundaryXAsym_xaa
  end interface

  interface BoundaryXAsym_xyr
    module procedure BoundaryXAsym_xaa
  end interface

  interface BoundaryXCyc_xyz
    module procedure BoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_xqz
    module procedure BoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_xyr
    module procedure BoundaryXCyc_aaa
  end interface

  interface BoundaryXCyc_pyz
    module procedure BoundaryXCyc_aaa
  end interface

  interface BoundaryYSym_xyz
    module procedure BoundaryYSym_aya
  end interface

  interface BoundaryYSym_pyz
    module procedure BoundaryYSym_aya
  end interface

  interface BoundaryYSym_xyr
    module procedure BoundaryYSym_aya
  end interface

  interface BoundaryYAsym_xyz
    module procedure BoundaryYAsym_aya
  end interface

  interface BoundaryYAsym_pyz
    module procedure BoundaryYAsym_aya
  end interface

  interface BoundaryYAsym_xyr
    module procedure BoundaryYAsym_aya
  end interface

  interface BoundaryYCyc_xyz
    module procedure BoundaryYCyc_aaa
  end interface

  interface BoundaryYCyc_pyz
    module procedure BoundaryYCyc_aaa
  end interface

  interface BoundaryYCyc_xyr
    module procedure BoundaryYCyc_aaa
  end interface

  interface BoundaryYCyc_xqz
    module procedure BoundaryYCyc_aaa
  end interface

  interface BoundaryZSym_xyz
    module procedure BoundaryZSym_aaz
  end interface

  interface BoundaryZSym_pyz
    module procedure BoundaryZSym_aaz
  end interface

  interface BoundaryZSym_xqz
    module procedure BoundaryZSym_aaz
  end interface

  interface BoundaryZAsym_xyz
    module procedure BoundaryZAsym_aaz
  end interface

  interface BoundaryZAsym_pyz
    module procedure BoundaryZAsym_aaz
  end interface

  interface BoundaryZAsym_xqz
    module procedure BoundaryZAsym_aaz
  end interface

  interface BoundaryZCyc_xyz
    module procedure BoundaryZCyc_aaa
  end interface

  interface BoundaryZCyc_pyz
    module procedure BoundaryZCyc_aaa
  end interface

  interface BoundaryZCyc_xqz
    module procedure BoundaryZCyc_aaa
  end interface

  interface BoundaryZCyc_xyr
    module procedure BoundaryZCyc_aaa
  end interface

  integer :: ix, jy, kz

  contains

!--------------------------------------------------------------------
    subroutine BoundaryXSym_xaa(xaa_Var)
      real(DBKIND),intent(inout) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! x оζŬѤ
!      do kz = kmin, kmax
!        do jy = jmin, jmax
!          call BoundarySym_x(xaa_Var(:,jy,kz))
!        end do
!      end do

      do ix = 1, xmargin
        xaa_Var(1-ix,:,:)  = xaa_Var(ix,:,:)
        xaa_Var(im+ix,:,:) = xaa_Var(im+1-ix,:,:)
      end do

    end subroutine BoundaryXSym_xaa
!--------------------------------------------------------------------
    subroutine BoundaryXSym_pyz(pyz_Var)
      real(DBKIND),intent(inout) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! x оζŬѤ
!      do kz = kmin, kmax
!        do jy = jmin, jmax
!          call BoundarySym_p(pyz_Var(:,jy,kz))
!        end do
!      end do

      do ix = 1, xmargin-1
        pyz_Var(-ix,:,:)   = pyz_Var(ix,:,:)      
      end do

      do ix = 1, xmargin
        pyz_Var(im+ix,:,:) = pyz_Var(im+1-ix,:,:)
      end do


    end subroutine BoundaryXSym_pyz
!--------------------------------------------------------------------
    subroutine BoundaryXAsym_xaa(xaa_Var)
      real(DBKIND),intent(inout) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! x ȿоζŬѤ
!      do kz = kmin, kmax
!        do jy = jmin, jmax
!          call BoundaryAsym_x(xaa_Var(:,jy,kz))
!        end do
!      end do

      do ix = 1, xmargin
        xaa_Var(1-ix,:,:)  = - xaa_Var(ix,:,:)
        xaa_Var(im+ix,:,:) = - xaa_Var(im+1-ix,:,:)
      end do

    end subroutine BoundaryXAsym_xaa
!--------------------------------------------------------------------
    subroutine BoundaryXAsym_pyz(pyz_Var)
      real(DBKIND),intent(inout) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! x ȿоζŬѤ
!      do kz = kmin, kmax
!        do jy = jmin, jmax
!          call BoundaryAsym_p(pyz_Var(:,jy,kz))
!        end do
!      end do

      pyz_Var(0,:,:) = 0.0d0
      pyz_Var(im,:,:) = 0.0d0
          
      do ix = 1, xmargin-1
        pyz_Var(-ix,:,:) = - pyz_Var(ix,:,:)
      end do

      do ix = 1, xmargin
        pyz_Var(im+ix,:,:) = - pyz_Var(im-ix,:,:)
      end do

    end subroutine BoundaryXAsym_pyz
!--------------------------------------------------------------------
    subroutine BoundaryXCyc_aaa(aaa_Var)
      real(DBKIND),intent(inout) :: aaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! x ˼ŬѤ
!      do kz = kmin, kmax
!        do jy = jmin, jmax
!          call BoundaryCyc_x(xaa_Var(:,jy,kz))
!        end do
!      end do

      do ix = 1, xmargin
        aaa_Var(1-ix,:,:)  = aaa_Var(im+1-ix,:,:)
        aaa_Var(im+ix,:,:) = aaa_Var(ix,:,:)
      end do
 
   end subroutine BoundaryXCyc_aaa
!--------------------------------------------------------------------
    subroutine BoundaryYSym_aya(aya_Var)
      real(DBKIND),intent(inout) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! y оζŬѤ
!      do kz = kmin, kmax
!        do ix = imin, imax
!          call boundarySym_y(aya_Var(ix,:,kz))
!        end do
!      end do

      do jy = 1, ymargin
        aya_Var(:,1-jy,:)  = aya_Var(:,jy,:)
        aya_Var(:,jm+jy,:) = aya_Var(:,jm+1-jy,:)
      end do

    end subroutine BoundaryYsym_aya
!--------------------------------------------------------------------
    subroutine BoundaryYSym_xqz(xqz_Var)
      real(DBKIND),intent(inout) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! y оζŬѤ
!      do kz = kmin, kmax
!        do ix = imin, imax
!          call boundarySym_q(xqz_Var(ix,:,kz))
!        end do
!      end do

      do jy = 1, ymargin-1
        xqz_Var(:,-jy,:)   = xqz_Var(:,jy,:)      
      end do

      do jy = 1, ymargin
        xqz_Var(:,jm+jy,:) = xqz_Var(:,jm+1-jy,:)
      end do

    end subroutine BoundaryYsym_xqz
!--------------------------------------------------------------------
    subroutine BoundaryYASym_aya(aya_Var)
      real(DBKIND),intent(inout) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! y ȿоζŬѤ
!      do kz = kmin, kmax
!        do ix = imin, imax
!          call boundaryASym_y(aya_Var(ix,:,kz))
!        end do
!      end do

      do jy = 1, ymargin
        aya_Var(:,1-jy,:)  = - aya_Var(:,jy,:)
        aya_Var(:,jm+jy,:) = - aya_Var(:,jm+1-jy,:)
      end do

    end subroutine BoundaryYAsym_aya
!--------------------------------------------------------------------
    subroutine BoundaryYASym_xqz(xqz_Var)
      real(DBKIND),intent(inout) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      integer           :: ix, kz
      
      ! y ȿоζŬѤ
!      do kz = kmin, kmax
!        do ix = imin, imax
!          call boundaryASym_q(xqz_Var(ix,:,kz))
!        end do
!      end do

      xqz_Var(:,0,:) = 0.0d0
      xqz_Var(:,jm,:) = 0.0d0
          
      do jy = 1, ymargin-1
        xqz_Var(:,-jy,:) = - xqz_Var(:,jy,:)
      end do

      do jy = 1, ymargin
        xqz_Var(:,jm+jy,:) = - xqz_Var(:,jm-jy,:)
      end do

    end subroutine BoundaryYAsym_xqz
!--------------------------------------------------------------------
    subroutine BoundaryYCyc_aaa(aaa_Var)
      real(DBKIND),intent(inout) :: aaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      integer           :: ix, kz
      
      ! y ˼ŬѤ
!      do kz = kmin, kmax
!        do ix = imin, imax
!          call BoundaryCyc_y(aya_Var(ix,:,kz))
!        end do
!      end do

      do jy = 1, ymargin
        aaa_Var(:,1-jy,:)  = aaa_Var(:,jm+1-jy,:)
        aaa_Var(:,jm+jy,:) = aaa_Var(:,jy,:)
      end do

    end subroutine BoundaryYCyc_aaa
!--------------------------------------------------------------------
    subroutine BoundaryZSym_aaz(aaz_Var)
      real(DBKIND),intent(inout) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z оζŬѤ
!      do jy = jmin, jmax
!        do ix = imin, imax
!          call boundarySym_z(aaz_Var(ix,jy,:))
!        end do
!      end do

      do kz = 1, zmargin
        aaz_Var(:,:,1-kz)  = aaz_Var(:,:,kz)
        aaz_Var(:,:,km+kz) = aaz_Var(:,:,km+1-kz)
      end do


    end subroutine BoundaryZSym_aaz
!--------------------------------------------------------------------
    subroutine BoundaryZSym_xyr(xyr_Var)
      real(DBKIND),intent(inout) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z оζŬѤ
!      do jy = jmin, jmax
!        do ix = imin, imax
!          call boundarySym_r(xyr_Var(ix,jy,:))
!        end do
!      end do

      do kz = 1, zmargin-1
        xyr_Var(:,:,-kz)   = xyr_Var(:,:,kz)      
      end do

      do kz = 1, zmargin
        xyr_Var(:,:,km+kz) = xyr_Var(:,:,km+1-kz)
      end do

    end subroutine BoundaryZSym_xyr
!--------------------------------------------------------------------
    subroutine BoundaryZAsym_aaz(aaz_Var)
      real(DBKIND),intent(inout) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z ȿоζŬѤ
!      do jy = jmin, jmax
!        do ix = imin, imax
!          call boundaryAsym_z(aaz_Var(ix,jy,:))
!        end do
!      end do

      do kz = 1, zmargin
        aaz_Var(:,:,1-kz)  = - aaz_Var(:,:,kz)
        aaz_Var(:,:,km+kz) = - aaz_Var(:,:,km+1-kz)
      end do

    end subroutine BoundaryZAsym_aaz
!--------------------------------------------------------------------
    subroutine BoundaryZAsym_xyr(xyr_Var)
      real(DBKIND),intent(inout) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z ȿоζŬѤ
!      do jy = jmin, jmax
!        do ix = imin, imax
!          call boundaryAsym_r(xyr_Var(ix,jy,:))
!        end do
!      end do

      xyr_Var(:,:,0) = 0.0d0
      xyr_Var(:,:,km) = 0.0d0
          
      do kz = 1, zmargin-1
        xyr_Var(:,:,-kz) = - xyr_Var(:,:,kz)
      end do

      do kz = 1, zmargin
        xyr_Var(:,:,km+kz) = - xyr_Var(:,:,km-kz)
      end do

    end subroutine BoundaryZAsym_xyr
!--------------------------------------------------------------------
    subroutine BoundaryZCyc_aaa(aaa_Var)
      real(DBKIND),intent(inout) :: aaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      
      ! z ˼ŬѤ
!      do jy = jmin, jmax
!        do ix = imin, imax
!          call boundaryCyc_z(aaz_Var(ix,jy,:))
!        end do
!      end do

      do kz = 1, zmargin
        aaa_Var(:,:,1-kz)  = aaa_Var(:,:,km+1-kz)
        aaa_Var(:,:,km+kz) = aaa_Var(:,:,kz)
      end do

    end subroutine BoundaryZCyc_aaa
!--------------------------------------------------------------------
end module xyz_bc_module
