#!/usr/bin/env ruby

require "numru/netcdf"
require "numru/dcl"
require "numru/ggraph"
require "getoptlong"
include NumRu

parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--DelTime',      GetoptLong::REQUIRED_ARGUMENT],
                   ['--Time',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--info',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--Num',          GetoptLong::REQUIRED_ARGUMENT],
                   ['--MaxT',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--MinT',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--MaxW',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--MinW',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--ZMin',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--ZMax',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--dump',         GetoptLong::NO_ARGUMENT],
                   ['--mpi',         GetoptLong::NO_ARGUMENT],
                   ['--anm',          GetoptLong::NO_ARGUMENT]
                   )
begin
  parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'" 
  end
    rescue
  exit(1)
end

file = ARGV[0]
info = $OPT_info
time0= $OPT_Time.to_f
num  = $OPT_Num.to_f
delt = $OPT_DelTime.to_f
time1=time0+delt*num

maximum1 = $OPT_MaxT.to_f
minimum1 = $OPT_MinT.to_f
maximum2 = $OPT_MaxW.to_f
minimum2 = $OPT_MinW.to_f

lev1 = []
for i in 0..90 do
  lev1.push( (minimum1 + (maximum1-minimum1)/90*i) )
end
rmiss = DCL.glpget('rmiss')
lev1.unshift(rmiss)
lev1.push(rmiss)

lev2 = []
for i in 0..90 do
  lev2.push( (minimum2 + (maximum2-minimum2)/90*i) )
end
rmiss = DCL.glpget('rmiss')
lev2.unshift(rmiss)
lev2.push(rmiss)

zmin = $OPT_ZMin.to_f
zmax = $OPT_ZMax.to_f


var1     = "PotTemp"
file1    = file+"_"+var1+".nc"
var2     = "PotTempBasicZ"
file2    = file+"_BasicZ.nc"
if ($OPT_anm)
  PotTemp    = GPhys::IO.open(file1,var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax) + 
               GPhys::IO.open(file2,var2).cut('z'=>zmin..zmax)
  PotTempAnm = PotTemp - PotTemp.mean('x')
else
  if ($OPT_mpi)
    # եΰ   
#    inputfile = "#{file}-node*#{var1}*"
#    inputfiles = Array.new
#    Dir::glob(inputfile).each {|f|
#      inputfiles.push( f.to_s )
#    }
#    inputfiles.sort

    inputfiles = Array.new
    32.times {|i|
      fnum = sprintf("%03d", i)
      inputfile = "#{file}-node#{fnum}_#{var1}.nc"
      inputfiles.push( inputfile )
    }
    
    p inputfiles
    PotTemp = GPhys::IO.open(inputfiles,var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax) 
    PotTempAnm = PotTemp * 1.0e0
  else
    PotTemp = GPhys::IO.open(file1,var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax) 
    PotTempAnm = PotTemp * 1.0e0
  end
end

PotTempAnm.coord(0).val = PotTempAnm.coord(0).val / 1000
PotTempAnm.coord(1).val = PotTempAnm.coord(1).val / 1000

var1     = "VelZ"
file1    = file+"_"+var1+".nc"

if ($OPT_mpi)
  # եΰ   
    inputfiles = Array.new
    32.times {|i|
      fnum = sprintf("%03d", i)
      inputfile = "#{file}-node#{fnum}_#{var1}.nc"
      inputfiles.push( inputfile )
    }
#  inputfile = "#{file}-node*#{var1}*"
#  inputfiles = Array.new
#  Dir::glob(inputfile).each {|f|
#      inputfiles.push( f.to_s )
#    }
  p inputfiles

  Vel = GPhys::IO.open(inputfiles,var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  VelZ = Vel * 1.0e0  # ߡ
else
  Vel = GPhys::IO.open(file1,var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  VelZ = Vel * 1.0e0  # ߡ
end
VelZ.coord(0).val = VelZ.coord(0).val / 1000
VelZ.coord(1).val = VelZ.coord(1).val / 1000


DCL::swpset('IWIDTH',  450 )
DCL::swpset('IHEIGHT', 600 )

if ( $OPT_dump )
  DCL::swlset("lwnd",false)
end

DCL.gropn(4)
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.sgpset('lcorner',false)  # ʡޡ񤫤ʤ
DCL.uzfact(0.7)              # ɸʸ󥵥
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ
DCL.udpset('lmsg',false)     # 󥿡ֳɽ

vx   = 0.6
vz   = 0.36
xmgn = 0.02
zmgn = 0.08
vx0  = 0.0
vz0  = 0.1

vpt00 = NArray[vx0, vx0+vx, vz0, vz0+vz*1]
#vpt10 = NArray[vx0+xmgn+vx, vx0+xmgn+vx*2, vz0+vz*0, vz0+vz*1]
vpt10 = NArray[vx0, vx0+vx, vz0+zmgn+vz, vz0+zmgn+vz*2]

p vpt00, vpt10


for i in 0..num
  p lev2

  GGraph.set_fig('viewport'=>vpt00, 'new_frame'=>true)
  GGraph.set_axes('xunits'=>'','yunits'=>'','xtitle'=>'Length [km]','ytitle'=>'Height [km]') 
  DCL.uzpset('labelyl',false)
  DCL.uzpset('labelxb',true)
  GGraph.tone( PotTempAnm.cut('t'=>time0+delt*i),  
               true, 
               'title' => '', 
               'annotate'=>false,
               'levels' => lev1
               )
  DCL.uzpset('pad1',0.4) 
  DCL.uxsttl('t','(d) Potential Temperature Deviation [K]',0) 
  DCL.uzpset('pad1',0.7)
  GGraph.color_bar('vlength'=>vz*0.85, 'tickintv'=>2)

  GGraph.set_fig('viewport'=>vpt10, 'new_frame'=>false)
  GGraph.set_axes('ytitle'=>'Height [km]','xtitle'=>'Length [km]')
  DCL.uzpset('labelyl',false)
  DCL.uzpset('labelxb',false)
  GGraph.tone( VelZ.cut('t'=>time0+delt*i), 
               true, 
               'title' => '',
               'annotate'=>false,
               'levels' => lev2
               )
  DCL.uzpset('pad1',0.4) 
  DCL.uxsttl('t','(b) Vertical Velocity [m/s]',0) 
  DCL.uzpset('pad1',0.7)
#  outputtime = sprintf("%.2f", (time0+delt*i)/86400.0)
#  DCL.uxsttl('t','t = '+outputtime.to_s+' day',1) 
  outputtime = time0+delt*i
  DCL.uxsttl('t','t = '+outputtime.to_s+' s',1) 
  GGraph.color_bar('vlength'=>vz*0.85, 'tickintv'=>2)

end

DCL.grcls


if ($OPT_dump)

  order = Math::log10(time0+delt*num).to_i + 1 
  fmt = "%0"+(order.to_i).to_s+"d"  
  p fmt

  for i in 0..num
    time = sprintf(fmt, time0.to_f+(i*delt).to_f)
    
    j = sprintf("%03d", i + 1)
    outputfile = info+"-1_t"+time.to_s+".png"  

    convert1 = "mv dcl_"+j+".png "+outputfile
    system( convert1 )
    p convert1
    
  end
end
