!-----------------------------------------------------------------------
! SWPACK SCREEN DRIVER FOR DEC Visual Fortran   September  1997, S.Sakai
!-----------------------------------------------------------------------
!
!************ service routine interface ***************
!
module ZMSERV
    USE DFWIN

    integer(4), public    :: hrp,hwp
    integer(4), parameter :: nbuf=1024
    integer(4), private   :: ndata = 0
    integer(4), private, dimension(nbuf) :: sd

    INTERFACE
    INTEGER*4 FUNCTION OpenDCLWindow [C,ALIAS:'_OpenDCLWindow'](x,y,mode)
        INTEGER*4   ::  x    [VALUE]
        INTEGER*4   ::  y    [VALUE]
        INTEGER*4   ::  mode [VALUE]
    END FUNCTION

    INTEGER*4 FUNCTION DCLPolyPolyLine [C,ALIAS:'_DCLPolyPolyLine'](point,pnum,lnum)
        INTEGER*4   ::  point [VALUE]
        INTEGER*4   ::  pnum  [VALUE]
        INTEGER*4   ::  lnum  [VALUE]
    END FUNCTION

    INTEGER*4 FUNCTION DCLBackgroundColor[C,ALIAS:'_DCLBackgroundColor'](red,green,blue)
        INTEGER*4   :: red   [VALUE]
        INTEGER*4   :: green [VALUE]
        INTEGER*4   :: blue  [VALUE]
    END FUNCTION DCLBackgroundColor

    INTEGER*4 FUNCTION DCLPolyPolygon [C,ALIAS:'_DCLPolyPolygon'] &
                               & (point,pnum,lnum)
        INTEGER*4   ::  point [VALUE]
        INTEGER*4   ::  pnum  [VALUE]
        INTEGER*4   ::  lnum  [VALUE]
    END FUNCTION DCLPolyPolygon

    INTEGER*4 FUNCTION DCLGetMouseClick [C,ALIAS:'_DCLGetMouseClick'](mf)
        INTEGER*4   ::  mf [VALUE]
    END FUNCTION DCLGetMouseClick

    INTEGER*4 FUNCTION DCLGetKeyCode [C,ALIAS:'_DCLGetKeyCode'](kc)
        INTEGER*4   ::  kc [VALUE]
    END FUNCTION DCLGetKeyCode

    INTEGER*4 FUNCTION ChangeDCLPen [C,ALIAS:'_ChangeDCLPen']   &
                                &   (Width,Red,Green,Blue)
        INTEGER*4   :: Width    [VALUE]
        INTEGER*4   :: Red      [VALUE]
        INTEGER*4   :: Green    [VALUE]
        INTEGER*4   :: Blue     [VALUE]
    END FUNCTION ChangeDCLPen

    INTEGER*4 FUNCTION ChangeDCLBrush [C,ALIAS:'_ChangeDCLBrush']   &
                                    & (pBmp,BmpSize,Red,Green,Blue)
        INTEGER*4   :: pBmp     [VALUE]
        INTEGER*4   :: BmpSize  [VALUE]
        INTEGER*4   :: Red      [VALUE]
        INTEGER*4   :: Green    [VALUE]
        INTEGER*4   :: Blue     [VALUE]
    END FUNCTION ChangeDCLBrush

    INTEGER*4 FUNCTION DCLNewPage [C,ALIAS:'_DCLNewPage'](Red,Green,Blue)
        INTEGER*4   :: Red      [VALUE]
        INTEGER*4   :: Green    [VALUE]
        INTEGER*4   :: Blue     [VALUE]
    END FUNCTION DCLNewPage 

    INTEGER*4 FUNCTION DCLStatusBarString [C,ALIAS:'_DCLStatusBarString'] &
                                     & (strStatusBar,nPane)
        INTEGER*4       :: strStatusBar [VALUE]
        INTEGER*4       :: nPane
    END FUNCTION DCLStatusBarString

    INTEGER*4 FUNCTION DCLTitleBarString [C,ALIAS:'_DCLTitleBarString'] &
                                      & (strTitle)
        INTEGER*4       :: strTitle [VALUE]
    END FUNCTION DCLTitleBarString

    INTEGER*4 FUNCTION DCLPageUpdate [C,ALIAS:'_DCLPageUpdate']()
    END FUNCTION DCLPageUpdate

    INTEGER*4 FUNCTION DCLExitProcess [C,ALIAS:'_DCLExitProcess']()
    END FUNCTION DCLExitProcess

    INTEGER*4 FUNCTION DCLDrawImage [C,ALIAS:'_DCLDrawImage'] &
                     & (left,top,width,height,bmpBits,bif)
        INTEGER*4   :: left     [VALUE]
        INTEGER*4   :: top      [VALUE]
        INTEGER*4   :: width    [VALUE]
        INTEGER*4   :: height   [VALUE]
        INTEGER*4   :: bmpBits  [VALUE]
        INTEGER*4   :: bif      [VALUE]
    END FUNCTION DCLDrawImage

    INTEGER*4 FUNCTION DCLSwapActivePage [C,ALIAS:'_DCLSwapActivePage']()
    END FUNCTION DCLSwapActivePage

    INTEGER*4 FUNCTION DCLSwapBMPOutMode [C,ALIAS:'_DCLSwapBMPOutMode']()
    END FUNCTION DCLSwapBMPOutMode

    INTEGER*4 FUNCTION DCLSwapWritePage [C,ALIAS:'_DCLSwapWritePage']()
    END FUNCTION DCLSwapWritePage

    INTEGER*4 FUNCTION DCLBMPFilename [C,ALIAS:'_DCLBMPFilename']   &
                                &   (FileName,Numbers)
        INTEGER*4   :: FileName [VALUE]
        INTEGER*4   :: Numbers  [VALUE]
    END FUNCTION DCLBMPFilename

    INTEGER*4 FUNCTION DCLGetPrinterdpi [C,ALIAS:'_DCLGetPrinterdpi']   &
                                &   (iwidth,iheight)
        INTEGER*4   :: iwidth   [VALUE]
        INTEGER*4   :: iheight  [VALUE]
    END FUNCTION DCLGetPrinterdpi

    INTEGER*4 FUNCTION DCLGetDCSize [C,ALIAS:'_DCLGetDCSize']   &
                                &   (iwidth,iheight)
        INTEGER*4   :: iwidth   [VALUE]
        INTEGER*4   :: iheight  [VALUE]
    END FUNCTION DCLGetDCSize

    INTEGER*4 FUNCTION DCLGetPrinterSize [C,ALIAS:'_DCLGetPrinterSize'] &
                                &   (iwidth,iheight)
        INTEGER*4   :: iwidth   [VALUE]
        INTEGER*4   :: iheight  [VALUE]
    END FUNCTION DCLGetPrinterSize

    INTEGER*4 FUNCTION DCLGetPrintBMPdpi [C,ALIAS:'_DCLGetPrintBMPdpi'] &
                                &   (idpi)
        INTEGER*4   :: idpi     [VALUE]
    END FUNCTION DCLGetPrintBMPdpi

    END INTERFACE

!DEC$ ATTRIBUTES DLLIMPORT::DCLGETPRINTERDPI
!DEC$ ATTRIBUTES DLLIMPORT::DCLGETDCSIZE
!DEC$ ATTRIBUTES DLLIMPORT::DCLGETPRINTERSIZE
!DEC$ ATTRIBUTES DLLIMPORT::DCLGETPRINTBMPDPI
!DEC$ ATTRIBUTES DLLIMPORT::OPENDCLWINDOW
!DEC$ ATTRIBUTES DLLIMPORT::DCLPOLYPOLYLINE
!DEC$ ATTRIBUTES DLLIMPORT::DCLBACKGROUNDCOLOR
!DEC$ ATTRIBUTES DLLIMPORT::DCLPOLYPOLYGON
!DEC$ ATTRIBUTES DLLIMPORT::DCLGETMOUSECLICK
!DEC$ ATTRIBUTES DLLIMPORT::DCLGETKEYCODE
!DEC$ ATTRIBUTES DLLIMPORT::CHANGEDCLPEN
!DEC$ ATTRIBUTES DLLIMPORT::CHANGEDCLBRUSH
!DEC$ ATTRIBUTES DLLIMPORT::DCLNEWPAGE
!DEC$ ATTRIBUTES DLLIMPORT::DCLSTATUSBARSTRING
!DEC$ ATTRIBUTES DLLIMPORT::DCLTITLEBARSTRING
!DEC$ ATTRIBUTES DLLIMPORT::DCLPAGEUPDATE
!DEC$ ATTRIBUTES DLLIMPORT::DCLEXITPROCESS
!DEC$ ATTRIBUTES DLLIMPORT::DCLDRAWIMAGE
!DEC$ ATTRIBUTES DLLIMPORT::DCLSWAPACTIVEPAGE
!DEC$ ATTRIBUTES DLLIMPORT::DCLSWAPBMPOUTMODE
!DEC$ ATTRIBUTES DLLIMPORT::DCLSWAPWRITEPAGE
!DEC$ ATTRIBUTES DLLIMPORT::DCLBMPFILENAME

end module ZMSERV


module CommentPut
use ZMSERV
contains
  subroutine ZMCMNT(ipos, comment)
    character(len=*) :: comment
    character(len=80) :: comz
    integer          :: ipos

	comz=comment
    l1 = min(len_trim(comz)+1, len(comz))
    comz(l1:l1) = char(0)

    if(ipos==0)then
        OtbRes=DCLTitleBarString(2)
    else
        OtbRes=DCLStatusBarString(LOC(comz),0)
    end if

  end subroutine
end module CommentPut
!
!************* coordinate object *****************
!
module ZMCOORD
   use ZMSERV
   integer, private :: nxmin, nxmax, nymin, nymax, nvx, nvy
   integer          :: mode0

contains
  subroutine ZMCOINI (iheight, iwidth)
    nvx    = iwidth - 1
    nxmin  = 0
    nxmax  = nxmin + nvx

    nvy    = iheight - 1
    nymin  = 0
    nymax  = nymin + nvy
  end subroutine

  subroutine ZMGVPT(ixmin, ixmax, iymin, iymax)
    ixmin = nxmin
    ixmax = nxmax
    iymin = nymin
    iymax = nymax
  end subroutine

  subroutine ZMFINT(wx, wy, iwx, iwy)
    iwx = nint(wx)
    iwy = nvy - nint(wy)
  end subroutine

  subroutine ZMIINT(iwx, iwy, wx, wy)
    wx = iwx
    wy = nvy - iwy
  end subroutine

  subroutine ZMQRCT(xwmin, xwmax, ywmin, ywmax, unit)
    xwmin = 0
    ywmin = 0
    xwmax = nvx
    ywmax = nvy
    if(mode0.eq.1) then
      unit  = 20./nvy
    else
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    OtbRes=DCLGetPrintBMPdpi(loc(idpi))
    unit = 2.54/idpi
    end if

  end subroutine

  subroutine ZMSTAT
    OtbRes=DCLGetPrinterdpi(loc(ixdpi),loc(iydpi))
    OtbRes=DCLGetPrinterSize(loc(ixsize),loc(iysize))
    OtbRes=DCLGetPrintBMPdpi(loc(ibdpi))

    write(*,'(A,2I6)') ' --- PRINTER RESOLUSION :', ixdpi,  iydpi
    write(*,'(A,2I6)') ' --- PRINTABLE SIZE     :', ixsize, iysize
    write(*,'(A,2I6)') ' --- PRINTING DPI       :', ibdpi
  end subroutine

end module ZMCOORD
!
!*************** colormap object *****************
!
module ZMCOLORMAP

    use ZMSERV

    logical,    private                     :: l_full_color = .false.
    integer(4), private                     :: ipalette

    integer(4), private, parameter         :: nplmax = 256
    integer(4), private, dimension(nplmax) :: ir, ig, ib
    integer(4), private                    :: max_pal

    integer(4)                             :: OtbRes

contains
    integer(4) function OtbZMCOLOR(index,number)
    integer(4)  :: index,number,itmp,ipp

!   itmp=number
!    if(itmp==0) then
!       itmp=1
!   end if
!    ipp = mod(itmp-1, max_pal-1)+2
    ipp=number+1
    if(index==1)then
        OtbZMCOLOR=ir(ipp)
    else if(index==2)then
        OtbZMCOLOR=ig(ipp)
    else
        OtbZMCOLOR=ib(ipp)
    end if
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!インデックスが0のやつに対しての色が変だよね??
!少なくともユニックスと違う。
!と思ったけど、ペンのIndexが0番になってる。
!正しくは1番のはず。

!    if(number==0)then
!       OtbZMCOLOR=0
!    end if

  end function

  integer(4) function OtbZMCOLOR2(index,number)
    integer(4)  :: index,number
    integer(4)  :: ipp

    ipp=number

    if(index==1)then
        OtbZMCOLOR2=ir(ipp)
    else if(index==2)then
        OtbZMCOLOR2=ig(ipp)
    else
        OtbZMCOLOR2=ib(ipp)
    end if

  end function

  subroutine ZMCLINI(ccfile)
    character(len=*) :: ccfile
    character(len=64) cmsg

    iu = iufopn()
    open(iu, file=ccfile)
    read(iu, '(i3)') max_pal
    if (max_pal.gt.nplmax) then
      max_pal = nplmax
      cmsg='color numbers greater than xx are ignored.'
      write(cmsg(28:29),'(i2)') nplmax
      call msgdmp('w', 'zmdopn', cmsg)
    endif

    ns = 2**8
    do i=1, max_pal
      read(iu, '(3i6)') ir0, ig0, ib0
      ir(i) = ir0 / ns
      ig(i) = ig0 / ns
      ib(i) = ib0 / ns
    end do

    close(iu)
  end subroutine

  subroutine ZMQFCC(lflag)
    logical lflag
    lflag = .TRUE.
  end subroutine

  subroutine ZMSFCM(lflag)
    logical lflag
    l_full_color = lflag
  end subroutine

  function ZMQFCM
    logical zmqfcm
    zmqfcm = l_full_color
  end function

end module ZMCOLORMAP
!
!*************** bitmap object *******************
!
module ZMBITMAP

    use ZMSERV
    use ZMCOLORMAP

    integer(4), private, parameter :: ntmax=100,   npat=500,  nch=10000
    integer(2), private            :: ipat(npat,2),ipos(npat),ilen(npat),nrec,iwdth
    integer(1), private            :: idata(nch)
    integer,    private            :: jwtrot=1, i_rgb

    integer(4)                      :: OtbRed,OtbGreen,OtbBlue,iwdth_brush


contains
  subroutine ZMBMINI(cbfile)
    character cbfile*(*)
   iu = iufopn()
    open (iu, file=cbfile,  form='unformatted')
    read (iu) nrec, iwdth, ipat, ipos, ilen, idata

    close(iu)
  end subroutine

  subroutine ZMSTCL(irgb)
    i_rgb = irgb*256
  end subroutine

  subroutine ZMSPATTERN(itpat)
    integer(1), dimension(4) :: itmp
    integer :: itpz=-1, ifz=-1, icz=-1
    character cmsg*64

    integer(2),dimension(128)   :: Otb_BmpPat
    icol  = itpat / 1000
    itptn = itpat - icol*1000
    if(zmqfcm()) then
      if(itptn.eq.itpz .and. i_rgb.eq.ifz) return
      ifz = i_rgb
      icz = -1
    else
      if(itptn.eq.itpz .and. icol.eq.icz) return
      icz = icol
      ifz = -1
    end if
    itpz = itptn

    itrec = 1
    do while (ipat(itrec, jwtrot).ne.itptn)
      itrec = itrec + 1
      if(itrec .gt. nrec) then
        cmsg = 'pattern (xxxxx) is not defined.'
        write(cmsg(10:14), '(i5)') itptn
        call msgdmp('w', 'zmspattern', cmsg)
        exit
      end if
    end do

    jlen = ilen(itrec)
    itmp = 0
    iword = iwdth/8

    KOtb=1
    do  i=1, iwdth
      do j=1, iword
        itmp = 0
        jpos = ipos(itrec) + mod((i-1)*iword+j-1, jlen*iword)
        itmp(1) = idata(jpos)
        int4 = not(transfer(itmp, int4))
        Otb_BmpPat(KOtb)=int4
        KOtb=KOtb+1
      end do
    end do

    if(zmqfcm()) then
        OtbRed=i_rgb / 16777216
        i_rgb = i_rgb - OtbRed * 16777216
        OtbGreen=i_rgb / 65536
        i_rgb = i_rgb - OtbGreen * 65536
        OtbBlue=i_rgb/256
    	iwdth_brush=iwdth
      OtbRes=ChangeDCLBrush(LOC(Otb_BmpPat(1)),iwdth_brush, &
              & OtbRed,OtbGreen,OtbBlue)
    else
       iwdth_brush=iwdth
       OtbRes=ChangeDCLBrush(LOC(Otb_BmpPat(1)),iwdth_brush, &
              & OtbZMCOLOR2(1,icol+1),OtbZMCOLOR2(2,icol+1),OtbZMCOLOR2(3,icol+1))
    end if
  end subroutine

  subroutine ZMSROT(iwtrot)
    jwtrot=iwtrot
  end subroutine
end module
!
!***************** LINE OBJECT *******************
!
module ZMLINE

    use ZMSERV
    use ZMCOORD
    use ZMCOLORMAP
    use DFWIN

    integer(4), private, parameter :: nmax =100
    integer(4), private :: ix(nmax), iy(nmax)
    integer(4), private :: ndata=0, iwidth=1, icolor=1, i_rgb=0, iwz=-1, icz=-1, ifz=-1

    TYPE(T_POINT),DIMENSION(nmax)   :: gpoint
    INTEGER*4,DIMENSION(255)        :: gpolypolyline
    integer(4)                      :: OtbRed,OtbGreen,OtbBlue

contains
  subroutine ZMQCLC(lflag)
    logical lflag
    lflag=.true.
  end subroutine

  subroutine ZMQWDC(lflag)
    logical lflag
    lflag=.true.
  end subroutine

  subroutine ZMSCLI(index)
    icolor = index
  end subroutine

  subroutine ZMSLCL(irgb)
    i_rgb = irgb*256
  end subroutine

  subroutine ZMSWDI(index)
    iwidth = index
    if(iwidth == 0) iwidth = 1
    iwidth = (iwidth+1)/2
  end subroutine

  subroutine ZMGOPN

    if(zmqfcm()) then
        OtbRed=i_rgb / 16777216
        i_rgb = i_rgb - OtbRed * 16777216
        OtbGreen=i_rgb / 65536
        i_rgb = i_rgb - OtbGreen * 65536
        OtbBlue=i_rgb/256

        OtbRes=ChangeDCLPen(iwidth,OtbRed,OtbGreen,OtbBlue)
        ifz = i_rgb
        icz = -1
        iwz = iwidth
    else
        OtbRes=ChangeDCLPen(iwidth,OtbZMCOLOR2(1,icolor+1),OtbZMCOLOR2(2,icolor+1),OtbZMCOLOR2(3,icolor+1))
        icz = icolor
        ifz = -1
        iwz = iwidth
    end if
  end subroutine

  subroutine ZMGPLT(xx, yy)
    ndata= ndata + 1
    call zmfint(xx, yy, ix(ndata), iy(ndata))
    if (ndata == nmax ) then
      call zmpline
      ix(1) = ix(ndata)
      iy(1) = iy(ndata)
      ndata = 1
    end if
  end subroutine

  subroutine ZMGMOV(xx, yy)
    call zmpline
    ndata = 1
    call zmfint(xx, yy, ix(ndata), iy(ndata))
  end subroutine

  subroutine ZMGCLS
    call zmpline
    ndata = 0
!    OtbRes=DCLPageUpdate()
  end subroutine

  subroutine ZMPLINE
    if(ndata >= 2) then

      gpolypolyline(1)=ndata

      do i =1, ndata
        gpoint(i)%x=ix(i)
        gpoint(i)%y=iy(i)
      end do
      OtbRes=DCLPolyPolyLine(LOC(gpoint(1)),LOC(gpolypolyline(1)),1)

    end if
  end subroutine
end module ZMLINE
!
!****************** TONE OBJECT *******************
!
module ZMTONE
    use DFWIN
    use ZMSERV
    use ZMCOORD
    use ZMCOLORMAP
    use ZMBITMAP

contains
  subroutine ZMQTNC(lflag)
    logical lflag
    lflag=.TRUE.
  end subroutine

  subroutine ZMGTON(np, wpx, wpy, itpat)
    real, dimension(np) :: wpx, wpy
    TYPE(T_POINT),DIMENSION(np) :: gpoint
    INTEGER*4,DIMENSION(np)     :: gpolypolygon

    call zmspattern(itpat)

    gpolypolygon(1)=np
    do i=1, np
      call zmfint(wpx(i), wpy(i), ix, iy)
        gpoint(i)%x=ix
        gpoint(i)%y=iy
    end do
    OtbRes=DCLPolyPolygon(LOC(gpoint(1)),LOC(gpolypolygon(1)),1)

  end subroutine
end module ZMTONE
!
!****************** IMAGE OBJECT *****************
!
module ZMIMAGE

    use DFWIN
    use ZMSERV
    use ZMCOLORMAP
	use CommentPut

    integer(4), private :: ix0, iy0, iy1, iy2, iy3, iwd, ipos, iend, idata
    integer(1), private, dimension(4) :: imd
!   integer(4), parameter :: nline = 16
    integer(4)  :: nline = 16
    character(len=16), private  :: cmnt


    integer(1),allocatable :: img(:)
    integer(4) :: ui

    type(T_BITMAPINFO)          ::  bmi

contains
  subroutine ZMQIMC(lflag)
    logical lflag
    lflag = .TRUE.
  end subroutine

  subroutine ZMihead

    ifrac = (iy1-iy0)*100/(iy3-iy0)
    write(cmnt, '(a,i3,a)') 'image:', ifrac, '%'
    call zmcmnt(1, cmnt)

    iy2 = min(iy3, iy1+nline-1)
    iht = iy2 - iy1 + 1
    if(iht /= 0) then
      bmi%bmiHeader%biSize          = 40
      bmi%bmiHeader%biPlanes        = 1
      bmi%bmiHeader%biWidth         = iwd
      bmi%bmiHeader%biHeight        = -iht
      bmi%bmiHeader%biBitCount      = 32
      bmi%bmiHeader%biClrImportant  = 0
      bmi%bmiHeader%biClrUsed       = 0
      bmi%bmiHeader%biCompression   = BI_RGB
      bmi%bmiHeader%biSizeImage     = 0
      bmi%bmiHeader%biXPelsPerMeter = 0
      bmi%bmiHeader%biYPelsPerMeter = 0

      idata = 0
      iend = iwd*iht
      ui=1

    end if
  end subroutine

  subroutine ZMIOPN(iwx, iwy, imw, imh)
    ix0 = iwx
    iy0 = iwy
    iy3 = iwy + imh -1
    iwd = imw

    ALLOCATE(img((imw+4)*imh*4))

!   nline=imh

    iy1 = iwy
    call zmihead
  end subroutine

  subroutine ZMIDAT(image, nlen)
    integer(4) :: image(*), int4

    do i=1, nlen
       idata = idata + 1
        img(ui)=OtbZMCOLOR2(3,image(i)+1)
        ui=ui+1
        img(ui)=OtbZMCOLOR2(2,image(i)+1)
        ui=ui+1
        img(ui)=OtbZMCOLOR2(1,image(i)+1)
        ui=ui+1
        img(ui)=0
        ui=ui+1
       if (idata == iend) then
        OtbRes=DCLDrawImage(ix0,iy1,bmi%bmiHeader%biWidth, &
            & -( bmi%bmiHeader%biHeight),LOC(img(1)),LOC(bmi))
         iy1 = iy2 + 1
         call zmihead
     end if
    end do
  end subroutine

  subroutine ZMICLS
    DEALLOCATE(img)
  end subroutine

!------------------- Full color image -----------------------------------

  subroutine ZMICLR(image, nlen)
    integer(4) :: image(*)

    do i=1, nlen
       idata = idata + 1
       img(ui) = ishft(iand(image(i), #0000FF),0)
       ui=ui+1
       img(ui) = ishft(iand(image(i), #00FF00),-8)
       ui=ui+1
       img(ui) = ishft(iand(image(i), #FF0000),-16)
       ui=ui+1
       img(ui)=0
       ui=ui+1
       if (idata == iend) then
         OtbRes=DCLDrawImage(ix0,iy1,bmi%bmiHeader%biWidth, &
            & -( bmi%bmiHeader%biHeight),LOC(img(1)),LOC(bmi))
         iy1 = iy2 + 1
         call zmihead
       end if
    end do

  end subroutine
end module ZMIMAGE
!
!***************** MOUSE OBJECT ******************
!
module ZMMOUSE
contains
  subroutine ZMQPTC(LFLAG)
    logical lflag
    LFLAG = .FALSE.
  end subroutine

  subroutine ZMQPNT(WX, WY, MB)
  end subroutine
end module ZMMOUSE
!
!**************** ZMPACK CONTROL *****************
!
module ZMPACK

    use ZMSERV
    use ZMLINE
    use ZMTONE
    use ZMIMAGE
    use ZMMOUSE
    USE SERVICE
	use CommentPut

    type T_MOUSEINFO
!       sequence
        INTEGER ::  bMouseClick;
        INTEGER ::  xPos
        INTEGER ::  yPos;
    end type T_MOUSEINFO

    integer(4) ivis, iact         ! visual page and active page
    logical    laltz, lstatus

    integer(4)             ::  kc
    type(T_MOUSEINFO)   ::  mf

contains

  subroutine zmdopn(iwidth, iheight, iposx, iposy, lwait, lalt, ldump, &
             &      ccfile, cbfile, cout, mode)

    character(len=*)  :: ccfile, cbfile, cout
    character(len=80) :: comment,cbmp
    logical lwait, lalt, ldump, ldisp
    integer(4)        :: mode, ixmax, iymax ,l1

    mode0 = mode
    ldisp = mode .eq. 1
    if(mode.eq.1)then
      OtbRes=OpenDCLWindow(iwidth, iheight,mode)
    end if
    if(mode.eq.2) then
      OtbRes=OpenDCLWindow(iwidth, iheight,mode)
      OtbRes=DCLGetDCSize(loc(ixmax),loc(iymax))
      iwidth  = ixmax
      iheight = iymax
    end if

      lenc = len_trim(cout)
      lw = (lenc+3)/4
      cbmp = cout
      l1 = min(len_trim(cout)+1, len(cout))
      cbmp(l1:l1) = char(0)
      OtbRes=DCLBMPFilename(LOC(cbmp),l1-1)

    call osgarg(0, comment)
    ipos = index(comment, '\', .true.)
    comment = comment(ipos+1:)
    ipos = len_trim(comment)
    comment(ipos+1:) = ' - (dcl-5.0)'
    call zmcmnt(0, comment)
    laltz = lalt

    call zmcoini(iheight, iwidth)          ! Initialize coordinate
    call zmclini(ccfile)                   ! Set up colormap
    call zmbmini(cbfile)                   ! Set up Tone pattern

   OtbRes=DCLNewPage(OtbZMCOLOR2(1,1),OtbZMCOLOR2(2,1),OtbZMCOLOR2(3,1))
   OtbRes=DCLBackgroundColor(OtbZMCOLOR2(1,1),OtbZMCOLOR2(2,1),OtbZMCOLOR2(3,1))
    if(lwait) then
      call zmpause
    endif

    if(laltz) then
      call fsleep (300)

      OtbRes=DCLSwapWritePage()
      OtbRes=DCLNewPage(OtbZMCOLOR2(1,1),OtbZMCOLOR2(2,1),OtbZMCOLOR2(3,1))
      OtbRes=DCLBackgroundColor(OtbZMCOLOR2(1,1),OtbZMCOLOR2(2,1),OtbZMCOLOR2(3,1))

    endif

    call ZMGVPT     (nxmin, nxmax, nymin, nymax)

  end subroutine

  subroutine ZMDCLS (lwait)
    logical lwait

    if(lwait) then
      call zmpause
    endif

    OtbRes=DCLExitProcess()

  end subroutine

  subroutine ZMPOPN
  end subroutine

  subroutine ZMPCLS (lwait, ldump)
    logical lwait, ldump

    if(ldump) then
       OtbRes=DCLSWAPBMPOUTMODE()
    end if

    call zmcmnt(1, 'Completed.')
    OtbRes=DCLPageUpdate()

    if(laltz) then
      OtbRes=DCLSwapActivePage()
      OtbRes=DCLSwapWritePage()
    endif

    if(lwait) then
      call zmpause
    endif

    OtbRes=DCLNewPage(OtbZMCOLOR2(1,1),OtbZMCOLOR2(2,1),OtbZMCOLOR2(3,1))
    OtbRes=DCLBackgroundColor(OtbZMCOLOR2(1,1),OtbZMCOLOR2(2,1),OtbZMCOLOR2(3,1))

  end subroutine

  subroutine ZMOOPN(cobj, comm)
    character(len=*) :: cobj, comm

    call zmcmnt(1, cobj)
  end subroutine

  subroutine ZMOCLS(cobj)
    character(len=*) :: cobj
!    call zmflush
  end subroutine

  subroutine ZMPAUSE

    do
      OtbRes=DCLGetMouseClick(LOC(mf))
      idat = mf.bMouseClick
      ix = mf.xPos
      iy = mf.yPos

      OtbRes=DCLGetKeyCode(LOC(kc))

      if(kc == 16) then
        OtbRes=DCLExitProcess()
        stop
      else if(idat==1 .or. kc/=0)then
        exit
      end if
      call fsleep (100)
    end do
  end subroutine
end module zmpack
