*-----------------------------------------------------------------------
*     TMSTLA : THE ROUTINE FOR DRAWING STREAM LINES (COORD. OF ANNULAR)
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2017 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMSTLA( R, T, U, V ,NX,NY )

      IMPLICIT NONE
      INTEGER NX,NY

*
*-- AGREENMENT
      REAL     U(NX,NY)
      REAL     V(NX,NY)
      REAL     R(NX)     !* GRID POINTS OF RADIAL DIR. [UNIT:LENGTH]
      REAL     T(NY)     !* GRID POINTS OF TANGENT DIR. [UNIT:DEGREE]

      INTEGER NXZ
      PARAMETER (NXZ=10)
      INTEGER NYZ
      PARAMETER (NYZ=10)


      REAL     TRX(2,NXZ*NYZ,NXZ*NYZ)  !* STREAM LINE OF X-COORDINATE
      REAL     TRY(2,NXZ*NYZ,NXZ*NYZ)  !* STREAM LINE OF Y-COORDINATE
      INTEGER  NM(2,NXZ*NYZ)         !* ARRAY NUMBER IN EACH STREAM LINE
      REAL     X(NXZ), Y(NYZ)
      REAL     TMPU(NXZ,NYZ), TMPV(NXZ,NYZ)

      CALL TMZTLA( R, T, U, V, NX, NY ,TRX,TRY,NM,X,Y,TMPU,TMPV)

      END SUBROUTINE TMSTLA

