*-----------------------------------------------------------------------
*     UGPQNP / UGPQID / UGPQCP / UGPQVL / UGPSVL
*-----------------------------------------------------------------------
      SUBROUTINE UGPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA=37)
      PARAMETER (RUNDEF=-999)

      INTEGER   IX(NPARA)
      REAL      RX(NPARA)
      LOGICAL   LX(NPARA),LCHREQ,LFIRST
      CHARACTER CPARA(NPARA)*8,CMSG*80

      EQUIVALENCE (IX,RX,LX)

      EXTERNAL  LCHREQ,LENC

      SAVE

      DATA      CPARA( 1)/'INDEX   '/, IX( 1)/3/
      DATA      CPARA( 2)/'LNRMAL  '/, LX( 2)/.TRUE./
      DATA      CPARA( 3)/'LEQRAT  '/, LX( 3)/.TRUE./
      DATA      CPARA( 4)/'XFACT1  '/, RX( 4)/1.0/
      DATA      CPARA( 5)/'YFACT1  '/, RX( 5)/1.0/
      DATA      CPARA( 6)/'XFACT2  '/, RX( 6)/RUNDEF/
      DATA      CPARA( 7)/'YFACT2  '/, RX( 7)/RUNDEF/
      DATA      CPARA( 8)/'LMSG    '/, LX( 8)/.TRUE./
      DATA      CPARA( 9)/'ICENT   '/, IX( 9)/0/
      DATA      CPARA(10)/'LMISSP  '/, LX(10)/.FALSE./
      DATA      CPARA(11)/'ITYPE1  '/, IX(11)/5/
      DATA      CPARA(12)/'LSMALL  '/, LX(12)/.FALSE./
      DATA      CPARA(13)/'RSMALL  '/, RX(13)/0.001/
      DATA      CPARA(14)/'ITYPE2  '/, IX(14)/1/
      DATA      CPARA(15)/'RSIZEM  '/, RX(15)/0.01/
      DATA      CPARA(16)/'RSIZET  '/, RX(16)/RUNDEF/
      DATA      CPARA(17)/'XTTL    '/, RX(17)/0.0/
      DATA      CPARA(18)/'IXINT   '/, IX(18)/1/
      DATA      CPARA(19)/'IYINT   '/, IX(19)/1/

*     / PARAMETERS FOR UNIT VECTOR /

      DATA      CPARA(20)/'LUNIT   '/, LX(20)/.FALSE./
      DATA      CPARA(21)/'LUMSG   '/, LX(21)/.TRUE./
      DATA      CPARA(22)/'VXUOFF  '/, RX(22)/0.02/
      DATA      CPARA(23)/'VYUOFF  '/, RX(23)/0./
      DATA      CPARA(24)/'VXULOC  '/, RX(24)/RUNDEF/
      DATA      CPARA(25)/'VYULOC  '/, RX(25)/RUNDEF/
      DATA      CPARA(26)/'UXUNIT  '/, RX(26)/RUNDEF/
      DATA      CPARA(27)/'UYUNIT  '/, RX(27)/RUNDEF/
      DATA      CPARA(28)/'VXUNIT  '/, RX(28)/0.05/
      DATA      CPARA(29)/'VYUNIT  '/, RX(29)/0.05/

*     / PARAMETERS FOR TITLES OF UNIT VECTOR /

      DATA      CPARA(30)/'IUNTTL  '/, IX(30)/0/
      DATA      CPARA(31)/'RSIZEUT '/, RX(31)/RUNDEF/
      DATA      CPARA(32)/'IUINDX  '/, IX(32)/3/
      DATA      CPARA(33)/'IUTXRO  '/, IX(33)/0/
      DATA      CPARA(34)/'IUTYRO  '/, IX(34)/90/
      DATA      CPARA(35)/'VUTOFF  '/, RX(35)/0.005/
      DATA      CPARA(36)/'RHFACT  '/, RX(36)/1.5/
      DATA      CPARA(37)/'RUNDEF  '/, RX(37)/RUNDEF/

      DATA      LFIRST/.TRUE./


      NCP=NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY UGPQID(CP,IDX)

      DO 10 N=1,NPARA
        IF (LCHREQ(CP,CPARA(N))) THEN
          IDX=N
          RETURN
        END IF
   10 CONTINUE
      CMSG='PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','UGPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY UGPQCP(IDX,CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP=CPARA(IDX)
      ELSE
        CALL MSGDMP('E','UGPQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UGPQVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UG:',CPARA,IX,NPARA-1)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA=IX(IDX)
        IF ((IDX.EQ.16 .OR. IDX.EQ.31) .AND. RX(IDX).EQ.RUNDEF) THEN
          CALL UZRGET('RSIZEL1',IPARA)
        END IF
      ELSE
        CALL MSGDMP('E','UGPQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UGPSVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UG:',CPARA,IX,NPARA-1)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA-1) THEN
        IX(IDX)=IPARA
      ELSE
        CALL MSGDMP('E','UGPSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
      END
