*-----------------------------------------------------------------------
*     LOGICAL PARAMETER CONTROL
*-----------------------------------------------------------------------
      SUBROUTINE SWLQNP(NCP)

      LOGICAL   LPARA
      CHARACTER CP*(*)

      PARAMETER (NPARA = 9)

      LOGICAL   LX(NPARA)
      LOGICAL   LCHREQ, LFIRST
      CHARACTER CPARAS(NPARA)*8
      CHARACTER CPARAL(NPARA)*40
      CHARACTER CMSG*80

      EXTERNAL  LCHREQ,LENC

      SAVE

*     / SHORT NAME /

      DATA      CPARAS(1) / 'LWAIT   ' / , LX(1) / .TRUE. /
      DATA      CPARAS(2) / 'LWAIT0  ' / , LX(2) / .FALSE. /
      DATA      CPARAS(3) / 'LWAIT1  ' / , LX(3) / .TRUE. /
      DATA      CPARAS(4) / 'LKEY    ' / , LX(4) / .TRUE. /
      DATA      CPARAS(5) / 'LDUMP   ' / , LX(5) / .FALSE. /
      DATA      CPARAS(6) / 'LALT    ' / , LX(6) / .FALSE. /
      DATA      CPARAS(7) / 'LCOLOR  ' / , LX(7) / .TRUE. /
      DATA      CPARAS(8) / 'LSEP    ' / , LX(8) / .FALSE. /
      DATA      CPARAS(9) / 'LPRINT  ' / , LX(9) / .FALSE. /

*     / LONG NAME /

      DATA      CPARAL(1) / 'WAIT' /
      DATA      CPARAL(2) / 'WAIT_OPENING' /
      DATA      CPARAL(3) / 'WAIT_CLOSING' /
      DATA      CPARAL(4) / 'KEYCLICK' /
      DATA      CPARAL(5) / 'DUMP' /
      DATA      CPARAL(6) / 'ALTERNATE' /
      DATA      CPARAL(7) / 'ENABLE_COLOR_PS' /
      DATA      CPARAL(8) / 'SEPARATE' /
      DATA      CPARAL(9) / 'PRINT' /

      DATA      LFIRST / .TRUE. /


      NCP = NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWLQID(CP, IDX)

      DO 10 N = 1, NPARA
        IF (LCHREQ(CP, CPARAS(N)) .OR. LCHREQ(CP, CPARAL(N))) THEN
          IDX = N
          RETURN
        END IF
   10 CONTINUE
      CMSG = 'PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','SWLQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWLQCP(IDX, CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP = CPARAS(IDX)
      ELSE
        CALL MSGDMP('E','SWLQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWLQCL(IDX, CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP = CPARAL(IDX)
      ELSE
        CALL MSGDMP('E','SWLQCL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWLQVL(IDX, LPARA)

      IF (LFIRST) THEN
        CALL RTLGET('SW', CPARAS, LX, NPARA)
        CALL RLLGET(CPARAL, LX, NPARA)
        LFIRST = .FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        LPARA = LX(IDX)
      ELSE
        CALL MSGDMP('E','SWLQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWLSVL(IDX, LPARA)

      IF (LFIRST) THEN
        CALL RTLGET('SW', CPARAS, LX, NPARA)
        CALL RLLGET(CPARAL, LX, NPARA)
        LFIRST = .FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        LX(IDX) = LPARA
      ELSE
        CALL MSGDMP('E','SWLSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWLQIN(CP, IN)

      DO 20 N = 1, NPARA
        IF (LCHREQ(CP, CPARAS(N)) .OR. LCHREQ(CP, CPARAL(N))) THEN
          IN = N
          RETURN
        END IF
   20 CONTINUE

      IN = 0

      RETURN
      END
