*-----------------------------------------------------------------------
*     PARAMETER CONTROL (GENERIC)
*-----------------------------------------------------------------------
*     Copyright (C) 2000 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      SUBROUTINE SGPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA = 114)

      INTEGER   ITYPE(NPARA)
      CHARACTER CPARAS(NPARA)*8
      CHARACTER CPARAL(NPARA)*40
      CHARACTER CMSG*80

      LOGICAL   LCHREQ

      EXTERNAL  LCHREQ,LENC

      SAVE

*     / SHORT NAME /

      DATA      CPARAS(  1)/'RDX     '/, ITYPE(  1) / 3 /
      DATA      CPARAS(  2)/'RDY     '/, ITYPE(  2) / 3 /
      DATA      CPARAS(  3)/'LCLIP   '/, ITYPE(  3) / 2 /
      DATA      CPARAS(  4)/'LCHAR   '/, ITYPE(  4) / 2 /
      DATA      CPARAS(  5)/'LLNINT  '/, ITYPE(  5) / 2 /
      DATA      CPARAS(  6)/'LGCINT  '/, ITYPE(  6) / 2 /
      DATA      CPARAS(  7)/'LSOFTF  '/, ITYPE(  7) / 2 /
      DATA      CPARAS(  8)/'LCL2TN  '/, ITYPE(  8) / 2 /
      DATA      CPARAS(  9)/'IRMODE  '/, ITYPE(  9) / 1 /
      DATA      CPARAS( 10)/'BITLEN  '/, ITYPE( 10) / 3 /
      DATA      CPARAS( 11)/'MOVE    '/, ITYPE( 11) / 1 /
      DATA      CPARAS( 12)/'NBITS   '/, ITYPE( 12) / 1 /
      DATA      CPARAS( 13)/'LCNTL   '/, ITYPE( 13) / 2 /
      DATA      CPARAS( 14)/'SMALL   '/, ITYPE( 14) / 3 /
      DATA      CPARAS( 15)/'SHIFT   '/, ITYPE( 15) / 3 /
      DATA      CPARAS( 16)/'ISUP    '/, ITYPE( 16) / 1 /
      DATA      CPARAS( 17)/'ISUB    '/, ITYPE( 17) / 1 /
      DATA      CPARAS( 18)/'IRST    '/, ITYPE( 18) / 1 /
      DATA      CPARAS( 19)/'LFULL   '/, ITYPE( 19) / 2 /
      DATA      CPARAS( 20)/'PMFACT  '/, ITYPE( 20) / 3 /
      DATA      CPARAS( 21)/'NPMSKIP '/, ITYPE( 21) / 1 /
      DATA      CPARAS( 22)/'RFAROT  '/, ITYPE( 22) / 3 /
      DATA      CPARAS( 23)/'TNBLEN  '/, ITYPE( 23) / 3 /
      DATA      CPARAS( 24)/'IFONT   '/, ITYPE( 24) / 1 /
      DATA      CPARAS( 25)/'LFPROP  '/, ITYPE( 25) / 2 /
      DATA      CPARAS( 26)/'LROT    '/, ITYPE( 26) / 2 /
      DATA      CPARAS( 27)/'IROT    '/, ITYPE( 27) / 1 /
      DATA      CPARAS( 28)/'FWC     '/, ITYPE( 28) / 3 /
      DATA      CPARAS( 29)/'CWL     '/, ITYPE( 29) / 3 /
      DATA      CPARAS( 30)/'FFCT    '/, ITYPE( 30) / 3 /
      DATA      CPARAS( 31)/'INDEXC  '/, ITYPE( 31) / 1 /
      DATA      CPARAS( 32)/'LBUFF   '/, ITYPE( 32) / 2 /
      DATA      CPARAS( 33)/'NBUFF   '/, ITYPE( 33) / 1 /
      DATA      CPARAS( 34)/'RBUFF   '/, ITYPE( 34) / 3 /
      DATA      CPARAS( 35)/'LCURV   '/, ITYPE( 35) / 2 /
      DATA      CPARAS( 36)/'RCURV   '/, ITYPE( 36) / 3 /
      DATA      CPARAS( 37)/'LPROP   '/, ITYPE( 37) / 2 /
      DATA      CPARAS( 38)/'LUARW   '/, ITYPE( 38) / 2 /
      DATA      CPARAS( 39)/'AFACT   '/, ITYPE( 39) / 3 /
      DATA      CPARAS( 40)/'CONST   '/, ITYPE( 40) / 3 /
      DATA      CPARAS( 41)/'CONSTM  '/, ITYPE( 41) / 3 /
      DATA      CPARAS( 42)/'ANGLE   '/, ITYPE( 42) / 3 /
      DATA      CPARAS( 43)/'LARROW  '/, ITYPE( 43) / 2 /
      DATA      CPARAS( 44)/'LATONE  '/, ITYPE( 44) / 2 /
      DATA      CPARAS( 45)/'IATONE  '/, ITYPE( 45) / 1 /
      DATA      CPARAS( 46)/'IWS     '/, ITYPE( 46) / 1 /
      DATA      CPARAS( 47)/'ITR     '/, ITYPE( 47) / 1 /
      DATA      CPARAS( 48)/'VXMIN   '/, ITYPE( 48) / 3 /
      DATA      CPARAS( 49)/'VXMAX   '/, ITYPE( 49) / 3 /
      DATA      CPARAS( 50)/'VYMIN   '/, ITYPE( 50) / 3 /
      DATA      CPARAS( 51)/'VYMAX   '/, ITYPE( 51) / 3 /
      DATA      CPARAS( 52)/'UXMIN   '/, ITYPE( 52) / 3 /
      DATA      CPARAS( 53)/'UXMAX   '/, ITYPE( 53) / 3 /
      DATA      CPARAS( 54)/'UYMIN   '/, ITYPE( 54) / 3 /
      DATA      CPARAS( 55)/'UYMAX   '/, ITYPE( 55) / 3 /
      DATA      CPARAS( 56)/'VXOFF   '/, ITYPE( 56) / 3 /
      DATA      CPARAS( 57)/'VYOFF   '/, ITYPE( 57) / 3 /
      DATA      CPARAS( 58)/'PLX     '/, ITYPE( 58) / 3 /
      DATA      CPARAS( 59)/'PLY     '/, ITYPE( 59) / 3 /
      DATA      CPARAS( 60)/'PLROT   '/, ITYPE( 60) / 3 /
      DATA      CPARAS( 61)/'SIMFAC  '/, ITYPE( 61) / 3 /
      DATA      CPARAS( 62)/'STLAT1  '/, ITYPE( 62) / 3 /
      DATA      CPARAS( 63)/'STLAT2  '/, ITYPE( 63) / 3 /
      DATA      CPARAS( 64)/'TXMIN   '/, ITYPE( 64) / 3 /
      DATA      CPARAS( 65)/'TXMAX   '/, ITYPE( 65) / 3 /
      DATA      CPARAS( 66)/'TYMIN   '/, ITYPE( 66) / 3 /
      DATA      CPARAS( 67)/'TYMAX   '/, ITYPE( 67) / 3 /
      DATA      CPARAS( 68)/'RSAT    '/, ITYPE( 68) / 3 /
      DATA      CPARAS( 69)/'LDEG    '/, ITYPE( 69) / 2 /
      DATA      CPARAS( 70)/'NFRAME  '/, ITYPE( 70) / 1 /
      DATA      CPARAS( 71)/'NPAGE   '/, ITYPE( 71) / 1 /
      DATA      CPARAS( 72)/'NLEVEL  '/, ITYPE( 72) / 1 /
      DATA      CPARAS( 73)/'FACTOR  '/, ITYPE( 73) / 3 /
      DATA      CPARAS( 74)/'INDEX   '/, ITYPE( 74) / 1 /
      DATA      CPARAS( 75)/'LCORNER '/, ITYPE( 75) / 2 /
      DATA      CPARAS( 76)/'LTITLE  '/, ITYPE( 76) / 2 /
      DATA      CPARAS( 77)/'CORNER  '/, ITYPE( 77) / 3 /
      DATA      CPARAS( 78)/'XPAD    '/, ITYPE( 78) / 3 /
      DATA      CPARAS( 79)/'YPAD    '/, ITYPE( 79) / 3 /
      DATA      CPARAS( 80)/'LWIDE   '/, ITYPE( 80) / 2 /
      DATA      CPARAS( 81)/'ITR3    '/, ITYPE( 81) / 1 /
      DATA      CPARAS( 82)/'TILT3   '/, ITYPE( 82) / 3 /
      DATA      CPARAS( 83)/'ANGLE3  '/, ITYPE( 83) / 3 /
      DATA      CPARAS( 84)/'XOFF3   '/, ITYPE( 84) / 3 /
      DATA      CPARAS( 85)/'YOFF3   '/, ITYPE( 85) / 3 /
      DATA      CPARAS( 86)/'XOBJ3   '/, ITYPE( 86) / 3 /
      DATA      CPARAS( 87)/'YOBJ3   '/, ITYPE( 87) / 3 /
      DATA      CPARAS( 88)/'ZOBJ3   '/, ITYPE( 88) / 3 /
      DATA      CPARAS( 89)/'XEYE3   '/, ITYPE( 89) / 3 /
      DATA      CPARAS( 90)/'YEYE3   '/, ITYPE( 90) / 3 /
      DATA      CPARAS( 91)/'ZEYE3   '/, ITYPE( 91) / 3 /
      DATA      CPARAS( 92)/'IXC3    '/, ITYPE( 92) / 1 /
      DATA      CPARAS( 93)/'IYC3    '/, ITYPE( 93) / 1 /
      DATA      CPARAS( 94)/'SEC3    '/, ITYPE( 94) / 3 /
      DATA      CPARAS( 95)/'L2TO3   '/, ITYPE( 95) / 2 /
      DATA      CPARAS( 96)/'VXMIN3  '/, ITYPE( 96) / 3 /
      DATA      CPARAS( 97)/'VXMAX3  '/, ITYPE( 97) / 3 /
      DATA      CPARAS( 98)/'VYMIN3  '/, ITYPE( 98) / 3 /
      DATA      CPARAS( 99)/'VYMAX3  '/, ITYPE( 99) / 3 /
      DATA      CPARAS(100)/'VZMIN3  '/, ITYPE(100) / 3 /
      DATA      CPARAS(101)/'VZMAX3  '/, ITYPE(101) / 3 /
      DATA      CPARAS(102)/'UXMIN3  '/, ITYPE(102) / 3 /
      DATA      CPARAS(103)/'UXMAX3  '/, ITYPE(103) / 3 /
      DATA      CPARAS(104)/'UYMIN3  '/, ITYPE(104) / 3 /
      DATA      CPARAS(105)/'UYMAX3  '/, ITYPE(105) / 3 /
      DATA      CPARAS(106)/'UZMIN3  '/, ITYPE(106) / 3 /
      DATA      CPARAS(107)/'UZMAX3  '/, ITYPE(107) / 3 /
      DATA      CPARAS(108)/'VXORG3  '/, ITYPE(108) / 3 /
      DATA      CPARAS(109)/'VYORG3  '/, ITYPE(109) / 3 /
      DATA      CPARAS(110)/'VZORG3  '/, ITYPE(110) / 3 /
      DATA      CPARAS(111)/'SIMFAC3 '/, ITYPE(111) / 3 /
      DATA      CPARAS(112)/'LXLOG3  '/, ITYPE(112) / 2 /
      DATA      CPARAS(113)/'LYLOG3  '/, ITYPE(113) / 2 /
      DATA      CPARAS(114)/'LZLOG3  '/, ITYPE(114) / 2 /

*     / LONG  NAME /

      DATA      CPARAL(  1) / 'INTERPOLATION_ANGLE_X' /
      DATA      CPARAL(  2) / 'INTERPOLATION_ANGLE_Y' /
      DATA      CPARAL(  3) / 'ENABLE_CLIPING' /
      DATA      CPARAL(  4) / 'ENABLE_LINE_LABELING' /
      DATA      CPARAL(  5) / 'ENABLE_LINEAR_INTERPOLATION' /
      DATA      CPARAL(  6) / 'ENABLE_GREATCIRCLE_INTERPOLATION' /
      DATA      CPARAL(  7) / 'ENABLE_SOFTFILL' /
      DATA      CPARAL(  8) / 'ENABLE_COLOR_SUBSTITUTION' /
      DATA      CPARAL(  9) / 'BOUNDARY_DIRECTION' /
      DATA      CPARAL( 10) / 'LINE_CYCLE_LENGTH' /
      DATA      CPARAL( 11) / 'LINE_RESUME_MODE' /
      DATA      CPARAL( 12) / 'PATTERN_BIT_LENGTH' /
      DATA      CPARAL( 13) / 'ENABLE_CONTROL_CHAR' /
      DATA      CPARAL( 14) / 'SCRIPT_HEIGHT' /
      DATA      CPARAL( 15) / 'SCRIPT_SHIFT' /
      DATA      CPARAL( 16) / 'BEGIN_SUPERSCRIPT' /
      DATA      CPARAL( 17) / 'BEGIN_SUBSCRIPT' /
      DATA      CPARAL( 18) / 'END_SCRIPT' /
      DATA      CPARAL( 19) / 'USE_FULL_WINDOW' /
      DATA      CPARAL( 20) / 'POLIMARKER_HEIGHT' /
      DATA      CPARAL( 21) / 'POLIMARKER_INTERVAL' /
      DATA      CPARAL( 22) / '****RFAROT  ' /
      DATA      CPARAL( 23) / 'TONE_CYCLE_LENGTH' /
      DATA      CPARAL( 24) / '++++IFONT   ' /
      DATA      CPARAL( 25) / 'ENABLE_PROPORTINAL_FONT' /
      DATA      CPARAL( 26) / 'ENABLE_LINE_LABEL_ROTATION' /
      DATA      CPARAL( 27) / 'LINE_LABEL_ROTATION_ANGLE' /
      DATA      CPARAL( 28) / 'LINE_LABEL_SPACE' /
      DATA      CPARAL( 29) / 'LINE_CYCLE_LENGTH' /
      DATA      CPARAL( 30) / 'LINE_START_POSITION' /
      DATA      CPARAL( 31) / 'LABEL_CHAR_INDEX' /
      DATA      CPARAL( 32) / 'ENABLE_LINE_BUFFERING' /
      DATA      CPARAL( 33) / 'LINE_BUFFERING_LENGTH' /
      DATA      CPARAL( 34) / 'RESUME_POSITION_AFTER_BUFFERING' /
      DATA      CPARAL( 35) / 'DISABLE_LINE_LABEL_AT_CURVE' /
      DATA      CPARAL( 36) / 'LINE_LABEL_THRESHOLD_CURVATURE' /
      DATA      CPARAL( 37) / 'FIX_ARROWHEAD_PROPORTION' /
      DATA      CPARAL( 38) / 'ENABLE_ARROWHEAD_MAPPING' /
      DATA      CPARAL( 39) / 'ARROWHEAD_PROPOTION' /
      DATA      CPARAL( 40) / 'ARROWHEAD_SIZE' /
      DATA      CPARAL( 41) / 'ARROWHEAD_SIZE_MAP' /
      DATA      CPARAL( 42) / 'ARROWHEAD_ANGLE' /
      DATA      CPARAL( 43) / '----LARROW  ' /
      DATA      CPARAL( 44) / 'ENABLE_ARROWHEAD_SHADE' /
      DATA      CPARAL( 45) / 'ARROWHEAD_SHADE_PATTERN' /
      DATA      CPARAL( 46) / '++++IWS     ' /
      DATA      CPARAL( 47) / '++++ITR     ' /
      DATA      CPARAL( 48) / '++++VXMIN   ' /
      DATA      CPARAL( 49) / '++++VXMAX   ' /
      DATA      CPARAL( 50) / '++++VYMIN   ' /
      DATA      CPARAL( 51) / '++++VYMAX   ' /
      DATA      CPARAL( 52) / '++++UXMIN   ' /
      DATA      CPARAL( 53) / '++++UXMAX   ' /
      DATA      CPARAL( 54) / '++++UYMIN   ' /
      DATA      CPARAL( 55) / '++++UYMAX   ' /
      DATA      CPARAL( 56) / '++++VXOFF   ' /
      DATA      CPARAL( 57) / '++++VYOFF   ' /
      DATA      CPARAL( 58) / '++++PLX     ' /
      DATA      CPARAL( 59) / '++++PLY     ' /
      DATA      CPARAL( 60) / '++++PLROT   ' /
      DATA      CPARAL( 61) / '++++SIMFAC  ' /
      DATA      CPARAL( 62) / '++++STLAT1  ' /
      DATA      CPARAL( 63) / '++++STLAT2  ' /
      DATA      CPARAL( 64) / '++++TXMIN   ' /
      DATA      CPARAL( 65) / '++++TXMAX   ' /
      DATA      CPARAL( 66) / '++++TYMIN   ' /
      DATA      CPARAL( 67) / '++++TYMAX   ' /
      DATA      CPARAL( 68) / 'SATELLITE_ALTITUDE' /
      DATA      CPARAL( 69) / 'USE_DEGREE' /
      DATA      CPARAL( 70) / '****NFRAME  ' /
      DATA      CPARAL( 71) / '****NPAGE   ' /
      DATA      CPARAL( 72) / '****NLEVEL  ' /
      DATA      CPARAL( 73) / '****FACTOR  ' /
      DATA      CPARAL( 74) / 'CORNERMARK_INDEX' /
      DATA      CPARAL( 75) / 'DRAW_CORNERMARK' /
      DATA      CPARAL( 76) / 'DRAW_PAGE_TITLE' /
      DATA      CPARAL( 77) / 'CORNERMARK_LENGTH' /
      DATA      CPARAL( 78) / '****XPAD    ' /
      DATA      CPARAL( 79) / '****YPAD    ' /
      DATA      CPARAL( 80) / '****LWIDE   ' /
      DATA      CPARAL( 81) / '++++ITR3    ' /
      DATA      CPARAL( 82) / '++++TILT3   ' /
      DATA      CPARAL( 83) / '++++ANGLE3  ' /
      DATA      CPARAL( 84) / '++++XOFF3   ' /
      DATA      CPARAL( 85) / '++++YOFF3   ' /
      DATA      CPARAL( 86) / '++++XOBJ3   ' /
      DATA      CPARAL( 87) / '++++YOBJ3   ' /
      DATA      CPARAL( 88) / '++++ZOBJ3   ' /
      DATA      CPARAL( 89) / '++++XEYE3   ' /
      DATA      CPARAL( 90) / '++++YEYE3   ' /
      DATA      CPARAL( 91) / '++++ZEYE3   ' /
      DATA      CPARAL( 92) / '++++IXC3    ' /
      DATA      CPARAL( 93) / '++++IYC3    ' /
      DATA      CPARAL( 94) / '++++SEC3    ' /
      DATA      CPARAL( 95) / '****L2TO3   ' /
      DATA      CPARAL( 96) / '++++VXMIN3  ' /
      DATA      CPARAL( 97) / '++++VXMAX3  ' /
      DATA      CPARAL( 98) / '++++VYMIN3  ' /
      DATA      CPARAL( 99) / '++++VYMAX3  ' /
      DATA      CPARAL(100) / '++++VZMIN3  ' /
      DATA      CPARAL(101) / '++++VZMAX3  ' /
      DATA      CPARAL(102) / '++++UXMIN3  ' /
      DATA      CPARAL(103) / '++++UXMAX3  ' /
      DATA      CPARAL(104) / '++++UYMIN3  ' /
      DATA      CPARAL(105) / '++++UYMAX3  ' /
      DATA      CPARAL(106) / '++++UZMIN3  ' /
      DATA      CPARAL(107) / '++++UZMAX3  ' /
      DATA      CPARAL(108) / '++++VXORG3  ' /
      DATA      CPARAL(109) / '++++VYORG3  ' /
      DATA      CPARAL(110) / '++++VZORG3  ' /
      DATA      CPARAL(111) / '++++SIMFAC3 ' /
      DATA      CPARAL(112) / '++++LXLOG3  ' /
      DATA      CPARAL(113) / '++++LYLOG3  ' /
      DATA      CPARAL(114) / '++++LZLOG3  ' /


      NCP = NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGPQID(CP, IDX)

      DO 10 N = 1, NPARA
        IF (LCHREQ(CP, CPARAS(N)) .OR. LCHREQ(CP, CPARAL(N))) THEN
          IDX = N
          RETURN
        END IF
   10 CONTINUE
      CMSG = 'PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','SGPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGPQCP(IDX, CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP = CPARAS(IDX)
      ELSE
        CALL MSGDMP('E','SGPQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGPQCL(IDX, CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP = CPARAL(IDX)
      ELSE
        CALL MSGDMP('E','SGPQCL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGPQIT(IDX, ITP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        ITP = ITYPE(IDX)
      ELSE
        CALL MSGDMP('E','SGPQIT','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGPQVL(IDX, IPARA)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IF (ITYPE(IDX) .EQ. 1) THEN
          CALL SGIQID(CPARAS(IDX), ID)
          CALL SGIQVL(ID, IPARA)
        ELSE IF (ITYPE(IDX) .EQ. 2) THEN
          CALL SGLQID(CPARAS(IDX), ID)
          CALL SGLQVL(ID, IPARA)
        ELSE IF (ITYPE(IDX) .EQ. 3) THEN
          CALL SGRQID(CPARAS(IDX), ID)
          CALL SGRQVL(ID, IPARA)
        END IF
      ELSE
        CALL MSGDMP('E','SGPQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGPSVL(IDX, IPARA)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IF (ITYPE(IDX) .EQ. 1) THEN
          CALL SGIQID(CPARAS(IDX), ID)
          CALL SGISVL(ID, IPARA)
        ELSE IF (ITYPE(IDX) .EQ. 2) THEN
          CALL SGLQID(CPARAS(IDX), ID)
          CALL SGLSVL(ID, IPARA)
        ELSE IF (ITYPE(IDX) .EQ. 3) THEN
          CALL SGRQID(CPARAS(IDX), ID)
          CALL SGRSVL(ID, IPARA)
        END IF
      ELSE
        CALL MSGDMP('E','SGPSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGPQIN(CP, IN)

      DO 20 N = 1, NPARA
        IF (LCHREQ(CP, CPARAS(N)) .OR. LCHREQ(CP, CPARAL(N))) THEN
          IN = N
          RETURN
        END IF
   20 CONTINUE

      IN = 0

      RETURN
      END
