*-----------------------------------------------------------------------
*     Copyright (C) 2000 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      SUBROUTINE UETONC (Z,MX,NX,NY)

      REAL      Z(MX,*)

      PARAMETER (MAXPXL=1000)

      INTEGER   IMAGE(MAXPXL)
      LOGICAL   LIMC

      EXTERNAL  IUETON, IUWGX, IUWGY


*     / CHECK IMAGE CAPABILITY /

      CALL SWQIMC(LIMC)
      IF (.NOT.LIMC) THEN
        CALL MSGDMP('E','UETONC','NO IMAGE CAPABILITY.')
      END IF

*     / GET INTERNAL PARAMETERS /

      CALL GLRGET('RUNDEF  ',RUNDEF)
      CALL GLIGET('IUNDEF  ',IUNDEF)

*     / SET GRID ATTRIBUTE IF IT HAS NOT BEEN SET YET /

      CALL UWDFLT(NX, NY)

*     / CHECK Z VALUES AND TONE LEVEL /

      CALL UEZCHK(Z,MX,NX,NY,'UETONC',ISTAT)
      IF (ISTAT.NE.0) RETURN

*     / INITIALIZE /

      CALL SGQVPT(VXMIN, VXMAX, VYMIN, VYMAX)

      CALL STFPR2(VXMIN, VYMIN, RX, RY)
      CALL STFWTR(RX, RY, WX, WY)
      CALL SWFINT(WX, WY, IX1, IY1)

      CALL STFPR2(VXMAX, VYMAX, RX, RY)
      CALL STFWTR(RX, RY, WX, WY)
      CALL SWFINT(WX, WY, IX2, IY2)

      IWIDTH = ABS(IX1-IX2)+1
      IHIGHT = ABS(IY1-IY2)+1
      IXMIN  = MIN(IX1, IX2)
      IYMIN  = MIN(IY1, IY2)

      CALL SWIOPN(IXMIN, IYMIN, IWIDTH, IHIGHT)

*     / LOOP FOR EACH PIXEL /

      DO 30 J=1, IHIGHT

        DO 20 I=1, IWIDTH

          CALL SWIINT(I+IXMIN-1, J+IYMIN-1, WX, WY)
          CALL STIWTR(WX, WY, RX, RY)
          CALL STIPR2(RX, RY, VX, VY)
          CALL STITRF(VX, VY, UX, UY)

          IF (UX .EQ. RUNDEF) THEN
            IMAGE(I) = 0
          ELSE
            IX = IUWGX(UX)
            IY = IUWGY(UY)
            IF (IX.EQ.IUNDEF .OR. IY.EQ.IUNDEF) THEN
              IMAGE(I) = 0
            ELSE
              ZZ = Z(IX, IY)
              IMAGE(I) = IUETON(ZZ)/1000
            END IF
          END IF

   20   CONTINUE

        CALL SWIDAT(IMAGE, IWIDTH)

   30 CONTINUE

      CALL SWICLS

      END
