!= dyn_as83 ⥸塼Υƥȥץ
!
!= Test program for "dyn_as83"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dyn_as83_test.f90,v 1.12 2008-04-21 10:36:21 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! dyn_as83 ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "dyn_as83" module.
! Confirm compilation and execution of this program.
!

program dyn_as83_test
  use constants, only: CONST, Create, Get
  use dyn_as83, only: DYNAS83, Create, PutLine, Close, initialized, &
    & EqualAxes, GetAxes
  use dyn_spectral, only: DYNSP, Create, Close, PutLine, &
    & GetCoriolis, GetSpectralCoeff, GetDiffCoeff, GetPhis
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'dyn_as83_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "dyn_as83" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(CONST):: const_earth
  real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
  real(DP):: Omega      ! $ \Omega $ . ž®.     Angular velocity
  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  real(DP):: EpsV       ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
  integer:: VisOrder    ! ĶǴμ.  Order of hyper-viscosity
  real(DP):: EFoldTime  ! ȿФ e-folding time. E-folding time for maximum wavenumber

  type(DYNSP):: dyn_sp00
  type(DYNAS83):: dyn_as00, dyn_as01, dyn_as02, dyn_as03, dyn_as04
  type(DYNAS83):: dyn_as05, dyn_as06, dyn_as07, dyn_as08, dyn_as09
  type(DYNAS83):: dyn_as10, dyn_as11, dyn_as12, dyn_as13, dyn_as14
  real(DP):: DelTime
  real(DP), allocatable:: xy_Cori(:,:)
  integer, allocatable:: nmo(:,:,:)
  real(DP), allocatable:: wz_rn (:,:)
  real(DP), allocatable:: wz_DiffVorDiv (:,:)
  real(DP), allocatable:: wz_DiffTherm (:,:)
!  real(DP), allocatable:: wz_DiffVorDivWork (:,:)
!  real(DP), allocatable:: wz_DiffThermWork (:,:)
!  real(DP), allocatable:: w_Phis (:)

  real(DP), allocatable:: z_Sigma (:)
  real(DP), allocatable:: r_Sigma (:)

  logical:: err
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './dyn_as83_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  DelTime = 1800.0_DP

  call Get( constant = const_earth, &              ! (inout)
    & PI = PI, RPlanet = RPlanet, Grav = Grav, &   ! (out)
    & Omega = Omega, &                             ! (out)
    & Cp = Cp, RAir = RAir, EpsV = EpsV, &         ! (out)
    & VisOrder = VisOrder, EFoldTime = EFoldTime ) ! (out)

  !---------------------------------------------------------
  !  ڥȥǡν
  !  Prepare spectral data
  !---------------------------------------------------------
  call Create( dyn_sp = dyn_sp00, &                 ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 20, & ! (in)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, &  ! (in)
    & Cp = Cp, VisOrder = VisOrder, &               ! (in)
    & EFoldTime = EFoldTime, &                      ! (in)
    & DelTime = DelTime )                           ! (in)
  if ( allocated(xy_Cori) ) deallocate(xy_Cori)
  allocate( xy_Cori(0:63, 0:31) )
  call GetCoriolis( dyn_sp = dyn_sp00, &  ! (inout)
    & xy_Cori = xy_Cori ) ! (out)
  if ( allocated(nmo) ) deallocate(nmo)
  allocate( nmo(1:2, 0:21, 0:21) )
  if ( allocated(wz_rn) ) deallocate(wz_rn)
  allocate( wz_rn(22**2, 0:19) )
  call GetSpectralCoeff( dyn_sp = dyn_sp00, &  ! (inout)
    & nmo = nmo, wz_rn = wz_rn ) ! (out)
  if ( allocated(wz_DiffVorDiv) ) deallocate(wz_DiffVorDiv)
  allocate( wz_DiffVorDiv(22**2, 0:19) )
  if ( allocated(wz_DiffTherm) ) deallocate(wz_DiffTherm)
  allocate( wz_DiffTherm(22**2, 0:19) )
  call GetDiffCoeff( dyn_sp = dyn_sp00, &  ! (inout)
    & wz_DiffVorDiv = wz_DiffVorDiv, wz_DiffTherm = wz_DiffTherm ) ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( dyn_as00, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 12, & ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:11), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:11), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:11) )         ! (in)

  call PutLine( dyn_as00 ) ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(dyn_as00) )

  err = .false.
  call Create( dyn_as00, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 12, & ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:11), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:11), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:11), &        ! (in)
    & err = err)                                    ! (out)

  call AssertEqual( 'initialization test 2', &
    & answer = .true., check = err )

  !---------------------------------------------------------
  !  ʰ˴ؤƤΥƥ
  !  Invalid argument test
  !---------------------------------------------------------
  err = .false.
  call Create( dyn_as02, &                          ! (inout)
    & nmax = 0, imax = 64, jmax = 32, kmax = 12, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:11), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:11), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:11), &        ! (in)
    & err = err)                                    ! (out)

  call AssertEqual( 'invalid argument test 2', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_as03, &                          ! (inout)
    & nmax = 21, imax = 0, jmax = 32, kmax = 12, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:11), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:11), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:11), &        ! (in)
    & err = err)                                    ! (out)


  call AssertEqual( 'invalid argument test 3', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_as04, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 0, kmax = 12, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:11), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:11), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:11), &        ! (in)
    & err = err)                                    ! (out)

  call AssertEqual( 'invalid argument test 4', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_as05, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 0, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:0), &            ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:0), &       ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:0), &         ! (in)
    & err = err)                                    ! (out)

  call AssertEqual( 'invalid argument test 5', &
    & answer = .true., check = err )


  !---------------------------------------------------------
  !  ľưƥ
  !  Vertical dimension auto setting test
  !---------------------------------------------------------
  err = .false.
  call Create( dyn_as06, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 10, & ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:9), &            ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:9), &       ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:9), &         ! (in)
    & err = err)                                    ! (out)

  call AssertEqual( 'vertical dimension auto setting test 1', &
    & answer = .true., check = err )

  err = .false.
  call Create( dyn_as07, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 2, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:1), &            ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:1), &       ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:1) )          ! (in)

  call AssertEqual( 'vertical dimension auto setting test 2', &
    & answer = .true., check = initialized(dyn_as07) )

  err = .false.
  call Create( dyn_as08, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 12, & ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:11), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:11), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:11) )         ! (in)

  call AssertEqual( 'vertical dimension auto setting test 3', &
    & answer = .true., check = initialized(dyn_as08) )

  err = .false.
  call Create( dyn_as09, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 16, & ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:15), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:15), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:15) )         ! (in)

  call AssertEqual( 'vertical dimension auto setting test 4', &
    & answer = .true., check = initialized(dyn_as09) )

  err = .false.
  call Create( dyn_as10, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 20, & ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:19), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:19), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:19) )         ! (in)

  call AssertEqual( 'vertical dimension auto setting test 5', &
    & answer = .true., check = initialized(dyn_as10) )

  err = .false.
  call Create( dyn_as11, &                                 ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 3, &         ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &               ! (in)
    & RAir = RAir, EpsV = EpsV, &                          ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &              ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:2), &                   ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:2), &              ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:2), &                ! (in)
    & r_SigmaSet = (/1.0_DP, 0.75_DP, 0.40_DP, 0.0_DP/) )  ! (in)

  call AssertEqual( 'vertical dimension manual setting test 1', &
    & answer = .true., check = initialized(dyn_as11) )

  err = .false.
  call Create( dyn_as12, &                                 ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 4, &         ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &               ! (in)
    & RAir = RAir, EpsV = EpsV, &                          ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &              ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:3), &                   ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:3), &              ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:3), &                ! (in)
    & r_SigmaSet = (/1.0_DP, 0.75_DP, 0.40_DP, 0.0_DP/), & ! (in)
    & err = err)                                           ! (out)

  call AssertEqual( 'vertical dimension manual setting test 2', &
    & answer = .true., check = err)

  err = .false.
  call Create( dyn_as13, &                                 ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 8, &         ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &               ! (in)
    & RAir = RAir, EpsV = EpsV, &                          ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &              ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:3), &                   ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:3), &              ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:3), &                ! (in)
    & nmlfile = VAL_namelist )                             ! (in)

  call AssertEqual( 'vertical dimension NAMELIST setting test 1', &
    & answer = .true., check = initialized(dyn_as13) )

  !---------------------------------------------------------
  !  ľʬΥƥ
  !  Coefficients for vertical difference test
  !---------------------------------------------------------
  err = .false.
  call Create( dyn_as12, &                          ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 2, &  ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &        ! (in)
    & RAir = RAir, EpsV = EpsV, &                   ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &       ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:1), &            ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:1), &       ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:1), &         ! (in)
    & r_SigmaSet = (/1.0_DP, 0.50_DP, 0.0_DP/) )    ! (in)

  call AssertGreaterThan( 'coefficient Alpha in hydrostatic equation test 1', &
    & answer = (/8.99017939586975E-02_DP, 0.2857256619550060_DP/), &
    & check = dyn_as12 % z_HydroAlpha )

  call AssertLessThan( 'coefficient Alpha in hydrostatic equation test 2', &
    & answer = (/8.990179395869798E-02_DP, 0.2857256619550080_DP/), &
    & check = dyn_as12 % z_HydroAlpha )

  call AssertGreaterThan( 'coefficient Beta in hydrostatic equation test 1', &
    & answer = (/0.105922074037610_DP, 0.999999999999999_DP/), &
    & check = dyn_as12 % z_HydroBeta )

  call AssertLessThan( 'coefficient Beta in hydrostatic equation test 2', &
    & answer = (/0.1059220740376119_DP, 1.000000000000001_DP/), &
    & check = dyn_as12 % z_HydroBeta )

  call AssertGreaterThan( 'coefficient Kappa for vertical interpolation of temperature test 1', &
    & answer = (/0.2857256619550071_DP, 0.2857256619550070_DP/) - 1.0e-15_DP, &
    & check = dyn_as12 % z_TempInpolKappa )

  call AssertLessThan( 'coefficient Kappa for vertical interpolation of temperature test 2', &
    & answer = (/0.2857256619550071_DP, 0.2857256619550070_DP/) + 1.0e-15_DP, &
    & check = dyn_as12 % z_TempInpolKappa )

  call AssertGreaterThan( 'coefficient A for vertical interpolation of temperature test 1', &
    & answer = (/0.000000000000000E+00_DP, 0.9379980581875695_DP/) - 1.0e-15_DP, &
    & check = dyn_as12 % z_TempInpolA )

  call AssertLessThan( 'coefficient A for vertical interpolation of temperature test 2', &
    & answer = (/0.000000000000000E+00_DP, 0.9379980581875695_DP/) + 1.0e-15_DP, &
    & check = dyn_as12 % z_TempInpolA )

  call AssertGreaterThan( 'coefficient B for vertical interpolation of temperature test 1', &
    & answer = (/0.2418055297298259_DP, 0.000000000000000E+00_DP/) - 1.0e-15_DP, &
    & check = dyn_as12 % z_TempInpolB )

  call AssertLessThan( 'coefficient B for vertical interpolation of temperature test 2', &
    & answer = (/0.2418055297298259_DP, 0.000000000000000E+00_DP/) + 1.0e-15_DP, &
    & check = dyn_as12 % z_TempInpolB )


  !---------------------------------------------------------
  !  ߥץꥷåȹΥƥ
  !  Semi-implicit matrices test
  !---------------------------------------------------------
  call AssertGreaterThan( 'Semi-implicit matrix G test 1', &
    & answer = (/86112.00000000006_DP, 86112.00000000003_DP/) - 2.0e-10_DP, &
    & check = dyn_as12 % z_siMtxG )

  call AssertLessThan( 'Semi-implicit matrix G test 2', &
    & answer = (/86112.00000000006_DP, 86112.00000000003_DP/) + 1.0e-10_DP, &
    & check = dyn_as12 % z_siMtxG )

  call AssertGreaterThan( 'Semi-implicit matrix h test 1', &
    & answer = &
    &  reshape((/   0.000000000000_DP, 26.97053818760929_DP, &
    &            85.71769858650207_DP, 58.74716039889282_DP/) - 1.0e-13_DP, &
    &          (/2,2/)), &
    & check = dyn_as12 % zz_siMtxH, negative_support=.false. )

  call AssertLessThan( 'Semi-implicit matrix h test 2', &
    & answer = &
    &  reshape((/   0.000000000000_DP, 26.97053818760929_DP, &
    &            85.71769858650207_DP, 58.74716039889282_DP/) + 1.0e-13_DP, &
    &          (/2,2/)), &
    & check = dyn_as12 % zz_siMtxH )

  call AssertGreaterThan( 'Semi-implicit matrix Wh test 1', &
    & answer = &
    &  reshape((/   0.000000000000_DP, 7741.623281371381_DP, &
    &            7741.623281371375_DP, 33725.56984179635_DP/) - 1.0e-10_DP, &
    &          (/2,2/)), &
    & check = dyn_as12 % zz_siMtxWH, negative_support=.false. )

  call AssertLessThan( 'Semi-implicit matrix Wh test 2', &
    & answer = &
    &  reshape((/   0.000000000000_DP, 7741.623281371381_DP, &
    &            7741.623281371375_DP, 33725.56984179635_DP/) + 1.0e-10_DP, &
    &          (/2,2/)), &
    & check = dyn_as12 % zz_siMtxWH )

  call AssertGreaterThan( 'Semi-implicit matrix GC^{T} test 1', &
    & answer = &
    &  reshape((/43056.00000000003_DP, 43056.00000000001_DP, &
    &            43056.00000000003_DP, 43056.00000000001_DP/) - 1.0e-10_DP, &
    &          (/2,2/)), &
    & check = dyn_as12 % zz_siMtxGCt )

  call AssertLessThan( 'Semi-implicit matrix GC^{T} test 2', &
    & answer = &
    &  reshape((/43056.00000000003_DP, 43056.00000000001_DP, &
    &            43056.00000000003_DP, 43056.00000000001_DP/) + 1.0e-10_DP, &
    &          (/2,2/)), &
    & check = dyn_as12 % zz_siMtxGCt )

  !---------------------------------------------------------
  !  EqualAxes ƥ
  !  "EqualAxes" test
  !---------------------------------------------------------
  allocate( z_Sigma (0:7) )
  allocate( r_Sigma (0:8) )

  r_Sigma = (/1.00_DP, 0.94_DP, 0.86_DP, 0.76_DP, 0.64_DP, &
    &         0.50_DP, 0.34_DP, 0.15_DP, 0.00_DP/)
  z_Sigma = (/0.9698895_DP, 0.8997882_DP, 0.8096323_DP, 0.6993869_DP, &
    &         0.5689736_DP, 0.4181732_DP, 0.2404809_DP, 0.06224255_DP/)

  call Create( dyn_as = dyn_as14, &                ! (inout)
    & nmax = 21, imax = 64, jmax = 32, kmax = 8, & ! (in)
    & PI = PI, RPlanet = RPlanet, Cp = Cp, &       ! (in)
    & RAir = RAir, EpsV = EpsV, &                  ! (in)
    & DelTime = DelTime, xy_Cori = xy_Cori, &      ! (in)
    & nmo = nmo, wz_rn = wz_rn(:,0:7), &           ! (in)
    & wz_DiffVorDiv = wz_DiffVorDiv(:,0:7), &      ! (in)
    & wz_DiffTherm = wz_DiffTherm(:,0:7), &        ! (in)
    & r_SigmaSet = r_Sigma )                       ! (in)

  call EqualAxes( dyn_as14, & ! (inout)
    & z_Sigma = z_Sigma, &    ! (in)
    & err = err )             ! (out)

  call AssertEqual( '"EqualAxes" test 1', &
    & answer = .false., check = err )

  call EqualAxes( dyn_as14, & ! (inout)
    & r_Sigma = r_Sigma, &    ! (in)
    & err = err )             ! (out)

  call AssertEqual( '"EqualAxes" test 2', &
    & answer = .false., check = err )

end program dyn_as83_test
