!= phy_implicit ⥸塼Υƥȥץ
!
!= Test program for "phy_implicit"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_implicit_test.f90,v 1.3 2007-09-26 15:55:26 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_implicit ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_implicit" module.
! Confirm compilation and execution of this program.
!

program phy_implicit_test
  use phy_implicit, only: PHYIMPL, Create, Close, &
    & PutLine, initialized, GetMatrices, Integrate
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_implicit_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "phy_implicit" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 32
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 16
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 12
                              ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
  real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: xy_SurfHeatCapacity (0:imax-1, 0:jmax-1)
                              ! ɽǮ. 
                              ! Surface heat capacity
  integer:: xy_SurfCondition (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface condition
  real(DP):: xy_GroundTempFlux (0:imax-1, 0:jmax-1)
                              ! Ǯեå. 
                              ! Ground temperature flux

  real(DP):: xyr_Press (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP):: xyr_UFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ®եå. 
                              ! Zonal wind flux
  real(DP):: xyr_VFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ®եå. 
                              ! Meridional wind flux
  real(DP):: xyr_TempFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
  real(DP):: xyr_QvapFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
  real(DP):: xy_SurfUVMatrix (0:imax-1, 0:jmax-1)
                              !  ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
  real(DP):: xyaa_SurfTempMatrix (0:imax-1, 0:jmax-1, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
  real(DP):: xyaa_SurfQvapMatrix (0:imax-1, 0:jmax-1, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface
  real(DP):: xy_SurfRadSFlux (0:imax-1, 0:jmax-1)
                              ! ͥեå (ɽ). 
                              ! Insolation flux on surface
  real(DP):: xy_SurfRadLFlux (0:imax-1, 0:jmax-1)
                              ! Ĺȥեå (ɽ). 
                              ! Long wave flux on surface
  real(DP):: xyza_UVMatrix (0:imax-1, 0:jmax-1, 0:kmax-1, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
  real(DP):: xyza_TempMatrix  (0:imax-1, 0:jmax-1, -1:kmax-1, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
  real(DP):: xyza_QvapMatrix (0:imax-1, 0:jmax-1, 0:kmax-1, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity
  real(DP):: xya_SurfRadLMatrix (0:imax-1, 0:jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface

  real(DP):: xyz_DVerdiffUDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ʬ ľȻ®. 
                              ! Zonal acceleration by vertical diffusion
  real(DP):: xyz_DVerdiffVDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ʬ ľȻ®. 
                              ! Meridional acceleration by vertical diffusion
  real(DP):: xyz_DVerdiffTempDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ľȻǮΨ. 
                              ! Temperature tendency by vertical diffusion
  real(DP):: xy_DVerdiffSurfTempDt (0:imax-1, 0:jmax-1)
                              ! ɽ ľȻǮΨ. 
                              ! Surface temperature tendency by vertical diffusion
  real(DP):: xyz_DVerdiffQvapDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ľȻüΨ. 
                              ! Specific humidity tendency by vertical diffusion

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYIMPL):: phy_impl00, phy_impl01, phy_impl02, phy_impl03
  logical:: err
  character(*), parameter:: subname = 'phy_implicit_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_implicit_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  DelTime = 600.0_DP

  call Get( constant = const_earth, &      ! (inout)
    & Grav = Grav, Cp = Cp, &              ! (out)
    & EL = EL )                            ! (out)

  !---------------------------------------------------------
  !  ɽ̥ǡν
  !  Prepare surface data
  !---------------------------------------------------------
  xy_SurfHeatCapacity = 0.0_DP
  xy_SurfCondition = 0
  xy_GroundTempFlux = 0.0_DP

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_impl = phy_impl00, &              ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, &       ! (in)
    & Grav = Grav, Cp = Cp, EL = EL, &               ! (in)
    & DelTime = DelTime, &                           ! (in)
    & xy_SurfHeatCapacity = xy_SurfHeatCapacity, &   ! (in)
    & xy_SurfCondition = xy_SurfCondition, &         ! (in)
    & xy_GroundTempFlux = xy_GroundTempFlux )        ! (in) 
  call PutLine( phy_impl = phy_impl00 ) ! (in)

  !---------------------------------------------------------
  !  GetMatrices ƥ
  !  GetMatrices test
  !---------------------------------------------------------
  call HistoryGet( &
    & file = 'phy_implicit_test00.nc', & ! (in)
    & varname = 'PressM', &                 ! (in)
    & array = xyr_Press )                   ! (out)

  call GetMatrices( phy_impl = phy_impl00, &                      ! (inout)
    & xyr_Press = xyr_Press, &                                    ! (in)
    & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &             ! (out)
    & xyr_TempFlux = xyr_TempFlux, xyr_QVapFlux = xyr_QVapFlux, & ! (out)
    & xyza_UVMatrix = xyza_UVMatrix, &                            ! (out)
    & xyza_TempMatrix = xyza_TempMatrix, &                        ! (out)
    & xyza_QVapMatrix = xyza_QVapMatrix )                         ! (out)

  call PutLine( xyr_UFlux, indent = ' xyr_UFlux=' )
  call PutLine( xyr_VFlux, indent = ' xyr_VFlux=' )
  call PutLine( xyr_TempFlux, indent = ' xyr_TempFlux=' )
  call PutLine( xyr_QVapFlux, indent = ' xyr_QVapFlux=' )
  call PutLine( xyza_UVMatrix, indent = ' xyza_UVMatrix=' )
  call PutLine( xyza_TempMatrix, indent = ' xyza_TempMatrix=' )
  call PutLine( xyza_QVapMatrix, indent = ' xyza_QVapMatrix=' )

  !---------------------------------------------------------
  !  Integrate ƥ
  !  Integrate test
  !---------------------------------------------------------
  xy_SurfRadSFlux     = 0.0_DP
  xy_SurfRadLFlux     = 0.0_DP
  xy_SurfUVMatrix     = 0.0_DP
  xyaa_SurfTempMatrix = 0.0_DP
  xyaa_SurfQVapMatrix = 0.0_DP
  xya_SurfRadLMatrix  = 0.0_DP

  call Integrate( phy_impl = phy_impl00, &               ! (inout)
    & xyr_UFlux = xyr_UFlux, xyr_VFlux = xyr_VFlux, &    ! (in)
    & xyr_TempFlux = xyr_TempFlux, &                     ! (in)
    & xy_SurfRadSFlux = xy_SurfRadSFlux, &               ! (in)
    & xy_SurfRadLFlux = xy_SurfRadLFlux, &               ! (in)
    & xyr_QVapFlux = xyr_QVapFlux, &                     ! (in)
    & xyza_UVMatrix = xyza_UVMatrix, &                   ! (in)
    & xyza_TempMatrix = xyza_TempMatrix, &               ! (in)
    & xyza_QVapMatrix = xyza_QVapMatrix, &               ! (in)
    & xy_SurfUVMatrix = xy_SurfUVMatrix, &               ! (in)
    & xyaa_SurfTempMatrix = xyaa_SurfTempMatrix, &       ! (in)
    & xyaa_SurfQVapMatrix = xyaa_SurfQVapMatrix, &       ! (in)
    & xya_SurfRadLMatrix = xya_SurfRadLMatrix, &         ! (in)
    & xyz_DVerdiffUDt = xyz_DVerdiffUDt, &               ! (out)
    & xyz_DVerdiffVDt = xyz_DVerdiffVDt, &               ! (out)
    & xyz_DVerdiffTempDt = xyz_DVerdiffTempDt, &         ! (out)
    & xy_DVerdiffSurfTempDt = xy_DVerdiffSurfTempDt, &   ! (out)
    & xyz_DVerdiffQVapDt = xyz_DVerdiffQVapDt )          ! (out)

  call PutLine( xyz_DVerdiffUDt, indent = ' xyz_DVerdiffUDt=' )
  call PutLine( xyz_DVerdiffVDt, indent = ' xyz_DVerdiffVDt=' )
  call PutLine( xyz_DVerdiffTempDt, indent = ' xyz_DVerdiffTempDt=' )
  call PutLine( xy_DVerdiffSurfTempDt, indent = ' xy_DVerdiffSurfTempDt=' )
  call PutLine( xyz_DVerdiffQVapDt, indent = ' xyz_DVerdiffQVapDt=' )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_impl = phy_impl00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_impl00) )
  call PutLine( phy_impl = phy_impl00 ) ! (in)

  call Close( phy_impl = phy_impl02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program phy_implicit_test
