!= phy_interpolate_test  netCDF եץ
!
!= NetCDF file generation program for "phy_interpolate_test"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: phy_interpolate_test_prepnc00.f90,v 1.2 2007-09-22 22:23:21 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_interpolate_test ǻѤ netCDF ե볫ȯ
! ץǤ. 
!
! This is a program for developers that generates 
! netCDF data for "phy_interpolate_test"
!

program phy_interpolate_test_prepnc00
  use spline_data, only: SPLDAT, Create, Close, &
    & PutLine, initialized, GetSpline
  use constants, only: CONST, Create, Get
  use phy_interpolate, only: PHYINTPOL, Create, Close, &
    & PutLine, initialized, InterpolateTemp, InterpolateGeoPot
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: GT_HISTORY, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
    & HistoryAddAttr
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_interpolate_test_prepnc00 $Name: dcpam4-20080427 $ :: ' // &
    & 'NetCDF file generation program for "phy_interpolate_test"'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: nmax = 10         ! ȿ. 
                              ! Maximum truncated wavenumber
  integer:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer:: kmax = 12         ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants
  !-----------------------------------------------------------------
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), allocatable:: x_Lon (:) ! . Longitude
  real(DP), allocatable:: y_Lat (:) ! . Latitude
  real(DP), allocatable:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), allocatable:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
  real(DP), allocatable:: y_Temp (:)
                              ! $ T $ . 
                              ! Temperature
  real(DP), allocatable:: z_TempCoeff (:)
                              ! ٤η
                              ! Temperature coefficient
!!$  real(DP), allocatable:: xyr_Temp (:,:,:)
!!$                              ! $ T $ .  (Ⱦ٥). 
!!$                              ! Temperature (half level)
!!$
  real(DP), allocatable:: y_Ps (:)
                              ! $ P_s $ .   ɽ̵. Surface pressure
  real(DP), allocatable:: xy_Ps (:,:)
                              ! $ P_s $ .   ɽ̵. Surface pressure
!!$  real(DP), allocatable:: xyz_Press (:,:,:)
!!$                              ! $ P_s $ . ɽ̵ (٥). 
!!$                              ! Surface pressure (full level)
!!$  real(DP), allocatable:: xyr_Press (:,:,:)
!!$                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
!!$                              ! Surface pressure (half level)
!!$  real(DP), allocatable:: xyz_GeoPot (:,:,:)
!!$                              ! $ \phi $ . ݥƥ󥷥 (٥). 
!!$                              ! Geo-potential (full level)
!!$  real(DP), allocatable:: xyr_GeoPot (:,:,:)
!!$                              ! $ \phi $ . ݥƥ󥷥 (Ⱦ٥). 
!!$                              ! Geo-potential (half level)

  !---------------------------------------------------------
  !  ǡ
  !  Data I/O
  !---------------------------------------------------------
  type(GT_HISTORY):: gthist
  character(STRING):: default_output_file = 'phy_interpolate_test00.nc'
  character(STRING):: output_file

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_output        ! -o, --output ץ̵ͭ. 
                              ! Existence of '-o', '--output' option
  character(STRING):: VAL_output
                              ! -o, --output ץ. 
                              ! Value of '-o', '--output' option

  integer:: i, j, k         ! DO 롼Ѻѿ
                            ! Work variables for DO loop


  type(CONST):: const_earth
  type(SPLDAT):: spl_dat_ps, spl_dat_tempy, spl_dat_tempz
  real(DP):: PI  ! $ \pi $ .    ߼Ψ.         Circular constant
  type(PHYINTPOL):: phy_intpol00
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_interpolate_test_prepnc00 [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-o', '--output'), &
    & OPT_output, VAL_output, &
    & help = 'Output filename (default: ' // trim(default_output_file) // ' )' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  if ( VAL_output == '' ) then
    output_file = default_output_file
  else
    output_file = VAL_output
  end if

  !---------------------------------------------------------
  !  ʪ
  !  Configure a physical constant
  !---------------------------------------------------------
  call Create( constant = const_earth )   ! (inout)
  call Get( constant = const_earth, &     ! (inout)
    & PI = PI, RAir = RAir, Grav = Grav ) ! (out)

  !---------------------------------------------------------
  !  ǡ
  !  Configure axes data
  !---------------------------------------------------------
  allocate( x_Lon (0:imax-1) )
  allocate( y_Lat (0:jmax-1) )
  allocate( z_Sigma (0:kmax-1) )
  allocate( r_Sigma (0:kmax) )

  x_Lon = &
    & (/  0.0,   11.25,  22.5,   33.75,  45.0,  56.25,  67.5,   78.75, &
    &    90.0,  101.25, 112.5,  123.75, 135.0, 146.25, 157.5,  168.75, &
    &   180.0,  191.25, 202.5,  213.75, 225.0, 236.25, 247.5,  258.75, &
    &   270.0,  281.25, 292.5,  303.75, 315.0, 326.25, 337.5,  348.75 /)

  y_Lat = &
    & (/ -81.65059, -70.83464, -59.95486, -49.06072, &
    &    -38.16121, -27.25921, -16.35593,  -5.45204, &
    &      5.45204,  16.35593,  27.25921,  38.16121, &
    &     49.06072,  59.95486,  70.83464,  81.65059 /)

  z_Sigma = &
    & (/ 0.994997,  0.9799879, 0.9499499,  0.8897859, &
    &    0.7996277, 0.689378,  0.5641075,  0.4286365, &
    &    0.2879657, 0.1572454, 0.07398598, 0.02074752 /)

  r_Sigma = &
    & (/ 1.0,  0.99, 0.97, 0.93, 0.85, 0.75, &
    &    0.63, 0.5,  0.36, 0.22, 0.1,  0.05, 0.0 /)

!!$  !---------------------------------------------------------
!!$  !  
!!$  !  Initialization
!!$  !---------------------------------------------------------
!!$  call Create( phy_intpol = phy_intpol00, & ! (inout)
!!$    & nmax = nmax, imax = imax, jmax = jmax, & ! (in)
!!$    & z_Sigma, r_Sigma, &
!!$    & PI = PI ) ! (in)
!!$

  !---------------------------------------------------------
  !  ɽ̵
  !  Configure surface pressure
  !---------------------------------------------------------
  call Create( spl_dat = spl_dat_ps, & ! (inout)
    & knots_num = 13, &
    & x_knots = &
    &   (/ -90.0_DP, -75.0_DP, -60.0_DP, -45.0_DP, -30.0_DP, -15.0_DP, &
    &        0.0_DP,  15.0_DP,  30.0_DP,  45.0_DP,  60.0_DP,  75.0_DP, &
    &       90.0_DP /), &             ! (in)
    & x_value = &
    &   (/ 1003.0_DP, 997.0_DP,  990.0_DP, 994.0_DP, 1005.0_DP, 998.0_DP, &
    &       996.0_DP, 998.0_DP, 1006.0_DP, 998.0_DP,  987.0_DP, 996.0_DP, &
    &       998.0_DP /) * 100.0_DP )  ! (in)

  allocate( xy_Ps (0:imax-1, 0:jmax-1) )
  allocate( y_Ps (0:jmax-1) )

  call GetSpline( spl_dat = spl_dat_ps , &
    & a_Dim = y_Lat, &  ! (in)
    & a_Data = y_Ps )   ! (out)

  do i = 0, imax - 1
    xy_Ps(i,:) = y_Ps
  end do

  !---------------------------------------------------------
  !  ٤
  !  Configure temperature
  !---------------------------------------------------------
  allocate( xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( y_Temp (0:jmax-1) )
  allocate( z_TempCoeff (0:kmax-1) )

  call Create( spl_dat = spl_dat_tempy, & ! (inout)
    & knots_num = 7, &
    & x_knots = &
    &   (/ -90.0_DP, -60.0_DP, -30.0_DP, &
    &        0.0_DP,  30.0_DP,  60.0_DP, 90.0_DP /), &             ! (in)
    & x_value = &
    &   (/  255.0_DP, 270.0_DP, 290.0_DP, &
    &       300.0_DP, 290.0_DP, 270.0_DP, 255.0_DP /) )  ! (in)

  call GetSpline( spl_dat = spl_dat_tempy , &
    & a_Dim = y_Lat, &    ! (in)
    & a_Data = y_Temp )   ! (out)

  call PutLine(y_Temp, indent=' y_Temp=')


  call Create( spl_dat = spl_dat_tempz, & ! (inout)
    & knots_num = 3, &
    & x_knots = &
    &   (/  1.0_DP, 0.5_DP, 0.0_DP /), &   ! (in)
    & x_value = &
    &   (/  1.0_DP, 0.85_DP, 0.75_DP /) )  ! (in)

  call GetSpline( spl_dat = spl_dat_tempz , &
    & a_Dim = z_Sigma, &      ! (in)
    & a_Data = z_TempCoeff )  ! (out)

  call PutLine(z_TempCoeff, indent=' z_TempCoeff=')

  do k = 0, kmax - 1
    do j = 0, jmax - 1
      xyz_Temp(:,j,k) = y_Temp(j) * z_TempCoeff(k)
    end do
  end do

  !----------------------------------------------------------------
  !  ǡ
  !  Output data
  !----------------------------------------------------------------
  call HistoryCreate( &
    & history = gthist, &                            ! (out)
    & file = 'phy_interpolate_test00.nc', &          ! (in)
    & title = title, &                               ! (in)
    & source = source, institution = institution, &  ! (in)
    & dims = StoA('lon', 'lat', 'sig', 'sigm'), &        ! (in)
    & dimsizes = (/imax, jmax, kmax, kmax + 1/), &       ! (in)
    & longnames = &
    &  StoA('longitude', 'latitude', &
    &       'sigma at layer midpoints', &
    &       'sigma at layer end-points (half level)'), & ! (in)
    & units = StoA('degree_east', 'degree_north', &
    &              '1', '1') )                           ! (out)

  call HistoryPut( &
    & history = gthist, &               ! (out)
    & varname = 'lon', array = x_Lon )  ! (in)
  call HistoryPut( &
    & history = gthist, &               ! (out)
    & varname = 'lat', array = y_Lat  ) ! (in)
  call HistoryPut( &
    & history = gthist, &                ! (out)
    & varname = 'sig', array = z_Sigma ) ! (in)
  call HistoryPut( &
    & history = gthist, &                 ! (out)
    & varname = 'sigm', array = r_Sigma ) ! (in)

  call HistoryAddAttr( &
    & history = gthist, &                    ! (inout)
    & varname = 'lon', attrname = 'standard_name', & ! (in)
    & value = 'longitude' )                          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                    ! (inout)
    & varname = 'lat', attrname = 'standard_name', & ! (in)
    & value = 'latitude' )                           ! (in)

  call HistoryAddAttr( &
    & history = gthist, &                              ! (inout)
    & varname = 'sig', attrname = 'standard_name', &   ! (in)
    & value = 'atmosphere_sigma_coordinate' )          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                              ! (inout)
    & varname = 'sigm', attrname = 'standard_name', &  ! (in)
    & value = 'atmosphere_sigma_coordinate' )          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                         ! (inout)
    & varname = 'sig', attrname = 'positive', &   ! (in)
    & value = 'down' )                            ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                         ! (inout)
    & varname = 'sigm', attrname = 'positive', &  ! (in)
    & value = 'down' )                            ! (in)


  call HistoryAddVariable( &
    & history = gthist, &                  ! (inout)
    & varname = 'Ps', &                    ! (in)
    & dims = StoA('lon', 'lat'), &         ! (in)
    & longname = 'surface pressure', &     ! (in)
    & units = 'Pa', xtype = 'double' )     ! (in)
  call HistoryAddAttr(&
    & history = gthist, &                           ! (inout)
    & varname = 'Ps', attrname = 'standard_name', & ! (in)
    & value = 'surface_air_pressure' )              ! (in)
  call HistoryPut( &
    & history = gthist, &             ! (inout)
    & varname = 'Ps', array = xy_Ps ) ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                           ! (inout)
    & varname = 'Temp', &                           ! (in)
    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
    & longname = 'temperature', &                   ! (in)
    & units = 'K', xtype = 'double' )               ! (in)
  call HistoryAddAttr(&
    & history = gthist, &                             ! (inout)
    & varname = 'Temp', attrname = 'standard_name', & ! (in)
    & value = 'air_temperature' )                     ! (in)
  call HistoryPut( &
    & history = gthist, &                     ! (inout)
    & varname = 'Temp', array = xyz_Temp )    ! (in)

  call HistoryClose( history = gthist ) ! (inout)

end program phy_interpolate_test_prepnc00
