!= ο
!
!= Remove negative moisture
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_neg_moist.f90,v 1.2 2007-10-12 01:01:55 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_neg_moist
  !
  != ο
  !
  != Remove negative moisture
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! οޤ.
  !
  ! Remove negative moisture
  !
  !== Procedures List
  !
  ! Create        :: PHYNEGMST ѿν
  ! RemoveNegQVap :: ον
  ! Close         :: PHYNEGMST ѿνλ
  ! PutLine       :: PHYNEGMST ѿ˳ǼƤΰ
  ! initialized   :: PHYNEGMST ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYNEGMST"
  ! RemoveNegQVap :: Remove negative moisture
  ! Close         :: Deconstructor of "PHYNEGMST"
  ! PutLine       :: Print information of "PHYNEGMST"
  ! initialized   :: Check initialization of "PHYNEGMST"
  !
  !== Usage
  !
  ! Ϥ, PHYNEGMST ѿ, Create ǽԤޤ.
  ! οˤ RemoveNegQVap ѤƤ. 
  ! PHYNEGMST ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYNEGMST" by "Create". 
  ! In order to remove negative moisture, use "RemoveNegQVap". 
  ! In order to terminate "PHYNEGMST", use "Close".
  !

  use dc_types, only: DP, TOKEN
  use intavr_operate, only: INTAVROPR
  implicit none
  private
  public:: PHYNEGMST, Create, Close, PutLine, initialized, RemoveNegQVap

  type PHYNEGMST
    !
    ! ޤ, Create  "PHYNEGMST" ѿꤷƲ.
    ! ꤵ줿 "PHYNEGMST" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYNEGMST" variable by "Create" before usage.
    ! If you reuse "PHYNEGMST" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    type(INTAVROPR):: intavr_opr
  end type PHYNEGMST

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: phy_neg_moist.f90,v 1.2 2007-10-12 01:01:55 morikawa Exp $'

  interface Create
    module procedure PhyNegMoistCreate
  end interface

  interface Close
    module procedure PhyNegMoistClose
  end interface

  interface PutLine
    module procedure PhyNegMoistPutLine
  end interface

  interface initialized
    module procedure PhyNegMoistInitialized
  end interface

  interface NmlRead
    module procedure PhyNegMoistNmlRead
  end interface

  interface RemoveNegQVap
    module procedure PhyNegMoistRemoveNegQVap
  end interface

!!$  interface Sample
!!$    module procedure PhyNegMoistSample
!!$  end interface

contains

  subroutine PhyNegMoistCreate( phy_neg_mst, &
    & imax, jmax, kmax, &
    & PI, DelTime, &
    & x_Lon_Weight, y_Lat_Weight, &
    & nmlfile, err )
    !
    ! PHYNEGMST ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYNEGMST ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_neg_mst* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_neg_moist_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYNEGMST".
    ! Initialize *phy_neg_mst* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_neg_mst* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_neg_moist_nml"
    ! for details about a NAMELIST group.
    !
    use intavr_operate, only: Create
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    implicit none
    type(PHYNEGMST), intent(inout):: phy_neg_mst
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    real(DP), intent(in), optional:: x_Lon_Weight(0:imax-1)
                   ! ٺɸŤ. 
                   ! Weight of longitude
    real(DP), intent(in), optional:: y_Lat_Weight(0:jmax-1)
                   ! ٺɸŤ. 
                   ! Weight of latitude
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_neg_moist_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_neg_moist_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyNegMoistCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_neg_mst % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYNEGMST'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    phy_neg_mst % imax = imax
    phy_neg_mst % jmax = jmax
    phy_neg_mst % kmax = kmax

    !-----------------------------------------------------------------
    !  $ \Delta t $ 
    !  Configure $ \Delta t $
    !-----------------------------------------------------------------
    phy_neg_mst % DelTime = DelTime

    !-----------------------------------------------------------------
    !  ʿѴؿ
    !  Configure functions for average operation
    !-----------------------------------------------------------------
    call Create( intavr_opr = phy_neg_mst % intavr_opr, & ! (inout)
      & imax = imax, jmax = jmax, &                       ! (in)
      & PI = PI, &                                        ! (in)
      & x_Lon_Weight = x_Lon_Weight, &                    ! (in)
      & y_Lat_Weight = y_Lat_Weight, &                    ! (in)
      & nmlfile = nmlfile, &                              ! (in)
      & err = err )                                       ! (out)

    !-----------------------------------------------------------------
    !  "PHYNEGMST" 
    !  Configure the settings for "PHYNEGMST"
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
!!$    phy_neg_mst % param_r = 0.0_DP
!!$    phy_neg_mst % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_neg_mst % param_i = param_i
!!$    if ( present(param_r) )  phy_neg_mst % param_r = param_r
!!$    if ( present(param_c) )  phy_neg_mst % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1=trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_neg_mst % param_i, &   ! (inout)
!!$        & param_r = phy_neg_mst % param_r, &   ! (inout)
!!$        & param_c_ = phy_neg_mst % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1=trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_neg_mst % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_neg_mst % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyNegMoistCreate

  subroutine PhyNegMoistClose( phy_neg_mst, err )
    !
    ! PHYNEGMST ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_neg_mst*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYNEGMST".
    ! Note that if *phy_neg_mst* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use intavr_operate, only: Close
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYNEGMST), intent(inout):: phy_neg_mst
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyNegMoistClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_neg_mst % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYNEGMST'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYNEGMST" ξõ
    !  Clear the settings for "PHYNEGMST"
    !-----------------------------------------------------------------
    call Close( intavr_opr = phy_neg_mst % intavr_opr, & ! (inout)
      & err = err )                                      ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_neg_mst % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyNegMoistClose

  subroutine PhyNegMoistPutLine( phy_neg_mst, unit, indent, err )
    !
    !  *phy_neg_mst* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_neg_mst*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use intavr_operate, only: PutLine
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYNEGMST), intent(in):: phy_neg_mst
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyNegMoistPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYNEGMST" ΰ
    !  Print the settings for "PHYNEGMST"
    !-----------------------------------------------------------------
    if ( phy_neg_mst % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYNEGMST:: @initialized=%y', &
        & l = (/phy_neg_mst % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_neg_mst % imax, phy_neg_mst % jmax, phy_neg_mst % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @DelTime=%f', &
        & d = (/phy_neg_mst % DelTime/) )

      call PutLine( intavr_opr = phy_neg_mst % intavr_opr, &
        & unit = out_unit, &
        & indent = indent_str(1:indent_len) // &
        & ' ', err = err )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYNEGMST:: @initialized=%y>', &
        & l = (/phy_neg_mst % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyNegMoistPutLine

  logical function PhyNegMoistInitialized( phy_neg_mst ) result(result)
    !
    ! *phy_neg_mst* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_neg_mst* is initialized, .true. is returned.
    ! If *phy_neg_mst* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYNEGMST), intent(in):: phy_neg_mst
  continue
    result = phy_neg_mst % initialized
  end function PhyNegMoistInitialized

  subroutine PhyNegMoistNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_neg_moist_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_neg_moist ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_neg_moist#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_neg_moist" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_neg_moist#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyNegMoistNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_neg_moist_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_neg_moist_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_neg_moist_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_neg_moist_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyNegMoistNmlRead

  subroutine PhyNegMoistRemoveNegQVap( phy_neg_mst, &
    & xyz_QVap, xyz_DNegQVapDt, xyr_Press, &
    & err )
    !
    ! *xyz_QVap* ͤޤ. 
    ! *xyz_DNegQVapDt* ˤ *xyz_QVap* Ѳ̤֤ޤ. 
    ! *xyz_DNegQVapDt* ϰʤΤ, Ѳ̤ͤ
    ! 褻֤ޤ. Ϥ줿ͤ *xyz_QVap* Ѳ̤
    ! ƶڤܤޤ. 
    !
    ! ʤ, Ϳ줿 *phy_neg_mst*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Remove negative values in *xyz_QVap*. 
    ! Variation of *xyz_QVap* is returned to *xyz_DNegQVapDt*. 
    ! So *xyz_DNegQVapDt* is input/output argument, variation is 
    ! added on input values. Input values do not have influence on
    ! variation of *xyz_QVap*. 
    !
    ! If *phy_neg_mst* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use intavr_operate, only: AvrLonLat_xy
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYNEGMST), intent(inout):: phy_neg_mst
    real(DP), intent(inout):: xyz_QVap (0:phy_neg_mst%imax-1, 0:phy_neg_mst%jmax-1, 0:phy_neg_mst%kmax-1)
                              ! $ q $ .     漾. Specific humidity

    real(DP), intent(inout):: xyz_DNegQVapDt (0:phy_neg_mst%imax-1, 0:phy_neg_mst%jmax-1, 0:phy_neg_mst%kmax-1)
                              ! 漾Ψ. 
                              ! Specific humidity correction
    real(DP), intent(in):: xyr_Press (0:phy_neg_mst%imax-1, 0:phy_neg_mst%jmax-1, 0:phy_neg_mst%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    real(DP):: xyz_QVapB (0:phy_neg_mst%imax-1, 0:phy_neg_mst%jmax-1, 0:phy_neg_mst%kmax-1)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xy_QVapW (0:phy_neg_mst%imax-1, 0:phy_neg_mst%jmax-1)
                              ! 漾 (ѿ). 
                              ! Specific humidity (work variable). 

    real(DP):: xyz_DPressDz (0:phy_neg_mst%imax-1, 0:phy_neg_mst%jmax-1, 0:phy_neg_mst%kmax-1)
                              ! $ \Delta p $
                              ! 
    real(DP):: xyz_QVapDPressDz (0:phy_neg_mst%imax-1, 0:phy_neg_mst%jmax-1, 0:phy_neg_mst%kmax-1)
                              ! $ q \Delta p $
                              ! 
    real(DP):: xyz_DelQVapDPressDz (0:phy_neg_mst%imax-1, 0:phy_neg_mst%jmax-1, 0:phy_neg_mst%kmax-1)
                              ! $ \Delta q \Delta p $
                              ! 
    real(DP):: QVapDPressDzAvrLonLatSig
                              ! $ \int<q \Delta p>dz $
                              ! 
    real(DP):: DelQVapDPressDzAvrLonLatSig
                              ! $ \int<\Delta q \Delta p>dz $
                              ! 

    type(INTAVROPR):: intavr_opr

    integer:: i, j, k         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyNegMoistRemoveNegQVap'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_neg_mst % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYNEGMST'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_neg_mst* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_neg_mst*
    !-----------------------------------------------------------------
    imax    = phy_neg_mst % imax
    jmax    = phy_neg_mst % jmax
    kmax    = phy_neg_mst % kmax
    DelTime = phy_neg_mst % DelTime
    intavr_opr = phy_neg_mst % intavr_opr

    !-----------------------------------------------------------------
    !  Ĵ漾¸
    !  Save specific humidity before adjust
    !-----------------------------------------------------------------
    xyz_QVapB = xyz_QVap

    !-----------------------------------------------------------------
    !  $ \Delta p $ η׻
    !  Calculate $ \Delta p $
    !-----------------------------------------------------------------
    do k = 0, kmax-1
      do i = 0, imax-1
        do j = 0, jmax-1
          xyz_DPressDz(i,j,k) = xyr_Press(i,j,k) - xyr_Press(i,j,k+1)
        end do
      end do
    end do

    !-----------------------------------------------------------------
    !  ɽǤ (ͤǲؤ)
    !  Correction at local (Negative values moved to botton layer)
    !-----------------------------------------------------------------
    xy_QVapW = 0.0_DP
    do k = kmax - 1, 1, -1
      where ( xyz_QVap(:,:,k) < 0.0_DP )
        xy_QVapW = - xyz_QVap(:,:,k) &
          &          * xyz_DPressDz(:,:,k) / xyz_DPressDz(:,:,k-1)
        xyz_QVap(:,:,k) = 0.0_DP
        xyz_QVap(:,:,k-1) = xyz_QVap(:,:,k-1) - xy_QVapW
      end where
    end do

    !-----------------------------------------------------------------
    !  Ǥ
    !  Correction in global
    !-----------------------------------------------------------------

    !-----------------------------------
    !  ؤˤ̤λ
    !  Calculate amount of correction in each layer
    xyz_QVapDPressDz = xyz_QVap * xyz_DPressDz
    where ( xyz_QVapDPressDz < 0.0_DP )
      xyz_DelQVapDPressDz = - xyz_QVapDPressDz
    elsewhere
      xyz_DelQVapDPressDz = 0.0_DP
    end where

    !-----------------------------------
    !  ̤̱ľʿ
    !  Zonal and meridional and vertical mean of amount of correction
    QVapDPressDzAvrLonLatSig = 0.0_DP
    DelQVapDPressDzAvrLonLatSig = 0.0_DP

    do k = 0, kmax-1
      QVapDPressDzAvrLonLatSig = &
        &   QVapDPressDzAvrLonLatSig  &
        & + AvrLonLat_xy( xyz_QVapDPressDz(:,:,k), intavr_opr )

      DelQVapDPressDzAvrLonLatSig = &
        &   DelQVapDPressDzAvrLonLatSig  &
        & + AvrLonLat_xy( xyz_DelQVapDPressDz(:,:,k), intavr_opr )
    end do

    !-----------------------------------
    !  ͤ򥼥Ȥ, ʬΤ. 
    !  Minus values are brought back to zero, 
    !  and total is reduced by just that much
    if ( QVapDPressDzAvrLonLatSig /= 0.0_DP ) then 
      xyz_QVap = &
        &   QVapDPressDzAvrLonLatSig &
        &   / ( QVapDPressDzAvrLonLatSig + DelQVapDPressDzAvrLonLatSig ) &
        &   * max( xyz_QVap, 0.0_DP )
    end if

    !-----------------------------------
    !  漾Ѳλ
    !  Calculate specific humidity variance
    xyz_DNegQVapDt = &
      &   xyz_DNegQVapDt + ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyNegMoistRemoveNegQVap

!!$  subroutine PhyNegMoistSample( phy_neg_mst, err )
!!$    !--
!!$    ! PhyNegMoistSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_neg_mst*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyNegMoistSample
!!$    !++
!!$    ! If *phy_neg_mst* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYNEGMST), intent(inout):: phy_neg_mst
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyNegMoistSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_neg_mst % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYNEGMST'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_neg_mst* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_neg_mst*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_neg_mst % param_i
!!$!!$    param_r = phy_neg_mst % param_r
!!$!!$    param_c = phy_neg_mst % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyNegMoistSample

end module phy_neg_moist
