!= ͥեå
!
!= Radiation flux
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_radiation_flux.f90,v 1.10 2008-03-02 22:34:19 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module phy_radiation_flux
  !
  != ͥեå
  !
  != Radiation flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! , 漾, , ͥեå׻ޤ. 
  !
  ! Calculate radiation flux from temperature, specific humidity, and
  ! air pressure.
  !
  !== Procedures List
  !
  ! PhyRadFluxCreate      :: PHYRADFLX ѿν
  ! RadiationFlux         :: ͥեåη׻
  ! RadiationDTempDt      :: ͥեåˤ벹Ѳη׻
  ! PhyRadFluxClose       :: PHYRADFLX ѿνλ
  ! PhyRadFluxPutLine     :: PHYRADFLX ѿ˳ǼƤΰ
  ! PhyRadFluxInitialized :: PHYRADFLX ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! PhyRadFluxCreate      :: Constructor of "PHYRADFLX"
  ! RadiationFlux         :: Calculate radiation flux
  ! RadiationDTempDt      :: Calculate temperature tendency with radiation flux
  ! PhyRadFluxClose       :: Deconstructor of "PHYRADFLX"
  ! PhyRadFluxPutLine     :: Print information of "PHYRADFLX"
  ! PhyRadFluxInitialized :: Check initialization of "PHYRADFLX"
  !
  !== Usage
  !
  ! Ϥ, PHYRADFLX ѿ, PhyRadFluxCreate ǽԤޤ.
  ! RadiationFlux Ѥͥեå, 
  ! RadiationDTempDt ˤäͥեåˤ벹Ѳ׻ޤ. 
  ! PHYRADFLX ѿνλˤ PhyRadFluxClose ѤƤ.
  !
  ! First, initialize "PHYRADFLX" by "PhyRadFluxCreate".
  ! Calculate radiation flux by "RadiationFlux". 
  ! And calculate temperature tendency with radiation flux
  ! by "RadiationFlux". 
  ! In order to terminate "PHYRADFLX", use "PhyRadFluxClose".
  !

  use dc_types, only: DP, TOKEN, STRING
  use dc_date_types, only: DC_DIFFTIME
  implicit none
  private
  public:: PHYRADFLX, PhyRadFluxCreate, PhyRadFluxClose
  public:: PhyRadFluxPutLine, PhyRadFluxInitialized
  public:: RadiationFlux, RadiationDTempDt

  type PHYRADFLX
    !
    ! ޤ, PhyRadFluxCreate  "PHYRADFLX" ѿꤷƲ.
    ! ꤵ줿 "PHYRADFLX" ѿѤݤˤ,
    ! PhyRadFluxClose ˤäƽλԤäƤ.
    !
    ! Initialize "PHYRADFLX" variable by "PhyRadFluxCreate" before usage.
    ! If you reuse "PHYRADFLX" variable again for another application, 
    ! terminate by "PhyRadFluxClose".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag

    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP), pointer:: y_Lat (:) =>null()
                              ! . Latitude
    real(DP), pointer:: xy_SurfTemp (:,:) =>null()
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), pointer:: xy_SurfAlbedo (:,:) =>null()
                              ! ɽ٥. 
                              ! Surface albedo
    type(DC_DIFFTIME):: current_time
                              ! ߻. Current time.
    type(DC_DIFFTIME):: delta_time
                              ! $ \Delta t $ . ॹƥå. Time step

    logical:: save_flag
                              ! ¸Υե饰. 
                              ! Flug for save

    !-----------------------------------
    !  ĹȥեåѾ
    !  Information for long wave flux
    type(DC_DIFFTIME):: delta_time_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ. 
                              ! Step interval of long wave flux calculation
    real(DP):: delta_time_value_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ֤ο. 
                              ! Value of step interval of long wave flux calculation
    character(STRING):: delta_time_unit_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ֤ñ. 
                              ! Unit of step interval of long wave flux calculation

    integer:: LongBandNumber = 4
                              ! ĹȥХɿ. 
                              ! Number of long wave band
    real(DP), pointer:: LongAbsorpCoeffQVap(:) =>null()
                              ! εۼ. ǥեͤ
                              ! (/ 8.0_DP, 1.0_DP, 0.1_DP, 0.0_DP /). 
                              !
                              ! Absorption coefficient of water. 
                              ! Default value is 
                              ! (/ 8.0_DP, 1.0_DP, 0.1_DP, 0.0_DP /). 
    real(DP), pointer:: LongAbsorpCoeffDryAir(:) =>null()
                              ! εۼ. ǥեͤ
                              ! (/ 0.0_DP, 0.0_DP, 0.0_DP, 5.0e-5_DP /)
                              !
                              ! Absorption coefficient of air. 
                              ! Default value is 
                              ! (/ 0.0_DP, 0.0_DP, 0.0_DP, 5.0e-5_DP /)
    real(DP), pointer:: LongBandWeight(:) =>null()
                              ! Хɥ. ǥեͤ
                              ! (/ 0.2_DP, 0.1_DP, 0.1_DP, 0.6_DP /)
                              !
                              ! Band weight. 
                              ! Default value is 
                              ! (/ 0.2_DP, 0.1_DP, 0.1_DP, 0.6_DP /)
    real(DP):: LongPathLengthFact = 1.5_DP
                              ! ϩĹΥե. 
                              ! Factor of optical length

    real(DP), pointer:: xy_TempSave (:,:) =>null()
                              ! $ T $ .      (¸). Temperature (for save)
    real(DP), pointer:: xyr_RadLFluxSave (:,:,:) =>null()
                              ! Ĺȥեå (¸). 
                              ! Long wave flux (for save)
    real(DP), pointer:: xyra_DelRadLFluxSave (:,:,:,:) =>null()
                              ! ĹɽѲ (¸). 
                              ! Surface temperature tendency with long wave (for save)

    !-----------------------------------
    !  ûȥեåѾ
    !  Information for short wave flux
    type(DC_DIFFTIME):: delta_time_RadShort
                              ! û () եå׻륹ƥå״ֳ. 
                              ! Step interval of short wave (insolation) flux calculation
    real(DP):: delta_time_value_RadShort
                              ! û () եå׻륹ƥå״ֳ֤ο. 
                              ! Value of step interval of short wave (insolation) flux calculation
    character(STRING):: delta_time_unit_RadShort
                              ! û () եå׻륹ƥå״ֳ֤ñ. 
                              ! Unit of step interval of short wave (insolation) flux calculation

    integer:: ShortBandNumber = 1
                              ! ûȥХɿ. 
                              ! Number of short wave band
    real(DP), pointer:: ShortAbsorpCoeffQVap(:) =>null()
                              ! εۼ. ǥեͤ
                              ! (/ 0.002_DP /)
                              !
                              ! Absorption coefficient of water. 
                              ! Default value is 
                              ! (/ 0.002_DP /)
    real(DP), pointer:: ShortAbsorpCoeffDryAir(:) =>null()
                              ! εۼ. ǥեͤ
                              ! (/ 0.0_DP /)
                              !
                              ! Absorption coefficient of air. 
                              ! Default value is 
                              ! (/ 0.0_DP /)
    real(DP), pointer:: ShortBandWeight(:) =>null()
                              ! Хɥ. ǥեͤ
                              ! (/ 1.0_DP /)
                              !
                              ! Band weight. 
                              ! Default value is 
                              ! (/ 1.0_DP /)
    real(DP):: ShortSecScat = 1.66_DP
                              !  $ sec \zeta $
                              ! $ sec \zeta $ of scattering

    real(DP), pointer:: xyr_RadSFluxSave (:,:,:) =>null()
                              ! û () եå (¸). 
                              ! Short wave (insolation) flux (for save)

    !-----------------------------------
    !  ûѾ
    !  Information for short wave incomming

    real(DP):: SolarCoeff = 1380.0_DP
                              ! . 
                              ! Solar constant
    real(DP):: AtmosAlbedo = 0.2_DP
                              ! 絤٥. 
                              ! Albedo of air

!!$    real(DP):: EpsOrb = 23.5_DP
!!$                              ! ƻг. 
!!$                              ! Inclination of equator to orbit
!!$    real(DP):: EqnOrb = 110.0_DP
!!$                              ! . 
!!$                              ! 
    real(DP):: IncomAIns   = 0.127_DP
                              ! ǯʿͤη. 
                              ! Coefficient of annual mean incoming radiation. 
    real(DP):: IncomBIns   = 0.183_DP
                              ! ǯʿͤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    real(DP):: IncomAZet   = 0.410_DP
                              ! ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    real(DP):: IncomBZet   = 0.590_DP
                              ! ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 


    real(DP), pointer:: xy_IncomRadSFlux (:,:) =>null()
                              ! û () եå. 
                              ! Short wave (insolation) flux
    real(DP), pointer:: xy_InAngle (:,:) =>null()
                              ! sec (ͳ). 
                              ! sec (angle of incidence)

  end type PHYRADFLX

  integer, parameter:: MaximumBandNumber = 256
                              ! NAMELIST ǻǤκ祵. 
                              ! Muximum size of array input from NAMELIST


  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: phy_radiation_flux.f90,v 1.10 2008-03-02 22:34:19 morikawa Exp $'

  !-----------------------------------------------------------------
  !  ³
  !  Public procedures
  !-----------------------------------------------------------------

  interface PhyRadFluxCreate
    module procedure PhyRadFluxCreate
  end interface

  interface RadiationFlux
    module procedure PhyRadFluxRadiationFlux
  end interface

  interface RadiationDTempDt
    module procedure PhyRadFluxDTempDt
  end interface

  interface PhyRadFluxClose
    module procedure PhyRadFluxClose
  end interface

  interface PhyRadFluxPutLine
    module procedure PhyRadFluxPutLine
  end interface

  interface PhyRadFluxInitialized
    module procedure PhyRadFluxInitialized
  end interface

  !-----------------------------------------------------------------
  !  ³
  !  Private procedures
  !-----------------------------------------------------------------

  interface LongFlux
    module procedure PhyRadFluxLongFlux
  end interface

  interface ShortIncoming
    module procedure PhyRadFluxShortIncoming
  end interface

  interface ShortFlux
    module procedure PhyRadFluxShortFlux
  end interface

  interface NmlRead
    module procedure PhyRadFluxNmlRead
  end interface

!!$  interface Sample
!!$    module procedure PhyRadFluxSample
!!$  end interface

contains

  subroutine PhyRadFluxCreate( phy_radflx, &
    & imax, jmax, kmax, &
    & y_Lat, &
    & Grav, Cp, StB, &
    & xy_SurfTemp, &
    & xy_SurfAlbedo, &
    & current_time_value, current_time_unit, &
    & delta_time_value, delta_time_unit, &
    & delta_time_value_RadLong, delta_time_unit_RadLong, &
    & delta_time_value_RadShort, delta_time_unit_RadShort, &
    & LongBandNumber, &
    & LongAbsorpCoeffQVap, LongAbsorpCoeffDryAir, &
    & LongBandWeight, LongPathLengthFact, &
    & ShortBandNumber, &
    & ShortAbsorpCoeffQVap, ShortAbsorpCoeffDryAir, &
    & ShortBandWeight, ShortSecScat, &
    & SolarCoeff, AtmosAlbedo, &
!!$    & EpsOrb, EqnOrb, &
    & IncomAIns, IncomBIns, IncomAZet, IncomBZet, &
    & nmlfile, err )
    !
    ! PHYRADFLX ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYRADFLX ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_radflx* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_radiation_flux_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYRADFLX".
    ! Initialize *phy_radflx* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_radflx* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_radiation_flux_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use dc_date, only: DCDiffTimeCreate
    use dcpam_error, only: StoreError, DCPAM_ENMLARRAYINSUFF
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    integer, intent(in):: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP), intent(in):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP), intent(in):: y_Lat (0:jmax-1)
                              ! . Latitude
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 0:jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 0:jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(in), optional:: current_time_value
                              ! ߻. Value of current time
    character(*), intent(in), optional:: current_time_unit
                              ! ߻ñ. Unit of current time
    real(DP), intent(in), optional:: delta_time_value
                              ! $ \Delta t $ . ॹƥåפ. Value of time step
    character(*), intent(in), optional:: delta_time_unit
                              ! ॹƥåפñ. Unit of time step
    real(DP), intent(in), optional:: delta_time_value_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ֤ο. 
                              ! Value of step interval of long wave flux calculation
    character(*), intent(in), optional:: delta_time_unit_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ֤ñ. 
                              ! Unit of step interval of long wave flux calculation
    real(DP), intent(in), optional:: delta_time_value_RadShort
                              ! û () եå׻륹ƥå״ֳ֤ο. 
                              ! Value of step interval of short wave (insolation) flux calculation
    character(*), intent(in), optional:: delta_time_unit_RadShort
                              ! û () եå׻륹ƥå״ֳ֤ñ. 
                              ! Unit of step interval of short wave (insolation) flux calculation
    integer, intent(in), optional:: LongBandNumber
                              ! ĹȥХɿ. 
                              ! Number of long wave band
    real(DP), intent(in), optional:: LongAbsorpCoeffQVap(:)
                              ! εۼ. 
                              ! Absorption coefficient of water
    real(DP), intent(in), optional:: LongAbsorpCoeffDryAir(:)
                              ! εۼ. 
                              ! Absorption coefficient of air
    real(DP), intent(in), optional:: LongBandWeight(:)
                              ! Хɥ. 
                              ! Band weight
    real(DP), intent(in), optional:: LongPathLengthFact
                              ! ϩĹΥե. 
                              ! Factor of optical length
    integer, intent(in), optional:: ShortBandNumber
                              ! ûȥХɿ. 
                              ! Number of long wave band
    real(DP), intent(in), optional:: ShortAbsorpCoeffQVap(:)
                              ! εۼ. 
                              ! Absorption coefficient of water
    real(DP), intent(in), optional:: ShortAbsorpCoeffDryAir(:)
                              ! εۼ. 
                              ! Absorption coefficient of air
    real(DP), intent(in), optional:: ShortBandWeight(:)
                              ! Хɥ. 
                              ! Band weight
    real(DP), intent(in), optional:: ShortSecScat
                              !  $ sec \zeta $
                              ! $ sec \zeta $ of scattering
    real(DP), intent(in), optional:: SolarCoeff
                              ! . 
                              ! Solar constant
    real(DP), intent(in), optional:: AtmosAlbedo
                              ! 絤٥. 
                              ! Albedo of air

!!$    real(DP), intent(in), optional:: EpsOrb
!!$                              ! ƻг. 
!!$                              ! Inclination of equator to orbit
!!$    real(DP), intent(in), optional:: EqnOrb
!!$                              ! . 
!!$                              ! 
    real(DP), intent(in), optional:: IncomAIns
                              ! ǯʿͤη. 
                              ! Coefficient of annual mean incoming radiation. 
    real(DP), intent(in), optional:: IncomBIns
                              ! ǯʿͤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    real(DP), intent(in), optional:: IncomAZet
                              ! ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    real(DP), intent(in), optional:: IncomBZet
                              ! ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_radiation_flux_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_radiation_flux_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  NAMELIST ɤ߹ѿ
    !  Variables for loading NAMELIST
    real(DP), parameter:: invalid_value = -9999.0
    integer:: ary_size, loaded_ary_size, err_count
    real(DP), pointer:: a_loaded_array(:), a_loaded_array_tmp(:), a_default_array(:)
    real(DP), target:: long_default(1:4), short_default(1:1)
    character(STRING):: warn_msg, ok_msg, loaded_array_name

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_radflx % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYRADFLX" 
    !  Configure the settings for "PHYRADFLX"
    !-----------------------------------------------------------------
    phy_radflx % imax    = imax   
    phy_radflx % jmax    = jmax   
    phy_radflx % kmax    = kmax   
    phy_radflx % Grav    = Grav   
    phy_radflx % Cp      = Cp   
    phy_radflx % StB     = StB    

    allocate( phy_radflx % y_Lat (0:phy_radflx%jmax-1) )
    phy_radflx % y_Lat   = y_Lat    

    allocate( phy_radflx % xy_SurfTemp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )
    allocate( phy_radflx % xy_SurfAlbedo (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )
    phy_radflx % xy_SurfTemp   = xy_SurfTemp   
    phy_radflx % xy_SurfAlbedo = xy_SurfAlbedo 

    !-----------------------------------------------------------------
    !  ¸ѿγ
    !  Allocate variables for save
    !-----------------------------------------------------------------
    phy_radflx % save_flag = .false.
    allocate( phy_radflx % xy_TempSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )
    allocate( phy_radflx % xyr_RadLFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax) )
    allocate( phy_radflx % xyr_RadSFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax) )
    allocate( phy_radflx % xyra_DelRadLFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax, 0:1) )

    phy_radflx % xy_TempSave = 0.0_DP
    phy_radflx % xyr_RadLFluxSave = 0.0_DP
    phy_radflx % xyr_RadSFluxSave = 0.0_DP
    phy_radflx % xyra_DelRadLFluxSave = 0.0_DP

    !-----------------------------------------------------------------
    !  NAMELIST μ
    !  Get NAMELIST
    !-----------------------------------------------------------------

    !-------------------------
    !  դ
    !  Allocation
    allocate( phy_radflx % LongAbsorpCoeffQVap ( MaximumBandNumber ) )
    allocate( phy_radflx % LongAbsorpCoeffDryAir ( MaximumBandNumber ) )
    allocate( phy_radflx % LongBandWeight ( MaximumBandNumber ) )
    phy_radflx % LongAbsorpCoeffQVap   = invalid_value
    phy_radflx % LongAbsorpCoeffDryAir = invalid_value
    phy_radflx % LongBandWeight        = invalid_value

    allocate( phy_radflx % ShortAbsorpCoeffQVap ( MaximumBandNumber ) )
    allocate( phy_radflx % ShortAbsorpCoeffDryAir ( MaximumBandNumber ) )
    allocate( phy_radflx % ShortBandWeight ( MaximumBandNumber ) )
    phy_radflx % ShortAbsorpCoeffQVap   = invalid_value
    phy_radflx % ShortAbsorpCoeffDryAir = invalid_value
    phy_radflx % ShortBandWeight        = invalid_value

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
    phy_radflx % delta_time_value_RadLong = -1.0_DP
    phy_radflx % delta_time_unit_RadLong = 'sec'
    phy_radflx % delta_time_value_RadShort = -1.0_DP
    phy_radflx % delta_time_unit_RadShort = 'sec'
    if ( present( delta_time_value_RadLong  ) ) phy_radflx % delta_time_value_RadLong  = delta_time_value_RadLong       
    if ( present( delta_time_unit_RadLong   ) ) phy_radflx % delta_time_unit_RadLong   = delta_time_unit_RadLong       
    if ( present( delta_time_value_RadShort ) ) phy_radflx % delta_time_value_RadShort = delta_time_value_RadShort       
    if ( present( delta_time_unit_RadShort  ) ) phy_radflx % delta_time_unit_RadShort  = delta_time_unit_RadShort       


    if ( present( LongBandNumber       ) ) phy_radflx % LongBandNumber        = LongBandNumber       
    if ( present( LongPathLengthFact   ) ) phy_radflx % LongPathLengthFact    = LongPathLengthFact   

    if ( present( LongAbsorpCoeffQVap  ) ) then
      ary_size = size( LongAbsorpCoeffQVap )
      phy_radflx % LongAbsorpCoeffQVap(1:ary_size) = LongAbsorpCoeffQVap 
    end if
    if ( present( LongAbsorpCoeffDryAir  ) ) then
      ary_size = size( LongAbsorpCoeffDryAir )
      phy_radflx % LongAbsorpCoeffDryAir(1:ary_size) = LongAbsorpCoeffDryAir 
    end if
    if ( present( LongBandWeight  ) ) then
      ary_size = size( LongBandWeight )
      phy_radflx % LongBandWeight(1:ary_size) = LongBandWeight 
    end if


    if ( present( ShortBandNumber ) ) phy_radflx % ShortBandNumber = ShortBandNumber       
    if ( present( ShortSecScat    ) ) phy_radflx % ShortSecScat    = ShortSecScat   

    if ( present( ShortAbsorpCoeffQVap  ) ) then
      ary_size = size( ShortAbsorpCoeffQVap )
      phy_radflx % ShortAbsorpCoeffQVap(1:ary_size) = ShortAbsorpCoeffQVap 
    end if
    if ( present( ShortAbsorpCoeffDryAir  ) ) then
      ary_size = size( ShortAbsorpCoeffDryAir )
      phy_radflx % ShortAbsorpCoeffDryAir(1:ary_size) = ShortAbsorpCoeffDryAir 
    end if
    if ( present( ShortBandWeight  ) ) then
      ary_size = size( ShortBandWeight )
      phy_radflx % ShortBandWeight(1:ary_size) = ShortBandWeight 
    end if

    if ( present( SolarCoeff ) ) phy_radflx % SolarCoeff  = SolarCoeff 
    if ( present( AtmosAlbedo) ) phy_radflx % AtmosAlbedo = AtmosAlbedo
!!$    if ( present( EpsOrb     ) ) phy_radflx % EpsOrb      = EpsOrb     
!!$    if ( present( EqnOrb     ) ) phy_radflx % EqnOrb      = EqnOrb     
    if ( present( IncomAIns  ) ) phy_radflx % IncomAIns   = IncomAIns  
    if ( present( IncomBIns  ) ) phy_radflx % IncomBIns   = IncomBIns  
    if ( present( IncomAZet  ) ) phy_radflx % IncomAZet   = IncomAZet  
    if ( present( IncomBZet  ) ) phy_radflx % IncomBZet   = IncomBZet  

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1 = trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &      ! (in)
        & delta_time_value_RadLong  = phy_radflx % delta_time_value_RadLong, &  ! (inout)
        & delta_time_unit_RadLong_  = phy_radflx % delta_time_unit_RadLong, &   ! (inout)
        & delta_time_value_RadShort = phy_radflx % delta_time_value_RadShort, & ! (inout)
        & delta_time_unit_RadShort_ = phy_radflx % delta_time_unit_RadShort, &  ! (inout)
!
        & LongBandNumber         = phy_radflx % LongBandNumber, &        ! (inout)
        & LongAbsorpCoeffQVap    = phy_radflx % LongAbsorpCoeffQVap, &   ! (inout)
        & LongAbsorpCoeffDryAir  = phy_radflx % LongAbsorpCoeffDryAir, & ! (inout)
        & LongBandWeight         = phy_radflx % LongBandWeight, &        ! (inout)
        & LongPathLengthFact     = phy_radflx % LongPathLengthFact, &    ! (inout)
!
        & ShortBandNumber        = phy_radflx % ShortBandNumber, &        ! (inout)
        & ShortAbsorpCoeffQVap   = phy_radflx % ShortAbsorpCoeffQVap, &   ! (inout)
        & ShortAbsorpCoeffDryAir = phy_radflx % ShortAbsorpCoeffDryAir, & ! (inout)
        & ShortBandWeight        = phy_radflx % ShortBandWeight, &        ! (inout)
        & ShortSecScat           = phy_radflx % ShortSecScat, &           ! (inout)
!
        & SolarCoeff  = phy_radflx % SolarCoeff, &  ! (inout)
        & AtmosAlbedo = phy_radflx % AtmosAlbedo, & ! (inout)
!!$        & EpsOrb      = phy_radflx % EpsOrb, &      ! (inout)
!!$        & EqnOrb      = phy_radflx % EqnOrb, &      ! (inout)
        & IncomAIns   = phy_radflx % IncomAIns, &   ! (inout)
        & IncomBIns   = phy_radflx % IncomBIns, &   ! (inout)
        & IncomAZet   = phy_radflx % IncomAZet, &   ! (inout)
        & IncomBZet   = phy_radflx % IncomBZet, &   ! (inout)
!
        & err = err )                          ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1 = trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  ץʥ NAMELIST 줿ͤΥå
    !  Validate setting values from optional arguments and NAMELIST
    !-----------------------------------------------------------------
    err_count = 0
    warn_msg = &
      & 'Number of data "%c" is "%d" (insufficient). ' // &
      & 'Number of data must be "%d".'
    ok_msg = '%c(%d:%d) = %*f'

    !-----------------------------------
    !  ĹȥեåѾ
    !  Information control for long wave flux
    if (phy_radflx % LongBandNumber < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'LongBandNumber'
      goto 999
    else
      ary_size = phy_radflx % LongBandNumber
    end if

    a_loaded_array => phy_radflx % LongAbsorpCoeffQVap
    loaded_array_name = 'LongAbsorpCoeffQVap'
    long_default = (/ 8.0_DP, 1.0_DP, 0.1_DP, 0.0_DP /)
    a_default_array => long_default
    call array_validation_check   ! ֥롼. This is an internal subroutine
    phy_radflx % LongAbsorpCoeffQVap => a_loaded_array

    a_loaded_array => phy_radflx % LongAbsorpCoeffDryAir
    loaded_array_name = 'LongAbsorpCoeffDryAir'
    long_default = (/ 0.0_DP, 0.0_DP, 0.0_DP, 5.0e-5_DP /)
    a_default_array => long_default
    call array_validation_check   ! ֥롼. This is an internal subroutine
    phy_radflx % LongAbsorpCoeffDryAir => a_loaded_array

    a_loaded_array => phy_radflx % LongBandWeight
    long_default = (/ 0.2_DP, 0.1_DP, 0.1_DP, 0.6_DP /)
    a_default_array => long_default
    loaded_array_name = 'LongBandWeight'
    call array_validation_check   ! ֥롼. This is an internal subroutine
    phy_radflx % LongBandWeight => a_loaded_array

    if (phy_radflx % LongPathLengthFact < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'LongPathLengthFact'
      goto 999
    end if

    !-----------------------------------
    !  ûȥեåѾ
    !  Information control for short wave flux
    if (phy_radflx % ShortBandNumber < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'ShortBandNumber'
      goto 999
    else
      ary_size = phy_radflx % ShortBandNumber
    end if

    a_loaded_array => phy_radflx % ShortAbsorpCoeffQVap
    loaded_array_name = 'ShortAbsorpCoeffQVap'
    short_default = (/ 0.002_DP /)
    a_default_array => short_default
    call array_validation_check   ! ֥롼. This is an internal subroutine
    phy_radflx % ShortAbsorpCoeffQVap => a_loaded_array

    a_loaded_array => phy_radflx % ShortAbsorpCoeffDryAir
    loaded_array_name = 'ShortAbsorpCoeffDryAir'
    short_default = (/ 0.0_DP /)
    a_default_array => short_default
    call array_validation_check   ! ֥롼. This is an internal subroutine
    phy_radflx % ShortAbsorpCoeffDryAir => a_loaded_array

    a_loaded_array => phy_radflx % ShortBandWeight
    short_default = (/ 1.0_DP /)
    a_default_array => short_default
    loaded_array_name = 'ShortBandWeight'
    call array_validation_check   ! ֥롼. This is an internal subroutine
    phy_radflx % ShortBandWeight => a_loaded_array

    if (phy_radflx % ShortSecScat < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'ShortSecScat'
      goto 999
    end if

    !-----------------------------------
    !  ûѾ
    !  Information control for short wave incomming
    if (phy_radflx % SolarCoeff < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'SolarCoeff'
      goto 999
    end if
    if (phy_radflx % AtmosAlbedo < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'AtmosAlbedo'
      goto 999
    end if
!!$    if (phy_radflx % EpsOrb < 0.0_DP) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'EpsOrb'
!!$      goto 999
!!$    end if
!!$    if (phy_radflx % EqnOrb < 0.0_DP) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'EqnOrb'
!!$      goto 999
!!$    end if
    if (phy_radflx % IncomAIns < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'IncomAIns'
      goto 999
    end if
    if (phy_radflx % IncomBIns < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'IncomBIns'
      goto 999
    end if
    if (phy_radflx % IncomAZet < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'IncomAZet'
      goto 999
    end if
    if (phy_radflx % IncomBZet < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'IncomBZet'
      goto 999
    end if

    if ( err_count > 0 ) then
      stat = DCPAM_ENMLARRAYINSUFF
      cause_c = ''
      goto 999
    end if


    !-----------------------------------------------------------------
    !  
    !  Configure time
    !-----------------------------------------------------------------
    if ( present(current_time_value) .and. present(current_time_unit) ) then
      call DCDiffTimeCreate( &
        & diff = phy_radflx % current_time, &   ! (out)
        & value = current_time_value, &         ! (in)
        & unit = current_time_unit )            ! (in)
    else
      call DCDiffTimeCreate( &
        & diff = phy_radflx % current_time, &   ! (out)
        & value = 0.0_DP, &         ! (in)
        & unit = 'sec' )            ! (in)
    end if

    if ( present(delta_time_value) .and. present(delta_time_unit) ) then
      call DCDiffTimeCreate( &
        & diff = phy_radflx % delta_time, &   ! (out)
        & value = delta_time_value, &         ! (in)
        & unit = delta_time_unit )            ! (in)
    else
      call DCDiffTimeCreate( &
        & diff = phy_radflx % delta_time, &   ! (out)
        & value = 1.0_DP, &          ! (in)
        & unit = 'sec' )             ! (in)
    end if

    call DCDiffTimeCreate( &
      & diff = phy_radflx % delta_time_RadLong, &        ! (out)
      & value = phy_radflx % delta_time_value_RadLong, & ! (in)
      & unit = phy_radflx % delta_time_unit_RadLong )    ! (in)

    call DCDiffTimeCreate( &
      & diff = phy_radflx % delta_time_RadShort, &        ! (out)
      & value = phy_radflx % delta_time_value_RadShort, & ! (in)
      & unit = phy_radflx % delta_time_unit_RadShort )    ! (in)

    !-----------------------------------------------------------------
    !  ե饰
    !  Set initialization flag 
    !-----------------------------------------------------------------
    phy_radflx % initialized = .true.

    !-----------------------------------------------------------------
    !  ûͤη׻
    !  Calculate short wave (insolation) incoming radiation
    !-----------------------------------------------------------------
    allocate( phy_radflx % xy_IncomRadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )
    allocate( phy_radflx % xy_InAngle (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1) )

    call ShortIncoming( phy_radflx = phy_radflx, &          ! (inout)
      & xy_IncomRadSFlux = phy_radflx % xy_IncomRadSFlux, & ! (out)
      & xy_InAngle = phy_radflx % xy_InAngle )              ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    if ( present_and_true(err) ) then
      if ( associated( phy_radflx % xy_TempSave            ) ) deallocate( phy_radflx % xy_TempSave )
      if ( associated( phy_radflx % xyr_RadLFluxSave       ) ) deallocate( phy_radflx % xyr_RadLFluxSave )
      if ( associated( phy_radflx % xyra_DelRadLFluxSave   ) ) deallocate( phy_radflx % xyra_DelRadLFluxSave )
      if ( associated( phy_radflx % LongAbsorpCoeffQVap    ) ) deallocate( phy_radflx % LongAbsorpCoeffQVap )
      if ( associated( phy_radflx % LongAbsorpCoeffDryAir  ) ) deallocate( phy_radflx % LongAbsorpCoeffDryAir )
      if ( associated( phy_radflx % LongBandWeight         ) ) deallocate( phy_radflx % LongBandWeight )
    end if

    call EndSub( subname )

  contains

    subroutine array_validation_check
      !
      ! 󷿥ǡ NAMELIST ɤ߹ݤͤ
      ! å. 
      !
      ! ڤ줿ˤ, a_loaded_array , ­ʤ
      ! 󥵥ΥǡǼ. 
      ! 
      ! , ڤʤˤ, err_count ͤ
      ! ץ饹 1 , ٹåɽ. 
      !
      !
      ! Check validation when array data is loaded from NAMELIST. 
      !
      ! If validation is checked, just enough data is stored in 
      ! "a_loaded_array". 
      ! 
      ! Otherwise, if validation is not checked, add 1 to 
      ! value of "err_count", and display warning messages. 
      !
      loaded_ary_size = count( a_loaded_array > invalid_value + 1.0_DP )

      if ( loaded_ary_size == 0 ) then
        loaded_ary_size = size( a_default_array ) 
        deallocate( a_loaded_array )
        a_loaded_array => a_default_array
      end if

      if ( loaded_ary_size == ary_size ) then
        call MessageNotify( 'M', subname, ok_msg, &
          & c1 = trim(loaded_array_name), i = (/1, loaded_ary_size/), &
          & d = a_loaded_array, n = (/loaded_ary_size/) )
        allocate( a_loaded_array_tmp(1:loaded_ary_size) )
        a_loaded_array_tmp(1:loaded_ary_size) = a_loaded_array(1:loaded_ary_size)
        nullify( a_loaded_array )
        a_loaded_array => a_loaded_array_tmp
        nullify( a_loaded_array_tmp )
      else
        call MessageNotify( 'W', subname, warn_msg, &
          & c1 = trim(loaded_array_name), &
          & i = (/loaded_ary_size, ary_size/) )
        err_count = err_count + 1
      end if
    end subroutine array_validation_check
    
  end subroutine PhyRadFluxCreate

  subroutine PhyRadFluxRadiationFlux( phy_radflx, &
    & xyz_Temp, xyz_QVap, xyr_Press, &
    & xyr_RadLFlux, xya_SurfRadLMatrix, xyra_DelRadLFlux, xyr_RadSFlux, &
    & err )
    !
    ! , 漾, , ͥեå׻ޤ. 
    !
    ! ʤ, Ϳ줿 *phy_radflx*  PhyRadFluxCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate radiation flux from temperature, specific humidity, and 
    ! air pressure. 
    !
    ! If *phy_radflx* is not initialized by "PhyRadFluxCreate" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_date, only: EvalSec, EvalByUnit, mod, &
      & operator(*), operator(==), operator(<), operator(/), &
      & operator(+), operator(-)
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(in):: xyz_Temp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyz_QVap (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyr_Press (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xyr_RadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
    real(DP), intent(out):: xya_SurfRadLMatrix (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
    real(DP), intent(out):: xyra_DelRadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
    real(DP), intent(out):: xyr_RadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: xy_SurfTemp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature

    real(DP):: xy_TempSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! $ T $ .      (¸). Temperature (for save)
    real(DP):: xyr_RadLFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ĺȥեå (¸). 
                              ! Long wave flux (for save)
    real(DP):: xyr_RadSFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! û () եå (¸). 
                              ! Short wave (insolation) flux (for save)
    real(DP):: xyra_DelRadLFluxSave (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax, 0:1)
                              ! ĹɽѲ (¸). 
                              ! Surface temperature tendency with long wave (for save)

    real(DP):: xyr_TauQVap (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of water
    real(DP):: xyr_TauDryAir (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of air

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop


    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxRadiationFlux'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    kmax    = phy_radflx % kmax   
    Grav    = phy_radflx % Grav   

    xy_SurfTemp   = phy_radflx % xy_SurfTemp   

    xyr_RadSFlux = 0.0_DP
    xyr_RadSFlux(:,:,kmax) = phy_radflx % xy_IncomRadSFlux

    xy_TempSave          = phy_radflx % xy_TempSave         
    xyr_RadLFluxSave     = phy_radflx % xyr_RadLFluxSave     
    xyr_RadSFluxSave     = phy_radflx % xyr_RadSFluxSave     
    xyra_DelRadLFluxSave = phy_radflx % xyra_DelRadLFluxSave 

    !-----------------------------------------------------------------
    !  Ūη׻
    !  Calculate optical depth
    !-----------------------------------------------------------------
    xyr_TauQVap   = 0.0_DP
    xyr_TauDryAir = 0.0_DP

    do k = kmax-1 , 0, -1
      xyr_TauQVap(:,:,k) = &
        &   xyr_TauQVap(:,:,k+1) &
        & + xyz_QVap(:,:,k) &
        &   * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav

      xyr_TauDryAir(:,:,k) = &
        &   xyr_TauDryAir(:,:,k+1) &
        & + ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
    end do


    !-----------------------------------------------------------------
    !  Ĺȥեåλ
    !  Calculate long wave flux
    !-----------------------------------------------------------------

    !---------------------------------------------
    !  current_time / delta_time_RadLong == 0, ޤ
    !  delta_time_RadLong ̤, ޤ
    !  ޤ٤׻ƤʤˤϷ׻Ԥ. 
    !
    !  If current_time / delta_time_RadLong == 0, or
    !  "delta_time_RadLong" is not configured, or
    !  calculation was never performed, 
    !  calculation is performed. 
    if ( mod( phy_radflx % current_time, &
      &       phy_radflx % delta_time_RadLong) == 0 .or. &
      &  EvalSec( phy_radflx % delta_time_RadLong ) < 0.0_DP .or. &
      &  .not. phy_radflx % save_flag                               ) then

      call DbgMessage( 'LongFlux is calculated' )

      call LongFlux( phy_radflx = phy_radflx, &  ! (inout)
        & xyr_RadLFlux = xyr_RadLFlux, &         ! (out)
        & xyra_DelRadLFlux = xyra_DelRadLFlux, & ! (out)
        & xyz_Temp = xyz_Temp, &                 ! (in)
        & xy_SurfTemp = xy_SurfTemp, &           ! (in)
        & xyr_TauQVap = xyr_TauQVap, &           ! (in)
        & xyr_TauDryAir = xyr_TauDryAir )        ! (in)
       
    !-----------------------------------
    !  ͤ
    !  Use values in last time
    else

      call DbgMessage( &
        & 'LongFlux is not calculated. Save values are used' )

      xyr_RadLFlux = xyr_RadLFluxSave
      xyra_DelRadLFlux = xyra_DelRadLFluxSave
       
      do k = 0, kmax
        xyr_RadLFlux(:,:,k) = &
          &   xyr_RadLFlux(:,:,k) &
          & + xyra_DelRadLFlux(:,:,k,1) &
          &     * ( xyz_Temp(:,:,0) - xy_TempSave )

        xyra_DelRadLFlux(:,:,k,1) = &
          &   xyra_DelRadLFlux(:,:,k,1) &
          &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,0)**3 )
      end do
    end if


    !-----------------------------------------------------------------
    !  Ĺȱѹλ
    !  Calculate long wave implicit matrix
    !-----------------------------------------------------------------
    xya_SurfRadLMatrix(:,:,0)  = xyra_DelRadLFlux(:,:,0,0)
    xya_SurfRadLMatrix(:,:,1)  = xyra_DelRadLFlux(:,:,0,1)
    xya_SurfRadLMatrix(:,:,-1) = 0.0_DP


    !-----------------------------------------------------------------
    !  û () եåλ
    !  Calculate short wave (insolation)
    !-----------------------------------------------------------------

    !---------------------------------------------
    !  current_time / delta_time_RadShort == 0, ޤ
    !  delta_time_RadShort ̤, ޤ
    !  ޤ٤׻ƤʤˤϷ׻Ԥ. 
    !
    !  If current_time / delta_time_RadShort == 0, or
    !  "delta_time_RadShort" is not configured, or
    !  calculation was never performed, 
    !  calculation is performed. 
    if ( mod( phy_radflx % current_time, &
      &       phy_radflx % delta_time_RadShort) == 0 .or. &
      &  EvalSec( phy_radflx % delta_time_RadShort ) < 0.0_DP .or. &
      &  .not. phy_radflx % save_flag                               ) then

      call DbgMessage( 'ShortFlux is calculated' )

      !---------------------------------
      !  ûȥեåη׻
      !  Calculate short wave (insolation) flux
      call ShortFlux( phy_radflx = phy_radflx, & ! (inout)
        & xyr_RadSFlux = xyr_RadSFlux, &         ! (inout)
        & xyr_TauQVap = xyr_TauQVap, &           ! (in)
        & xyr_TauDryAir = xyr_TauDryAir )        ! (in)


    !-----------------------------------
    !  ͤ
    !  Use values in last time
    else

      call DbgMessage( &
        & 'ShortFlux is not calculated. Save values are used' )

      xyr_RadSFlux = xyr_RadSFluxSave
    end if


    !-----------------------------------------------------------------
    !  ׻ͤ¸
    !  Save calculated values in this time
    !-----------------------------------------------------------------
    phy_radflx % xy_TempSave          = xyz_Temp (:,:,0)
    phy_radflx % xyr_RadLFluxSave     = xyr_RadLFlux
    phy_radflx % xyr_RadSFluxSave     = xyr_RadSFlux
    phy_radflx % xyra_DelRadLFluxSave = xyra_DelRadLFlux

    phy_radflx % save_flag = .true.

    !-----------------------------------------------------------------
    !  ι
    !  Update time
    !-----------------------------------------------------------------
    phy_radflx % current_time = &
      & phy_radflx % current_time + phy_radflx % delta_time

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxRadiationFlux

  subroutine PhyRadFluxLongFlux( phy_radflx, &
    & xyr_RadLFlux, &
    & xyra_DelRadLFlux, &
    & xyz_Temp, &
    & xy_SurfTemp, &
    & xyr_TauQVap, &
    & xyr_TauDryAir, &
    & err )
    !
    ! Ĺȥեåη׻
    !
    ! ʤ, Ϳ줿 *phy_radflx*  PhyRadFluxCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate long wave flux
    !
    ! If *phy_radflx* is not initialized by "PhyRadFluxCreate" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(out):: xyr_RadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
    real(DP), intent(out):: xyra_DelRadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
    real(DP), intent(in):: xyz_Temp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xy_SurfTemp (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xyr_TauQVap (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of water
    real(DP), intent(in):: xyr_TauDryAir (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of air
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant

    real(DP):: xyr_Trans (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP):: xyr_Trans1 (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! 1/2 ٥뤫Ʃ᷸. 
                              ! Transmission coefficient above 1/2 level
    real(DP):: xyr_Trans2 (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! 3/2 ٥뤫Ʃ᷸. 
                              ! Transmission coefficient above 3/2 level
    real(DP):: xyz_PiB (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! $ \pi B = \sigma T^{4} $
    real(DP):: xy_SurfPiB (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! ɽ̤ $ \pi B $ . 
                              ! $ \pi B $ on surface

    integer:: kk , bn
    real(DP):: BandWeightSum

    integer:: BandNumber
                              ! ĹȥХɿ. 
                              ! Number of long wave band

    real(DP), pointer:: AbsorpCoeffQVap(:)
                              ! εۼ. 
                              ! Absorption coefficient of water
    real(DP), pointer:: AbsorpCoeffDryAir(:)
                              ! εۼ. 
                              ! Absorption coefficient of air
    real(DP), pointer:: BandWeight(:)
                              ! Хɥ. 
                              ! Band weight
    real(DP):: PathLengthFact
                              ! ϩĹΥե. 
                              ! Factor of optical length

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxLongFlux'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    kmax    = phy_radflx % kmax   
    StB     = phy_radflx % StB    
    
    BandNumber        =  phy_radflx % LongBandNumber
    AbsorpCoeffQVap   => phy_radflx % LongAbsorpCoeffQVap   
    AbsorpCoeffDryAir => phy_radflx % LongAbsorpCoeffDryAir 
    BandWeight        => phy_radflx % LongBandWeight        
    PathLengthFact    =  phy_radflx % LongPathLengthFact    

    !-----------------------------------------------------------------
    !  ХɥȤ
    !  Configure band weight
    !-----------------------------------------------------------------
    BandWeightSum = 0.0_DP

    do bn = 1, BandNumber
      BandWeightSum =  BandWeightSum +  BandWeight(bn)
    end do

    do bn = 1, BandNumber
      BandWeight(bn) = BandWeight(bn) / BandWeightSum
    end do

    !-----------------------------------------------------------------
    !  $ \pi B $ η׻
    !  Calculate $ \pi B $
    !-----------------------------------------------------------------
    xyz_PiB    = StB * ( xyz_Temp**4 )
    xy_SurfPiB = StB * ( xy_SurfTemp**4 )

    do k = 0, kmax

      !---------------------------------------------------------------
      !  Ʃؿ׻
      !  Calculate transmission functions
      !---------------------------------------------------------------
      xyr_Trans = 0.0_DP
      
      do bn = 1, BandNumber
        do kk = 0, kmax
          xyr_Trans(:,:,kk) = &
            &   xyr_Trans(:,:,kk) &
            & + BandWeight(bn) &
            &   * exp( - PathLengthFact &
            &            * (   AbsorpCoeffQVap(bn) &
            &                  * abs(   xyr_TauQVap(:,:,kk) &
            &                         - xyr_TauQVap(:,:,k)  ) &
            &                + AbsorpCoeffDryAir(bn) &
            &                  * abs(   xyr_TauDryAir(:,:,kk) &
            &                         - xyr_TauDryAir(:,:,k)  ) ) )
        end do
      end do
      

      !---------------------------------------------------------------
      !  ͥեå׻
      !  Calculate radiation flux
      !---------------------------------------------------------------
      xyr_RadLFlux(:,:,k) = xy_SurfPiB * xyr_Trans(:,:,0)
 
      do kk = 0, kmax-1
        xyr_RadLFlux(:,:,k) = &
          &   xyr_RadLFlux(:,:,k) &
          & - xyz_PiB(:,:,kk) * ( xyr_Trans(:,:,kk) - xyr_Trans(:,:,kk+1) )
      end do

      !---------------------------------------------------------------
      !  ׻Ʃؿ׻
      !  Calculate transmission functions for correction terms
      !---------------------------------------------------------------
      xyr_Trans1(:,:,k) = xyr_Trans(:,:,0)
      xyr_Trans2(:,:,k) = xyr_Trans(:,:,1)

    end do

    !-----------------------------------------------------------------
    !  ĹɽѲη׻
    !  Calclate surface temperature tendency with long wave
    !-----------------------------------------------------------------
    do k = 0, kmax
      xyra_DelRadLFlux(:,:,k,0) = &
        & 4.0_DP * xy_SurfPiB / xy_SurfTemp * xyr_Trans1(:,:,k)

      xyra_DelRadLFlux(:,:,k,1) = &
        & 4.0_DP * xyz_PiB(:,:,0) / xyz_Temp(:,:,0) &
        &   * ( xyr_Trans2(:,:,k) - xyr_Trans1(:,:,k) )
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxLongFlux

  subroutine PhyRadFluxShortIncoming( phy_radflx, &
    & xy_IncomRadSFlux, &
    & xy_InAngle, &
    & err )
    !
    ! ûͤ׻ޤ.
    !
    ! ʤ, Ϳ줿 *phy_radflx*  PhyRadFluxCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate short wave (insolation) incoming radiation. 
    !
    ! If *phy_radflx* is not initialized by "PhyRadFluxCreate" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(out):: xy_IncomRadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! û () եå. 
                              ! Short wave (insolation) flux
    real(DP), intent(out):: xy_InAngle (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude

    real(DP):: y_Lat (0:phy_radflx%jmax-1)
                              !  (饸). Latitude (radian)

    real(DP):: SolarCoeff
                              ! . 
                              ! Solar constant
    real(DP):: AtmosAlbedo
                              ! 絤٥. 
                              ! Albedo of air

!!$    real(DP):: EpsOrb
!!$                              ! ƻг. 
!!$                              ! Inclination of equator to orbit
!!$    real(DP):: EqnOrb
!!$                              ! . 
!!$                              ! 
    real(DP):: AIns
                              ! ǯʿͤη. 
                              ! Coefficient of annual mean incoming radiation. 
    real(DP):: BIns
                              ! ǯʿͤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    real(DP):: AZet
                              ! ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    real(DP):: BZet
                              ! ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 

    integer:: i, j            ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxShortIncoming'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    imax    = phy_radflx % imax   
    jmax    = phy_radflx % jmax   
    y_Lat   = phy_radflx % y_Lat   

    SolarCoeff  = phy_radflx % SolarCoeff
    AtmosAlbedo = phy_radflx % AtmosAlbedo
!!$    EpsOrb      = phy_radflx % EpsOrb
!!$    EqnOrb      = phy_radflx % EqnOrb
    AIns        = phy_radflx % IncomAIns
    BIns        = phy_radflx % IncomBIns
    AZet        = phy_radflx % IncomAZet
    BZet        = phy_radflx % IncomBZet

    !-----------------------------------------------------------------
    !  ǯ, ʿͤη׻
    !  Calculate annual mean, daily mean insolation
    !-----------------------------------------------------------------
    do i = 0, imax - 1
      do j = 0, jmax - 1
        xy_IncomRadSFlux(i,j) = &
          &  - SolarCoeff * (1.0_DP - AtmosAlbedo ) &
          &    * ( AIns + BIns * cos( y_Lat(j) )**2 )

        if ( xy_IncomRadSFlux(i,j) < 0.0_DP ) then
          xy_InAngle(i,j) = 1.0_DP / ( AZet + BZet * cos( y_Lat(j) )**2 )
        else
          xy_IncomRadSFlux(i,j) = 0.0_DP
          xy_InAngle(i,j) = 0.0_DP
        end if
      end do
    end do

    !-----------------------------------------------------------------
    !  Ѳ, Ѳη׻
    !  Calculate with seasonal change and diurnal change
    !-----------------------------------------------------------------
    ! ᤯ AGCM5 ܿͽ. 
    ! Importation from AGCM5 is planed within days


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxShortIncoming

  subroutine PhyRadFluxShortFlux( phy_radflx, &
    & xyr_RadSFlux, &
    & xyr_TauQVap, &
    & xyr_TauDryAir, &
    & err )
    !
    ! Ĺȥեåη׻
    !
    ! ʤ, Ϳ줿 *phy_radflx*  PhyRadFluxCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate long wave flux
    !
    ! If *phy_radflx* is not initialized by "PhyRadFluxCreate" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(inout):: xyr_RadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux

    real(DP), intent(in):: xyr_TauQVap (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of water
    real(DP), intent(in):: xyr_TauDryAir (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ū
                              ! Optical depth of air
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: xy_InAngle (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)

    real(DP):: xy_SurfAlbedo (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo

    integer:: bn
    real(DP):: BandWeightSum

    integer:: BandNumber
                              ! ûȥХɿ. 
                              ! Number of short wave band

    real(DP), pointer:: AbsorpCoeffQVap(:)
                              ! εۼ. 
                              ! Absorption coefficient of water
    real(DP), pointer:: AbsorpCoeffDryAir(:)
                              ! εۼ. 
                              ! Absorption coefficient of air
    real(DP), pointer:: BandWeight(:)
                              ! Хɥ. 
                              ! Band weight
    real(DP):: SecScat
                              !  $ sec \zeta $
                              ! $ sec \zeta $ of scattering

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxShortFlux'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    kmax          = phy_radflx % kmax   
    xy_InAngle    = phy_radflx % xy_InAngle
    xy_SurfAlbedo = phy_radflx % xy_SurfAlbedo

    BandNumber        =  phy_radflx % ShortBandNumber        
    AbsorpCoeffQVap   => phy_radflx % ShortAbsorpCoeffQVap   
    AbsorpCoeffDryAir => phy_radflx % ShortAbsorpCoeffDryAir 
    BandWeight        => phy_radflx % ShortBandWeight        
    SecScat           =  phy_radflx % ShortSecScat      

    !-----------------------------------------------------------------
    !  ХɥȤ
    !  Configure band weight
    !-----------------------------------------------------------------
    BandWeightSum = 0.0_DP

    do bn = 1, BandNumber
      BandWeightSum =  BandWeightSum +  BandWeight(bn)
    end do

    do bn = 1, BandNumber
      BandWeight(bn) = BandWeight(bn) / BandWeightSum
    end do

    do bn = 1, BandNumber
      do k = 0, kmax

        !-------------------------------------------------------------
        !  ƥ٥ǤβƩ
        !  Downward transmission on each level
        !-------------------------------------------------------------
        if ( k /= kmax ) then
          xyr_RadSFlux(:,:,k) = &
            &   xyr_RadSFlux(:,:,k) & 
            & + BandWeight(bn) * xyr_RadSFlux(:,:,kmax) &
            &   * exp( - xy_InAngle(:,:) &
            &            * (   AbsorpCoeffQVap(bn) * xyr_TauQVap(:,:,k) &
            &                + AbsorpCoeffDryAir(bn) * xyr_TauDryAir(:,:,k) ) &
            &       )
        end if
        
        !-------------------------------------------------------------
        !  ƥ٥ǤξƩ
        !  Upward transmission on each level
        !-------------------------------------------------------------
        xyr_RadSFlux(:,:,k) = &
          &   xyr_RadSFlux(:,:,k) & 
          & - BandWeight(bn) * xyr_RadSFlux(:,:,kmax) &
          &   * exp( - xy_InAngle(:,:) &
          &            * (   AbsorpCoeffQVap(bn) * xyr_TauQVap(:,:,0) &
          &                + AbsorpCoeffDryAir(bn) * xyr_TauDryAir(:,:,0) ) &
          &       ) &
          &   * xy_SurfAlbedo &
          &   * exp( - SecScat &
          &            * (   AbsorpCoeffQVap(bn) &
          &                  * ( xyr_TauQVap(:,:,0) - xyr_TauQVap(:,:,k) ) &
          &                + AbsorpCoeffDryAir(bn) &
          &                  * ( xyr_TauDryAir(:,:,0) - xyr_TauDryAir(:,:,k) ) &
          &              ) &
          &        )
      end do
    end do

    !-----------------------------------------------------------------
    !  ۼʤξ
    !  In the case of no absorption
    !-----------------------------------------------------------------
    if ( BandNumber == 0 ) then
      do k = 0, kmax
        xyr_RadSFlux(:,:,k) = &
          & ( 1.0_DP - xy_SurfAlbedo ) * xyr_RadSFlux(:,:,kmax)
      end do
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxShortFlux

  subroutine PhyRadFluxDTempDt( phy_radflx, &
    & xyr_RadLFlux, &
    & xyr_RadSFlux, &
    & xyr_Press, &
    & xyz_DRadLTempDt, &
    & xyz_DRadSTempDt, &
    & err )
    !
    ! ͤˤ벹ѲΨ׻ޤ. 
    !
    ! ʤ, Ϳ줿 *phy_radflx*  PhyRadFluxCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Calculate temperature tendency with radiation.
    !
    ! If *phy_radflx* is not initialized by "PhyRadFluxCreate" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    real(DP), intent(in):: xyr_RadLFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
    real(DP), intent(in):: xyr_RadSFlux (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux
    real(DP), intent(in):: xyr_Press (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xyz_DRadLTempDt (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with long wave
    real(DP), intent(out):: xyz_DRadSTempDt (0:phy_radflx%imax-1, 0:phy_radflx%jmax-1, 0:phy_radflx%kmax-1)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with short wave

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxDTempDt'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_radflx* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_radflx*
    !-----------------------------------------------------------------
    kmax        = phy_radflx % kmax   
    Grav        = phy_radflx % Grav   
    Cp          = phy_radflx % Cp   

    !----------------------------------------------------------------
    !  Ψα黻
    !  Calculate radiation cooling rate
    !----------------------------------------------------------------
    do k = 0, kmax - 1
      xyz_DRadLTempDt(:,:,k) = &
        & ( xyr_RadLFlux(:,:,k) - xyr_RadLFlux(:,:,k+1) ) &
        & / ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Cp * Grav
      xyz_DRadSTempDt(:,:,k) = &
        & ( xyr_RadSFlux(:,:,k) - xyr_RadSFlux(:,:,k+1) ) &
        & / ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Cp * Grav
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxDTempDt

!!$  subroutine PhyRadFluxSample( phy_radflx, err )
!!$    !--
!!$    ! PhyRadFluxSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_radflx*  PhyRadFluxCreate ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyRadFluxSample
!!$    !++
!!$    ! If *phy_radflx* is not initialized by "PhyRadFluxCreate" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYRADFLX), intent(inout):: phy_radflx
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyRadFluxSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_radflx % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYRADFLX'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_radflx* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_radflx*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_radflx % param_i
!!$!!$    param_r = phy_radflx % param_r
!!$!!$    param_c = phy_radflx % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyRadFluxSample

  subroutine PhyRadFluxClose( phy_radflx, err )
    !
    ! PHYRADFLX ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_radflx*  PhyRadFluxCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYRADFLX".
    ! Note that if *phy_radflx* is not initialized by "PhyRadFluxCreate" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYRADFLX), intent(inout):: phy_radflx
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyRadFluxClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_radflx % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYRADFLX'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYRADFLX" ξõ
    !  Clear the settings for "PHYRADFLX"
    !-----------------------------------------------------------------
    deallocate( phy_radflx % y_Lat )

    deallocate( phy_radflx % xy_SurfTemp )
    deallocate( phy_radflx % xy_SurfAlbedo )

    deallocate( phy_radflx % xy_TempSave )
    deallocate( phy_radflx % xyr_RadLFluxSave )
    deallocate( phy_radflx % xyra_DelRadLFluxSave )
    deallocate( phy_radflx % LongAbsorpCoeffQVap )
    deallocate( phy_radflx % LongAbsorpCoeffDryAir )
    deallocate( phy_radflx % LongBandWeight )

    deallocate( phy_radflx % xyr_RadSFluxSave )

    deallocate( phy_radflx % xy_IncomRadSFlux )
    deallocate( phy_radflx % xy_InAngle )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_radflx % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxClose

  subroutine PhyRadFluxPutLine( phy_radflx, unit, indent, err )
    !
    !  *phy_radflx* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_radflx*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_date, only: toChar
    implicit none
    type(PHYRADFLX), intent(in):: phy_radflx
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyRadFluxPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYRADFLX" ΰ
    !  Print the settings for "PHYRADFLX"
    !-----------------------------------------------------------------
    if ( phy_radflx % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYRADFLX:: @initialized=%y', &
        & l = (/phy_radflx % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_radflx % imax, phy_radflx % jmax, phy_radflx % kmax/) )

      call PutLine( phy_radflx % y_Lat, unit = out_unit, &
        & lbounds = lbound(phy_radflx % y_Lat), &
        & ubounds = ubound(phy_radflx % y_Lat), &
        & indent = indent_str(1:indent_len) // &
        & ' @y_Lat=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Grav=%f @Cp=%f @StB=%f', &
        & d = (/ phy_radflx % Grav, phy_radflx % Cp, phy_radflx % StB/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @current_time=%c', &
        & c1 = trim( toChar(phy_radflx % current_time) ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @delta_time=%c', &
        & c1 = trim( toChar(phy_radflx % delta_time) ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @delta_time_RadLong=%c', &
        & c1 = trim( toChar(phy_radflx % delta_time_RadLong) ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @delta_time_RadShort=%c', &
        & c1 = trim( toChar(phy_radflx % delta_time_RadShort) ) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @LongBandNumber=%d, @LongPathLengthFact=%f', &
        & i = (/ phy_radflx % LongBandNumber /), &
        & d = (/ phy_radflx % LongPathLengthFact /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @LongAbsorpCoeffQVap=%*f', &
        & d = (/ phy_radflx % LongAbsorpCoeffQVap /), &
        & n = (/ phy_radflx % LongBandNumber /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @LongAbsorpCoeffDryAir=%*f', &
        & d = (/ phy_radflx % LongAbsorpCoeffDryAir /), &
        & n = (/ phy_radflx % LongBandNumber /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @LongBandWeight=%*f', &
        & d = (/ phy_radflx % LongBandWeight /), &
        & n = (/ phy_radflx % LongBandNumber /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @ShortBandNumber=%d, @ShortSecScat=%f', &
        & i = (/ phy_radflx % ShortBandNumber /), &
        & d = (/ phy_radflx % ShortSecScat /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @ShortAbsorpCoeffQVap=%*f', &
        & d = (/ phy_radflx % ShortAbsorpCoeffQVap /), &
        & n = (/ phy_radflx % ShortBandNumber /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @ShortAbsorpCoeffDryAir=%*f', &
        & d = (/ phy_radflx % ShortAbsorpCoeffDryAir /), &
        & n = (/ phy_radflx % ShortBandNumber /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @ShortBandWeight=%*f', &
        & d = (/ phy_radflx % ShortBandWeight /), &
        & n = (/ phy_radflx % ShortBandNumber /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @SolarCoeff=%f, @AtmosAlbedo=%f', &
        & d = (/ phy_radflx % SolarCoeff, phy_radflx % AtmosAlbedo /) )

!!$      call Printf( out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @EpsOrb=%f, @EqnOrb=%f', &
!!$        & d = (/ phy_radflx % EpsOrb, phy_radflx % EqnOrb /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @IncomAIns=%f, @IncomBIns=%f', &
        & d = (/ phy_radflx % IncomAIns, phy_radflx % IncomBIns /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @IncomAZet=%f, @IncomBZet=%f', &
        & d = (/ phy_radflx % IncomAZet, phy_radflx % IncomBZet /) )

      call PutLine( phy_radflx % xy_SurfTemp, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_SurfTemp), &
        & ubounds = ubound(phy_radflx % xy_SurfTemp), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfTemp=' )

      call PutLine( phy_radflx % xy_SurfAlbedo, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_SurfAlbedo), &
        & ubounds = ubound(phy_radflx % xy_SurfAlbedo), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfAlbedo=' )

      call PutLine( phy_radflx % xy_TempSave, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_TempSave), &
        & ubounds = ubound(phy_radflx % xy_TempSave), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_TempSave=' )

      call PutLine( phy_radflx % xyr_RadLFluxSave, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xyr_RadLFluxSave), &
        & ubounds = ubound(phy_radflx % xyr_RadLFluxSave), &
        & indent = indent_str(1:indent_len) // &
        & ' @xyr_RadLFluxSave=' )

      call PutLine( phy_radflx % xyra_DelRadLFluxSave, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xyra_DelRadLFluxSave), &
        & ubounds = ubound(phy_radflx % xyra_DelRadLFluxSave), &
        & indent = indent_str(1:indent_len) // &
        & ' @xyra_DelRadLFluxSave=' )

      call PutLine( phy_radflx % xy_IncomRadSFlux, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_IncomRadSFlux), &
        & ubounds = ubound(phy_radflx % xy_IncomRadSFlux), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_IncomRadSFlux=' )

      call PutLine( phy_radflx % xy_InAngle, unit = out_unit, &
        & lbounds = lbound(phy_radflx % xy_InAngle), &
        & ubounds = ubound(phy_radflx % xy_InAngle), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_InAngle=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYRADFLX:: @initialized=%y>', &
        & l = (/phy_radflx % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxPutLine

  logical function PhyRadFluxInitialized( phy_radflx ) result(result)
    !
    ! *phy_radflx* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_radflx* is initialized, .true. is returned.
    ! If *phy_radflx* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYRADFLX), intent(in):: phy_radflx
  continue
    result = phy_radflx % initialized
  end function PhyRadFluxInitialized

  subroutine PhyRadFluxNmlRead( nmlfile, &
    & delta_time_value_RadLong, delta_time_unit_RadLong_, &
    & delta_time_value_RadShort, delta_time_unit_RadShort_, &
    & LongBandNumber, &
    & LongAbsorpCoeffQVap, LongAbsorpCoeffDryAir, &
    & LongBandWeight, LongPathLengthFact, &
    & ShortBandNumber, &
    & ShortAbsorpCoeffQVap, ShortAbsorpCoeffDryAir, &
    & ShortBandWeight, ShortSecScat, &
    & SolarCoeff, AtmosAlbedo, &
!!$    & EpsOrb, EqnOrb, &
    & IncomAIns, IncomBIns, IncomAZet, IncomBZet, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. PhyRadFluxCreate ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "PhyRadFluxCreate".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    real(DP), intent(inout):: delta_time_value_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ֤ο. 
                              ! Value of step interval of long wave flux calculation
    character(*), intent(inout):: delta_time_unit_RadLong_
    character(STRING):: delta_time_unit_RadLong
                              ! Ĺȥեå׻륹ƥå״ֳ֤ñ. 
                              ! Unit of step interval of long wave flux calculation
    real(DP), intent(inout):: delta_time_value_RadShort
                              ! û () եå׻륹ƥå״ֳ֤ο. 
                              ! Value of step interval of short wave (insolation) flux calculation
    character(*), intent(inout):: delta_time_unit_RadShort_
    character(STRING):: delta_time_unit_RadShort
                              ! û () եå׻륹ƥå״ֳ֤ñ. 
                              ! Unit of step interval of short wave (insolation) flux calculation
    integer, intent(inout):: LongBandNumber
                              ! ĹȥХɿ. 
                              ! Number of long wave band
    real(DP), intent(inout):: LongAbsorpCoeffQVap(1:MaximumBandNumber)
                              ! εۼ. 
                              ! Absorption coefficient of water
    real(DP), intent(inout):: LongAbsorpCoeffDryAir(1:MaximumBandNumber)
                              ! εۼ. 
                              ! Absorption coefficient of air
    real(DP), intent(inout):: LongBandWeight(1:MaximumBandNumber)
                              ! Хɥ. 
                              ! Band weight
    real(DP), intent(inout):: LongPathLengthFact
                              ! ϩĹΥե. 
                              ! Factor of optical length
    integer, intent(inout):: ShortBandNumber
                              ! ûȥХɿ. 
                              ! Number of long wave band
    real(DP), intent(inout):: ShortAbsorpCoeffQVap(1:MaximumBandNumber)
                              ! εۼ. 
                              ! Absorption coefficient of water
    real(DP), intent(inout):: ShortAbsorpCoeffDryAir(1:MaximumBandNumber)
                              ! εۼ. 
                              ! Absorption coefficient of air
    real(DP), intent(inout):: ShortBandWeight(1:MaximumBandNumber)
                              ! Хɥ. 
                              ! Band weight
    real(DP), intent(inout):: ShortSecScat
                              !  $ sec \zeta $
                              ! $ sec \zeta $ of scattering
    real(DP), intent(inout):: SolarCoeff
                              ! . 
                              ! Solar constant
    real(DP), intent(inout):: AtmosAlbedo
                              ! 絤٥. 
                              ! Albedo of air

!!$    real(DP), intent(inout):: EpsOrb
!!$                              ! ƻг. 
!!$                              ! Inclination of equator to orbit
!!$    real(DP), intent(inout):: EqnOrb
!!$                              ! . 
!!$                              ! 
    real(DP), intent(inout):: IncomAIns
                              ! ǯʿͤη. 
                              ! Coefficient of annual mean incoming radiation. 
    real(DP), intent(inout):: IncomBIns
                              ! ǯʿͤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    real(DP), intent(inout):: IncomAZet
                              ! ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    real(DP), intent(inout):: IncomBZet
                              ! ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    namelist /phy_radiation_flux_nml/ &
      & delta_time_value_RadLong, delta_time_unit_RadLong, &
      & delta_time_value_RadShort, delta_time_unit_RadShort, &
      & LongBandNumber, &
      & LongAbsorpCoeffQVap, LongAbsorpCoeffDryAir, &
      & LongBandWeight, LongPathLengthFact, &
      & ShortBandNumber, &
      & ShortAbsorpCoeffQVap, ShortAbsorpCoeffDryAir, &
      & ShortBandWeight, ShortSecScat, &
      & SolarCoeff, AtmosAlbedo, &
!!$      & EpsOrb, EqnOrb, &
      & IncomAIns, IncomBIns, IncomAZet, IncomBZet
                              ! phy_radiation_flux ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_radiation_flux#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_radiation_flux" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_radiation_flux#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyRadFluxNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
    delta_time_unit_RadLong = delta_time_unit_RadLong_
    delta_time_unit_RadShort = delta_time_unit_RadShort_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    read( unit = unit_nml, & ! (in)
      & nml = phy_radiation_flux_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1 = 'phy_radiation_flux_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_radiation_flux_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1 = 'phy_radiation_flux_nml', c2 = trim(nmlfile), &
        & i = (/iostat_nml/) )
    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
    delta_time_unit_RadLong_ = delta_time_unit_RadLong
    delta_time_unit_RadShort_ = delta_time_unit_RadShort

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyRadFluxNmlRead

end module phy_radiation_flux
