!= ɽ̥ǡ⥸塼
!
!= Surface data data generation module
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: surface_data.f90,v 1.11 2008-03-02 14:22:09 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module surface_data
  !
  != ɽ̥ǡ⥸塼
  !
  != Surface data data generation module
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! GCM Ѥɽ̥ǡޤ.
  ! եؤνϤϼץǹԤȤꤷƤޤ.
  ! ߤϻŪ Hosaka et al. (1998)  SST ʬۤͿޤ.
  !
  ! Surface data for GCM is generated.
  ! File output is expected to done by a main program.
  ! Now, SST profile in Hosaka et al. (1998) is provided tentatively.
  !
  !== Procedures List
  !
  ! SurfDataCreate        :: SRFDAT ѿν
  ! SurfDataGetAxes       :: ɸǡμ
  ! SurfDataGet           :: ɽ̥ǡμ
  ! SurfDataClose         :: SRFDAT ѿνλ
  ! SurfDataPutLine       :: SRFDAT ѿ˳ǼƤΰ
  ! SurfDataInitialized   :: SRFDAT ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! SurfDataCreate        :: Constructor of "SRFDAT"
  ! SurfDataGetAxes       :: Get axes data
  ! SurfDataGet           :: Get surface data
  ! SurfDataClose         :: Deconstructor of "SRFDAT"
  ! SurfDataPutLine       :: Print information of "SRFDAT"
  ! SurfDatainitialized   :: Check initialization of "SRFDAT"
  !
  !== Usage
  !
  ! Ϥ, SRFDAT ѿ, SurfDataCreate ǽԤޤ.
  ! , SurfDataGet ˤäɽ̥ǡɤ߹Ǥ.
  ! ǡɤ߹ˤ SurfDataGetAxes ѤƤ.
  ! Ǹ, SRFDAT ѿνλ SurfDataClose ˤƹԤޤ.
  !
  ! First, initialize "SRFDAT" by "SurfDataCreate".
  ! Then, get surface data by "SurfDataGet".
  ! If axes data is needed, get it by "SurfDataGetAxes".
  ! Finally, terminate "SRFDAT" by "SurfDataClose".
  !

  use dc_types, only: TOKEN, DP
  implicit none
  private
  public:: SRFDAT, SurfDataCreate, SurfDataGetAxes, SurfDataGet
  public:: SurfDataClose, SurfDataPutLine, SurfDataInitialized

  type SRFDAT
    !
    ! ޤ, SurfDataCreate  "SRFDAT" ѿꤷƲ.
    ! 줿 "SRFDAT" ѿѤݤˤ,
    ! SurfDataClose ˤäƽλԤäƤ.
    !
    ! Initialize "SRFDAT" variable by "SurfDataCreate" before usage.
    ! If you reuse "SRFDAT" variable again for another application, 
    ! terminate by "SurfDataClose".
    !
    logical:: initialized = .false.    ! initialization flag
    character(TOKEN):: pattern
                              ! ɽ̥ǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Surface data pattern. 
                              ! Available patterns are as follows.
                              ! 
                              ! * "Hosaka et al. (1998)"
                              ! * "Homogeneous"
                              ! 
    integer:: nmax ! ȿ. 
                   ! Maximum truncated wavenumber
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    real(DP):: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), pointer:: x_Lon (:) =>null()
                              ! . Longitude
    real(DP), pointer:: x_Lon_Weight (:) =>null()
                              ! ʬѺɸŤ. 
                              ! Weight for integration in longitude
    real(DP), pointer:: y_Lat (:) =>null()
                              ! . Latitude
    real(DP), pointer:: y_Lat_Weight (:) =>null()
                              ! ʬѺɸŤ. 
                              ! Weight for integration in latitude

    real(DP):: TempBase
                              ! $ T $ . ٤δܾ. Basic state temperature
    real(DP), pointer:: xy_SurfTemp (:,:) =>null()
                              ! ɽ̲. 
                              ! Surface temperature
  end type SRFDAT

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: surface_data.f90,v 1.11 2008-03-02 14:22:09 morikawa Exp $'

  !-----------------------------------------------------------------
  !  ³
  !  Public procedures
  !-----------------------------------------------------------------

  interface SurfDataCreate
    module procedure SurfDataCreate
  end interface

  interface SurfDataGetAxes
    module procedure SurfDataGetAxes
  end interface

  interface SurfDataGet
    module procedure SurfDataGet
  end interface

  interface SurfDataClose
    module procedure SurfDataClose
  end interface

  interface SurfDataPutLine
    module procedure SurfDataPutLine
  end interface

  interface SurfDataInitialized
    module procedure SurfDataInitialized
  end interface

  !-----------------------------------------------------------------
  !  ³
  !  Private procedures
  !-----------------------------------------------------------------

  interface NmlRead
    module procedure SurfDataNmlRead
  end interface

contains

  subroutine SurfDataCreate( srf_dat, &
    & nmax, imax, jmax, &
    & PI, &
    & TempBase, &
    & pattern, &
    & nmlfile, err )
    !
    ! SRFDAT ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! SRFDAT ѿꤷƤ.
    !
    ! ץʥ *PI* ٿ饸Ѵݤ˻Ѥޤ.
    ! ΰͿʤ, 
    ! constants ⥸塼뤫ǥեͤѤޤ.
    !
    ! ʤ, Ϳ줿 *srf_dat* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#surface_data_nml 򻲾ȤƤ. 
    !
    ! Constructor of "SRFDAT".
    ! Initialize *srf_dat* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Optinal argument *PI* is used for conversion of degree into radian.
    ! If this argument is not given, 
    ! default valuse provided by "constants" module is used instead.
    !
    ! Note that if *srf_dat* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#surface_data_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_error, only: DC_NOERR, DC_EALREADYINIT, DC_ENEGATIVE, DC_ENOFILEREAD
    use dcpam_error, only: StoreError, DCPAM_EBADPATTERN
    use constants, only: CONST, Create, Get
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_string, only: LChar
    use dc_message, only: MessageNotify
    use w_module, only: w_Initial, &
      & x_Lon_spml => x_Lon, y_Lat_spml => y_Lat, &
      & x_Lon_Weight_spml => x_Lon_Weight, &
      & y_Lat_Weight_spml => y_Lat_Weight
    implicit none
    type(SRFDAT), intent(inout):: srf_dat
    integer, intent(in):: nmax ! ȿ. 
                               ! Maximum truncated wavenumber
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    real(DP), intent(in), optional:: PI  ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(in), optional:: TempBase
                              ! $ T $ . ٤δܾ. Basic state temperature
    character(*), intent(in), optional:: pattern
                              ! ɽ̥ǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Surface data pattern. 
                              ! Available patterns are as follows.
                              ! 
                              ! * "Hosaka et al. (1998)"
                              ! * "Homogeneous"
                              ! 
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#surface_data_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#surface_data_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ (Hosaka et al. (1998))
    !  Work variables (Hosaka et al. (1998))
    real(DP):: TempEq         ! ƻ (Τˤ LatCenter ) Ǥβ.
                              ! Temperature on the equator 
                              ! (on LatCenter, to be exact)
    real(DP):: LatCenter      ! ٺǹΰ. 
                              ! Latitude on which temperature is maximum.
    real(DP):: LatFlatWidth   ! ٤ʿó. 
                              ! Latitude width in which temperature is flattened
    integer:: jp
    integer:: jm

    real(DP):: LatA, Alpha, Beta, Gamma

    real(DP):: Phi1, AlphaBeta4, Phi, LatAPlus, LatAMinus
    real(DP):: SurfTempMx
    real(DP):: xy_SurfTemp (0:imax-1, 0:jmax-1)
    real(DP):: y_Lat (0:jmax-1)
                              ! . Latitude

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(CONST):: const_earth
    integer:: j               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'SurfDataCreate'
  continue
    call BeginSub(subname, version)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (srf_dat % initialized) then
      stat = DC_EALREADYINIT
      cause_c = 'SRFDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʻ
    !  Configure grid point
    !-----------------------------------------------------------------
    srf_dat % nmax = nmax
    srf_dat % imax = imax
    srf_dat % jmax = jmax

    !-----------------------------------------------------------------
    !  ͥǡΥѥ
    !  Get initial data pattern from argument
    !-----------------------------------------------------------------
    if ( present(pattern) ) then
      srf_dat % pattern = pattern
    else
      srf_dat % pattern = ''
    end if

    !---------------------------------------------------------
    !  ʪν
    !  Prepare physical constants
    !---------------------------------------------------------
    call Create( const_earth ) ! (inout)
    call Get( constant = const_earth, & ! (inout)
      & PI = srf_dat % PI )             ! (out)

    if ( present(PI) ) srf_dat % PI = PI

    if ( present(TempBase) ) then
      srf_dat % TempBase = TempBase
    else
      srf_dat % TempBase = 302.0_DP
    end if

    !-----------------------------------------------------------------
    !  NAMELIST ͤ
    !  Get values from NAMELIST
    !-----------------------------------------------------------------
    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1=trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & nmax = srf_dat % nmax, &   ! (inout)
!!$        & imax = srf_dat % imax, &   ! (inout)
!!$        & jmax = srf_dat % jmax, &   ! (inout)
!!$        & PI = srf_dat % PI, &   ! (inout)
        & TempBase = srf_dat % TempBase, & ! (inout)
        & pattern_ = srf_dat % pattern, &  ! (inout)
        & err = err )                          ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1=trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (srf_dat % nmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'nmax'
      goto 999
    end if
    if (srf_dat % imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (srf_dat % jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ɽ̥ǡΥѥ
    !  Surface data pattern
    !-----------------------------------------------------------------
    if ( trim(srf_dat % pattern) == '' ) then
      srf_dat % pattern = 'Hosaka et al. (1998)'  ! ߤϻŪ Hosaka et al. (1998) ǥեȤˤ
    else
      select case ( LChar( trim(srf_dat % pattern) ) )
      case ( 'hosaka et al. (1998)' )
      case ( 'homogeneous' )
      case default
        stat = DCPAM_EBADPATTERN
        cause_c = trim(srf_dat % pattern)
        goto 999
      end select
    end if

    !-----------------------------------------------------------------
    !  ɸǡ
    !  Create axes data
    !-----------------------------------------------------------------
    call w_Initial( srf_dat % nmax, srf_dat % imax, srf_dat % jmax )
    allocate( srf_dat % x_Lon (0:srf_dat%imax-1) )
    srf_dat % x_Lon = x_Lon_spml
    allocate( srf_dat % x_Lon_Weight (0:srf_dat%imax-1) )
    srf_dat % x_Lon_Weight = x_Lon_Weight_spml

    allocate( srf_dat % y_Lat (0:srf_dat%jmax-1) )
    srf_dat % y_Lat = y_Lat_spml
    y_Lat = srf_dat % y_Lat
    allocate( srf_dat % y_Lat_Weight (0:srf_dat%jmax-1) )
    srf_dat % y_Lat_Weight = y_Lat_Weight_spml

    !-----------------------------------------------------------------
    !  ɽ̥ǡ
    !  Create surface data
    !-----------------------------------------------------------------
    select case ( LChar( trim(srf_dat % pattern) ) )
    case ( 'homogeneous' )

      allocate( srf_dat % xy_SurfTemp(0:srf_dat%imax-1, 0:srf_dat%jmax-1) )
      srf_dat % xy_SurfTemp = srf_dat % TempBase

    case ( 'hosaka et al. (1998)' )

      TempEq       = srf_dat % TempBase
      LatCenter    =   0.0_DP
      LatFlatWidth =   7.0_DP

      LatA         =  30.0_DP
      Alpha        =  60.0_DP
      Beta         =  32.0_DP
      Gamma        =   0.0_DP

      Phi1 = abs( LatA * PI / 180.0_DP )
      AlphaBeta4  = 2.0_DP *( Phi1**3 ) * ( Beta / Alpha )

      do j = 0, jmax - 1
        Phi = abs( y_Lat(j) - LatCenter * PI / 180.0_DP )
        xy_SurfTemp (:,j) = &
          & TempEq &
          & - Alpha / 2.0_DP &
          &   * ( Phi - max( sqrt( Phi1**2 + AlphaBeta4 ) - sqrt( ( Phi - Phi1 )**2 + AlphaBeta4 ), 0.0_DP ) ) &
          & + Gamma * ( Phi**3 )
      end do

      !----- 濴 LatCenter +/- LatFlatWidth δ֤ʿó ------
      if ( LatFlatWidth < 0.0_DP ) then
        LatFlatWidth = - LatFlatWidth
      end if
      LatAPlus = ( LatCenter + LatFlatWidth ) * PI / 180.0_DP
      LatAMinus = ( LatCenter - LatFlatWidth ) * PI / 180.0_DP

      jp = 0
      jm = jmax - 1
      do  j = 0, jmax - 1
        if ( y_Lat(j) <= LatAPlus ) then
          jp = j
          if ( j == jmax - 1 ) jp = jp - 1
        end if
        if ( y_Lat(j) < LatAMinus ) then
          jm = j
          if ( j == jmax - 1 ) jm = jm - 1
        end if
      end do

      SurfTempMx = &
        & (   xy_SurfTemp(1,jm) * ( y_Lat(jm+1) - LatAMinus ) &
        &   + xy_SurfTemp(1,jm+1) * ( LatAMinus - y_Lat(jm) ) &
        & ) &
        & / ( y_Lat(jm+1) - y_Lat(jm) )

      xy_SurfTemp(:,jm+1:jp) = SurfTempMx

      allocate( srf_dat % xy_SurfTemp(0:srf_dat%imax-1, 0:srf_dat%jmax-1) )
      srf_dat % xy_SurfTemp = xy_SurfTemp

    end select

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    srf_dat % initialized = .true.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine SurfDataCreate

  subroutine SurfDataGetAxes( srf_dat, &
    & x_Lon, x_Lon_Weight, y_Lat, y_Lat_Weight, &
    & err )
    !
    ! ɸǡ֤ޤ.
    !
    ! ʤ, Ϳ줿 *srf_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return axes data.
    !
    ! If *srf_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(SRFDAT), intent(inout):: srf_dat
    real(DP), intent(out), optional:: x_Lon (0:srf_dat % imax-1)
                              ! . Longitude
    real(DP), intent(out), optional:: x_Lon_Weight (0:srf_dat%imax-1)
                              ! ʬѺɸŤ. 
                              ! Weight for integration in longitude
    real(DP), intent(out), optional:: y_Lat (0:srf_dat % jmax-1)
                              ! . Latitude
    real(DP), intent(out), optional:: y_Lat_Weight (0:srf_dat%jmax-1)
                              ! ʬѺɸŤ. 
                              ! Weight for integration in latitude
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'SurfDataGetAxes'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. srf_dat % initialized) then
      stat = DC_ENOTINIT
      cause_c = 'SRFDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ɽ̥ǡμФ
    !  Fetch surface data
    !-----------------------------------------------------------------
    if ( present(x_Lon       ) ) x_Lon        = srf_dat % x_Lon
    if ( present(x_Lon_Weight) ) x_Lon_Weight = srf_dat % x_Lon_Weight
    if ( present(y_Lat       ) ) y_Lat        = srf_dat % y_Lat
    if ( present(y_Lat_Weight) ) y_Lat_Weight = srf_dat % y_Lat_Weight

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine SurfDataGetAxes


  subroutine SurfDataGet( srf_dat, &
    & xy_SurfTemp, &
    & err )
    !
    ! GCM Ѥɽ̥ǡ֤ޤ.
    !
    ! ʤ, Ϳ줿 *srf_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return surface data for GCM.
    !
    ! If *srf_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(SRFDAT), intent(inout):: srf_dat
    real(DP), intent(out):: xy_SurfTemp (0:srf_dat%imax-1, 0:srf_dat%jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'SurfDataGet'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. srf_dat % initialized) then
      stat = DC_ENOTINIT
      cause_c = 'SRFDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ɽ̥ǡμФ
    !  Fetch surface data
    !-----------------------------------------------------------------
    xy_SurfTemp = srf_dat % xy_SurfTemp

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine SurfDataGet

  subroutine SurfDataClose( srf_dat, err )
    !
    ! SRFDAT ѿνλԤޤ.
    ! ʤ, Ϳ줿 *srf_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "SRFDAT".
    ! Note that if *srf_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(SRFDAT), intent(inout):: srf_dat
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'SurfDataClose'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. srf_dat % initialized) then
      stat = DC_ENOTINIT
      cause_c = 'SRFDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "SRFDAT" ξõ
    !  Clear the settings for "DYNSP"
    !-----------------------------------------------------------------
    deallocate( srf_dat % xy_SurfTemp )
    deallocate( srf_dat % x_Lon )
    deallocate( srf_dat % x_Lon_Weight )
    deallocate( srf_dat % y_Lat )
    deallocate( srf_dat % y_Lat_Weight )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    srf_dat % initialized = .false.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine SurfDataClose

  subroutine SurfDataPutLine( srf_dat, unit, indent, err )
    !
    !  *srf_dat* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *srf_dat*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: Printf, PutLine
    implicit none
    type(SRFDAT), intent(inout):: srf_dat
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνϤɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'SurfDataPutLine'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if (present(indent)) then
      if (len(indent) /= 0) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "SRFDAT" ΰ
    !  Print the settings for "SRFDAT"
    !-----------------------------------------------------------------
    if (srf_dat % initialized) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<SRFDAT:: @initialized=%y @pattern="%c"', &
        & c1 = trim( srf_dat % pattern ), &
        & l = (/srf_dat % initialized/))

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @nmax=%d @imax=%d @jmax=%d', &
        & i = (/srf_dat % nmax, srf_dat % imax, srf_dat % jmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @PI=%f', &
        & d = (/srf_dat % PI/) )

      call PutLine( srf_dat % x_Lon, unit = out_unit, &
        & lbounds = lbound(srf_dat % x_Lon), &
        & ubounds = ubound(srf_dat % x_Lon), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_Lon=' )

      call PutLine( srf_dat % y_Lat, unit = out_unit, &
        & lbounds = lbound(srf_dat % y_Lat), &
        & ubounds = ubound(srf_dat % y_Lat), &
        & indent = indent_str(1:indent_len) // &
        & ' @y_Lat=' )

      call PutLine( srf_dat % xy_SurfTemp, unit = out_unit, &
        & lbounds = lbound(srf_dat % xy_SurfTemp), &
        & ubounds = ubound(srf_dat % xy_SurfTemp), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfTemp=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<SRFDAT:: @initialized=%y>', &
        & l = (/srf_dat % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine SurfDataPutLine

  logical function SurfDataInitialized( srf_dat ) result(result)
    !
    ! *srf_dat* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *srf_dat* is initialized, .true. is returned.
    ! If *srf_dat* is not initialized, .false. is returned.
    !
    implicit none
    type(SRFDAT), intent(in):: srf_dat
  continue
    result = srf_dat % initialized
  end function SurfDataInitialized

  subroutine SurfDataNmlRead( nmlfile, &
!!$    & nmax, imax, jmax, &
!!$    & PI, &
    & TempBase, &
    & pattern_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: nmax ! ȿ. 
!!$                               ! Maximum truncated wavenumber
!!$    integer, intent(inout):: imax ! ٳʻ. 
!!$                               ! Number of grid points in longitude
!!$    integer, intent(inout):: jmax ! ٳʻ. 
!!$                               ! Number of grid points in latitude
!!$    real(DP), intent(inout), optional:: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(inout):: TempBase
                              ! $ T $ . ٤δܾ. Basic state temperature
    character(*), intent(inout):: pattern_
    character(TOKEN):: pattern
                              ! ɽ̥ǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Surface data pattern. 
                              ! Available patterns are as follows.
                              ! 
                              ! * "Hosaka et al. (1998)"
                              ! * "Homogeneous"
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    namelist /surface_data_nml/ &
!!$      & nmax, imax, jmax, &
!!$      & PI, &
      & TempBase, &
      & pattern
                              ! surface_data ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! surface_data#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "surface_data" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "surface_data#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'SurfDataNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
    pattern = pattern_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    read( unit = unit_nml, & ! (in)
      & nml = surface_data_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='surface_data_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = surface_data_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='surface_data_nml', c2=trim(nmlfile), &
        & i=(/iostat_nml/) )
    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
    pattern_ = pattern

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine SurfDataNmlRead

!!$  subroutine SurfDataSample( srf_dat, err )
!!$    !--
!!$    ! SurfDataSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *srf_dat*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of SurfDataSample
!!$    !++
!!$    ! If *srf_dat* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(SRFDAT), intent(inout):: srf_dat
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'SurfDataSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. srf_dat % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'SRFDAT'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *srf_dat* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *srf_dat*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = srf_dat % param_i
!!$!!$    param_r = srf_dat % param_r
!!$!!$    param_c = srf_dat % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine SurfDataSample


end module surface_data

