!= surface_data ⥸塼Υƥȥץ
!
!= Test program for "surface_data"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: surface_data_test.f90,v 1.6 2008-03-02 14:22:09 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! surface_data ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "surface_data" module.
! Confirm compilation and execution of this program.
!

program surface_data_test
  use constants, only: CONST, Create, Get
  use surface_data, only: SRFDAT, SurfDataCreate, SurfDataClose, &
    & SurfDataPutLine, SurfDataInitialized, SurfDataGetAxes, SurfDataGet
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, DCArgsOpen, DCArgsHelpMsg, DCArgsOption, &
    & DCArgsDebug, DCArgsHelp, DCArgsStrict, DCArgsClose
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'surface_data_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "surface_data" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: nmax = 10         ! ȿ. 
                              ! Maximum truncated wavenumber
  integer:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), allocatable:: x_Lon (:) ! . Longitude
  real(DP), allocatable:: x_Lon_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in longitude
  real(DP), allocatable:: y_Lat (:) ! . Latitude
  real(DP), allocatable:: y_Lat_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in latitude
  real(DP), allocatable:: x_LonAns (:) ! . Longitude
  real(DP), allocatable:: x_Lon_WeightAns (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in longitude
  real(DP), allocatable:: y_LatAns (:) ! . Latitude
  real(DP), allocatable:: y_Lat_WeightAns (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in latitude

  !---------------------------------------------------------
  !  ɽ̥ǡ
  !  surface data
  !---------------------------------------------------------
  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲. 
                              ! Surface temperature
  real(DP), allocatable:: xy_SurfTempAns (:,:)

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option

  type(CONST):: const_earth
  real(DP):: PI  ! $ \pi $ .    ߼Ψ.         Circular constant
  type(SRFDAT):: srf_dat00, srf_dat01
  logical:: err
  character(*), parameter:: subname = 'surface_data_test'
continue

  !-------------------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line options handling
  !-------------------------------------------------------------------
  call cmdline_optparse ! ֥롼. This is an internal subroutine

  !---------------------------------------------------------
  !  ʪ
  !  Configure a physical constant
  !---------------------------------------------------------
  call Create( constant = const_earth ) ! (inout)
  call Get( constant = const_earth, & ! (inout)
    & PI = PI ) ! (out)

  !---------------------------------------------------------
  !  μ
  !  Get correct answer
  !---------------------------------------------------------
  allocate( x_LonAns (0:imax-1) )
  allocate( x_Lon_WeightAns (0:imax-1) )
  allocate( y_LatAns (0:jmax-1) )
  allocate( y_Lat_WeightAns (0:jmax-1) )
  call HistoryGet( &
    & file = 'surface_data_test00.nc', & ! (in)
    & varname = 'lon', &            ! (in)
    & array = x_LonAns )            ! (out)
  call HistoryGet( &
    & file = 'surface_data_test00.nc', & ! (in)
    & varname = 'lon_weight', &     ! (in)
    & array = x_Lon_WeightAns )     ! (out)
  call HistoryGet( &
    & file = 'surface_data_test00.nc', & ! (in)
    & varname = 'lat', &            ! (in)
    & array = y_LatAns )            ! (out)
  call HistoryGet( &
    & file = 'surface_data_test00.nc', & ! (in)
    & varname = 'lat_weight', &     ! (in)
    & array = y_Lat_WeightAns )     ! (out)

  x_LonAns = x_LonAns * PI / 180.0_DP
  y_LatAns = y_LatAns * PI / 180.0_DP

  allocate( xy_SurfTempAns (0:imax-1, 0:jmax-1) )
  call HistoryGet( &
    & file = 'surface_data_test00.nc', & ! (in)
    & varname = 'SurfTemp', &            ! (in)
    & array = xy_SurfTempAns )           ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call SurfDataCreate( srf_dat = srf_dat00, &  ! (out)
    & nmax = nmax, imax = imax, jmax = jmax, & ! (in)
    & PI = PI ) ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = SurfDataInitialized(srf_dat00) )
  call SurfDataPutLine( srf_dat = srf_dat00 ) ! (in)

  !---------------------------------------------------------
  !  ǡƥ
  !  Axes data test
  !---------------------------------------------------------
  allocate( x_Lon (0:imax-1) )
  allocate( x_Lon_Weight (0:imax-1) )
  allocate( y_Lat (0:jmax-1) )
  allocate( y_Lat_Weight (0:jmax-1) )

  call SurfDataGetAxes( srf_dat = srf_dat00, &      ! (inout)
    & x_Lon = x_Lon, x_Lon_Weight = x_Lon_Weight, & ! (out)
    & y_Lat = y_Lat, y_Lat_Weight = y_Lat_Weight )  ! (out)

  call AssertEqual( 'longitude test 1', &
    & answer = x_LonAns, check = x_Lon, &
    & significant_digits = 7, ignore_digits = -15 )

  call AssertEqual( 'weight for integration in longitude test 1', &
    & answer = x_Lon_WeightAns, check = x_Lon_Weight, &
    & significant_digits = 15, ignore_digits = -15 )

  call AssertEqual( 'latitude test 1', &
    & answer = y_LatAns, check = y_Lat, &
    & significant_digits = 7, ignore_digits = -15 )

  call AssertEqual( 'weight for integration in latitude test 1', &
    & answer = y_Lat_WeightAns, check = y_Lat_Weight, &
    & significant_digits = 15, ignore_digits = -15 )

  !---------------------------------------------------------
  !  ɽ̲٥ƥ
  !  Surface temperature test
  !---------------------------------------------------------
  allocate( xy_SurfTemp (0:imax-1, 0:jmax-1) )
  call SurfDataGet( srf_dat = srf_dat00, & ! (inout)
    & xy_SurfTemp = xy_SurfTemp )          ! (out)

  call AssertEqual( 'surface temperature test 1', &
    & answer = xy_SurfTempAns, check = xy_SurfTemp, &
    & significant_digits = 15, ignore_digits = -15 )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call SurfDataClose( srf_dat = srf_dat00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = SurfDataInitialized(srf_dat00) )
  call SurfDataPutLine( srf_dat = srf_dat00 ) ! (in)

  !---------------------------------------------------------
  !  NAMELIST ɤ߹ߥƥ
  !  NAMELIST loading test
  !---------------------------------------------------------
  call SurfDataCreate( srf_dat = srf_dat01, & ! (out)
    & nmax = nmax, imax = imax, jmax = jmax, &
    & nmlfile = VAL_namelist, err = err ) ! (in)
  call AssertEqual( 'NAMELIST loading test 1', &
    & answer = .true., check = err )
  call SurfDataPutLine( srf_dat = srf_dat01 ) ! (in)

contains

  subroutine cmdline_optparse
    !
    ! ޥɥ饤νԤޤ
    !
    ! Handle command line options
    !
    call DCArgsOpen( arg = arg )               ! (out)

    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Title', msg = title )      ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Usage', &                  ! (in)
      & msg = './' // trim(subname) // &
      &       ' [Options]' )                   ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Source', msg = source )    ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Institution', &            ! (in)
      & msg = institution )                    ! (in)

    call DCArgsOption( arg = arg, &           ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = OPT_namelist, &                ! (out)
      & value = VAL_namelist, &               ! (out)
      & help = "Namelist filename")           ! (in)

    call DCArgsDebug( arg = arg )  ! (inout)
    call DCArgsHelp( arg = arg )   ! (inout)
    call DCArgsStrict( arg = arg ) ! (inout)

    call DCArgsClose( arg = arg )  ! (inout)
  end subroutine cmdline_optparse

end program surface_data_test
