!= ʪ⥸塼
!
!= Physical constants control
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: constants.f90,v 1.14 2008-04-21 10:36:20 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module constants
  !
  != ʪ⥸塼
  !
  != Physical constants control
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʪꤹ뤿Υ⥸塼Ǥ.
  !
  ! This module manages physical constants.
  !
  !== Procedures List
  !
  ! Create        :: CONST ѿν
  ! Get           :: CONST ѿ˳Ǽʪμ
  ! PutLine       :: CONST ѿ˳ǼƤΰ
  ! Close         :: CONST ѿνλ
  ! initialized   :: CONST ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "CONST"
  ! Get           :: Get physical constants etc. stored in "CONST"
  ! PutLine       :: Print information of "CONST"
  ! Close         :: Deconstructor of "CONST"
  ! initialized   :: Check initialization of "CONST"
  !
  !== Usage
  !
  ! Ϥ, ¤ǡ CONST ѿ, Create ǽꤷޤ.
  ! Create ǽꤹ뤳Ȥˤ CONST ʪѿꤵޤ.
  ! CONST ʪݤˤ Get ѤƤ.
  !
  ! Firstly, initialize "CONST" by "Create". 
  ! Then physical constants in "CONST" are configured. 
  ! To get physical constants in "CONST", use "Get".
  !
  !=== Example
  !
  !   program constants_sample
  !     use dc_string, only: Printf
  !     use dc_types, only: DP
  !     use constants, only: CONST, Create, Get
  !     implicit none
  !     type(CONST):: constants_earth, constants_mars
  !     real(DP):: RPlanet, Omega, Grav
  !   
  !     call Create(constants_earth)
  !     call Create(constants_mars, & 
  !       & RPlanet = 3.397e6_DP, Omega = 7.088e-5_DP, Grav = 3.72_DP )
  !   
  !     ! print some phycical constants on Earth
  !     call Get(constants_earth, &
  !       & RPlanet = RPlanet, Omega = Omega, Grav = Grav)
  !     call Printf( &
  !       & fmt = 'The radius of Earth is %f (m), ' // &
  !       &       'the angular velocity of Earth is %f (m/s), ' // &
  !       &       'the acceleration due to gravity on Earth is %f (m^2/s)', &
  !       & d=(/RPlanet, Omega, Grav/))
  !   
  !     ! print some phycical constants on Mars
  !     call Get(constants_mars, &
  !       & RPlanet = RPlanet, Omega = Omega, Grav = Grav)
  !     call Printf( &
  !       & fmt = 'The radius of Mars is %f (m), ' // &
  !       &       'the angular velocity of Mars is %f (m/s), ' // &
  !       &       'the acceleration due to gravity on Mars is %f (m^2/s)', &
  !       & d=(/RPlanet, Omega, Grav/))
  !   
  !   end program constants_sample
  !

  !-------------------------------------
  !  ѥ桼ƥƥ
  !  Common utilities
  use dc_types, only: DP
  implicit none

  private
  public :: CONST, Create, Close, PutLine, initialized, Get

  type CONST
    logical:: initialized = .false.   ! ե饰. 
                                      ! Initialization flag
    integer :: dummy0    ! 8 ӥåȶѤΥߡѿ.      Dummy variable for 8 bit boundary
    real(DP):: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP):: RPlanet   ! $ a $ .      Ⱦ.       Radius of planet
    real(DP):: Omega     ! $ \Omega $ . ž®.     Angular velocity
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: CpVap     ! $ C_v $ .    갵Ǯ. Specific heat of water vapor at constant pressure
    real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP):: DH2O      ! $ d_{\mathrm{H_2O}} $ . ο̩.   Density of liquid water
    real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
    real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
    real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP):: FKarm     ! $ k $ .                 ޥ.   Karman constant
    real(DP):: EFoldTime ! ȿФ e-folding time. E-folding time for maximum wavenumber
    integer :: VisOrder  ! ĶǴμ.                    Order of hyperviscosity
    integer :: dummy1    ! 8 ӥåȶѤΥߡѿ.      Dummy variable for 8 bit boundary

  end type CONST

  interface Create
    module procedure ConstantsCreate
  end interface

  interface Close
    module procedure ConstantsClose
  end interface

  interface PutLine
    module procedure ConstantsPutLine
  end interface

  interface initialized
    module procedure ConstantsInitialized
  end interface

  interface NmlRead
    module procedure ConstantsNmlRead
  end interface

  interface Get
    module procedure ConstantsGet
  end interface

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: constants.f90,v 1.14 2008-04-21 10:36:20 morikawa Exp $'
contains

  subroutine ConstantsCreate( &
    & constant, &
    & PI, RPlanet, Omega, Grav, Cp, RAir, EL, CpVap, RVap, &
    & DH2O, EpsV, ES0, StB, FKarm, EFoldTime, VisOrder, &
    & nmlfile, err )
    !
    !  *constant* ʪԤޤ.
    ! ǥեȤǤϵ絤˴ؤͤꤵޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#constants_nml 򻲾ȤƤ. 
    !
    ! Physical constants are configured to argument *constant*.
    ! By default, values on Earth are configured.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#constants_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, DP
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_EALREADYINIT
    use dc_present, only: present_and_not_empty
    use dc_message, only: MessageNotify
    type(CONST), intent(inout) :: constant
    real(DP), intent(in), optional:: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(in), optional:: RPlanet   ! $ a $ .      Ⱦ.       Radius of planet
    real(DP), intent(in), optional:: Omega     ! $ \Omega $ . ž®.     Angular velocity
    real(DP), intent(in), optional:: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in), optional:: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in), optional:: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in), optional:: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP), intent(in), optional:: CpVap     ! $ C_v $ .    갵Ǯ. Specific heat of water vapor at constant pressure
    real(DP), intent(in), optional:: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP), intent(in), optional:: DH2O      ! $ d_{\mathrm{H_2O}} $ . ο̩.   Density of liquid water
    real(DP), intent(in), optional:: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
    real(DP), intent(in), optional:: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
    real(DP), intent(in), optional:: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP), intent(in), optional:: FKarm     ! $ k $ .                 ޥ.   Karman constant
    real(DP), intent(in), optional:: EFoldTime ! ȿФ e-folding time. E-folding time for maximum wavenumber
    integer , intent(in), optional:: VisOrder  ! ĶǴμ.                    Order of hyperviscosity

    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#constants_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#constants_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional :: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer :: stat
    character(STRING) :: cause_c
    character(*), parameter :: subname = 'ConstantsCreate'
  continue
    call BeginSub(subname, version=version)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (constant % initialized) then
      stat = DCPAM_EALREADYINIT
      cause_c = 'CONST'
      goto 999
    end if

    !-------------------------------------------------------------------
    !  constant 
    !  Configure the settings of constant
    !-------------------------------------------------------------------

    !-------------------------
    ! ǥե (ϵ)
    ! Default values (on Earth)
    constant % PI        = 3.1415926535897930_DP
    constant % RPlanet   = 6.371e6_DP
    constant % Omega     = 7.29210659088065e-05_DP
    constant % Grav      = 9.8_DP
    constant % Cp        = 1004.6_DP
    constant % RAir      = 287.04_DP
    constant % EL        = 2.5e6_DP
    constant % CpVap     = 1810.0_DP
    constant % RVap      = 461.0_DP
    constant % DH2O      = 1000.0_DP
    constant % EpsV      = 0.62264642082430_DP
    constant % ES0       = 611.0_DP
    constant % StB       = 5.67e-8_DP
    constant % FKarm     = 0.4_DP
    constant % EFoldTime = 8640.0_DP
    constant % VisOrder  = 4

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
    if ( present(PI)        )  constant % PI        = PI       
    if ( present(RPlanet)   )  constant % RPlanet   = RPlanet  
    if ( present(Omega)     )  constant % Omega     = Omega    
    if ( present(Grav)      )  constant % Grav      = Grav     
    if ( present(Cp)        )  constant % Cp        = Cp       
    if ( present(RAir)      )  constant % RAir      = RAir     
    if ( present(EL)        )  constant % EL        = EL       
    if ( present(CpVap)     )  constant % CpVap     = CpVap    
    if ( present(RVap)      )  constant % RVap      = RVap     
    if ( present(DH2O)      )  constant % DH2O      = DH2O     
    if ( present(EpsV)      )  constant % EpsV      = EpsV     
    if ( present(ES0)       )  constant % ES0       = ES0      
    if ( present(StB)       )  constant % StB       = StB      
    if ( present(FKarm)     )  constant % FKarm     = FKarm    
    if ( present(EFoldTime) )  constant % EFoldTime = EFoldTime
    if ( present(VisOrder)  )  constant % VisOrder  = VisOrder 

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST file "%c" is loaded.', &
        & c1=trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, & ! (in)
        & PI = constant % PI,       RPlanet = constant % RPlanet, & ! (inout)
        & Omega = constant % Omega, Grav = constant % Grav, & ! (inout)
        & Cp = constant % Cp,       RAir = constant % RAir, & ! (inout)
        & EL = constant % EL,       CpVap = constant % CpVap, & ! (inout)
        & RVap = constant % RVap,   DH2O = constant % DH2O, & ! (inout)
        & EpsV = constant % EpsV,   ES0 = constant % ES0, & ! (inout)
        & StB = constant % StB,     FKarm = constant % FKarm, & ! (inout)
        & EFoldTime = constant % EFoldTime, & ! (inout)
        & VisOrder = constant % VisOrder ) ! (inout)
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    constant % initialized = .true.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine ConstantsCreate


  subroutine ConstantsClose( constant, err )
    !
    ! CONST ѿνλԤޤ.
    ! ʤ, Ϳ줿 *constant*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "CONST".
    ! Note that if *constant* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(CONST), intent(inout):: constant
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'ConstantsClose'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. constant % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'CONST'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "CONST" ξõ
    !  Clear the settings for "CONST"
    !-----------------------------------------------------------------


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    constant % initialized = .false.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine ConstantsClose


  subroutine ConstantsPutLine( constant, unit, indent, err )
    !
    !  *constant* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *constant*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dc_string, only: Printf
    implicit none
    type(CONST), intent(in):: constant
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'ConstantsPutLine'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if (present(indent)) then
      if (len(indent) /= 0) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "CONST" ΰ
    !  Print the settings for "CONST"
    !-----------------------------------------------------------------
    if (constant % initialized) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<CONST:: @initialized=%y', &
        & l=(/constant % initialized/))
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @PI=%f @RPlanet=%f @Omega=%f', &
        & d=(/constant % PI, constant % RPlanet, constant % Omega/))
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Grav=%f @Cp=%f', &
        & d=(/constant % Grav, constant % Cp/))
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @RAir=%f @EL=%f @CpVap=%f @RVap=%f @DH2O=%f', &
        & d=(/constant % RAir, constant % EL, constant % CpVap, constant % RVap, constant % DH2O/))
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @EpsV=%f', &
        & d=(/constant % EpsV/))
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @ES0=%f @StB=%f @FKarm=%f', &
        & d=(/constant % ES0, constant % StB, constant % FKarm/))
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @EFoldTime=%f @VisOrder=%d', &
        & d=(/constant % EFoldTime/), i=(/constant % VisOrder/))
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<CONST:: @initialized=%y>', &
        & l=(/constant % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine ConstantsPutLine

  logical function ConstantsInitialized( constant ) result(result)
    !
    ! *constant* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *constant* is initialized, .true. is returned.
    ! If *constant* is not initialized, .false. is returned.
    !
    implicit none
    type(CONST), intent(in):: constant
  continue
    result = constant % initialized
  end function ConstantsInitialized

  subroutine ConstantsNmlRead( nmlfile, &
    & PI, RPlanet, Omega, Grav, Cp, RAir, EL, CpVap, RVap, DH2O, &
    & EpsV, ES0, StB, FKarm, EFoldTime, VisOrder, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, DP, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    real(DP), intent(inout):: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(inout):: RPlanet   ! $ a $ .      Ⱦ.       Radius of planet
    real(DP), intent(inout):: Omega     ! $ \Omega $ . ž®.     Angular velocity
    real(DP), intent(inout):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(inout):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(inout):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(inout):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP), intent(inout):: CpVap     ! $ C_v $ .    갵Ǯ. Specific heat of water vapor at constant pressure
    real(DP), intent(inout):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP), intent(inout):: DH2O      ! $ d_{\mathrm{H_2O}} $ . ο̩.   Density of liquid water
    real(DP), intent(inout):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
    real(DP), intent(inout):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
    real(DP), intent(inout):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP), intent(inout):: FKarm     ! $ k $ .                 ޥ.   Karman constant
    real(DP), intent(inout):: EFoldTime ! ȿФ e-folding time. E-folding time for maximum wavenumber
    integer , intent(inout):: VisOrder  ! ĶǴμ.                    Order of hyperviscosity
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    namelist /constants_nml/ &
      & PI, RPlanet, Omega, Grav, Cp, RAir, &
      & EL, CpVap, RVap, DH2O, EpsV, ES0, &
      & StB, FKarm, EFoldTime, VisOrder
                              !
                              ! constants ⥸塼 NAMELIST ѿ̾.
                              ! ʪɤ߹ߤޤ.
                              !
                              ! constants#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for "constants" module.
                              ! physical constants etc. are input.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "constants#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'ConstantsNmlRead'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r' )  ! (in)

    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    read( unit = unit_nml, &                     ! (in)
      & nml = constants_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='constants_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = constants_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='constants_nml', c2=trim(nmlfile), &
        & i=(/iostat_nml/) )
    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine ConstantsNmlRead


  subroutine ConstantsGet( &
    & constant, &
    & PI, RPlanet, Omega, Grav, Cp, RAir, EL, CpVap, RVap, &
    & DH2O, EpsV, ES0, StB, FKarm, EFoldTime, VisOrder, &
    & err )
    !
    !  *constant* ˳ǼƤʪʤɤФޤ.
    !
    ! ʤ, Ϳ줿 *constant*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Physical constants etc. stored in argument *constant*
    ! are gotten.
    !
    ! If *constant* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(CONST), intent(inout):: constant
    real(DP), intent(out), optional:: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(out), optional:: RPlanet   ! $ a $ .      Ⱦ.       Radius of planet
    real(DP), intent(out), optional:: Omega     ! $ \Omega $ . ž®.     Angular velocity
    real(DP), intent(out), optional:: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(out), optional:: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(out), optional:: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(out), optional:: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP), intent(out), optional:: CpVap     ! $ C_v $ .    갵Ǯ. Specific heat of water vapor at constant pressure
    real(DP), intent(out), optional:: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP), intent(out), optional:: DH2O      ! $ d_{\mathrm{H_2O}} $ . ο̩.   Density of liquid water
    real(DP), intent(out), optional:: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight of water vapor
    real(DP), intent(out), optional:: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
    real(DP), intent(out), optional:: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
    real(DP), intent(out), optional:: FKarm     ! $ k $ .                 ޥ.   Karman constant
    real(DP), intent(out), optional:: EFoldTime ! ȿФ e-folding time. E-folding time for maximum wavenumber
    integer , intent(out), optional:: VisOrder  ! ĶǴμ.                    Order of hyperviscosity

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'ConstantsGet'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. constant % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'CONST'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʪμФ
    !  Fetch physical constants etc.
    !-----------------------------------------------------------------
    if ( present(PI)        )  PI        = constant % PI        
    if ( present(RPlanet)   )  RPlanet   = constant % RPlanet   
    if ( present(Omega)     )  Omega     = constant % Omega     
    if ( present(Grav)      )  Grav      = constant % Grav      
    if ( present(Cp)        )  Cp        = constant % Cp        
    if ( present(RAir)      )  RAir      = constant % RAir      
    if ( present(EL)        )  EL        = constant % EL        
    if ( present(CpVap)     )  CpVap     = constant % CpVap     
    if ( present(RVap)      )  RVap      = constant % RVap      
    if ( present(DH2O)      )  DH2O      = constant % DH2O      
    if ( present(EpsV)      )  EpsV      = constant % EpsV      
    if ( present(ES0)       )  ES0       = constant % ES0       
    if ( present(StB)       )  StB       = constant % StB       
    if ( present(FKarm)     )  FKarm     = constant % FKarm     
    if ( present(EFoldTime) )  EFoldTime = constant % EFoldTime 
    if ( present(VisOrder)  )  VisOrder  = constant % VisOrder  

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine ConstantsGet


!!$  subroutine ConstantsSample( constant, err )
!!$    !--
!!$    ! ConstantsSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *constant*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of ConstantsSample
!!$    !++
!!$    ! If *constant* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: STRING, STDOUT
!!$    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
!!$    implicit none
!!$    type(CONST), intent(inout):: constant
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'ConstantsSample'
!!$  continue
!!$    call BeginSub(subname)
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if (.not. constant % initialized) then
!!$      stat = DCPAM_ENOTINIT
!!$      cause_c = 'CONST'
!!$      goto 999
!!$    end if
!!$
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError(stat, subname, err, cause_c)
!!$    call EndSub(subname)
!!$  end subroutine ConstantsSample


end module constants
