!= intavr_operate ⥸塼Υƥȥץ
!
!= Test program for "intavr_operate"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: intavr_operate_test.f90,v 1.2 2007-09-20 10:21:45 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! intavr_operate ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "intavr_operate" module.
! Confirm compilation and execution of this program.
!

program intavr_operate_test
  use intavr_operate, only: INTAVROPR, Create, Close, &
    & PutLine, initialized, &
    & IntLonLat_xy, y_IntLon_xy, IntLon_x, x_IntLat_xy, IntLat_y, &
    & AvrLonLat_xy, y_AvrLon_xy, AvrLon_x, x_AvrLat_xy, AvrLat_y
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'intavr_operate_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "intavr_operate" module'
  character(*), parameter:: source = &
    & 'dcmodel project: hierarchical numerical models ' // &
    & '(See http://www.gfd-dennou.org/library/dcmodel)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 32
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 16
                              ! ٳʻ. 
                              ! Number of grid points in latitude

  !---------------------------------------------------------
  !  ʬѺɸŤ
  !  Weight for integration
  !---------------------------------------------------------
  real(DP), allocatable:: x_Lon_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in longitude
  real(DP), allocatable:: y_Lat_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in latitude

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP), allocatable:: xy_Temp (:,:)
                              ! $ T $ .     . Temperature

  real(DP), allocatable:: x_TempIntLatAns (:)
                              ! $ T $ .     ٤ΰʬ. 
                              ! Temperature integration in latitude

  real(DP), allocatable:: y_TempAvrLonAns (:)
                              ! $ T $ .     ٤ηʿ. 
                              ! Meridional mean temperature

  real(DP):: TempAvrLonLatAns
                              ! $ T $ .     ٤ΰʿ. 
                              ! Global mean temperature

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(INTAVROPR):: intavr_opr00, intavr_opr01
  type(CONST):: const_earth

!!$  logical:: err
!!$  character(*), parameter:: subname = 'intavr_operate_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './intavr_operate_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  call Get( constant = const_earth, & ! (inout)
    & PI = PI )                       ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( intavr_opr = intavr_opr00, & ! (inout)
    & imax = imax, jmax = jmax, &           ! (in)
    & PI = PI )                             ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(intavr_opr00) )
  call PutLine( intavr_opr = intavr_opr00 ) ! (in)

  !---------------------------------------------------------
  !  ʬѺɸŤߤμ
  !  Get weight for integration
  !---------------------------------------------------------
  allocate( x_Lon_Weight (0:imax-1) )
  allocate( y_Lat_Weight (0:jmax-1) )

  call HistoryGet( &
    & file = 'intavr_operate_test00.nc', & ! (in)
    & varname = 'lon_weight', &     ! (in)
    & array = x_Lon_Weight )        ! (out)
  call HistoryGet( &
    & file = 'intavr_operate_test00.nc', & ! (in)
    & varname = 'lat_weight', &     ! (in)
    & array = y_Lat_Weight )        ! (out)

  !---------------------------------------------------------
  !  ʬѺɸŤߤѤƥ
  !  Initialization test with weight for integration
  !---------------------------------------------------------
  call Create( intavr_opr = intavr_opr01, & ! (inout)
    & imax = imax, jmax = jmax, &           ! (in)
    & PI = PI, &                            ! (in)
    & x_Lon_Weight = x_Lon_Weight, &        ! (in)
    & y_Lat_Weight = y_Lat_Weight )         ! (in)
  call AssertEqual( 'initialization test 2', &
    & answer = .true., check = initialized(intavr_opr01) )
  call PutLine( intavr_opr = intavr_opr01 ) ! (in)


  !---------------------------------------------------------
  !  ץǡ
  !  Input sample data
  !---------------------------------------------------------
  allocate( xy_Temp (0:imax-1, 0:jmax-1) )

  call HistoryGet( &
    & file = 'intavr_operate_test00.nc', & ! (in)
    & varname = 'SurfTemp', &              ! (in)
    & array = xy_Temp )                    ! (out)

  !---------------------------------------------------------
  !  ʬƥ
  !  Integration test
  !---------------------------------------------------------
  allocate( x_TempIntLatAns (0:imax-1) )

  call HistoryGet( &
    & file = 'intavr_operate_test01.nc', & ! (in)
    & varname = 'IntLatTemp0', &           ! (in)
    & array = x_TempIntLatAns )            ! (out)

  call AssertEqual( 'integration test 1-1', &
    & answer = x_TempIntLatAns, &
    & check = x_IntLat_xy( xy_Temp, intavr_opr00 ), &
    & significant_digits = 15, ignore_digits = -15 )

  call HistoryGet( &
    & file = 'intavr_operate_test01.nc', & ! (in)
    & varname = 'IntLatTemp1', &           ! (in)
    & array = x_TempIntLatAns )            ! (out)

  call AssertEqual( 'integration test 1-2', &
    & answer = x_TempIntLatAns, &
    & check = x_IntLat_xy( xy_Temp, intavr_opr01 ), &
    & significant_digits = 15, ignore_digits = -15 )

  !---------------------------------------------------------
  !  ʿѥƥ 1
  !  Average test 1
  !---------------------------------------------------------
  allocate( y_TempAvrLonAns (0:jmax-1) )

  call HistoryGet( &
    & file = 'intavr_operate_test01.nc', & ! (in)
    & varname = 'AvrLonTemp0', &           ! (in)
    & array = y_TempAvrLonAns )            ! (out)

  call AssertEqual( 'average test 1-1', &
    & answer = y_TempAvrLonAns, &
    & check = y_AvrLon_xy( xy_Temp, intavr_opr00 ), &
    & significant_digits = 15, ignore_digits = -15 )

  call HistoryGet( &
    & file = 'intavr_operate_test01.nc', & ! (in)
    & varname = 'AvrLonTemp1', &           ! (in)
    & array = y_TempAvrLonAns )            ! (out)

  call AssertEqual( 'average test 1-2', &
    & answer = y_TempAvrLonAns, &
    & check = y_AvrLon_xy( xy_Temp, intavr_opr01 ), &
    & significant_digits = 15, ignore_digits = -15 )

  !---------------------------------------------------------
  !  ʿѥƥ 2
  !  Average test 2
  !---------------------------------------------------------
  call HistoryGet( &
    & file = 'intavr_operate_test01.nc', & ! (in)
    & varname = 'AvrLonLatTemp0', &        ! (in)
    & array = TempAvrLonLatAns )           ! (out)

  call AssertEqual( 'average test 2-1', &
    & answer = TempAvrLonLatAns, &
    & check = AvrLonLat_xy( xy_Temp, intavr_opr00 ), &
    & significant_digits = 15, ignore_digits = -15 )

  call HistoryGet( &
    & file = 'intavr_operate_test01.nc', & ! (in)
    & varname = 'AvrLonLatTemp1', &        ! (in)
    & array = TempAvrLonLatAns )           ! (out)

  call AssertEqual( 'average test 2-2', &
    & answer = TempAvrLonLatAns, &
    & check = AvrLonLat_xy( xy_Temp, intavr_opr01 ), &
    & significant_digits = 15, ignore_digits = -15 )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( intavr_opr = intavr_opr00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(intavr_opr00) )
  call PutLine( intavr_opr = intavr_opr00 ) ! (in)

!!$  call Close( intavr_opr = intavr_opr02, & ! (inout)
!!$    & err = err )                            ! (out)
!!$  call AssertEqual( 'termination test 2', &
!!$    & answer = .true., check = err )

end program intavr_operate_test
