!  ƥȥץ༫ΤѲ.

!= phy_cumulus_adjust ⥸塼Υƥȥץ
!
!= Test program for "phy_cumulus_adjust"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_cumulus_adjust_test.f90,v 1.4 2008-02-28 05:21:55 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_cumulus_adjust ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_cumulus_adjust" module.
! Confirm compilation and execution of this program.
!

program phy_cumulus_adjust01_test
  use phy_cumulus_adjust01, only: PHYCUMAD, Create, Close, &
    & PutLine, initialized, Cumulus
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  use dc_clock, only: CLOCK, DCClockCreate, DCClockClose, &
    & DCClockStart, DCClockStop, DCClockResult, DCClockPredict, operator(+)
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_cumulus_adjust_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "phy_cumulus_adjust" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  integer:: test_step = 200

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: imax = 64         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 32         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer:: kmax = 16         ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
  real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
  real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
  real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
  real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
  real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .     . Temperature
  real(DP), allocatable:: xyz_QVap (:,:,:)
                              ! $ q $ .     漾. Specific humidity
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP), allocatable:: xy_CumulusRain (:,:)
                              ! ѱˤ߿. 
                              ! Precipitation by cumulus scheme
  real(DP), allocatable:: xyz_DCumulusTempDt (:,:,:)
                              ! ѱˤ벹ѲΨ. 
                              ! Temperature tendency by cumulus scheme
  real(DP), allocatable:: xyz_DCumulusQVapDt (:,:,:)
                              ! ѱˤ漾ѲΨ. 
                              ! Specific humidity tendency by cumulus scheme

  real(DP), allocatable:: xy_Ps (:,:)
                              ! $ p_s $ .   ɽ̵. Surface pressure
  real(DP), allocatable:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), allocatable:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  integer:: i, k
  
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYCUMAD):: phy_cumad00, phy_cumad01, phy_cumad02, phy_cumad03
  logical:: err

  type(CLOCK):: clk_cum

  character(*), parameter:: subname = 'phy_cumulus_adjust_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_cumulus_adjust_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  DelTime = 600.0_DP

  call Get( constant = const_earth, &      ! (inout)
    & Grav = Grav, Cp = Cp, RAir = RAir, & ! (out)
    & EL = EL, RVap = RVap, &              ! (out)
    & EpsV = EpsV, ES0 = ES0 )             ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_cumad = phy_cumad00,  &     ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, & ! (in)
    & Grav = Grav, Cp = Cp, RAir = RAir, &     ! (in)
    & EL = EL, RVap = RVap, &                  ! (in)
    & EpsV = EpsV, ES0 = ES0, &                ! (in)
    & DelTime = DelTime )
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_cumad00) )
!!$  call PutLine( phy_cumad = phy_cumad00 ) ! (in)

  !---------------------------------------------------------
  !  ǡ
  !  Input Data
  !---------------------------------------------------------
  allocate( xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_Press (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyr_Press (0:imax-1, 0:jmax-1, 0:kmax) )
  allocate( xy_CumulusRain (0:imax-1, 0:jmax-1) )
  allocate( xyz_DCumulusTempDt (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DCumulusQVapDt (0:imax-1, 0:jmax-1, 0:kmax-1) )

  allocate( z_Sigma(0:kmax-1) )
  allocate( r_Sigma(0:kmax) )
  allocate( xy_Ps (0:imax-1, 0:jmax-1) )

  call HistoryGet( 'Temp500.nc', 'Temp', array = xyz_Temp )
  call HistoryGet( 'QVap500.nc', 'QVap', array = xyz_QVap )
  call HistoryGet( 'Ps500.nc', 'Ps', array = xy_Ps )

  call HistoryGet( 'Temp500.nc', 'sig', array = z_Sigma )
  call HistoryGet( 'Temp500.nc', 'sigm', array = r_Sigma )

  do k = 0, kmax - 1
    xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
    xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
  end do
  xyr_Press(:,:,kmax) = xy_Ps * r_Sigma(kmax)

!!$  xyz_Temp = 273.0_DP
!!$  xyz_QVap = 1.0e-5_DP
!!$  xyz_Press = 1.0e+6_DP
!!$  xyr_Press = 1.0e+6_DP

  !---------------------------------------------------------
  !  Cumulus ׻
  !  Cumulus calculation
  !---------------------------------------------------------
  call DCClockCreate(  clk = clk_cum, &    ! (out)
    &                 name = 'Cumulus' )       ! (in)

  call DCClockStart( clk = clk_cum ) ! (inout)

  do i = 1, test_step
!!$    write(*,*) 'loop=', i
    call Cumulus( phy_cumad = phy_cumad00, &            ! (inout)
      & xyz_Temp = xyz_Temp, xyz_QVap = xyz_QVap, &     ! (inout)
      & xyz_Press = xyz_Press, xyr_Press = xyr_Press, & ! (in)
      & xy_Rain = xy_CumulusRain, &                     ! (out)
      & xyz_DTempDt = xyz_DCumulusTempDt, &             ! (out)
      & xyz_DQVapDt = xyz_DCumulusQVapDt )              ! (out)
  end do

  call DCClockStop( clk = clk_cum ) ! (inout)

  call DCClockResult( &
    & clks = (/clk_cum/), &       ! (in)
    & total_auto = .true.)        ! (in)

!!$  call PutLine ( xyz_Temp, indent = ' xyz_Temp=')
!!$  call PutLine ( xyz_QVap, indent = ' xyz_QVap=')
!!$  call PutLine ( xy_CumulusRain, indent = ' xy_CumulusRain=')
!!$  call PutLine ( xyz_DCumulusTempDt, indent = ' xyz_DCumulusTempDt=')
!!$  call PutLine ( xyz_DCumulusQvapDt, indent = ' xyz_DCumulusQvapDt=')

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_cumad = phy_cumad00 ) ! (inout)
!!$  call AssertEqual( 'termination test 1', &
!!$    & answer = .false., check = initialized(phy_cumad00) )
!!$  call PutLine( phy_cumad = phy_cumad00 ) ! (in)
!!$
!!$  call Close( phy_cumad = phy_cumad02, & ! (inout)
!!$    & err = err )                            ! (out)
!!$  call AssertEqual( 'termination test 2', &
!!$    & answer = .true., check = err )

end program phy_cumulus_adjust01_test
